/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.impl;

/**
 * ChampVAException is the Abstract Base Class for Exceptions propagated by the
 * CHAMPVA Pay Service.
 * 
 * @author PII
 * @version 1.0.0
 */
public abstract class ChampVAException extends Exception {

    private static final long serialVersionUID = -2731999808009747003L;

    /**
     * These constants define the error codes for their corresponding exception
     * types, which will allow us to communicate Exceptions to the Web Client
     * without leaking details of the Web Service's design to the Wild Wild Web.
     */
    public static final String VISTALINK_FAULT_EXCEPTION = "100";
    public static final String FOUNDATIONS_EXCEPTION = "200";
    public static final String NAMING_EXCEPTION = "300";
    public static final String RESOURCE_EXCEPTION = "400";
    public static final String JSON_PROCESSING_EXCEPTION = "500";

    private String mErrorCode = "0";

    /**
     * ChampVAException constructor.
     * 
     * @param t
     *            - an instance of Throwable
     */
    public ChampVAException(Throwable t) {
	super(t);
    }

    /**
     * @return the Error Code of the Exception.
     */
    public String getErrorCode() {
	return mErrorCode;
    }

    /**
     * @param mErrorCode
     *            the mErrorCode to set
     */
    public void setErrorCode(String mErrorCode) {
	this.mErrorCode = mErrorCode;
    }

}
