/**
 * The package gov.va.med.mbcp.champva.domain.impl contains the CodeResult class, which
 * represents a Code Result Transfer Object in the Service Layer. The abstract ChampVAException,
 * along with its concrete implementations, are also defined here. 
 * 
 */
package gov.va.med.mbcp.champva.domain.common;

/**
 * Interface ICodeResult is the Data Transfer Object interface for the CHAMPVA
 * Pay Service
 * 
 * @author PII
 * @version 1.0.0
 */
public interface ICodeResult {

    /**
     * @return String Code Result
     */
    public abstract String getResult();

    /**
     * @return String Code Message
     */    
    public abstract String getMessage();
}
