/**
 * The package gov.va.med.mbcp.champva.dao.common contains the public Interface for 
 * retrieval of CHAMPVA CodeResults from the target VistA instance.
 * 
 */
package gov.va.med.mbcp.champva.dao.common;

import gov.va.med.mbcp.champva.domain.common.ICodeResult;
import gov.va.med.mbcp.champva.domain.impl.ChampVAException;

/**
 * Interface IChampVAPayDAO is the Data Access Object for the CHAMPVA Pay
 * Service.
 * 
 * @author PII
 * @version 1.0.0
 */
public interface IChampVAPayDAO {

    /**
     * The business method for the Data Access Object.
     * 
     * @param codeSystem - String identifying the coding system identifier (e.g., "CPT")
     * @param code - String the code to be evaluated
     * @return ICodeResult - Code Result DTO to be serialized to Json by the ChampVAResource
     * @throws ChampVAException - a ChampVAException to be propagated to the resource.
     */
    public abstract ICodeResult getCodeResult(String codeSystem, String code) throws ChampVAException;

}
