//Adjust for invoking app from a folder other than app root.
var dirAppInvokedFrom = process.cwd();

//identify application directory
if (!(dirAppInvokedFrom === __dirname)) {
try {
	process.chdir(__dirname);
} catch (error) {
  console.log('chdir to app.js folder error: ' + error);	
	}
};

//namespace
var cbe = (function () {
	var route;
	var serverErrors = [];
	return {
		route: route,
		serverErrors: serverErrors
	};
} )(); //end of namespace

module.exports.serverErrors = cbe.serverErrors;
//dynamically set log file
module.exports.dirAppInvokedFrom = dirAppInvokedFrom;

var express = require('express');
//var cookieParser = require('cookie-parser');
var routes = require('./routes/index'); // ./routes/index.js -- file
var setting = require('./config/settings.json');	
var consul = require('./config/consul-settings.json');	
var screens = require('./config/screens.json');	
var system  = require('./lib/cbe-system');
var compress = require('compression');
var packageJson = require('./package.json');
var http = require("http");
var https = require("https");
var fs = require('fs');
var helmet = require('helmet');
var csp = require('helmet')(helmet-csp);
var constants = require('constants');
var bodyParser = require('body-parser');  //030917 Added process form data
//var mongoose = require('mongoose');  //031417 -- removed on 7/31/17 -- return for mongodb
const configJs  = require('../config');

//dump consul contents
var buffer = new Buffer(fs.readFileSync('./config/consul-settings.json','utf8'));
system.logger.warn('consul contentsPopulated: '+consul.contentsPopulated);
system.logger.warn('consul metrics (true/false): '+consul.metrics);
system.logger.warn('consul.via.endPoint: ' + consul.via.endPoint);
system.logger.trace('consul contents: ' + buffer.toString());

//TODO Try to add promise -- Accepted warning because of uncaught exceptions in promises -- for now
/**
//DeprecationWarning: Mongoose: mpromise (mongoose's default promise library) is deprecated
//no mongoose connection at all
//mongoose.Promise = require('mpromise'); //031617
//removed promises because exception thrown inside while mongo down -- maybe dump bluebird node module
//http://stackoverflow.com/questions/38138445/node3341-deprecationwarning-mongoose-mpromise 
//mongoose.Promise = global.Promise;
//mongoose.Promise = require('bluebird'); //031617

//promise fix
//http://stackoverflow.com/questions/29794064/error-thrown-from-a-mongoose-promise-callback-function-is-not-caught

var mongoose = require('mongoose');
var Promise = require("bluebird");
mongoose.Promise = Promise;
//mongoose.set('error', true);
Promise.promisifyAll(require("mongoose"));
//var mongoose = Promise.promisifyAll(require("mongoose"));
**/

//configuration
var app = express();
app.set('view engine', 'ejs');	//use ejs - embedded javascript
app.use(compress());    //compress all requests

//Log4JS insists on using the initial cdw (DirAppInvokedFrom) as root to save all log files-- even after switching to __dirname. 
//I wasn't able to log activity at the part 1/2 location in the code, therefore it is located here.
if (!(dirAppInvokedFrom === __dirname)) {
	system.logger.warn('Invoking remote directory: ' + dirAppInvokedFrom); 
	system.logger.warn('App working directory: ' + process.cwd());
};

//030917 Process Form Data
app.use(bodyParser.urlencoded({
    extended: true
})); 

//Set https security headers
app.use(helmet());

//X-XSS Protection Header (DLEA-1251)
app.use(helmet.xssFilter()); 

//HSTS header (DLEA-1252)
var maxHttpsAge = 31536000000; 
app.use(helmet.hsts({ 
	maxAge: maxHttpsAge,
	force: true
}));

//Content Security Policy Header (DLEA-1253)
app.use(helmet.csp({
  // Specify directives as normal. 
  directives: {
    defaultSrc: ["'self'"],
    scriptSrc: ["'self'", "'unsafe-inline'", "'unsafe-eval'"], //inline required by EJS and eval by underscore
    styleSrc: ["'self'"],
    imgSrc: ["'self'"],
    //removed sandbox to allow safari/chrome to open new browser tab
    //sandbox: ['allow-scripts', 'allow-same-origin'], //safari required for backbone- allow-scripts+allow-same-origin
    objectSrc: [], // An empty array allows nothing through 
    //frameAncestors: ["'none'"], //unknown by safari
  },
 
  // Set to true if you only want browsers to report errors, not block them 
  reportOnly: false,
 
  // Set to true if you want to blindly set all headers: Content-Security-Policy, 
  // X-WebKit-CSP, and X-Content-Security-Policy. 
  setAllHeaders: false,
 
  // Set to true if you want to disable CSP on Android where it can be buggy. 
  disableAndroid: false,
 
  // Set to false if you want to completely disable any user-agent sniffing. 
  // This may make the headers less compatible but it will be much faster. 
  // This defaults to `true`. 
  browserSniff: false
}));

//X-Content_Type-Options (DLEA-1254)
app.use(helmet.nosniff());

//validate that package.json and consul are populated
if (!(packageJson.config.appBuildDate.length > 0)) {
	system.logger.warn('Application Build Date is Empty!');
};
if (!(consul.dbConnInfo.name.length > 0)) {
	system.logger.fatal('DB Name is Empty!');
	throw new Error("DB Name is Empty!");  //stop app
};
if (!(consul.dbConnInfo.host.length > 0)) {
	system.logger.fatal('DB Host Name is Empty!');
	throw new Error("DB Host Name is Empty!");  //stop app
};
if (!(consul.dbConnInfo.username.length > 0)) {
	system.logger.warn('DB Host UserName is Empty!');
};
if (!(consul.dbConnInfo.password.length > 0)) {
	system.logger.warn('DB Host Password is Empty!');
};
if (!(consul.dbConnInfo.port > 0)) {
	system.logger.fatal('DB Port is Empty!');
	throw new Error("DB Port is Empty!");  //stop app
};
if (!(consul.dbConnInfo.secure == 'true' || 'false')) {
	system.logger.fatal('DB secure is Empty!');
	throw new Error("DB secure is Empty!");  //stop app
};
if (!(packageJson.config.processName.length > 0)) {
	system.logger.fatal('processName is Empty!');
	throw new Error("processName is Empty!");  //stop app
};
if (!(configJs.PORT > 0)) {
	system.logger.fatal('processPort is Empty!');
	throw new Error("processPort is Empty!");  //stop app
};
   
//var dbURI = "mongodb://127.0.0.1:27017/cbe";
var dbURI;
//removed on 7/31/17 -- return for mongodb   var db = mongoose.connection;
//var connectToMongo = true;
const dbOptions = {server: {socketOptions: {keepAlive: 1}}};

try {
	if (consul.metrics) {
		dbURI = 'mongodb://' + 
			consul.dbConnInfo.host + ':' + 
			consul.dbConnInfo.port + '/' + 
			consul.dbConnInfo.name;
		system.logger.info('Mongo Connection');
	
		/** removed Mongo for NextGen solution
		app.set('trust proxy', 1); //trust proxy for secure cookie
		if ((consul.dbConnInfo.username.length > 0) &&
			(consul.dbConnInfo.password.length > 0) ) {			
			//app.use(cookieParser());  //needed to store client side cookie? 
			app.set('trust proxy', 1); // trust first proxy			
			dbURI = 'mongodb://' + 
		        	consul.dbConnInfo.username + ':' +
		        	consul.dbConnInfo.password + '@' +
					consul.dbConnInfo.host + ':' + 
					consul.dbConnInfo.port + '/' + 
					consul.dbConnInfo.name;			
			system.logger.info('Connected to Server Mongo w/credentials - secure: '+consul.dbConnInfo.secure);
		//anonymous Mongo connection	
		} else {
			//app.use(cookieParser());
			app.set('trust proxy', 1); // trust first proxy			
			dbURI = 'mongodb://' + 
				consul.dbConnInfo.host + ':' + 
				consul.dbConnInfo.port + '/' + 
				consul.dbConnInfo.name;
			system.logger.info('Connected to Server Mongo anonymously - secure: '+consul.dbConnInfo.secure);
		}
		**/
	} else {		
		//connectToMongo = false;
		system.logger.info('No Mongo Connection');
	}
} catch( err ) {
	system.logger.fatal('Failure with Mongo Configuration: '+err);
	throw new Error("Failure with Mongo Configuration: "+err);  //stop app
};
  
system.logger.info('dbURI is: '+dbURI);

/** Removed on 7/31/17 -- return for mongodb usage
const connect = function () {
    mongoose.connect(dbURI, dbOptions);
};

if (consul.metrics) {
	connect();
}

db.on('connected', function(error) {
	system.logger.info("Connected to Mongo");
}); 

db.on('open', function() {
    system.logger.trace('Mongo Connection Open');
});

db.on('connecting', function() {
    system.logger.trace('Mongo Connecting');
});

db.on('error', function(error) {
    system.logger.error('Mongo Failed to Connect!: ' + error);
    
    //added try/catch for promise exception -- didn't catch promise exception
    mongoose.disconnect(); //added - needed for instance pool was distroyed

}); 

db.on('disconnected', function() {
	system.logger.error("Disconnected from Mongo");
    setTimeout(connect, 10000);
});  

db.on('reconnected', function() {
    system.logger.trace('Mongo Reconnected');
});

return for mongodb **/

//fatal -- stop application
process.on('uncaughtException', function(err) {
	system.logger.fatal('Caught exception: '+err);
	system.logger.fatal(err.stack);
	//interrogate the error, if it's something you can recover from, let it be.
	//if the exception is fatal, exit with prejudice
	setTimeout(process.exit.bind(process, 666), 1000); //exit in a second
});

//cbe.route = consul.environment==='server'?packageJson.config.proxyProcessName:packageJson.config.processName;
cbe.route = packageJson.config.processName;
system.logger.info('app route: '+cbe.route);

//content passed to all ejs pages -- Added locally to every page/template/partial
app.locals.access = '0';
app.locals.appVersion = packageJson.version;
app.locals.appUpdatedDate = packageJson.config.appBuildDate;
app.locals.errors = '';
app.locals.helpPage = '';
app.locals.name = '';
app.locals.typeOfCode = '';
app.locals.code = '';
app.locals.codeMessage = '';
app.locals.launchPadLink = consul.launchPadLink;
app.locals.feedbackLink = setting.feedbackLink;
app.locals.trainingLink = setting.trainingLink;
app.locals.route = cbe.route;
app.locals.screens = screens;
system.logger.info('route: ' + app.locals.route);
 
//Fixed passport.initialize() middleware not in use
app.use(express.static(__dirname + '/public'));

//Fixes CORS cross-origin ressource sharing error
app.all('*', function (request, response, next) {
	'use strict';
	// log.debug('URL:' + request.originalUrl);	
	response.header('Access-Control-Allow-Origin', '*');
	response.header('Access-Control-Allow-Methods', 'PUT, GET, POST, DELETE, OPTIONS');
	response.header('Access-Control-Allow-Headers', 'Content-Type');
	next();
});

//app.use(auth.passport.initialize());
//app.use(auth.passport.session()); //not sure its needed
 
//Serve static content to SPA
app.use('/'+cbe.route, express.static(__dirname + '/public'));
app.use('/'+cbe.route+'/help', express.static(__dirname + '/public'));
app.use('/'+cbe.route+'/success/token', express.static(__dirname + '/public'));

//testing process to capture oAuth exceptions
//app.use(errorHandler);  //haven't seen it setting

system.logger.warn('__dirname: '+__dirname);

//valid server routes
app.get('/'+cbe.route, routes.cbe);
app.get('/'+cbe.route+'/index.html', routes.cbe); 
app.get('/'+cbe.route+'/help/:page', routes.helpPage); 
app.get('/'+cbe.route+'/failure', routes.cbeFailure); 
app.post('/'+cbe.route+'/code', routes.checkCode); 

//captures errors and exceptions -- node errors capture and move on
app.use( function(err, req, res, next){   			
	system.logger.error('node errors and exceptions: '+err.message);
	system.logger.debug('err.stack: '+err.stack);
	cbe.serverErrors = [['7',err.message]];
	module.exports.serverErrors = cbe.serverErrors;
	res.redirect("/"+cbe.route+"/failure");  //res.render doesn't properly render like no access to public
  	//next(err);
});

//Removed this for CRISP
/** 
app.get('/*', function(req, res) {
	system.logger.warn('server hit with this invalid url path: '+req.url);
 	res.send('if all else fails, we hit this page');
});
**/

//Setup node listener -- events.js:72 indicates that server port is already used
//Pull port from config.js file also used for testing 
//note: consul variables are later in the process
http.createServer(app).listen(configJs.PORT);
system.logger.warn('listening on http port: '+configJs.PORT);

//required for debug -- see generator -- no benefit that i noticed
//module.exports = app;
