# CHAMPVA Pay Application

Version 1.0.0

## Description

The CHAMPVA Benefit Authorization Application is intended to be an interactive tool to identify the participation status of 
CHAMPVA medical codes (CPT, ICD-10, DME and NDC) for use by a Veteran's beneficiaries and/or medical providers.   

This project supports:

- Building the application through a `build.sh` script.
- Configuring the Automated Build/CI with `app.yml`.
- Dockerizing/Containerizing the application with `Dockerfile` and `docker-compose.yml`.
- Executing tasks through Gulp with `gulpfile.js`.
- Performing tests on the application.

## Technologies

- HTML5
- CSS3
- Body-Parser v1.17.1
- Bootstrap v3.3.7
- Backbone v1.2.3
- Compression v1.4.0
- EJS v1.0.0
- Helmet v1.3.0
- Jquery v1.11.0
- Log4js v0.6.22
- Request v2.69.0
- respond v1.4.0
- underscore v1.8.3
- Javascript
- Node.js v6.10.0
- ExpressJS v4.13.4

## Commands Available

- `npm test` - This will execute the tests on the application.
- `npm install` - (From project root) This will install packages at the project level, typically to support testing of the project.
- `npm install` - (From app/ directory)  This will install packages for the application itself.

## Build

From the application root using the automation pipeline - `./build.sh` will install any missing node packages, run tests and tar up application to be shipped off to Nexus.

To run locally (w/out docker), after running build-local.sh (optional for https). Run 'node app' or 'npm start' from /app directory.

## Test

From the application root, run `npm test`.

## Notes for Package Maintainers

Ensure consul updated with variables needed for each environment
    

## References

- [Project Rational](https://URL                    /ccm/web/projects/MD%20(CM)#action=com.ibm.team.dashboard.viewDashboard&team=MD%20-%20ChampVA%20CM)

