var gulp            = require("gulp"),
    mocha           = require('gulp-mocha'),
    mochaPhantomJS  = require("gulp-mocha-phantomjs");

const config        = require('./config');    

gulp.task('webserver', function() {
    var webserver = require('gulp-webserver');
    return gulp.src(config.APPDIR).pipe(webserver({
        fallback: '/',
        port: PORT,
        logLevel: 'verbose',
        waitforTimeout: 10000
    }));
});

//no effect
gulp.task('app', function() {
    var nodemon = require('gulp-nodemon');
    nodemon({
        stdout: false,
        script: config.APPDIR + '/app.js',
        env: { 'NODE_ENV': 'development' }
    });
});

gulp.task("mocha", function () {
    return gulp.src('./test/index.js', {read: false})
        .pipe(mocha({reporter: 'spec'}))
        .once('error', function () {
            process.exit(1);
        })
        .once('end', function () {
            process.exit();
        });
});

gulp.task("test", ["app","mocha"]);