#!/bin/sh

printf "\n\n\n\n**** RUNNING build.sh ********************\n\n"

# Set DTR for Docker - Perform against ALL Dockerfiles in your project
/usr/bin/perl -i -pe "s|%%DTR_PREFIX%%|$DTR_PREFIX|" Dockerfile || { echo "FATAL: Could not set DTR Prefix"; exit 1; }
/usr/bin/perl -i -pe "s|%%DTR_ORG%%|$DTR_ORG|" Dockerfile || { echo "FATAL: Could not set DTR Ogranization'"; exit 1; }

# Dependency Check
printf "\n\n**** Mandatory: Dependency Checks ********************\n"

npm install || { echo "FATAL: Failed on 'npm install'"; exit 1; } 
cd app
npm install || { echo "FATAL: Failed on 'npm install'"; exit 1; } 
cd ../


# Build Injection
printf "\n\n**** Build Injection: Add Build Date/Time ********************\n"

cd app
currentDate=$('date')
/usr/bin/perl -i -pe "s!\"appBuildDate\": \"\"!\"appBuildDate\": \"$currentDate\"!" ./package.json 

printf "\n\n**** Build Injection: Add Build Date/Time Complete ********************\n"

# Reset directory
cd ../


# Functional, Integration, Unit and Acceptance Tests
printf "\n\n**** Mandatory: Testing ********************\n"

npm test || { echo "FATAL: Failed on 'npm test'"; exit 1; } 

# Build Artifact Production
printf "\n\n**** Optional: Producing Build Artifacts ********************\n"

tar -zcvf $JOB_NAME.BUILD-$BUILD_NUMBER.tar.gz app ctmpl build.sh app.yml app.env config.js Dockerfile docker-compose.yml || { echo "FATAL: Failed on 'Artifact tar''"; exit 1; }

printf "\n\n\n\n**** COMPLETED build.sh ********************\n\n"
