//Express Routing 
var system  = require('../lib/cbe-system');
var cbeAppServer = require('../public/js/libs/cbe-app-server');
var setting  = require('../config/settings.json');
var consul = require('../config/consul-settings.json');	
//var request = require('request');
var nodeSoap = require('node-soap');
var packageJson = require('../package.json');

var app = require('../app'); //share variables
//073117 -- var mongoose = require('mongoose');  //031417
//TODO Try to add promise -- Accepted warning because of uncaught exceptions in promises -- for now
/**
//Accept warning because of uncaught exceptions for now
//DeprecationWarning: Mongoose: mpromise (mongoose's default promise library) is deprecated

//no mongoose connection at all
//mongoose.Promise = require('mpromise'); //031617
//removed promises because exception thrown inside while mongo down
//mongoose.Promise = global.Promise;
//mongoose.Promise = require('bluebird'); //031617

//promise fix
//http://stackoverflow.com/questions/29794064/error-thrown-from-a-mongoose-promise-callback-function-is-not-caught

var mongoose = require('mongoose');
var Promise = require("bluebird");
mongoose.Promise = Promise;
//mongoose.set('error', true);
Promise.promisifyAll(require("mongoose"));
//var mongoose = Promise.promisifyAll(require("mongoose"));
**/

//namespacing to protect module variables
//access like this alert(index.embedded);
//other apps can call it the sameway but need to 
//be later in the js load order
var index = (function () {
	//var route = consul.environment==='server'?packageJson.config.proxyProcessName:packageJson.config.processName;
	var route = packageJson.config.processName;
	return {
		route: route
	};
} )(); //end of namespace
system.logger.warn('index route: '+index.route);

//031417 mongoose db
/** removed on 7/31/17 -- put back for mongodb
var Schema = mongoose.Schema;
var mySchema = new Schema({
  codeType: { type: String, default: 'empty' },
  code: { type: String, default: 'empty' },
  date: { type: Date, default: Date.now }
});
var Usage = mongoose.model('Usage', mySchema);
**/
var serverErrors = [];

//032717
//Validate settings content
if (!(consul.via.endPoint.length > 0)) {
	system.logger.fatal('Service End Point is Empty!');
	throw new Error("Service End Point is Empty!");  //stop app
};

if (!(setting.viaServiceInfo.method.length > 0)) {
	system.logger.fatal('Service Method is Empty!');
	throw new Error("Service Method is Empty!");  //stop app
};

if (!(setting.viaServiceInfo.timeOut > 0)) {
	system.logger.fatal('Service Timeout is not set!');
	throw new Error("Service Timeout is not set!");  //stop app
};

serviceInfo = {
	viaServiceProfile: {
        method          : setting.viaServiceInfo.method,
        uri             : consul.via.endPoint,
        timeout         : +setting.viaServiceInfo.timeOut  
    }
};

exports.cbe = function(req, res){   //called by app.js
  	res.render('index');			//renders ./views/index.ejs template
  	res.flush(); 					//this maybe needed everywhere to utilize compression
};

/** test using -> https://127.0.0.1/cbe/help/auth  **/
exports.helpPage = function(req, res) {
	system.logger.info('redirect to page: '+req.params.page);
 	res.redirect("/"+index.route+"/#"+req.params.page);
};


//Called by cbeAppServer.validateServer chain
exports.checkConditions = function (validValue, typeCode, value, min, max) {

	if ( !(value.length >= min) || !(value.length <= max) || !(validValue) ) {
		system.logger.error('Invalid Medical Code Value: ' + typeCode + " : " + value);
    	serverErrors.push(['2', 'Invalid Medical Code']);
    };

};

/** test using -> https://127.0.0.1/cbe/code  **/
exports.checkCode = function(req, res) {
	var typeOfCode = req.body.medicalCode;
	var code = req.body.codeValue.toUpperCase();
	var codeMessage;
	var usage;
	
	system.logger.info('medicalCode: '+code);
	system.logger.info('typeOfCode: '+typeOfCode);
	
	cbeAppServer.validateServer('server', typeOfCode.toLowerCase(), code);
	
  if (serverErrors.length<1) { 

	try {
		//stubbed service call
		//codeMessage = callService (typeOfCode, code);
		
		switch(typeOfCode) {
	    	case "CPT":
	      		codeMessage = "Yes";
	      		//codeMessage = "";
	      		break;
	    	case "ICD":
	      		codeMessage = "No";
	      		break;
	    	case "DME":
	      		codeMessage = "YES with conditions. To learn more please call our service center at 1-800-733-8387";
	      		break;
	      	case "NDC":
	      		codeMessage = "Unknown Code. To learn more please call our service center at 1-800-733-8387";
	      		break;
	   	 	// add the default keyword here
	   	 	default: 
	        	codeMessage = "Unknown Code Type";
	  	};
  	} catch (error) {
  		system.logger.error('Mongo Service Exception: ' + error);
  		serverErrors.push(['5', 'Mongo Service Exception: ' + error]);
  		//res.render('index', {errors: serverErrors});	 
	};
	
	//test error screen
	//serverErrors.push(['3', 'Test Error Sccreen']);	
	//res.redirect("/"+index.route+"/failure");

	/** removed on 7/31/17 -- put back for mongodb
	if (consul.metrics) {
		usage = new Usage({ 
			codeType: typeOfCode,
			code: code 
		});
		try {
			//async 
			usage.save(function (err) {
		  		if (err){
					system.logger.error("Code Type/Code: " + typeOfCode + "/" + code + " Mongo Save Error: "+err);
				} 
			});
	
		} catch (error) {
	  		system.logger.error('Mongo Save Error Exception: ' + error);	
		};
	};
	**/

 };
 
	if (serverErrors.length<1) {
	 	res.render('index', {typeOfCode: String(typeOfCode), code: String(code), codeMessage: String(codeMessage)});
	} else {
		res.redirect("/"+index.route+"/failure");
	}
};

function callService (typeOfCode, code) {
	
	var codeResult;
	var options = serviceInfo.viaServiceProfile;
 	options['multipart'] = [{ 
			'content-type': setting.viaServiceInfo.contentType,
       body: JSON.stringify({
			"typeOfCode": typeOfCode,
    		"code": code})
 	}];
   
	/** remove for node-soap   
    request(options, function(error, response, body) {

        if (!error && response.statusCode === 200) {
            try {
            	//system.logger.info('200: body: '+body);
                serviceReturnJson = JSON.parse(body);
                
                if ( checkBodyForFailureMessage(serviceReturnJson) ) {
                	system.logger.trace('checkBodyForFailureMessage Failure'); 
                 	//module.exports.serverErrors = serverErrors;
                 	//return done(null, null);
                 	throw new Error("checkBodyForFailureMessage Failure"); 
                };

				codeResult = serviceReturnJson.codeResult;
                system.logger.trace('200: code result: '+codeResult);
                //system.logger.info('200: loa: '+serviceReturnJson.loa);
                //module.exports.serviceReturnJson = serviceReturnJson; //exported above fails to include content?
            } catch(e) {
                var detail = (e) ? e : 'Invalid response from Service';
                system.logger.error('Invalid response from Service: ' + detail);
            	serverErrors.push(['3', 'Invalid response from Service']);
            	//module.exports.serverErrors = serverErrors;
                //return done(null, null);
                throw new Error("Invalid response from Service"); 
            }
            system.logger.trace('Sucessfully called service');
            //return done(null, serviceReturnJson);  //passport.initialize() middleware not in use
            return (codeResult);  
        } else {
        	//service unreachable failure happens here
            if (error) { 
            	system.logger.error('Failure on Service Call: ' + error);
            	serverErrors.push(['4', 'Failure on Service Call ' + error]); 
            	system.logger.debug('error.stack: '+error.stack);
            }  
            if  (response && response.statusCode != 200) {
            	system.logger.error('Failure on Service Call with Status Code: ' + response.statusCode);
            	serverErrors.push(['4', 'Failure on Service Call: ' + response.statusCode]);
            }
            //module.exports.serverErrors = serverErrors;
            //return done('Error with login', null); // returning a value here causes node to choke-n-die
            //return done(null, null);
            throw new Error("Failure on Service Call");
         }
         
    });
    **/
	return(false);
};

function checkBodyForFailureMessage(serviceReturnJson) {
	
	system.logger.trace('checkBodyForFailure');
	 
	if (serviceReturnJson.authorized=='FALSE') {
		system.logger.error('Body Failure user not authorized: ' + serviceReturnJson.authorized);
		serverErrors.push(['3', 'User Not Authorized']); 
		return(true);
	}; 
	 
	if (serviceReturnJson.faultstring) {
		system.logger.error('Body Failure faultstring: ' + serviceReturnJson.faultstring);
		serverErrors.push(['3', serviceReturnJson.faultstring]); 
		return(true);
	}; 
	 
	return(false);
};

//oAuth entry point from the client for full screen 
//exports.authProvider = auth.passport.authenticate('provider');
  	
exports.cbeFailure = function(req, res) {
	
	system.logger.trace('/'+index.route+'/failure');
	system.logger.trace('serverError: ' + serverErrors.length);
	system.logger.trace('app.serverError: ' + app.serverErrors.length);
	
	if (serverErrors.length<1 && app.serverErrors.length<1) {
		serverErrors.push(['6', 'Service has Failed ']);
	}

	//var exceptions = serverErrors;
	var exceptions = serverErrors.concat(app.serverErrors);
	
	for (var i in exceptions) {
  		system.logger.error("Error: " + exceptions[i][0]+" : "+exceptions[i][1]);
	}
	
	system.logger.trace('all serverErrors reset');						
  	serverErrors = [];
  	app.serverErrors = [];

    system.logger.trace('/'+index.route+'/failure return');                                                                                             
    res.render('index', {errors: exceptions});  //render views/index.ejs -- with 'errors' parameter
    
};  	
