//"use strict";

//Global variables
//var currentPage,
var dleRouter = new app.Router(); 
//Backbone.history.start(); //retain historical clicks

//namespacing to protect module variables
//access like this alert(dle_app.namespaceR);
//other apps can call it the sameway but need to 
//be later in the js load order
var dle_app = (function () {

	var testVariableNotUsed = "cbe-app";
	var userDecline = "Declined";
	var eulaDeclineMessage = "You have declined the End User License Agreement. Please dismiss this message and you will be returned to the launchpad.";
	var cptMin = 3;
	
	
	return {
		namespaceR: testVariableNotUsed,
		userDecline: userDecline,
		eulaDeclineMessage: eulaDeclineMessage,
		cptMin: cptMin
	};
	
} )(); //end of namespace

$(document).ready(function() {
	Backbone.history.start(); //retain historical clicks	

	//intercept data-confirm click event
	//only need to load one time
	$('a[data-confirm-navbar]').click(function(ev) {
		var inBody = $(this).attr('data-confirm-navbar');
		var inHref = $(this).attr('data-href');
		var inTitle = $(this).attr('data-title');
		var confirmationDialog = modalConfirmDialog(inTitle, inBody);
		
		confirmationDialog.then(function (confirmationResponse) {							
			if (confirmationResponse) {
				window.location=inHref;
				}
			else {
				document.getElementById("launchpadButton").focus();
			}
		});
	});

});

function checkConditions(validValue, typeCode, value, min, max) {
	
	if (value.length >= min && value.length <= max) {
    	if ( validValue ){
			removeValidationError(typeCode);
	    	setSubmitButton(typeCode, false);
			addValidationSuccess(typeCode);
    	} else {
			removeValidationSuccess(typeCode);
	    	setSubmitButton(typeCode, true);
	    	addValidationError(typeCode);
    	}   	
    } else {
    	//alert('length issue');
    	if (value.length < min) {
	    	if ( validValue ){
				removeValidationError (typeCode);
		    	setSubmitButton(typeCode, true);
				removeValidationSuccess(typeCode);
		    } else {
				removeValidationSuccess(typeCode);
		    	setSubmitButton(typeCode, true);
				addValidationError(typeCode); 
		    }
		} else {
			removeValidationSuccess(typeCode);
		   	setSubmitButton(typeCode, true);
			addValidationError(typeCode); 
		}
    };
	
};

function addValidationError ( typeCode ){
	$("#"+typeCode+"ValidateBox").addClass("has-error");
    $("#"+typeCode+"ValidateHelper").addClass("glyphicon-remove"); 
}

function removeValidationError ( typeCode ){
	$("#"+typeCode+"ValidateBox").removeClass("has-error");
	$("#"+typeCode+"ValidateHelper").removeClass("glyphicon-remove");
}

function addValidationSuccess ( typeCode ){
	$("#"+typeCode+"ValidateBox").addClass("has-success");
	$("#"+typeCode+"ValidateHelper").addClass("glyphicon-ok");
}

function removeValidationSuccess ( typeCode ){
	$("#"+typeCode+"ValidateBox").removeClass("has-success");
	$("#"+typeCode+"ValidateHelper").removeClass("glyphicon-ok");
}
	    	
function setSubmitButton ( typeCode, disabled ){
	$('#'+typeCode+'Submit').attr('disabled', disabled);
}


// SEC 508 requirement to have a keyboard event associated with the launchpadButton
$('#exit').keypress(function(event) {
  switch (event.keyCode) {
    case 13: //enter key (13)
			//alert("Launchpad keyboard event triggered");
			//Keyboard event simply invokes the button's mouse click event
			$('#launchpadButton').click();
    break;
  }
});

function declineEulaExit() {
	var inTitle = dle_app.userDecline;
	var inBody = dle_app.eulaDeclineMessage;
	$('#myModal').css('background-color', 'black', 'opacity', '1 !important');
	$("#cancelButton").hide();
	var confirmationDialog = modalConfirmDialog(inTitle, inBody);
	
	confirmationDialog.then(function (confirmationResponse) {							
		if (confirmationResponse) {
			window.location=launchPadLink;
		}
	});
};

//reset event with new screen content
function resetDataConfirmEvent() {
	$('a[data-confirm]').off('click',addDataConfirm);
	$('a[data-confirm]').on('click',addDataConfirm);
}

function addDataConfirm() {
	var inBody = $(this).attr('data-confirm');
	var inHref = $(this).attr('data-href');
	var inTitle = $(this).attr('data-title');
	var inFocus = $(this).attr('id');
	var confirmationDialog = modalConfirmDialog(inTitle, inBody);
	
	confirmationDialog.then(function (confirmationResponse) {							
		if (confirmationResponse) {
			window.location=inHref;
			}
		else {
			$('#'+inFocus).focus();
			}
	});
}

function modalConfirmDialog(title, bodyText) {
  var deferredQueue = jQuery.Deferred();
  var modalConfirm = $('#myModal');
  
  $('#myModalTitle').html(title);  
  $('#myModalText').html(bodyText); 
  modalConfirm.modal('show');
  
  $('#okButton').off('click').click(function () {
    modalConfirm.modal('hide');
    deferredQueue.resolve(true);
  });
  
  $('#cancelButton').off('click').click(function () {
    modalConfirm.modal('hide');
    deferredQueue.resolve(false);
  });
  
  return deferredQueue.promise();
};

function ConfirmEulaYesNo() {
  var deferredQueue = jQuery.Deferred();
  var modalConfirm = $('#eula-modal');
  modalConfirm.modal('show');

  $('#acceptEulaBtn').off('click').click(function () {
    modalConfirm.modal('hide');
    deferredQueue.resolve(true);
  });
  
  $('#declineEulaBtn').off('click').click(function () {
    modalConfirm.modal('hide');
    deferredQueue.resolve(false);
  });
  
  return deferredQueue.promise();
};

$('#myModal').on('shown.bs.modal', function () { 
	$('#myModalTitle').focus(); 
});

$('#eula-modal').on('shown.bs.modal', function () {
  $('#eulaModalTitle').focus();
});

function identifyMenu(activeButton) {
	
	//alert('identifyMenu: '+activeButton);
	var menuId = "#" + activeButton;
	var navigationArray=['#home', '#exit', '#about', '#help', '#checkCode', '#contactus'];  

	for (i in navigationArray) {  
        $(navigationArray[i]).removeClass('active'); 
        $(navigationArray[i]+'Selected').html("");
        $(navigationArray[i]+' a').attr('aria-selected', false); 
    }
	
	$(menuId+'Selected').html("selected");	
	$(menuId+' a').attr('aria-selected', "true");
	$(menuId).addClass('active');
	$(menuId+'Selected').html("");
} //function identifyButton

/**
function addInfoScreen508events() {

	$('#howDsLogonAppHelpMe').on('show.bs.collapse', function () {
	  $("#toggleHowDsLogonAppHelpMe").html("hide content"); 
	  $("#headingHowDsLogonAppHelpMe a").attr("aria-expanded","true");	  
	  //alert("howDsLogonAppHelpMe hide");
	});
	
	$('#howDsLogonAppHelpMe').on('hidden.bs.collapse', function () {
	  $("#toggleHowDsLogonAppHelpMe").html("show content");
	  $("#headingHowDsLogonAppHelpMe a").attr("aria-expanded","false");
	  //alert("howDsLogonAppHelpMe show");
	});
	
	$('#howDoIRegisterForDsLogon').on('show.bs.collapse', function () {
	  $("#toggleHowDoIRegisterForDsLogon").html("hide content");
	  $("#headingHowDoIRegisterForDsLogon a").attr("aria-expanded","true");
	  //alert("howDoIRegisterForDsLogon hide");
	});
	
	$('#howDoIRegisterForDsLogon').on('hidden.bs.collapse', function () {
	  $("#toggleHowDoIRegisterForDsLogon").html("show content");
	  $("#headingHowDoIRegisterForDsLogon a").attr("aria-expanded","false");
	  //alert("howDoIRegisterForDsLogon show");
	});
	
	$('#whatIsADsLogon').on('show.bs.collapse', function () {
	  $("#toggleWhatIsADsLogon").html("hide content"); 
	  $("#headingWhatIsADsLogon a").attr("aria-expanded","true");
	  //alert("whatIsADsLogon hide");
	});
	
	$('#whatIsADsLogon').on('hidden.bs.collapse', function () {
	  $("#toggleWhatIsADsLogon").html("show content");
	  $("#headingWhatIsADsLogon a").attr("aria-expanded","false");
	  //alert("whatIsADsLogon show");
	});
	
	$('#whoIsEligibleForDsLogon').on('show.bs.collapse', function () {
	  $("#toggleWhoIsEligibleForDsLogon").html("hide content"); 
	  $("#headingWhoIsEligibleForDsLogon a").attr("aria-expanded","true");
	  //alert("whoIsEligibleForDsLogon hide");
	});
	
	$('#whoIsEligibleForDsLogon').on('hidden.bs.collapse', function () {
	  $("#toggleWhoIsEligibleForDsLogon").html("show content");
	  $("#headingWhoIsEligibleForDsLogon a").attr("aria-expanded","false");
	  //alert("whoIsEligibleForDsLogon show");
	});
	
	$('#howDoIUpgradeFromLevel1ToLevel2Info').on('show.bs.collapse', function () {
	  $("#toggleHowDoIUpgradeFromLevel1ToLevel2Info").html("hide content"); 
	  $("#headingHowDoIUpgradeFromLevel1ToLevel2Info a").attr("aria-expanded","true");	  
	  //alert("howDoIUpgradeFromLevel1ToLevel2Info hide");
	});
	
	$('#howDoIUpgradeFromLevel1ToLevel2Info').on('hidden.bs.collapse', function () {
	  $("#toggleHowDoIUpgradeFromLevel1ToLevel2Info").html("show content");
	  $("#headingHowDoIUpgradeFromLevel1ToLevel2Info a").attr("aria-expanded","false");
	  //alert("howDoIUpgradeFromLevel1ToLevel2Info show");
	});	
	
	$('#whatIsDeers').on('show.bs.collapse', function () {
	  $("#toggleWhatIsDeers").html("hide content"); 
	  $("#headingWhatIsDeers a").attr("aria-expanded","true");
	  //alert("whatIsDeers hide");
	});
	
	$('#whatIsDeers').on('hidden.bs.collapse', function () {
	  $("#toggleWhatIsDeers").html("show content");
	  $("#headingWhatIsDeers a").attr("aria-expanded","false");
	  //alert("whatIsDeers show");
	});
	
	$('#whatIsDifferenceBetween1and2').on('show.bs.collapse', function () {
	  $("#toggleWhatIsDifferenceBetween1and2").html("hide content"); 
	  $("#headingWhatIsDifferenceBetween1and2 a").attr("aria-expanded","true");
	  //alert("whatIsDifferenceBetween1and2 hide");
	});
	
	$('#whatIsDifferenceBetween1and2').on('hidden.bs.collapse', function () {
	  $("#toggleWhatIsDifferenceBetween1and2").html("show content");
	  $("#headingWhatIsDifferenceBetween1and2 a").attr("aria-expanded","false");
	  //alert("whatIsDifferenceBetween1and2 show");
	});
	
	$('#dsLogonMobileApps').on('show.bs.collapse', function () {
	  $("#toggleDsLogonMobileApps").html("hide content"); 
	  $("#headingDsLogonMobileApps a").attr("aria-expanded","true");
	  //alert("dsLogonMobileApps hide");
	});
	
	$('#dsLogonMobileApps').on('hidden.bs.collapse', function () {
	  $("#toggleDsLogonMobileApps").html("show content");
	  $("#headingDsLogonMobileApps a").attr("aria-expanded","false");
	  //alert("dsLogonMobileApps show");
	});

	// SEC 508 requirement to have a keyboard event associated with the vaAppStore link
	$('#vaAppStore').keypress(function(event) {
			 switch (event.keyCode) {
	    case 13: //Enter key (13)
				//Keyboard event simply invokes the link's mouse click event
				$('#vaAppStore').click();
	    break;
	 	 }
		});
	
	// SEC 508 requirement to have a keyboard event associated with the dsLogonApps link
	$('#dsLogonApps').keypress(function(event) {
			 switch (event.keyCode) {
	    case 13: //enter key (13)
				//Keyboard event simply invokes the link's mouse click event
				$('#dsLogonApps').click();
	    break;
	 	 }
	});
	
};
**/

/**
function addResolutionScreen508events() {

	$('#useHealtheVetInsteadDsLogon').on('show.bs.collapse', function () {
	  $("#toggleUseHealtheVetInsteadDsLogon").html("hide content"); 
	  $("#headingUseHealtheVetInsteadDsLogon a").attr("aria-expanded","true");
	  //alert("useHealtheVetInsteadDsLogon hide");
	});
	
	$('#useHealtheVetInsteadDsLogon').on('hidden.bs.collapse', function () {
	  $("#toggleUseHealtheVetInsteadDsLogon").html("show content");
	  $("#headingUseHealtheVetInsteadDsLogon a").attr("aria-expanded","false");
	  //alert("useHealtheVetInsteadDsLogon show");
	});
	
	$('#howDoIRecoverUsernamePassword').on('show.bs.collapse', function () {
	  $("#toggleHowDoIRecoverUsernamePassword").html("hide content");
	  $("#headingHowDoIRecoverUsernamePassword a").attr("aria-expanded","true");
	  //alert("howDoIRecoverUsernamePassword hide"); 
	});
	
	$('#howDoIRecoverUsernamePassword').on('hidden.bs.collapse', function () {
	  $("#toggleHowDoIRecoverUsernamePassword").html("show content");
	  $("#headingHowDoIRecoverUsernamePassword a").attr("aria-expanded","false");
	  //alert("howDoIRecoverUsernamePassword show");
	});
	
	$('#howDoIUpgradeFromLevel1ToLevel2').on('show.bs.collapse', function () {
	  $("#toggleHowDoIUpgradeFromLevel1ToLevel2").html("hide content"); 
	  $("#headingHowDoIUpgradeFromLevel1ToLevel2 a").attr("aria-expanded","true");
	  //alert("howDoIUpgradeFromLevel1ToLevel2 hide"); 
	});
	
	$('#howDoIUpgradeFromLevel1ToLevel2').on('hidden.bs.collapse', function () {
	  $("#toggleHowDoIUpgradeFromLevel1ToLevel2").html("show content");
	  $("#headingHowDoIUpgradeFromLevel1ToLevel2 a").attr("aria-expanded","false");
	  //alert("howDoIUpgradeFromLevel1ToLevel2 show"); 
	});
	
	$('#remoteProofingFailsTryAgain').on('show.bs.collapse', function () {
	  $("#toggleRemoteProofingFailsTryAgain").html("hide content"); 
	  $("#headingRemoteProofingFailsTryAgain a").attr("aria-expanded","true");
	  //alert("remoteProofingFailsTryAgain hide");
	});
	
	$('#remoteProofingFailsTryAgain').on('hidden.bs.collapse', function () {
	  $("#toggleRemoteProofingFailsTryAgain").html("show content");
	  $("#headingRemoteProofingFailsTryAgain a").attr("aria-expanded","false");
	  //alert("remoteProofingFailsTryAgain show");
	});
	
	$('#whatIsRemoteProofing').on('show.bs.collapse', function () {
	  $("#toggleWhatIsRemoteProofing").html("hide content"); 
	  $("#headingWhatIsRemoteProofing a").attr("aria-expanded","true");
	  //alert("whatIsRemoteProofing hide");
	});
	
	$('#whatIsRemoteProofing').on('hidden.bs.collapse', function () {
	  $("#toggleWhatIsRemoteProofing").html("show content");
	  $("#headingWhatIsRemoteProofing a").attr("aria-expanded","false");
	  //alert("whatIsRemoteProofing show");
	});

	// SEC 508 requirement to have a keyboard event associated with the myAccessCenter link
	$('#myAccessCenter').keypress(function(event) {
			 switch (event.keyCode) {
	    case 13: //Enter key (13)
				//Keyboard event simply invokes the link's mouse click event
				$('#myAccessCenter').click();
	    break;
	 	 }
		});

};
**/

//TODO Fix 508 following completion of Help Screen
function addHelpScreen508events() {

	$('#howToCheckACode').on('show.bs.collapse', function () {
	  $("#toggleHowToCheckACode").html("hide content"); 
	  $("#headingHowToCheckACode a").attr("aria-expanded","true");
	  //alert("howToCheckACode hide");
	});
	
	$('#howToCheckACode').on('hidden.bs.collapse', function () {
	  $("#toggleHowToCheckACode").html("show content");
	  $("#headingHowToCheckACode a").attr("aria-expanded","false");
	  //alert("howToCheckACode show");
	});

	//DLEA-1360	
	$(function () {
    $('#howToCheckACode').on('shown.bs.collapse', function (e) {
    var offset = $('.panel.panel-default > .panel-collapse.in').offset();
    if (offset) $('html,body').scrollTop(offset.top);
		});
	 });
	
	$('#howToExecModule').on('show.bs.collapse', function () {
	  $("#toggleHowToExecModule").html("hide content");
	  $("#headingHowToExecModule a").attr("aria-expanded","true");	  
	  //alert("howToExecModule hide"); 
	});
	
	$('#howToExecModule').on('hidden.bs.collapse', function () {
	  $("#toggleHowToExecModule").html("show content");
	  $("#headingHowToExecModule a").attr("aria-expanded","false");
		//alert("howToExecModule show");
	});

	//DLEA-1360	
	$(function () {
    $('#howToExecModule').on('shown.bs.collapse', function (e) {
    var offset = $('.panel.panel-default > .panel-collapse.in').offset();
    if (offset) $('html,body').scrollTop(offset.top);
		});
	 });
	
	$('#howToResolutionModule').on('show.bs.collapse', function () {
	  $("#toggleHowToResolutionModule").html("hide content"); 
	  $("#headingHowToResolutionModule a").attr("aria-expanded","true");
	  //alert("howToResolutionModule hide"); 
	});
	
	$('#howToResolutionModule').on('hidden.bs.collapse', function () {
	  $("#toggleHowToResolutionModule").html("show content");
	  $("#headingHowToResolutionModule a").attr("aria-expanded","false");
		//alert("howToResolutionModule show"); 
	});

	//DLEA-1360	
	$(function () {
    $('#howToResolutionModule').on('shown.bs.collapse', function (e) {
    var offset = $('.panel.panel-default > .panel-collapse.in').offset();
    if (offset) $('html,body').scrollTop(offset.top);
		});
	 });

	$('#whoToContactForSupport').on('show.bs.collapse', function () {
	  $("#toggleWhoToContactForSupport").html("hide content"); 
	  $("#headingWhoToContactForSupport a").attr("aria-expanded","true");
	  //alert("whoToContactForSupport hide");
	});
	
	$('#whoToContactForSupport').on('hidden.bs.collapse', function () {
	  $("#toggleWhoToContactForSupport").html("show content");
	  $("#headingWhoToContactForSupport a").attr("aria-expanded","false");
	  //alert("whoToContactForSupport show");
	});
	
	$('#howToNavigateLaunchpad').on('show.bs.collapse', function () {
	  $("#toggleHowToNavigateLaunchpad").html("hide content"); 
	  $("#headingHowToNavigateLaunchpad a").attr("aria-expanded","true");
	  //alert("howToNavigateLaunchpad hide");
	});
	
	$('#howToNavigateLaunchpad').on('hidden.bs.collapse', function () {
	  $("#toggleHowToNavigateLaunchpad").html("show content");
	  $("#headingHowToNavigateLaunchpad a").attr("aria-expanded","false");
	  //alert("howToNavigateLaunchpad show");
	});
	
	$('#whereTrainingMaterials').on('show.bs.collapse', function () {
	  $("#toggleWhereTrainingMaterials").html("hide content"); 
	  $("#headingWhereTrainingMaterials a").attr("aria-expanded","true");
	  //alert("whereTrainingMaterials hide");
	});
	
	$('#whereTrainingMaterials').on('hidden.bs.collapse', function () {
	  $("#toggleWhereTrainingMaterials").html("show content");
	  $("#headingWhereTrainingMaterials a").attr("aria-expanded","false");
	  //alert("whereTrainingMaterials show");
	});
	
	$('#whereSubmitFeedback').on('show.bs.collapse', function () {
	  $("#toggleWhereSubmitFeedback").html("hide content"); 
	  $("#headingWhereSubmitFeedback a").attr("aria-expanded","true");
	  //alert("whereSubmitFeedback hide");
	});
	
	$('#whereSubmitFeedback').on('hidden.bs.collapse', function () {
	  $("#toggleWhereSubmitFeedback").html("show content");
	  $("#headingWhereSubmitFeedback a").attr("aria-expanded","false");
	  //alert("whereSubmitFeedback show");
	});
	
	$('#whatBrowsersUse').on('show.bs.collapse', function () {
	  $("#toggleWhatBrowsersUse").html("hide content"); 
	  $("#headingWhatBrowsersUse a").attr("aria-expanded","true");
	  //alert("whatBrowsersUse hide");
	});
	
	$('#whatBrowsersUse').on('hidden.bs.collapse', function () {
	  $("#toggleWhatBrowsersUse").html("show content");
	  $("#headingWhatBrowsersUse a").attr("aria-expanded","false");
	  //alert("whatBrowsersUse show");
	});

	//DLEA-1360	
	$(function () {
    $('#whatBrowsersUse').on('shown.bs.collapse', function (e) {
    var offset = $('.panel.panel-default > .panel-collapse.in').offset();
    if (offset) $('html,body').scrollTop(offset.top);
		});
	 });
};

/**
function addAuthHelp508events() {

	$('#stepsDsLogon').on('show.bs.collapse', function () {
	  $("#toggleStepsDsLogon").html("hide content"); 
	  $("#headingStepsDsLogon a").attr("aria-expanded","true");
	  //alert("stepsDsLogon hide");
	});
	
	$('#stepsDsLogon').on('hidden.bs.collapse', function () {
	  $("#toggleStepsDsLogon").html("show content");
	  $("#headingStepsDsLogon a").attr("aria-expanded","false");
	  //alert("stepsDsLogon show");
	});
	
	$('#logonPasswordIssue').on('show.bs.collapse', function () {
	  $("#toggleLogonPasswordIssue").html("hide content");
	  $("#headingLogonPasswordIssue a").attr("aria-expanded","true");
	  //alert("logonPasswordIssue hide"); 
	});
	
	$('#logonPasswordIssue').on('hidden.bs.collapse', function () {
	  $("#toggleLogonPasswordIssue").html("show content");
	  $("#headingLogonPasswordIssue a").attr("aria-expanded","false");
	  //alert("logonPasswordIssue show");
	});
	
	$('#technicalIssue').on('show.bs.collapse', function () {
	  $("#toggleTechnicalIssue").html("hide content"); 
	  $("#headingTechnicalIssue a").attr("aria-expanded","true");
	  //alert("technicalIssue hide"); 
	});
	
	$('#technicalIssue').on('hidden.bs.collapse', function () {
	  $("#toggleTechnicalIssue").html("show content");
	  $("#headingTechnicalIssue a").attr("aria-expanded","false");
	  //alert("technicalIssue show"); 
	});

	// SEC 508 requirement to have a keyboard event associated with the Test Access button
	$('#check-code').keypress(function(event) {
			 switch (event.keyCode) {
	    case 13: //enter key (13)
		  	//alert("testaccessButton keyboard event triggered");
				//Keyboard event simply invokes the button's mouse click event
				$('#check-code').click();
	    break;
	 	 }
	});
};
**/

//TODO Add Pulled stub 508 Event from DLE
function addWelcome508events() {
	
	// SEC 508 requirement to have a keyboard event associated with the Test Access button
	$('#check-code').keypress(function(event) {
			 switch (event.keyCode) {
	    case 13: //enter key (13)
		  	//alert("testaccessButton keyboard event triggered");
				//Keyboard event simply invokes the button's mouse click event
				$('#check-code').click();
	    break;
	 	 }
	});	
	
};

//TODO Add Pulled stub 508 Event from DLE
function addCheckedCode508events() {
	
	// SEC 508 requirement to have a keyboard event associated with the Test Access button
	$('#check-code').keypress(function(event) {
			 switch (event.keyCode) {
	    case 13: //enter key (13)
		  	//alert("testaccessButton keyboard event triggered");
				//Keyboard event simply invokes the button's mouse click event
				$('#check-code').click();
	    break;
	 	 }
	});	
	
};

//auto closes navbar following a selection on mobile devices
$(document).on('click','.navbar-collapse.in',function(e) {
    if( $(e.target).is('a') ) {
        $(this).collapse('hide');
    }
});

//sets mobile menu text to reflect menu status for screen readers
$('#collapse').on('show.bs.collapse', function () {
  $("#toggleNavigation").html("Menu, close menu"); 
  //alert("Menu, close menu");
});

$('#collapse').on('hidden.bs.collapse', function () {
  $("#toggleNavigation").html("Menu, open menu");
  //alert("Menu, open menu");
});

$('#contactus').on('show.bs.dropdown', function () {
  $("#contactus a").attr("aria-expanded","true");
  $("#contactUsDropdown").html("Cellular service is required for automatic dialing");
  //alert("dropdown show");
});

$('#contactus').on('hidden.bs.dropdown', function () {
  $("#contactus a").attr("aria-expanded","false");
  $("#contactUsDropdown").html("");
  //alert("dropdown hide");
});

/** removed id="auth" from welcome screen
$('#auth').on('show.bs.dropdown', function () {
  $("#authDropdown").html("hide content");
  //alert("dropdown show");
});

$('#auth').on('hidden.bs.dropdown', function () {
  $("#authDropdown").html("show content");
  //alert("dropdown hide");
});
**/
/**	
function getParameterByName(name) {
	name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
	var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
		results = regex.exec(location.search);
	return results == null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
}
**/
