//"use strict";
//Removed strict to allow shared import

function validate (entry, typeCode, codeValue) {
	switch(typeCode) {
	    case "cpt":
	        validateText(entry, typeCode, codeValue, 3, 7);
	        break;
	    case "icd":
	        validateText(entry, typeCode, codeValue, 1, 8);
	        break;
	    case "dme":
	        validateText(entry, typeCode, codeValue, 3, 7);
	        break;
	    case "ndc":
	        validateText(entry, typeCode, codeValue, 11, 11);
	        break;	 
	    default:
        	if (entry == 'client') {
    			checkConditions(false, typeCode, codeValue, 0, 0);
    		} else {
    			routes.checkConditions(false, typeCode, codeValue, 0, 0);
    		}       
	}
};

function validateText(entry, typeCode, value, min, max) {   
    var validValue = validateValue (typeCode, value);
    if (entry == 'client') {
    	checkConditions(validValue, typeCode, value, min, max);
    } else {
    	routes.checkConditions(validValue, typeCode, value, min, max);
    }
    
};

function validateValue (typeCode, value){
	for (var i = 0; i < value.length; i++) {
  		if ( !(validateCharacter ( typeCode, value[i], i))) {
  			return false;
  		};
	}
	return true;
}

function validateCharacter(typeCode, char, position){
    //mandatory	
    /** removed 070317
    if ( (typeCode == 'ndc') && (position == 5 || position == 10) ) {
    	if ( /[-]/.test( char ) ) {
    		return true;
    	} else {
    		return false;
    	}
    }	
    **/
    //optional
    if ( (typeCode == 'icd') && (position == 3) ) {
    	if ( /[.]/.test( char ) ) {
    		return true;
    	}
    }	
    if (typeCode == 'ndc') {
	    if( /[0-9]/.test( char ) ) {
	       return true;
	    }     	
    } else {
	    if( /[a-zA-Z0-9]/.test( char ) ) {
	       return true;
	    }    	
    }
    
    return false;     
 }
//end 032017


