/* 
Author: L. Mansfield
*Build 4 - 2018-02-05
*/
:setvar DatabaseName "RegistryHRE"
:setvar MajorReleaseNumber "4" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "10"
:setvar ScriptName "1_ROLLBACK.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Rollback of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following two lines:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO
USE $(DatabaseName)
GO
---------------------------------------------------------------------------------------------------------
PRINT '$(ScriptName) script started...';
PRINT GETDATE();
GO

-- Roll Back ALTER VIEW
---------------------------------------------------------------------------------------------------------
PRINT 'Revert [AHOBPR].[VIEW_LOOKUP] to 3.0.10 version';
GO
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
--last updated in 3.0.10  script
ALTER VIEW [AHOBPR].[VIEW_LOOKUP] 
WITH SCHEMABINDING 
AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
		OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME = 'Eligibility Review - More Documentation Needed'))--2.0.13.1 changed this line
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM  AHOBPR.VIEW_ETL_LOOKUP 
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     , ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM  AHOBPR.VIEW_ETL_LOOKUP 
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM [AHOBPR].[STD_SEPARATION_FAMILY]
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_DISCHARGE_CHARACTER]
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[EMAIL_TEMPLATES]
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 0 AND USER_FLAG = 0  -- Build 3.0.10
  AND TITLE NOT IN ('Eligible for Burn Pit Registry', 'Not Eligible for Burn Pit Registry', 
	'New Follow-up Questions', 'Need More Documentation', 'Name Updated')  -- Build 3.0.6 add 'Name Updated'
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_FORM] A
  WHERE FOLLOWUP_FLAG = 1
  --Follow up Send Page > Deactivated groups showing in Drop down (272277)
   AND NOT EXISTS (SELECT 'X' FROM AHOBPR.TOOL_FORM WHERE TOOL_FORM_ID = A.TOOL_FORM_ID AND (ACTIVE_FLAG = 0 OR SYSTEM_WIDE_FLAG = 1))
UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''
UNION ALL
SELECT 'MY_TEMPLATES_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,CREATEDBY AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[EMAIL_TEMPLATES]
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 1
UNION ALL
SELECT DISTINCT 'ENROLLMENT_STATUS' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[ENROLLMENT_STATUS] AS CODE
       ,[ENROLLMENT_STATUS] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
   WHERE ENROLLMENT_STATUS > ''
UNION ALL
SELECT 'USER_ROLE' AS LOOKUP_TYPE    -- Build 3.0.7
	     ,A.ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [dbo].[STD_ROLE] A, [dbo].[STD_REGISTRY] B
  WHERE A.STD_REGISTRY_ID = B.ID AND B.CODE = 'AHOBPR'
UNION ALL
  SELECT DISTINCT 'AUDIT_ACTION_TYPE' AS LOOKUP_TYPE   -- Build 3.0.7
	     ,TYPE_ID AS ID
       , [DESCRIPTION] AS CODE
       , [DESCRIPTION] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[AUDIT_LOG_TYPE]
  WHERE [DESCRIPTION] <> 'Data Maintenance'  
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_DROPDOWN' AS LOOKUP_TYPE   -- Build 3.0.8 
          ,STD_FORM_ID AS ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_FORM] A, [AHOBPR].[TOOL_FORM] B
  WHERE A.FOLLOWUP_FLAG = 1 AND A.TOOL_FORM_ID = B.TOOL_FORM_ID
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,0 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,1 AS ID
       ,'Active' AS CODE
       ,'Active' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,2 AS ID
       ,'Inactive' AS CODE
       ,'Inactive' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,3 AS ID
       ,'Pending' AS CODE
       ,'Pending' AS NAME
       ,0 AS PARENT_ID
       ,4 AS SORT_ORDER
UNION ALL
SELECT 'USER_EMAIL_TEMPLATE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND USER_FLAG = 1  -- Build 3.0.10 
UNION ALL
SELECT 'USER_ROLE_ALL' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,0 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,0 AS SORT_ORDER
UNION ALL
SELECT 'USER_ROLE_ALL' AS LOOKUP_TYPE    -- Build 3.0.10
	     ,A.ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [dbo].[STD_ROLE] A, [dbo].[STD_REGISTRY] B
  WHERE A.STD_REGISTRY_ID = B.ID AND B.CODE = 'AHOBPR'

-- select * from  [AHOBPR].[VIEW_LOOKUP]
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS, QUOTED_IDENTIFIER ON;
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Rollback Data INSERT into STD_GUI_CONTROLS';
GO
---------------------------------------------------------------------------------------------------------
DECLARE  @RegistryId int
SELECT @RegistryId = ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR'
BEGIN
	-- Delete the previously inserted AHOBPR GUI control entries...
	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
		and CATEGORY = 'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION' 
		AND [NAME] IN ('My Account Primary Job Parameters', 'My Account Secondary Job Parameters', 'My Account Work Location Parameters');
END

BEGIN
	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
  	and CATEGORY = 'AHOBPR_CLINICAL_USER_ADHOC_REPORT'
		AND [NAME] IN ('Ad-Hoc Report', 'Primary Job parameters', 'Status parameters','Secondary Job parameters','Work Location parameters','Job Title parameters','Change Status State parameters');	
END

BEGIN
    DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
  	and CATEGORY = 'AHOBPR_CREATE_ACCOUNT'
		AND [NAME] IN ('My Account Primary Job Parameters', 'My Account Secondary Job Parameters', 'My Account Work Location Parameters');
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'DROP CONSTRAINT FK_PRIMARY_JOB_ID FROM TABLE [AHOBPR].[AHOBPR_USER]';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[FK_PRIMARY_JOB_ID]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_PRIMARY_JOB_ID';
	ALTER TABLE [AHOBPR].[AHOBPR_USER] DROP CONSTRAINT FK_PRIMARY_JOB_ID;
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'DROP CONSTRAINT FK_SECONDARY_JOB_ID FROM TABLE [AHOBPR].[AHOBPR_USER]';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[FK_SECONDARY_JOB_ID]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop [FK_SECONDARY_JOB_ID]';
ALTER TABLE [AHOBPR].[AHOBPR_USER] DROP CONSTRAINT FK_SECONDARY_JOB_ID;
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'DROP CONSTRAINT FK_WORK_LOCATION_ID FROM TABLE [AHOBPR].[AHOBPR_USER]';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[FK_WORK_LOCATION_ID]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop [FK_WORK_LOCATION_ID]';
ALTER TABLE [AHOBPR].[AHOBPR_USER] DROP CONSTRAINT FK_WORK_LOCATION_ID
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'DROP CONSTRAINT [FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION] FROM TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS]';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop [FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION]';
ALTER TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS] DROP CONSTRAINT FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'REMOVE PRIMARY_JOB_ID FROM TABLE [AHOBPR].[AHOBPR_USER]';
GO
---------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM  sys.columns WHERE  object_id = OBJECT_ID(N'[AHOBPR].[AHOBPR_USER]') AND name = 'PRIMARY_JOB_ID')
BEGIN
	ALTER TABLE [AHOBPR].[AHOBPR_USER] DROP COLUMN  PRIMARY_JOB_ID;
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'REMOVE SECONDARY_JOB_ID FROM TABLE [AHOBPR].[AHOBPR_USER]';
GO
---------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM  sys.columns WHERE  object_id = OBJECT_ID(N'[AHOBPR].[AHOBPR_USER]') AND name = 'SECONDARY_JOB_ID')
BEGIN
	ALTER TABLE [AHOBPR].[AHOBPR_USER] DROP COLUMN  SECONDARY_JOB_ID;
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'REMOVE WORK_LOCATION_ID FROM TABLE [AHOBPR].[AHOBPR_USER]';
GO
---------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM  sys.columns WHERE  object_id = OBJECT_ID(N'[AHOBPR].[AHOBPR_USER]') AND name = 'WORK_LOCATION_ID')
BEGIN
	ALTER TABLE[AHOBPR].[AHOBPR_USER] DROP COLUMN  WORK_LOCATION_ID;
END
GO












-- DROP TABLE [AHOBPR].[STD_PRIMARY_JOB]
---------------------------------------------------------------------------------------------------------
PRINT 'DROP TABLE [AHOBPR].[STD_PRIMARY_JOB]';
GO
---------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_PRIMARY_JOB]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_PRIMARY_JOB];
END
GO

-- DROP TABLE [AHOBPR].[STD_SECONDARY_JOB]
---------------------------------------------------------------------------------------------------------
PRINT 'DROP TABLE [AHOBPR].[STD_SECONDARY_JOB]';
GO
---------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_SECONDARY_JOB]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_SECONDARY_JOB];
END
GO

-- DROP TABLE [AHOBPR].[STD_WORK_LOCATION]
---------------------------------------------------------------------------------------------------------
PRINT 'DROP TABLE [AHOBPR].[STD_WORK_LOCATION]';
GO
---------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_WORK_LOCATION]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_WORK_LOCATION];
END
GO

-- DROP TABLE [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION]
---------------------------------------------------------------------------------------------------------
PRINT 'DROP TABLE [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION]';
GO
---------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION];
END
GO
 
-- DROP CONSTRAINT FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION
---------------------------------------------------------------------------------------------------------
PRINT 'DROP CONSTRAINT FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION  [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION]';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop [FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION]';
ALTER TABLE [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] DROP CONSTRAINT FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION
END
GO


-- DROP TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS]
---------------------------------------------------------------------------------------------------------
PRINT 'DROP TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS]';
GO
---------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS];
END
GO

-- DROP TABLE [AHOBPR].[UPDATES_BENS_NOTIFICATION]
---------------------------------------------------------------------------------------------------------
PRINT 'DROP TABLE [AHOBPR].[UPDATES_BENS_NOTIFICATION]';
GO
---------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_BENS_NOTIFICATION]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[UPDATES_BENS_NOTIFICATION];
END
GO

-- Delete Trigger [AHOBPR].[TRG_AddToNotificationQueue]
---------------------------------------------------------------------------------------------------------
PRINT 'DROP TRIGGER [AHOBPR].[TRG_AddToNotificationQueue]';
GO
---------------------------------------------------------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[TRG_AddToNotificationQueue]') AND type in (N'U'))
BEGIN
	DROP TRIGGER [AHOBPR].[TRG_AddToNotificationQueue];
END
GO

-- Revert STD_GUI_CONTROLS  BASE_CONTROL_TYPE Back to '1' where CATEGORY = 'AHOBPR_CREATE_ACCOUNT'
UPDATE [dbo].[STD_GUI_CONTROLS] SET BASE_CONTROL_TYPE = 1 WHERE CATEGORY = 'AHOBPR_CREATE_ACCOUNT';
GO



---------------------------------------------------------------------------------------------------------
PRINT 'Remove stored procuedues:  AHOBPR.SP_UpdateRegistrant, AHOBPR.SP_InsertIntoUpdatesProcessed, AHOBPR.SP_GetPendingRegistrantUpdates ';
GO
---------------------------------------------------------------------------------------------------------
-- REMOVE STORED PROCEDURE [AHOBPR].[SP_UpdateRegistrant]
IF OBJECT_ID('AHOBPR.SP_UpdateRegistrant') IS NOT NULL -- Check if SP Exists
 EXEC('DROP PROCEDURE AHOBPR.SP_UpdateRegistrant;')
GO

-- REMOVE STORED PROCEDURE [AHOBPR].[SP_InsertIntoUpdatesProcessed]
IF OBJECT_ID('AHOBPR.SP_InsertIntoUpdatesProcessed') IS NOT NULL -- Check if SP Exists
 EXEC('DROP PROCEDURE AHOBPR.SP_InsertIntoUpdatesProcessed;') 
GO
-- REMOVE STORED PROCEDURE 
IF OBJECT_ID('AHOBPR.SP_GetPendingRegistrantUpdates') IS NOT NULL -- Check if SP Exists
 EXEC('DROP PROCEDURE AHOBPR.SP_GetPendingRegistrantUpdates;') 
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Revert [dbo].[STD_ROLE] and [dbo].[ROLE_PERMISSIONS]';
GO
---------------------------------------------------------------------------------------------------------
DECLARE @PageId INT, @AdminRoleId INT, @AdvancedUserRoleId INT, @CareTeamRoleId INT, @RegistryId INT, @HelpDeskRoleId INT;
DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();

SET @RegistryId  = (SELECT ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR');

-- Load STD_ROLE
WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES  
               (N'AHOBPR_REGISTRY_MANAGER', N'AHOBPR Registry Manager', N'AHOBPR Registry Manager who is a super user of the registry', 1, 1),
               (N'AHOBPR_ADVANCED_USER', N'AHOBPR Advanced User', N'AHOBPR Advanced User', 2, 0),
               (N'AHOBPR_CARE_TEAM',    N'AHOBPR Care Team',    N'AHOBPR Care Team', 3, 0),
			   (N'AHOBPR_HELP_DESK',    N'AHOBPR Help Desk',    N'AHOBPR Help Desk', 4, 0))
       AS MasterRecord(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, SUPER_USER_FLAG)
       )
MERGE
  INTO  [dbo].[STD_ROLE] AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [PARENT_ROLE_ID], [STD_REGISTRY_ID], [SUPER_USER_FLAG]) 
        VALUES
        (Src.CODE, Src.NAME, Src.DESCRIPTION_TEXT, Src.SORT_ORDER, 0, NULL,  @UserName, @UserName, @Today,@Today, NULL, @RegistryId, Src.SUPER_USER_FLAG)
 WHEN MATCHED 
 THEN UPDATE SET Tgt.[NAME] = Src.Name,
                 Tgt.DESCRIPTION_TEXT = Src.DESCRIPTION_TEXT,
                 Tgt.SORT_ORDER = Src.SORT_ORDER,
                 Tgt.SUPER_USER_FLAG = Src.SUPER_USER_FLAG,
                 Tgt.STD_REGISTRY_ID = @RegistryId;

-- Load STD_APPPAGE
WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
				('AHOBPR ADMIN EDIT USERS','AHOBPR ADMIN EDIT USERS','AHOBPR Admin Edit Users',1),
				('AHOBPR ADMIN LIST USERS','AHOBPR ADMIN LIST USERS','AHOBPR Admin List Users',1),
				('AHOBPR ADMIN TRACKING','AHOBPR ADMIN TRACKING','AHOBPR ADMIN TRACKING',1),
				('AHOBPR ADMIN USER ROLE','AHOBPR ADMIN USER ROLE','AHOBPR Admin User Role',1),
				('AHOBPR CHANGE STATUS','AHOBPR CHANGE STATUS','AHOBPR CHANGE STATUS',1),
				('AHOBPR QUESTIONNAIRE FULL','AHOBPR QUESTIONNAIRE FULL','AHOBPR QUESTIONNAIRE FULL',1),
				('AHOBPR QUESTIONNAIRE SECTION','AHOBPR QUESTIONNAIRE SECTION','AHOBPR QUESTIONNAIRE SECTION',1),
				('AHOBPR QUESTIONNAIRE SUMMARY','AHOBPR QUESTIONNAIRE SUMMARY','AHOBPR QUESTIONNAIRE SUMMARY',1),
				('AHOBPR REGISTRANT SEARCH','AHOBPR REGISTRANT SEARCH','AHOBPR REGISTRANT SEARCH',1),
				('AHOBPR REGISTRANTS','AHOBPR REGISTRANTS','AHOBPR REGISTRANTS',1),
				('AHOBPR REGISTRY FLAG','AHOBPR REGISTRY FLAG','AHOBPR Registry Flag will be used to flag registrants',1),
				('AHOBPR Report Ad Hoc','AHOBPR Report Ad Hoc','AHOBPR Report Ad Hoc',1),
				('AHOBPR REPORT AGING','AHOBPR REPORT AGING','AHOBPR REPORT AGING',1),
				('AHOBPR Report Selected Questionnaire','AHOBPR Report Selected Questionnaire','AHOBPR Report Selected Questionnaire',1),
				('AHOBPR Report Status by Location','AHOBPR Report Status by Location','AHOBPR Report Status by Location',1),
				('AHOBPR SUBPOPULATION FLAG','AHOBPR SUBPOPULATION FLAG','AHOBPR SUBPOPULATION FLAG',1),
				('AHOBPR STATUS HISTORY','AHOBPR STATUS HISTORY', 'AHOBPR STATUS HISTORY',1),
				('AHOBPR REPORT PARTICIPATION','AHOBPR REPORT PARTICIPATION','AHOBPR REPORT PARTICIPATION',1),
				('AHOBPR REPORT CONTACT INFORMATION','AHOBPR REPORT CONTACT INFORMATION','AHOBPR REPORT CONTACT INFORMATION',1),
				('AHOBPR REPORT AD HOC BY LOCATION','AHOBPR REPORT AD HOC BY LOCATION','AHOBPR REPORT AD HOC BY LOCATION',1),
				('AHOBPR REPORT ELIGIBILITY REVIEW','AHOBPR REPORT ELIGIBILITY REVIEW','AHOBPR REPORT ELIGIBILITY REVIEW',1),
				('AHOBPR REGISTRANT INFORMATION','AHOBPR REGISTRANT INFORMATION','AHOBPR REGISTRANT INFORMATION',1),
				('AHOBPR REGISTRY MESSAGES','AHOBPR REGISTRY MESSAGES','AHOBPR REGISTRY MESSAGES',1),
				('AHOBPR ADMIN EDIT TEMPLATE','AHOBPR ADMIN EDIT TEMPLATE','AHOBPR ADMIN EDIT TEMPLATE',1),
				('AHOBPR SEND MESSAGE','AHOBPR SEND MESSAGE','AHOBPR SEND MESSAGE',1),
				('AHOBPR TOOL','AHOBPR TOOL','AHOBPR TOOL',1),
				('AHOBPR ADMIN ADD FLAGS','AHOBPR ADMIN ADD FLAGS','AHOBPR ADMIN ADD FLAGS',1),
				('AHOBPR MY TEMPLATES','AHOBPR MY TEMPLATES','AHOBPR MY TEMPLATES',1),
				('AHOBPR REPORT FOLLOW-UP QUESTIONS','AHOBPR REPORT FOLLOW-UP QUESTIONS','AHOBPR REPORT FOLLOW-UP QUESTIONS',1),
				('AHOBPR MY ACCOUNT','AHOBPR MY ACCOUNT','AHOBPR MY ACCOUNT',1),
				('AHOBPR NAME UPDATE','AHOBPR NAME UPDATE','AHOBPR NAME UPDATE',1),
        ('ERROR PAGE','ERROR PAGE','ERROR PAGE',1),
				('AHOBPR TIMEOUT','AHOBPR TIMEOUT','AHOBPR TIMEOUT',1),
				('AHOBPR SYSTEM CHECK','AHOBPR SYSTEM CHECK','AHOBPR SYSTEM CHECK',1),
				('AHOBPR ERROR PAGE','AHOBPR ERROR PAGE','AHOBPR ERROR PAGE',1),
				('AHOBPR DEPLOYMENT HISTORY','AHOBPR DEPLOYMENT HISTORY','AHOBPR DEPLOYMENT HISTORY',1))
   AS MasterRecord(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER)
       )
MERGE
  INTO  [dbo].STD_APPPAGE AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
        VALUES
        (Src.CODE, Src.NAME, Src.DESCRIPTION_TEXT, Src.SORT_ORDER, 0, NULL,  @UserName, @UserName, @Today,@Today);

-- Load ROLE_PERMISSIONS
SET @AdminRoleId 		= (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_REGISTRY_MANAGER'); --100
SET @AdvancedUserRoleId = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_ADVANCED_USER'); --101
SET @CareTeamRoleId     = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_CARE_TEAM');--102
SET @HelpDeskRoleId     = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_HELP_DESK');

DELETE FROM [dbo].ROLE_PERMISSIONS WHERE STD_ROLE_ID IN(@AdminRoleId, @AdvancedUserRoleId, @CareTeamRoleId, @HelpDeskRoleId);

WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
        -- Admin User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN EDIT USERS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN LIST USERS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN USER ROLE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR CHANGE STATUS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRY FLAG'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT PARTICIPATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT ELIGIBILITY REVIEW'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT FOLLOW-UP QUESTIONS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRY MESSAGES'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN EDIT TEMPLATE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SEND MESSAGE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TOOL'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN ADD FLAGS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR NAME UPDATE'),@AdminRoleId),				
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@AdminRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@AdminRoleId),					
        	-- Advanced User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR CHANGE STATUS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT PARTICIPATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT FOLLOW-UP QUESTIONS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN ADD FLAGS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY TEMPLATES'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@AdvancedUserRoleId),				
		-- Care Team User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@CareTeamRoleId),				
		-- Help Desk User Role
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR NAME UPDATE'),@HelpDeskRoleId),				
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@HelpDeskRoleId)		
				)
   AS MasterRecord(AppPageId, RoleId)
       )
MERGE
  INTO  [dbo].ROLE_PERMISSIONS AS Tgt
  USING MasterData AS Src
  ON    Tgt.[STD_APPPAGE_ID] = Src.AppPageId
  AND   Tgt.STD_ROLE_ID = Src.RoleId
 WHEN  NOT MATCHED
 THEN  INSERT
	   ([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
	VALUES(Src.RoleId, Src.AppPageId, @UserName, @UserName, @Today,@Today, 1, 1, 1);
GO








---------------------------------------------------------------------------------------------------------
PRINT 'DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN FROM TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN;
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'REMOVE STD_PAYPLAN_ID FROM TABLE  [AHOBPR].[REGISTRANT_DEPLOYMENT]';
GO
---------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM  sys.columns WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') AND name = 'STD_PAYPLAN_ID')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]  DROP COLUMN STD_PAYPLAN_ID;
END
GO


---------------------------------------------------------------------------------------------------------
PRINT 'DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE FROM TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE;
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Adding MILITARY_RANK TO TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') 
         AND name = 'MILITARY_RANK')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]
		ADD MILITARY_RANK varchar(50)
END
GO

IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT_H]') 
         AND name = 'MILITARY_RANK')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT_H]
		ADD MILITARY_RANK varchar(50)
END
GO

ALTER trigger [AHOBPR].[TRG_REGISTRANT_DEPLOYMENT_H] on [AHOBPR].[REGISTRANT_DEPLOYMENT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_DEPLOYMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
--, [OCCUPATION_SPECIALTY_CODE]
, [MILITARY_RANK]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
--, [OCCUPATION_SPECIALTY_CODE]
, [MILITARY_RANK]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End


GO


ALTER TRIGGER  [AHOBPR].[TRG_REGISTRANT_DEPLOYMENT_DEL_H]
on  [AHOBPR].[REGISTRANT_DEPLOYMENT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_DEPLOYMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
--, [OCCUPATION_SPECIALTY_CODE]
, [MILITARY_RANK]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
--, [OCCUPATION_SPECIALTY_CODE]
, [MILITARY_RANK]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End


GO




---------------------------------------------------------------------------------------------------------
PRINT 'DONE'
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') 
         AND name = 'STD_SERVICE_OCCUPATION_ID')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] ADD STD_SERVICE_OCCUPATION_ID int
END
GO

-- Add the FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE foreign key constraint if it does not exist
IF (OBJECT_ID('[AHOBPR].[FK_REGISTRANT_DEPLOYMENT_OCCUPATION]', 'F') IS NULL)
BEGIN
	Print N'Trying to add foreign key FK_REGISTRANT_DEPLOYMENT_OCCUPATION'
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] WITH CHECK ADD  CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_OCCUPATION] FOREIGN KEY([STD_SERVICE_OCCUPATION_ID])
		REFERENCES [AHOBPR].[STD_SERVICE_OCCUPATION] ([STD_SERVICE_OCCUPATION_ID]);
END
GO


------------------
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
-- Remove FK from REGISTRANT_SERVICE_EPISODE Table
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT', 'F') IS NOT NULL)
BEGIN
    ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] DROP CONSTRAINT  [FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT]
END
GO
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT', 'D') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT';
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] DROP CONSTRAINT [FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT];
END
GO
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT', 'C') IS NOT  NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT';
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] DROP CONSTRAINT [FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT];
END
GO
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT', 'PK') IS NOT  NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT';
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] DROP CONSTRAINT [FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT];
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Drop Column PERSONNEL_CATEGORY_TYPE_CODE from [AHOBPR].[REGISTRANT_SERVICE_EPISODE] if it exists';
---------------------------------------------------------------------------------------------------------
IF  EXISTS (
  SELECT 1 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'AHOBPR.REGISTRANT_SERVICE_EPISODE') 
         AND name = 'PERSONNEL_CATEGORY_TYPE_CODE')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE] DROP COLUMN	[PERSONNEL_CATEGORY_TYPE_CODE]
END
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Drop column NARRATIVE_REASON_FOR_SEPARATION_TEXT to [AHOBPR].[REGISTRANT_SERVICE_EPISODE] if it does not exist';
---------------------------------------------------------------------------------------------------------
IF  EXISTS (
  SELECT 1 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_SERVICE_EPISODE]') 
         AND name = 'NARRATIVE_REASON_FOR_SEPARATION_TEXT')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE]
		DROP COLUMN [NARRATIVE_REASON_FOR_SEPARATION_TEXT] 
END
GO

-----------------
-- Remove FK from REGISTRANT_SERVICE_SPECIFIC_OCCUPATION Table
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION';
	ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] DROP CONSTRAINT FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION;
END
GO
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION', 'D') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION';
	ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] DROP CONSTRAINT FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION;
END
GO
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION', 'C') IS NOT  NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION';
	ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] DROP CONSTRAINT FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION;
END
GO


-----------------
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT';
	ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] DROP CONSTRAINT FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT;
END
GO
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT', 'D') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT';
	ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] DROP CONSTRAINT FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT;
END
GO
IF (OBJECT_ID('AHOBPR.FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT', 'C') IS NOT  NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT';
	ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] DROP CONSTRAINT FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT;
END


---------------------------------------------------------------------------------------------------------
PRINT 'Dropping Table [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION]';
---------------------------------------------------------------------------------------------------------

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION]
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';

PRINT 'Dropping Table [AHOBPR].[STD_ETHNICITY]';
---------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_ETHNICITY]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_ETHNICITY]
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Done';

PRINT 'Dropping Table [AHOBPR].[STD_RACE]';
---------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_RACE]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_RACE]
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';

PRINT 'Dropping Table [AHOBPR].[STD_EDUCATION_LEVEL]';
---------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_EDUCATION_LEVEL]') AND type in (N'U'))
BEGIN
	DROP TABLE [AHOBPR].[STD_EDUCATION_LEVEL]
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';

PRINT 'Removed Deceased from [AHOBPR].[STD_SERVICE_STATUS]';
---------------------------------------------------------------------------------------------------------
DELETE FROM [AHOBPR].[STD_SERVICE_STATUS] 
WHERE [SERVICE_STATUS] = 'Deceased';
GO

/****** Object:  StoredProcedure [AHOBPR].[SP_DeleteRegistrantAndResponse]    Script Date: 2/8/2018 4:06:16 PM ******/
SET ANSI_NULLS OFF
GO

SET QUOTED_IDENTIFIER OFF
GO


-- =============================================
-- Author:		Bruce Clegg
-- Edited:      Leon Mansfield
-- Create date: 4/24/2015
-- Last Edit:   2/08/2018
-- Description:	Called after loading Response
-- =============================================
ALTER PROCEDURE [AHOBPR].[SP_DeleteRegistrantAndResponse]
 @registrantId INT = NULL 
AS
BEGIN

  DELETE 
    FROM  AHOBPR.FORM_RESPONSE_ANSWER
    WHERE FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FORM_RESPONSE_ANSWER_ID
          FROM AHOBPR.FORM_RESPONSE r
          JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
          JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
          WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE 
    FROM  AHOBPR.FORM_RESPONSE_QUESTION
    WHERE FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FORM_RESPONSE_QUESTION_ID
          FROM AHOBPR.FORM_RESPONSE r
          JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
          WHERE  r.REGISTRANT_ID = @registrantId
         );      
            
  DELETE 
    FROM  AHOBPR.FORM_RESPONSE_STATUS
    WHERE FORM_RESPONSE_STATUS_ID IN
         ( 
          SELECT a.FORM_RESPONSE_STATUS_ID
          FROM AHOBPR.FORM_RESPONSE r
          JOIN AHOBPR.FORM_RESPONSE_STATUS a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
          WHERE  r.REGISTRANT_ID = @registrantId
         );      

  DELETE 
    FROM  AHOBPR.FORM_RESPONSE   
    WHERE REGISTRANT_ID  = @registrantId;
 
   DELETE 
    FROM  AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER
    WHERE FOLLOWUP_FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FOLLOWUP_FORM_RESPONSE_ANSWER_ID
          FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
          JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
          JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER c ON a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID = c.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
          WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE 
    FROM AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION
    WHERE FOLLOWUP_FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            

  DELETE 
    FROM  AHOBPR.FOLLOWUP_FORM_RESPONSE   
    WHERE REGISTRANT_ID  = @registrantId;
 
  DELETE 
    FROM  AHOBPR.REGISTRANT_DEPLOYMENT   
    WHERE REGISTRANT_ID  = @registrantId;

  DELETE 
    FROM  AHOBPR.REGISTRANT_ADDRESS   
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_PHONE
    WHERE REGISTRANT_ID  = @registrantId;  
        
   DELETE 
    FROM  AHOBPR.REGISTRANT_EMAIL     
    WHERE REGISTRANT_ID  = @registrantId;  
        
      
  DELETE 
    FROM  AHOBPR.REGISTRANT_CONTACT_INFO
    WHERE REGISTRANT_ID  = @registrantId;  
     
  --DELETE 
  --  FROM AHOBPR.REGISTRANT_HEALTH_FACTOR
  --  WHERE REGISTRANT_VISIT_ID IN
  --                          (SELECT REGISTRANT_VISIT_ID
  --                              FROM AHOBPR.REGISTRANT_VISIT
  --                            WHERE REGISTRANT_ID = @registrantId
  --                          );  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_VISIT
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_RECORD_INFO
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_REGISTRY_FLAG
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_SERVICE_EPISODE
    WHERE REGISTRANT_ID  = @registrantId;  
    
  DELETE 
    FROM  AHOBPR.PROCESS_METRICS
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.EMAIL_LOG
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.QUEUE_STATUS
    WHERE REGISTRANT_ID  = @registrantId;              

  DELETE 
    FROM  AHOBPR.QUEUE
    WHERE REGISTRANT_ID  = @registrantId;      

  DELETE 
    FROM [AHOBPR].[PROCESS_METRICS] 
	  WHERE REGISTRANT_ID  = @registrantId;  

  DELETE 
    FROM [AHOBPR].[CPRS_LOG] 
		WHERE REGISTRANT_ID = @registrantId;

  DELETE 
    FROM AHOBPR.REGISTRANT_FACILITY
    WHERE REGISTRANT_ID  = @registrantId;    
	
  DELETE 
    FROM AHOBPR.REGISTRANT
    WHERE REGISTRANT_ID  = @registrantId;              
END;
-- EXECUTE [AHOBPR].[SP_DeleteRegistrantAndResponse]  140
GO
/****** Object:  StoredProcedure [AHOBPR].[SP_ReportAdHocByIndividual]    Script Date: 2/27/2018 2:56:37 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters and remove NULLs from display where possible
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-03-30 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 2015-04-27 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce CLegg - Rewrote as Dynamic SQL for performance
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 2016-02-07 - D. May - Addressed performance of specific question query (Script 2.0.32.2)
-- 2016-05-24 - D. Barr - Add Date Range Registrant at current status filter (Build 3.0.13)
-- 2016-06-23 - Sherry Wang - Add Closest Facility filter (Build 3.0.17)
-- =============================================
ALTER PROCEDURE [AHOBPR].[SP_ReportAdHocByIndividual]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All',
	   @StatusFromDateText varchar(100) = NULL,
       @StatusToDateText varchar(100) = NULL,
	   @closestFacilityId  VARCHAR(50) = NULL
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
		  @StatusFromDate DATETIME2(0) = NULL,
          @StatusToDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);                
  DECLARE @AnswerWith VARCHAR(8000) = '';             

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText)); 
  SET @StatusFromDate = dbo.CleanDate(@StatusFromDateText);
  SET @StatusToDate = dbo.AddMaxTime(dbo.CleanDate(@StatusToDateText)); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0,
		@ClosestInstitutionId INT = 0;


IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

IF ISNULL(@closestFacilityId, '') != ''
  SET @ClosestInstitutionId = CONVERT(INT,@closestFacilityId);
  
  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = '
WITH SubPop AS 
     ( 
      SELECT a.REGISTRANT_ID, 
             STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME 
                    FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b 
                    JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID 
                    WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                       AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) + '
                   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] 
      FROM AHOBPR.REGISTRANT a 
      WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = '
                    , Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = '
                    , Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
  BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                   

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';

 IF @StatusFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.REGISTRANT_STATUS_LAST_UPDATED_DATE >= ''' + CONVERT(VARCHAR(20),@StatusFromDate,121) + '''';
     
  IF @StatusToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.REGISTRANT_STATUS_LAST_UPDATED_DATE  <= ''' + CONVERT(VARCHAR(20),@StatusToDate,121) + '''';

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;     
                                                      
  
 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @RegCriteria = @RegCriteria + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
  
  -- Closest Facility
  IF @ClosestInstitutionId > 0
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_REGISTRANT_CLOSEST_FACILITY closest ' +
                                                      ' WHERE closest.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20), @ClosestInstitutionId) +
                                                      '   AND closest.REGISTRANT_ID = a.REGISTRANT_ID) ';	 
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
    
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]  @ethnicity = 'JEWISH'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '5',   @StatusFromDateText  = '20160501'
--EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual]  @status = '7', @questionNumber = '1.3.A'  , @answer = '39'; --4:08 atfer index
--EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @closestFacilityId = '1000088'

GO


/****** Object:  StoredProcedure [AHOBPR].[SP_ReportAdHocByLocation]    Script Date: 2/27/2018 2:57:32 PM ******/
SET ANSI_NULLS OFF
GO

SET QUOTED_IDENTIFIER OFF
GO

-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters, Add distinct and outer query to group counts.
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-05-07 - Bruce Clegg - Change Facility name from "Other" to "No Facitilty Assigned" when not found
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce Clegg - Rewrote as Dynamic SQL for performance
-- 2015-08-05 - Bruce Clegg - Fix bug with AdminFlag - Set From and To date defaults
-- 2015-12-11 - D Barr      - added evaluation parameter
-- Deborah Barr - Script 2.0.16.1
-- 2016-02-08    D May - Performance Improvement when answer is specified. Script 2.0.32.2
-- 2016-05-26 - D, Barr - Add Date Range Registrant at current status filter (Build 3.0.13)
-- =============================================
ALTER PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(10) = 'All', 
       @requestToBeSeen varchar(10) = 'All',
       @groupBy VARCHAR(50) = '',                 -- 'VISN' or 'Facility'   
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All',
	   @StatusFromDateText varchar(100) = NULL,
       @StatusToDateText varchar(100) = NULL
AS

BEGIN

  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
		  @StatusFromDate DATETIME2(0) = NULL,
          @StatusToDate DATETIME2(0) = NULL;
          
  DECLARE @Query VARCHAR(8000);         
  DECLARE @AnswerWith VARCHAR(8000) = '';

  -- Convert date parameters      

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
  SET @StatusFromDate = dbo.CleanDate(@StatusFromDateText);
  SET @StatusToDate = dbo.AddMaxTime(dbo.CleanDate(@StatusToDateText));   

  -- Build Src TDE
  SET @Query = 'WITH ';

  IF ISNULL(@answer,'') != ''
    SET @Query = @Query + '
selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
), ';

 SET @Query = @Query + '
 Src 
    AS( SELECT a.REGISTRANT_ID, a.STD_INSTITUTION_ID 
        FROM AHOBPR.REGISTRANT a 
        WHERE 1 = 1 
';
                                   
  IF @status IS NOT NULL
    SET @Query = @Query + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > ''
    SET @Query = @Query + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @Query = @Query + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @Query = @Query + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';

IF @StatusFromDate IS NOT NULL                     
     SET @Query = @Query + ' AND a.REGISTRANT_STATUS_LAST_UPDATED_DATE >= ''' + CONVERT(VARCHAR(20),@StatusFromDate,121) + '''';
     
  IF @StatusToDate IS NOT NULL                     
     SET @Query = @Query + ' AND a.REGISTRANT_STATUS_LAST_UPDATED_DATE  <= ''' + CONVERT(VARCHAR(20),@StatusToDate,121) + '''';
	     
  IF @formStartFromDate IS NOT NULL OR @formStartToDate IS NOT NULL 
    OR @formCompletionFromDate IS NOT NULL OR @formCompletionToDate IS NOT NULL
  BEGIN
    SET @Query = @Query + '
AND EXISTS( SELECT d.REGISTRANT_ID 
            FROM AHOBPR.FORM_RESPONSE d 
		        JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID	
		        WHERE a.REGISTRANT_ID = d.REGISTRANT_ID ';
		IF @formStartFromDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
		IF @formStartToDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
		IF @formCompletionFromDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';
		IF @formCompletionToDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
		SET @Query = @Query + ' ) ' -- Close Exists statement
  END    
    
  IF ISNULL(@answer,'') != '' 
  BEGIN
    SET @Query = @Query +  '
and exists( select *
            from AHOBPR.FORM_RESPONSE_ANSWER fra 
            join AHOBPR.FORM_RESPONSE_QUESTION frq  on frq.FORM_RESPONSE_QUESTION_ID = fra.FORM_RESPONSE_QUESTION_id
            join AHOBPR.FORM_RESPONSE fr           on fr.FORM_RESPONSE_ID = frq.FORM_RESPONSE_ID
            join selectedAnswer                   on selectedAnswer.STD_FORM_ANSWER_ID = fra.STD_FORM_ANSWER_ID
            where a.REGISTRANT_ID = fr.REGISTRANT_ID
          )'; 
                 
--  SET @Query = @Query + '
--AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
--                        'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
--                        'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
--                        'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
--                        ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
--                      ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                         
  END;                       
  
  IF ISNULL(@subpopulationFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                            
  IF ISNULL(@healthFactor,'') != ''
    SET @Query = @Query + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

  IF ISNULL(@deploymentAll,'') != '' 
    SET @Query = @Query + ' AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                       ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                           AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;

  IF ISNULL(@deploymentExposure,'') != '' 
    SET @Query = @Query + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
IF (@evaluation = 'Yes') 
		 SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @Query = @Query + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                                    
                                      
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @Query = @Query + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @Query = @Query + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @Query = @Query + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @Query = @Query + ' AND ''' + @separationType + ''' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @Query = @Query + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @Query = @Query + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @Query = @Query + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @Query = @Query + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  -- Add Summary TDE                   
  SET @Query = @Query + '  )	,Summary  AS( ' + 
                        ' SELECT Src.STD_INSTITUTION_ID, COUNT(*) AS TotalRegistrants FROM Src ' +
                        ' GROUP BY STD_INSTITUTION_ID ) ';
-- By Facility 
	IF @groupBy = 'Facility'
	BEGIN  SET @Query = @Query + ' 
SELECT  inst.Name AS Location, 
        ISNULL(CONVERT(VARCHAR(10),Summary.STD_INSTITUTION_ID),''-1'') AS LocationId, 
        SUM(TotalRegistrants) AS TotalRegistrants 
FROM      Summary
JOIN      AHOBPR.VIEW_INSTITUTION_NAME inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1) 
GROUP BY  inst.Name,STD_INSTITUTION_ID 
OPTION    (OPTIMIZE FOR UNKNOWN);';
  END
  ELSE -- By VISN
  BEGIN
	  IF @groupBy = 'VISN'
	     SET @Query = @Query + '
,VisnSummary AS 
 ( 
  SELECT ISNULL(inst.VisnID,''NLA'') AS Location, 
        ISNULL(inst.VisnID, ''-1'') AS LocationId, 
        SUM(TotalRegistrants) AS TotalRegistrants        
   FROM Summary 
   LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1)  
   GROUP BY inst.VisnID  
 ) --close the WITH
 SELECT REPLACE(Location,''NLA'',''No Facitilty Assigned'') AS Location,
        CONVERT(VARCHAR(10),LocationId) AS LocationId, TotalRegistrants 
   FROM VisnSummary  
  ORDER BY Location 
  OPTION (OPTIMIZE FOR UNKNOWN); ' ;
	END;

  PRINT @Query;		
  		                     
  EXECUTE (@Query);  		                     		
END
-- Parameters
  --@status, @dutyStatus ,@questionnaireStartDate, @questionnaireCompleteDate, 
  --@questionNumber, @answer, @healthConcerns= 'All', @requestToBeSeen = 'All',
  --@registryFlag,@InstitutionId = 0, @VisnId = '' 
-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @evaluation = 'No'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthConcerns = 'Yes' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @requestToBeSeen = 'Yes'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentAll = 'Iraq'    -- 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @answer = '39'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy =  'Facility' , @status = '6,7' ,@answer = '2346,1571,17'   -- '20,795,1570' 
GO

IF OBJECT_ID('SP_ReportRegistrantStatus') IS NOT NULL -- Check if SP Exists
  DROP PROCEDURE [AHOBPR].[SP_ReportRegistrantStatus]
GO

IF OBJECT_ID('SP_ReportMilitaryStatus') IS NOT NULL -- Check if SP Exists
  DROP PROCEDURE [AHOBPR].[SP_ReportMilitaryStatus]
GO

---------------------------------------------------------
PRINT 'Drop column pre_911_deployment [AHOBPR].[REGISTRANT_H]'
GO
---------------------------------------------------------
IF COL_LENGTH('AHOBPR.REGISTRANT_H', 'PRE_911_DEPLOYMENT') IS NOT NULL
BEGIN
  ALTER TABLE [AHOBPR].[REGISTRANT_H]
  DROP  COLUMN [PRE_911_DEPLOYMENT] 
END 
 GO
 Print 'Done'
 ---------------------------------------------------------
PRINT 'Drop column pre_911_deployment [AHOBPR].[REGISTRANT_H]'
GO
---------------------------------------------------------
IF COL_LENGTH('AHOBPR.REGISTRANT_H', 'POST_911_DEPLOYMENT') IS NOT NULL
BEGIN
  ALTER TABLE [AHOBPR].[REGISTRANT_H]
  DROP  COLUMN [POST_911_DEPLOYMENT]
 END      
 GO
 Print 'Done';
 Print 'Rollback changes to [AHOBPR].[TRG_REGISTRANT_H] on [AHOBPR].[REGISTRANT]';
/****** Object:  Trigger [AHOBPR].[TRG_REGISTRANT_H]    Script Date: 3/26/2018 2:16:28 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER trigger [AHOBPR].[TRG_REGISTRANT_H] on [AHOBPR].[REGISTRANT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [RACE]
, [ETHNICITY]
, [STD_SERVICE_STATUS_ID]
, [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS]
, [EDUCATION_LEVEL]
, [STD_SEPARATION_REASON_ID_CURRENT]
, [SEPARATION_DATE_CURRENT]
, [STD_SEPARATION_REASON_ID_WHEN_ENROLLED]
, [SEPARATION_DATE_WHEN_ENROLLED]
, [STD_DISCHARGE_CHARACTER_ID]
, [STD_COMPONENT_ID_CURRENT]
, [STD_COMPONENT_ID_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [ELIGIBILITY_STATUS]
, [ELIGIBILITY]
, [CONTACT_PREFERENCE]
, [ETL_UPDATED]
, [ENROLLMENT_STATUS]
, [ENROLLED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [RACE]
, [ETHNICITY]
, [STD_SERVICE_STATUS_ID]
, [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS]
, [EDUCATION_LEVEL]
, [STD_SEPARATION_REASON_ID_CURRENT]
, [SEPARATION_DATE_CURRENT]
, [STD_SEPARATION_REASON_ID_WHEN_ENROLLED]
, [SEPARATION_DATE_WHEN_ENROLLED]
, [STD_DISCHARGE_CHARACTER_ID]
, [STD_COMPONENT_ID_CURRENT]
, [STD_COMPONENT_ID_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [ELIGIBILITY_STATUS]
, [ELIGIBILITY]
, [CONTACT_PREFERENCE]
, [ETL_UPDATED]
, [ENROLLMENT_STATUS]
, [ENROLLED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End
GO
 Print 'Done';
---------------------------------------------------------------------------------------------------------
print N'Rollback complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------
go


delete
	from  [dbo].[DatabaseChangeLog]
	where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
	  and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
	  and [PointReleaseNumber]  = '$(PointReleaseNumber)'
	  and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)';  