/* 
Author: L. Mansfield
*Build 4 - 2018-02-05
*/
:setvar DatabaseName "RegistryHRE"
:setvar MajorReleaseNumber "4" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "10"
:setvar ScriptName "1_INSTALL.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following two lines:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO
USE $(DatabaseName)
GO

IF EXISTS ( select * from [dbo].[DatabaseChangeLog]
            where [MajorReleaseNumber]	= '$(MajorReleaseNumber)'
              and [MinorReleaseNumber]	= '$(MinorReleaseNumber)'
              and [PointReleaseNumber]	= '$(PointReleaseNumber)'
			  and [TargetRegistry]		= 'AHOBPR'
              and [ScriptName]			= '$(ScriptName)'
          )
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE()
            );

GO
---------------------------------------------------------------------------------------------------------
PRINT '$(ScriptName) script started...';
PRINT GETDATE();
GO
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS OFF
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Table UPDATES_BENS_REGISTRANT_NOTIFICATION';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION](
    [UPDATES_BENS_REGISTRANT_NOTIFICATION_ID] [bigint] IDENTITY(1,1) NOT NULL,
    [EDIPI] [varchar](50) NOT NULL,
    [REGISTRANT_ID] int NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL,
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [UPDATES_BENS_REGISTRANT_NOTIFICATION_PK] PRIMARY KEY CLUSTERED 
  (
    [UPDATES_BENS_REGISTRANT_NOTIFICATION_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Table UPDATES_BENS_NOTIFICATION';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_BENS_NOTIFICATION]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[UPDATES_BENS_NOTIFICATION](
    [UPDATES_BENS_NOTIFICATION_ID] [bigint] IDENTITY(1,1) NOT NULL,
    [EDIPI] [varchar](50) NOT NULL,	
    [CREATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL,
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [UPDATES_BENS_NOTIFICATION_PK] PRIMARY KEY CLUSTERED 
  (
    [UPDATES_BENS_NOTIFICATION_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Table UPDATES_PROCESSED_NOTIFICATION_STATUS';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS](
    [UPDATES_PROCESSED_NOTIFICATION_STATUS_ID] [bigint] IDENTITY(1,1) NOT NULL,
    [UPDATES_BENS_REGISTRANT_NOTIFICATION_ID] [bigint] NOT NULL,
    [REGISTRANT_ID] int NOT NULL,
    [EDIPI] [varchar](50) NOT NULL,
    [PROCESS_NAME] [varchar](100) NOT NULL,
    [PROCESS_STATUS] [varchar](100) NOT NULL,
    [PROCESS_ERROR] [varchar](4000) NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL,
    [UPDATED] [datetime2](0) NOT NULL,
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [UPDATES_PROCESSED_NOTIFICATION_STATUS_PK] PRIMARY KEY CLUSTERED 
  (
    [UPDATES_PROCESSED_NOTIFICATION_STATUS_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]

  ALTER TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS]  WITH CHECK ADD  CONSTRAINT [FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION] FOREIGN KEY([UPDATES_BENS_REGISTRANT_NOTIFICATION_ID])
  REFERENCES [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] ([UPDATES_BENS_REGISTRANT_NOTIFICATION_ID])
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Create Table STD_PAYPLAN';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_PAYPLAN]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[STD_PAYPLAN](
    [STD_PAYPLAN_ID] [int] IDENTITY(1,1) NOT NULL,
    [SERVICE_CODE] [varchar](50) NOT NULL,
    [PAY_PLAN_CODE_SHORT] [varchar](25) NOT NULL,
    [PAYGRADE_CODE] [varchar](25) NOT NULL,
    [RANK_CODE] [varchar](50) NOT NULL,
    [RANK_TEXT] [varchar](100) NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL,
    [UPDATED] [datetime2](0) NOT NULL,
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [STD_PAYPLAN_PK] PRIMARY KEY CLUSTERED 
  (
    [STD_PAYPLAN_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Table [AHOBPR].[STD_RACE]';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_RACE]') AND type in (N'U'))
BEGIN
CREATE TABLE [AHOBPR].[STD_RACE](
	[STD_RACE_ID]  [int] IDENTITY(1,1) NOT NULL,
	[CODE] [varchar](50) NOT NULL,
	[DESCRIPTION_TEXT] [varchar](500) NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL DEFAULT ('AHOBPR DBA'),
	[UPDATEDBY] [varchar](30) NOT NULL DEFAULT ('AHOBPR DBA'),
	[CREATED] [datetime] NOT NULL DEFAULT (getdate()),
	[UPDATED] [datetime] NOT NULL DEFAULT (getdate()),

 CONSTRAINT [AHBOPRSTDRACE_PK] PRIMARY KEY CLUSTERED 
(
	[STD_RACE_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Create Table STD_SECONDARY_JOB';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_SECONDARY_JOB]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[STD_SECONDARY_JOB](
    [STD_SECONDARY_JOB_ID] [int] IDENTITY(1,1) NOT NULL,
    [SECONDARY_JOB] [varchar](100) NOT NULL,
    [ORDINAL_VALUE] [tinyint] NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdSecondaryJob_Created]  DEFAULT (getdate()),
    [UPDATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdSecondaryJob_Updated]  DEFAULT (getdate()),
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [STD_SECONDARY_JOB_PK] PRIMARY KEY CLUSTERED 
  (
    [STD_SECONDARY_JOB_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An IDENTITY surrogate key acting as the PK for the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'STD_SECONDARY_JOB_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the status, unique within the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'SECONDARY_JOB'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A value indicating the relative position in the registration workflow.  Higher values are later in the workflow.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'ORDINAL_VALUE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that created the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that updated the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'CREATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique row identifier required by LINQ to SQL' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'ROW_VERSION'
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Create Table STD_PRIMARY_JOB';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_PRIMARY_JOB]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[STD_PRIMARY_JOB](
    [STD_PRIMARY_JOB_ID] [int] IDENTITY(1,1) NOT NULL,
    [PRIMARY_JOB] [varchar](100) NOT NULL,
    [ORDINAL_VALUE] [tinyint] NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdPrimaryJob_Created]  DEFAULT (getdate()),
    [UPDATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdPrimaryJob_Updated]  DEFAULT (getdate()),
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [STD_PRIMARY_JOB_PK] PRIMARY KEY CLUSTERED 
  (
    [STD_PRIMARY_JOB_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An IDENTITY surrogate key acting as the PK for the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'STD_PRIMARY_JOB_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the status, unique within the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'PRIMARY_JOB'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A value indicating the relative position in the registration workflow.  Higher values are later in 

the workflow.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'ORDINAL_VALUE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that created the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that updated the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'CREATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique row identifier required by LINQ to SQL' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'ROW_VERSION'
GO

-- Create Table STD_WORK_LOCATION
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Create Table STD_WORK_LOCATION';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_WORK_LOCATION]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[STD_WORK_LOCATION](
    [STD_WORK_LOCATION_ID] [int] IDENTITY(1,1) NOT NULL,
    [WORK_LOCATION] [varchar](100) NOT NULL,
    [ORDINAL_VALUE] [int] NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdWorkLocation_Created]  DEFAULT (getdate()),
    [UPDATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdWorkLocation_Updated]  DEFAULT (getdate()),
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [STD_WORK_LOCATION_PK] PRIMARY KEY CLUSTERED 
  (
    [STD_WORK_LOCATION_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

SET ANSI_PADDING OFF
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An IDENTITY surrogate key acting as the PK for the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'STD_WORK_LOCATION_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the status, unique within the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'WORK_LOCATION'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A value indicating the relative position in the registration workflow.  Higher values are later in the workflow.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'ORDINAL_VALUE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that created the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that updated the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'CREATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique row identifier required by LINQ to SQL' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'ROW_VERSION'
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Trigger TRG_AddToNotificationQueue';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[TRG_AddToNotificationQueue]') IS NOT NULL) 
	EXEC('DROP TRIGGER [AHOBPR].[TRG_AddToNotificationQueue];')
GO
CREATE TRIGGER [AHOBPR].[TRG_AddToNotificationQueue]
ON [AHOBPR].[REGISTRANT] 
AFTER INSERT
AS
BEGIN
SET NOCOUNT ON

DECLARE @i TABLE (
     EDIPI varchar(50) PRIMARY KEY CLUSTERED,
    CREATED datetime2,
    CREATEDBY varchar(30)
)
INSERT INTO @i
SELECT EDIPI, CREATED, CREATEDBY FROM INSERTED

    --Insert the Notification record
    INSERT INTO UPDATES_BENS_NOTIFICATION (
        EDIPI,
        CREATED,
        CREATEDBY
    )
    SELECT
        EDIPI,
        CREATED,
        'TR_REGISTRANT'
    FROM @i;
END

-- ALTER AHOBPR_USER table
---------------------------------------------------------------------------------------------------------
PRINT 'ALTER AHOBPR_USER table';
GO
---------------------------------------------------------------------------------------------------------
ALTER TABLE [AHOBPR].[AHOBPR_USER] 
ADD PRIMARY_JOB_ID INT NULL;

ALTER TABLE [AHOBPR].[AHOBPR_USER]  
ADD CONSTRAINT FK_PRIMARY_JOB_ID
FOREIGN KEY(PRIMARY_JOB_ID) REFERENCES [AHOBPR].[STD_PRIMARY_JOB](STD_PRIMARY_JOB_ID);

ALTER TABLE [AHOBPR].[AHOBPR_USER] 
ADD SECONDARY_JOB_ID INT NULL;

ALTER TABLE [AHOBPR].[AHOBPR_USER]
ADD CONSTRAINT FK_SECONDARY_JOB_ID
FOREIGN KEY(SECONDARY_JOB_ID) REFERENCES [AHOBPR].[STD_SECONDARY_JOB](STD_SECONDARY_JOB_ID);

ALTER TABLE [AHOBPR].[AHOBPR_USER] 
ADD  WORK_LOCATION_ID INT NULL;

ALTER TABLE [AHOBPR].[AHOBPR_USER]
ADD CONSTRAINT FK_WORK_LOCATION_ID
FOREIGN KEY(WORK_LOCATION_ID) REFERENCES [AHOBPR].[STD_WORK_LOCATION](STD_WORK_LOCATION_ID);
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data into STD_RETIREMENT_TERMINATION_REASON';
GO
---------------------------------------------------------------------------------------------------------

SET IDENTITY_INSERT [AHOBPR].[STD_RETIREMENT_TERMINATION_REASON] ON 
;WITH  MasterData
AS    ( select * 
        from (VALUES 
                (1, N'D', N'Death while in personnel category or organization', N'DBADMIN', N'DBADMIN', GETDATE(), GETDATE()),
                (2, N'F', N'Invalid entry into segment', N'DBADMIN', N'DBADMIN', GETDATE(), GETDATE()),
                (3, N'S', N'Separation from personnel category or organization', N'DBADMIN', N'DBADMIN', GETDATE(), GETDATE()),
                (4, N'W', N'Not applicable', N'DBADMIN', N'DBADMIN', GETDATE(), GETDATE())
              ) AS MasterRecord(STD_RETIREMENT_TERMINATION_REASON_ID, RETIREMENT_TERMINATION_REASON_CODE, RETIREMENT_TERMINATION_REASON_DESCRIPTION, CREATEDBY, UPDATEDBY, CREATED, UPDATED) 
)
MERGE INTO [AHOBPR].[STD_RETIREMENT_TERMINATION_REASON] as Tgt
USING MasterData as Src
ON Tgt.[STD_RETIREMENT_TERMINATION_REASON_ID] = Src.STD_RETIREMENT_TERMINATION_REASON_ID
WHEN NOT MATCHED
THEN INSERT
  ([STD_RETIREMENT_TERMINATION_REASON_ID], [RETIREMENT_TERMINATION_REASON_CODE], [RETIREMENT_TERMINATION_REASON_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED])
  VALUES
   (Src.STD_RETIREMENT_TERMINATION_REASON_ID, Src.RETIREMENT_TERMINATION_REASON_CODE, Src.RETIREMENT_TERMINATION_REASON_DESCRIPTION, Src.CREATEDBY, Src.UPDATEDBY, Src.CREATED, Src.UPDATED)
WHEN MATCHED
THEN UPDATE SET 
        Tgt.[RETIREMENT_TERMINATION_REASON_CODE] = Src.RETIREMENT_TERMINATION_REASON_CODE,
        Tgt.[RETIREMENT_TERMINATION_REASON_DESCRIPTION] = Src.RETIREMENT_TERMINATION_REASON_DESCRIPTION,
				Tgt.[CREATEDBY] = Src.CREATEDBY, 
				Tgt.[UPDATEDBY] = Src.UPDATEDBY, 
				Tgt.[CREATED] = Src.CREATED,
				Tgt.[UPDATED] = Src.UPDATED;
SET IDENTITY_INSERT [AHOBPR].[STD_RETIREMENT_TERMINATION_REASON] OFF
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data into STD_GUI_CONTROLS';
GO
---------------------------------------------------------------------------------------------------------
DECLARE  @RegistryId int
BEGIN

	SELECT @RegistryId = ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR'
	-- Delete the previously inserted AHOBPR GUI control entries...
	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
		and CATEGORY = 'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION' 
		AND [NAME] IN ('My Account Primary Job Parameters', 'My Account Secondary Job Parameters', 'My Account Work Location Parameters')
INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION','My Account Primary Job Parameters',4,'BaseControlDropdownListPrimaryJob', 'Primary Job is required',null,'Admin Users Primary Job',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_PRIMARY_JOB', null,null,1,1,'Primary Job (Required): </br>',null,null,'UserSave',null,'PanelUserInformation');

INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION','My Account Secondary Job Parameters',4,'BaseControlDropdownListSecondaryJob', 'Secondary Job is required',null,'Admin Users Secondary Job',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_SECONDARY_JOB', null,null,1,1,'Secondary Job (Required): </br>',null,null,'UserSave',null,'PanelUserInformation');

INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION','My Account Work Location Parameters',4,'BaseControlDropdownListWorkLocation', 'Work Location is required',null,'Admin Users Work Location',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_WORK_LOCATION', null,null,1,1,'Work Location (Required): </br>',null,null,'UserSave',null,'PanelUserInformation');

	UPDATE	[dbo].[STD_GUI_CONTROLS] 
	SET LABEL_TEXT = 'Change Status States (Required):</br>'
	WHERE [STD_REGISTRY_ID] = 10
		and CATEGORY = 'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION' 
		AND [NAME] ='My Account State Parameters';
END

BEGIN

	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
  	and CATEGORY = 'AHOBPR_CREATE_ACCOUNT'
		AND [NAME] IN ('My Account Primary Job Parameters', 'My Account Secondary Job Parameters', 'My Account Work Location Parameters')

INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CREATE_ACCOUNT','My Account Primary Job Parameters',4,'BaseControlDropdownListPrimaryJob', 'Primary Job is required',null,'Primary Job',@RegistryId,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_PRIMARY_JOB', null,null,1,1,'Primary Job: ',null,null,'alpha',null,'entryPanel');
	  
INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CREATE_ACCOUNT','My Account Secondary Job Parameters',4,'BaseControlDropdownListSecondaryJob', 'Secondary Job is required',null,'Secondary Job',11,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_SECONDARY_JOB', null,null,1,1,'Secondary Job: ',null,null,'alpha',null,'entryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CREATE_ACCOUNT','My Account Work Location Parameters',4,'BaseControlDropdownListWorkLocation', 'Work Location is required',null,'Work Location',12,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_WORK_LOCATION', null,null,1,1,'Work Location: ',null,null,'alpha',null,'entryPanel');
END

BEGIN 
	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
  	and CATEGORY = 'AHOBPR_CLINICAL_USER_ADHOC_REPORT'
		AND [NAME] IN ('Ad-Hoc Report', 'Primary Job parameters', 'Status parameters','Secondary Job parameters','Work Location parameters','Job Title parameters','Change Status State parameters')

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Ad-Hoc Report',4,'BaseControlDropdownListActionType',null,null,'The Selection Criteria allows the user to filter by one user action type.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','AUDIT_ACTION_TYPE',null,null,0,1,'Action Type: </br>',null,null,null,null,'PanelSearchCriteriaAction');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Ad-Hoc Report',4,'BaseControlDropdownListRole',null,null,'The Selection Criteria allows the user to filter by one user role.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','USER_ROLE',null,null,0,1,'Role: </br>',null,null,null,null,'SecondaryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Primary Job parameters',5,'BaseControlListBoxPrimaryJob',null,null,'The Selection Criteria allows the user to filter by one or more Primary Jobs.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_PRIMARY_JOB',  170,170,0,1,'Primary Job: </br>',null,null,null,null,'SecondaryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Status parameters',4,'BaseControlDropDownListStatus',null,null,'The Selection Criteria allows the user to filter by one user account status.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STATUS',null,null,0,1,'Status: </br>',null,null,null,null,'MainPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Secondary Job parameters',5,'BaseControlListBoxSecondaryJob',null,null,'The Selection Criteria allows the user to filter by one or more Secondary Jobs.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_SECONDARY_JOB',  170,170,0,1,'Secondary Job: </br>',null,null,null,null,'SecondaryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Work Location parameters',5,'BaseControlListBoxWorkLocation',null,null,'The Selection Criteria allows the user to filter by one or more Work Locations.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_WORK_LOCATION',  170,170,0,1,'Work Location: </br>',null,null,null,null,'SecondaryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Job Title parameters',2,'BaseControlTextBoxJobTitle',null,null,'The Selection Criteria allows the user to filter by words in Job Title.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA',NULL,null,null,0,1,'Job Title Keyword search: ',null,null,null,null,'MainPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Change Status State parameters',4,'BaseControlDropDownListChangeStatusState',null,null,'Change Status State is the State selected by Advanced Users to display Registrants on the Change Status page. The Selection Criteria all a user to filter by one State.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_STATE',null,null,0,1,'Change Status State: <br>',null,null,null,null,'MainPanel');
END

IF NOT EXISTS (SELECT 1 FROM [dbo].[STD_GUI_CONTROLS] WHERE [CATEGORY] = 'AHOBPR_REPORT_ADHOC' AND [USER_CONTROL_ID] IN ('BaseControlDropDownListDeploymentStage', 'BaseControlDropDownListContactPreference', 'BaseControlListBoxState'))
BEGIN
	INSERT [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) 
		VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', N'Report State Parameters', 5, N'BaseControlListBoxState', NULL, NULL, N'State is the state from the current addresses a Registrant has in AHOBPR.  The Selection Criteria allows a user to filter with one or more states.', 0, CAST(N'2017-12-11 12:40:31.110' AS DateTime), CAST(N'2017-12-11 12:40:31.110' AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', N'STD_STATE', 170, 170, 0, 1, N'State:<br />', NULL, NULL, NULL, NULL, N'PanelReportParm')
	INSERT [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) 
		VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', N'Report Deployment Stage Parameters', 4, N'BaseControlDropDownListDeploymentStage', NULL, NULL, N'Deployment Stage indicated if a deployment has been reviewed.  The selection Criteria allows a user to filter by Registrants that have at least one deployment in the Stage selected.', 0, CAST(N'2017-12-12 09:43:16.367' AS DateTime), CAST(N'2017-12-12 09:43:16.367' AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', N'DEPLOYMENT_STAGE', NULL, NULL, 0, 1, N'Deployment Stage:<br />', NULL, NULL, NULL, NULL, N'PanelReportParm')
	INSERT [dbo].[STD_GUI_CONTROLS] ([STD_REGISTRY_ID], [CATEGORY], [NAME], [BASE_CONTROL_TYPE], [USER_CONTROL_ID], [VALIDATION_ERROR_MESSAGE], [VALIDATION_REGULAR_EXPRESSION], [TOOL_TIP], [SORT_ORDER], [CREATED], [UPDATED], [CREATEDBY], [UPDATEDBY], [LOOKUP_LIST_CATEGORY], [BASE_CONTROL_WIDTH], [DATA_ELEMENT_WIDTH], [REQUIRED], [INCLUDE_LABEL], [LABEL_TEXT], [LOOKUP_LIST_CATEGORY2], [LOOKUP_LIST_CATEGORY3], [VALIDATION_GROUP], [DATA_TYPE_MAX_LENGTH], [PANEL_NAME]) 
		VALUES (@RegistryId, N'AHOBPR_REPORT_ADHOC', N'Report Contact Preference', 4, N'BaseControlDropDownListContactPreference', NULL, NULL, N'Contact Preference is for the preferred method of being contacted. The Selection Criteria allows a user to filter by a contact preference.', 0, CAST(N'2017-12-12 10:07:33.713' AS DateTime), CAST(N'2017-12-12 10:07:33.713' AS DateTime), N'AHOBPR DBA', N'AHOBPR DBA', N'CONTACT_PREFERENCE', NULL, NULL, 0, 1, N'Contact Preference:<br />', NULL, NULL, NULL, NULL, N'PanelReportParm')
END

GO

UPDATE STD_GUI_CONTROLS set base_control_type = 2 WHERE  (CATEGORY = 'AHOBPR_CREATE_ACCOUNT') and  base_control_type = 1
GO


GO

---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data into STD_PRIMARY_JOB';
GO
---------------------------------------------------------------------------------------------------------
DELETE from [AHOBPR].[STD_PRIMARY_JOB];
GO

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Administrator',1,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Assoc./Allied Health',2,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('OEF/OIF/OND Case Manager',3,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Clinical Psychologist',4,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Licensed Clinical Social Worker',5,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Licensed Counselor(MFT or other)',6,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Occupational Therapist',7,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('PDICI Champ',8,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Recreational Therapist',9,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('VHA Mental Health',10,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Intensive Case Manager',11,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Chief/Director',13,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('VHA Social Work Service Manager',14,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Physician Assistant',15,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Nurse Practitioner',16,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Registered Nurse',17,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Vocational Nurse',18,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Environmental Health Clinician',19,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Environmental Health Coordinator',20,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Primary Care Physician',21,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Physician',22,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Other',23,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data into STD_SECONDARY_JOB';
GO
---------------------------------------------------------------------------------------------------------
DELETE from [AHOBPR].[STD_SECONDARY_JOB];
GO
INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Not Applicable',1,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Administrator',2,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Assoc./Allied Health',3,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('OEF/OIF/OND Case Manager',4,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Clinical Psychologist',5,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Licensed Clinical Social Worker',6,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Licensed Counselor(MFT or other)',7,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Occupational Therapist',8,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('PDICI Champ',9,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Recreational Therapist',10,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('VHA Mental Health',11,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Intensive Case Manager',12,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Chief/Director',14,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('VHA Social Work Service Manager',15,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Physician Assistant',16,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Nurse Practitioner',17,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Registered Nurse',18,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Vocational Nurse',19,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Environmental Health Clinician',20,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Environmental Health Coordinator',21,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Primary Care Physician',22,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Physician',23,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Other',24,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

GO
---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data for STD_WORK_LOCATION';
GO
---------------------------------------------------------------------------------------------------------
DELETE from [AHOBPR].[STD_WORK_LOCATION];
GO
INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Austin TX Automation Center(AAC)',1,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Albuquerque NM (ABQ)',2,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Baltimore MD Baltimore Academy (ACD)',3,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Austin TX AIM Center (AIM)',4,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Albuquerque NM (ALB)',5,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Allen Park MI (ALL)',6,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Albany NY VAMC (ALN)',7,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Altoona PA (ALT)',8,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Alexandria LA (ALX)',9,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Amarillo TX (AMA)',10,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Anchorage AK (ANC)',11,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Ann Arbor MI (ANN)',12,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Boston MA Allocation Resource Center (ARC)',13,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Asheville NC (ASH)',14,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Atlanta GA (ATG)',15,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Atwater CA (ATW)',16,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Austin TX (ATX)',17,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Auburn CA (AUB)',18,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Augusta GA (AUG)',19,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Austin TX Austin (AUS)',20,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Battle Creek MI VAMC (BAC)',21,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Baltimore MD (BAL)',22,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Bath NY (BAN)',23,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Batavia NY (BAT)',24,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Bay Pines FL (BAY)',25,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Beckley WV (BEC)',26,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Bedford MA (BED)',27,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Fort Meade SD Black Hills HCS (BHH)',28,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Boston MA Boston HCS (BHS)',29,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Big Spring TX (BIG)',30,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Biloxi MS(BIL)',31,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Birmingham AL (BIR)',32,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boise ID (BOI)',33,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bonham TX (BON)',34,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA (BOS)',35,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA Vet Center (BOV)',36,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brecksville OH ORM (BRE)',37,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brockton MA (BRK)',38,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Branson MO CBOC (BRN)',39,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brockton MA Vet Center (BRV)',40,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bronx NY (BRX)',41,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Buffalo NY (BUF)',42,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Butler PA (BUT)',43,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brooklyn NY (BYN)',44,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Amazon Cloud US Amazon Cloud (C10)',45,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Microsoft Government Cloud US Microsoft Government Cloud (C20)',46,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Microsoft Office365 Cloud US Microsoft Office365 Cloud (C40)',47,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Montgomery AL Central Alabama HCS (CAH)',48,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cambridge MD (CAM)',49,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Canandaigua NY (CAN)',50,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Capitola CA (CAP)',51,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Castle Point NY (CAS)',52,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA Outpatient Clinic (CAU)',53,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Montgomery AL Central Alabama HCS (CAV)',54,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Columbus GA CAVHCS (CBS)',55,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO CEOSH (CEO)',56,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV Office of Cyber and Information Security (CFW)',57,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Charleston SC (CHA)',58,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chico CA (CHC)',59,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chelsea MA Vet Center (CHE)',60,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL (CHI)',61,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL (Lakeside) (CHL)',62,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL Chicago HCS (CHS)',63,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL (Westside) (CHW)',64,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cheyenne WY VAM&ROC (CHY)',65,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Des Moines IA Central Iowa HCS (CIH)',66,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cincinnati OH (CIN)',67,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Clarksburg WV (CLA)',68,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX Co-located with national gateway (CLD)',69,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cleveland OH (CLE)',70,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kansas City KS Co-located with national gateway (CLK)',71,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chillicothe OH (CLL)',72,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Reston VA Co-located with national gateway (CLR)',73,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Santa Rosa CA Co-located with national gateway (CLS)',74,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chelmsford MA CMOP (CMB)',75,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('North Charleston SC CMOP (CMC)',76,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX CMOP (CMD)',77,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL CMOP (CMH)',78,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Leavenworth KS CMOP (CML)',79,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Murfreesboro TN CMOP (CMM)',80,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tucson AZ National (CMOP) IT Program Office (CMN)',81,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Columbia MO Harry S. Truman Memorial Veterans Hospital (CMO)',82,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tucson AZ Southwest CMOP (CMP)',83,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Columbia SC (CMS)',84,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Community Nursing Home (CNH)',85,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC VACO (CO)',86,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Coatesville PA (COA)',87,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV VA COOP/COG Center (COG)',88,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Haven CT Connecticut HCS (CON)',89,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA Outpatient Clinic (COR)',90,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Columbus OH NULL (COS)',91,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Asheville NC Consolidated Patient Account Center (CPA)',92,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA Compensation & Pension Exam (CPE)',93,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Orlando FL Florida CPAC (CPF)',94,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Leavenworth KS Central Plains CPAC (CPK)',95,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Las Vegas NV West CPAC (CPN)',96,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lebenon PA CPAC (CPP)',97,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Murfreesboro TN Mid-South CPAC (CPT)',98,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Madison WI North Central CPAC (CPW)',99,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV (CRD)',100,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV National Capital Region Readiness Center (CRR)',101,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Albuquerque NM VA Cooperative Studies Program (CSP)',102,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Temple TX Central Texas HCS (CTX)',103,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Culpeper VA QITC COOP location (CUL)',104,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO CHAMPVA (CVA)',105,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northampton MA Central Western Massachusetts (CWM)',106,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX (DAL)',107,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Danville IL VAMC (DAN)',108,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA DSS (DAT)',109,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dayton OH (DAY)',110,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bedford MA DSS (DBE)',111,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cleveland OH DSS (DCL)',112,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO (DCO)',113,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Distribution Center (DDC)',114,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO (DEN)',115,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Des Moines IA (DES)',116,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Detroit MI (DET)',117,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Denver Acquisition & Logistics Center (DLC)',118,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Manassas VA DSS (DMA)',119,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Murfreesboro TN DSS (DMU)',120,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dorchester MA Outpatient Clinic (DOR)',121,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dothan AL CAVHCS (DOT)',122,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bedford MA Decision Support System (DSO)',123,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dublin GA (DUB)',124,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC (DUR)',125,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Region 1 Data Center (DVR)',126,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Disability Examination Management Office (DXM)',127,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('East Orange NJ (EAS)',128,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Birmingham AL Ed Center (EBI)',129,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boise ID CHEP Ed. Center (EBO)',130,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Colorado Springs CO Eastern Colorado Health Care System (ECH)',131,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cleveland OH Ed Center (ECL)',132,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV ECSIP (ECS)',133,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dublin GA CHEP Ed. Center (EDB)',134,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC Ed Center (EDH)',135,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Erie PA CHEP Ed. Center (EER)',136,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Meade SD CHEP Ed. Center (EFM)',137,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('KS Eastern Kansas HCS (EKS)',138,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Long Beach CA Ed Center (ELB)',139,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lincoln NE CHEP Ed. Center (ELI)',140,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('El Paso TX (ELP)',141,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Little Rock AR Ed Center (ELR)',142,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minneapolis MN Ed Center (EMN)',143,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northport NY Ed Center (ENP)',144,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Orlando FL Ed Center - Orlando (EOR)',145,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Perry Point MD CHEP Ed. Center (EPP)',146,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Prescott AZ CHEP Ed. Center (EPR)',147,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Erie PA (ERI)',148,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO Engineering Training Center (ESC)',149,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT Ed Center (ESL)',150,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO Employee Education System (EST)',151,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('LittleRock AR Engineering Training Center (ETC)',152,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT Enterprise Test Center (ETL)',153,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Enterprise Test Center (ETN)',154,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Togus ME CHEP Ed. Center (ETO)',155,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA Enterprise Test Center (ETP)',156,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tuskegee AL CHEP Ed. Center (ETU)',157,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Albany NY Enterprise Test Center (ETY)',158,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Eureka CA (EUR)',159,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC Ed Center (EWA)',160,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV Enterprise Web Hosting (EWH)',161,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fairfield CA (FAI)',162,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fargo ND (FAR)',163,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fayetteville AR (FAV)',164,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Harrison MT (FHM)',165,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fayetteville NC (FNC)',166,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Framingham MA Outpatient Clinic (FRA)',167,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fresno CA (FRE)',168,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Financial Services Center (FSC)',169,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ft. Smith AR CBOC (FSM)',170,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Howard MD (FTH)',171,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Lyon CO DO NOT USE. Code is decomissioned 1/2011 (FTL)',172,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Meade SD (FTM)',173,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Rucker AL CAVHCS (FTR)',174,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Worth TX (FWO)',175,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Gainesville FL (GAI)',176,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA OGC Atlanta (GAT)',177,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD OGC Baltimore (GBA)',178,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Glen Burnie MD (GBC)',179,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA OGC Boston (GBO)',180,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bay Pines FL OGC Bay Pines (GBP)',181,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Buffalo NY OGC Buffalo (GBU)',182,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL OGC Chicago (GCH)',183,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cleveland OH OGC Cleveland (GCL)',184,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Detroit MI OGC Detroit (GDE)',185,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO OGC Denver (GDV)',186,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Houston TX OGC Houston (GHO)',187,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Indianapolis IN OGC Indianapolis (GIN)',188,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS OGC Jackson (GJA)',189,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minneapolis MN OGC Minneapolis (GMI)',190,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Nashville TN OGC Nashville (GNA)',191,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brooklyn NY OGC Brooklyn (GNY)',192,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA OGC Philadelphia (GPH)',193,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Portland OR OGC Portland (GPO)',194,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Phoenix AZ OGC Phoenix (GPX)',195,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fresno CA (GRE)',196,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Grand Island NE (GRI)',197,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Grand Junction CO (GRJ)',198,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Francisco CA OGC San Francisco (GSF)',199,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO OGC St. Louis (GST)',200,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Guam   (GUA)',201,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Waco TX OGC Waco (GWA)',202,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sterling VA National Gateway East (GWE)',203,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Winston-Salem NC OGC Winston-Salem (GWI)',204,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL National Gateway North (GWN)',205,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX National Gateway South (GWS)',206,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Jose CA National Gateway West (GWW)',207,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Health Administration Center (HAC)',208,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hampton VA (HAM)',209,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hartford CT (HAR)',210,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Denver HRC (HCO)',211,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA Health Eligibility Center (HEC)',212,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Hines Finance Center (HFC)',213,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hilo HI Outpatient Clinic (HIL)',214,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL (HIN)',215,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD Baltimore HRC (HMD)',216,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Detroit MI Detroit HRC (HMI)',217,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS Jackson HRC (HMS)',218,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Honolulu HI NCPTSD (HNC)',219,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Honolulu HI (HON)',220,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hot Springs SD (HOT)',221,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Houston TX (HOU)',222,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hilo HI PRRP (HPR)',223,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Hines Remote Access (HRA)',224,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Topeka KS Health Revenue Center (HRC)',225,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Harrison AR CBOC (HRS)',226,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Oklahoma City OK Healthcare Talent Management Program Office (HTM)',227,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Huntington WV (HUN)',228,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hudson Valley NY Hudson Valley HCS (HVH)',229,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Indianapolis IN (IND)',230,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA Philadelphia Insurance Center (INS)',231,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Iowa City IA (IOW)',232,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Iron Mountain MI VAMC (IRO)',233,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Albany NY CIO Field Office (ISA)',234,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Birmingham AL CIO Field Office (ISB)',235,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX CIO Field Office (ISD)',236,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Francisco CA CIO Field Office (ISF)',237,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL CIO Field Office (ISH)',238,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT CIO Field Office (ISL)',239,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bay Pines FL CIO Field Office (ISP)',240,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tuscaloosa AL CIO Field Office (IST)',241,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Silver Spring MD CIO Field Office (ISW)',242,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Birmingham AL IVM (IVB)',243,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA IVM (IVM)',244,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS (JAC)',245,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jacksonville FL Outpatient Clinic (JAX)',246,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jay OK CBOC (JAY)',247,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kansas City MO (KAN)',248,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kauai HI (KAU)',249,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Knoxville IA (KNX)',250,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kona HI (KON)',251,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lake City FL (LAK)',252,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Los Angeles CA (LAN)',253,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Las Vegas NV (LAS)',254,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Leavenworth KS (LEA)',255,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lebanon PA (LEB)',256,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lexington KY (LEX)',257,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lincoln NE (LIN)',258,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Little Rock AR (LIT)',259,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Livermore CA (LIV)',260,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Langley MD (LNG)',261,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Loma Linda CA (LOM)',262,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Long Beach CA (LON)',263,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Los Angeles CA (LOS)',264,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Louisville KY (LOU)',265,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Loch Raven MD (LRC)',266,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lowell MA Outpatient Clinic (LWL)',267,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lyons NJ (LYN)',268,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinez CA Northern California Health System (MAC)',269,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Madison WI (MAD)',270,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mare Island CA (MAI)',271,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Manchester NH (MAN)',272,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD Maryland HCS (MAR)',273,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC VACO (MAS)',274,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Maui HI (MAU)',275,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Miles City MT (MCM)',276,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minden CA (MDN)',277,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Memphis TN (MEM)',278,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Montgomery AL (MGY)',279,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD Maryland HCS (MHS)',280,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Miami FL (MIA)',281,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minneapolis MN (MIN)',282,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC VACO (CIO) (MIR)',283,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mission CA (MIS)',284,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Milwaukee WI (MIW)',285,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Austin MLAC (MLA)',286,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Manassas VA DSS (MNS)',287,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV Operations Center (MOC)',288,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Modesto CA (MOD)',289,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Monterey CA (MON)',290,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Montrose NY (MOR)',291,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mountain Home TN (MOU)',292,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Menlo Park CA (MPD)',293,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Manila PI (MPI)',294,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Marion IL (MRN)',295,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Milwaukee WI Contract Service Center (MSC)',296,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT NMDC (MSL)',297,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO NMDC (MST)',298,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mt. Vernon AR CBOC (MTV)',299,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Murfreesboro TN (MUR)',300,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Muskogee OK (MUS)',301,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC NMDC (MWA)',302,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV (MWV)',303,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Maxwell AFB AL CAVHCS (MXL)',304,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Nashville TN (NAS)',305,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('North Chicago IL (NCH)',306,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ann Arbor MI National Center for Patient Safety (NCP)',307,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV National Capital Regional Data Center (NCR)',308,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Newington CT (NCT)',309,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Newark NJ (NEW)',310,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Gainesville FL North Florida HCS (NFL)',311,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northampton MA (NHM)',312,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northern Indiana IN Northern Indiana HCS (NIN)',313,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New Jersey NJ New Jersey HCS (NJH)',314,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('North Little Rock AR ORM (NLR)',315,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV Network Operations Center (NOC)',316,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New Orleans LA (NOL)',317,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northport NY (NOP)',318,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV NSOC (NSF)',319,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL NSOC (NSH)',320,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV  NSOC (NSM)',321,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX North Texas HCS (NTX)',322,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New York NY New York Harbor HCS (NYH)',323,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New York NY (NYN)',324,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Oakland CA (OAK)',325,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Oklahoma City OK (OKL)',326,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Omaha NE (OMA)',327,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Oakland CA Oakland Outpatient Center (OPC)',328,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Morrisville NC DO NOT USE. Code is decommissioned (OQP)',329,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD Office of Research & Development (ORD)',330,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Orlando FL (ORL)',331,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ozark AR CBOC (OZK)',332,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Palo Alto CA (PAL)',333,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pasay City Philippines (PAS)',334,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Pharmacy Benefits Management (PBM)',335,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Culpeper VA Terremark location (PCP)',336,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Miami FL Terremark location (PCS)',337,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fairfax VA Fairfax PEC (PEC)',338,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Perry Point MD (PER)',339,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA Philadelphia ITC (PHC)',340,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA (PHI)',341,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Phoenix AZ (PHO)',342,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Secaucus NJ R04 Data Center (PHS)',343,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA Highland Dr (PIH)',344,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA (PIT)',345,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('National USA Perimeter Network - East (PNE)',346,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('National USA Perimeter Network - North (PNN)',347,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('National USA Perimeter Network - South (PNS)',348,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('National USA Perimeter Network - West (PNW)',349,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pocomoke MD (POC)',350,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Poplar Bluff MO (POP)',351,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Portland OR (POR)',352,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA (PPA)',353,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Hines Pre-Production (PPP)',354,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Prescott AZ (PRE)',355,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Providence RI (PRO)',356,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA (PRS)',357,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC VA Nat. Center for Health Promotion & Disease Prev (PRV)',358,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC (PSG)',359,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA (Aspinwall) (PTA)',360,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA (PTB)',361,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA Pittsburgh HCS (PTH)',362,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Seattle WA Puget Sound HCS (PUG)',363,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC QMI Center (QMI)',364,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Quantico VA NULL (QUA)',365,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Quincy MA Outpatient Clinic (QUI)',366,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Richmond VA Rehab (RBA)',367,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Benetia CA Rehab (RBE)',368,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bay Pines FL Rehab (RBP)',369,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL Rehab (RCH)',370,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX Rehab (RDA)',371,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Rehab (RDE)',372,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Reno NV Reno Eye Clinic (REC)',373,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Redding CA (RED)',374,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Reno NV (REN)',375,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Richmond VA (RIC)',376,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Saint Louis MO Records Management Center (RMC)',377,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Roanoke VA (ROA)',378,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Roseburg OR (ROS)',379,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Providence RI Rehab (RPR)',380,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Research Triangle Park NC R06 (RTP)',381,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA (SAC)',382,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Saginaw MI (SAG)',383,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Juan PR (SAJ)',384,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salem VA (SAM)',385,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Antonio TX (SAT)',386,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salisbury NC (SBY)',387,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Los Angeles CA Southern California System of Clinics (SC2)',388,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ft. Lyons CO Southern Colorado Health Care System (SCH)',389,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA Region 1 Data Center (SCR)',390,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Diego CA (SDC)',391,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL S&D (SDH)',392,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA Philly SDT (SDT)',393,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Seattle WA (SEA)',394,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sepulveda CA (SEP)',395,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Francisco CA (SFC)',396,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sioux Falls SD VAM&ROC (SFX)',397,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sheridan WY (SHE)',398,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Shreveport LA (SHR)',399,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Hines SIE (SIE)',400,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Jose CA (SJC)',401,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT (SLC)',402,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA Sacramento (McClellan) (SMC)',403,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA Sacramento Mental Health Clinic (SMH)',404,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA Sacramento (McClellan New) (SMN)',405,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Saint Louis MO (SMO)',406,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Security Operations Center (SOC)',407,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sonora CA (SON)',408,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Paul MN (SPL)',409,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Spokane WA (SPO)',410,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Petersburg FL (SPT)',411,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Santa Rosa CA (SRO)',412,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('South San Francisco CA (SSF)',413,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Cloud MN (STC)',414,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Stockton CA (STK)',415,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO (STL)',416,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('South Texas TX HCS (STX)',417,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sioux Falls SD (SUX)',418,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Syracuse NY (SYR)',419,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tallahassee FL Outpatient Clinic (TAL)',420,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tampa FL (TAM)',421,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Temple TX (TEM)',422,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Togus ME (TOG)',423,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tomah WI (TOM)',424,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Topeka KS (TOP)',425,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('VACO DC Telecommunications Support Office (TSO)',426,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tuscaloosa AL (TUA)',427,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tucson AZ (TUC)',428,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tuskegee AL CAVHCS (TUG)',429,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tulare CA (TUL)',430,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Nashville TN Tennesee Valley HCS (TVH)',431,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ukiah CA (UKI)',432,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Buffalo NY Upstate New York (UNY)',433,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA VISN 01 (V01)',434,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Albany NY VISN 02 (V02)',435,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bronx NY VISN 03 (V03)',436,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA VISN 04 (V04)',437,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Linthicum MD VISN 05 (V05)',438,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC VISN 06 (V06)',439,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA VISN 07 (V07)',440,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bay Pines FL VISN 08 (V08)',441,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Nashville TN VISN 09 (V09)',442,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cincinnati OH VISN 10 (V10)',443,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ann Arbor MI VISN 11 (V11)',444,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL VISN 12 (V12)',445,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kansas City MO VISN 15 (V15)',446,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS VISN 16 (V16)',447,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Grand Prairie TX VISN 17 (V17)',448,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mesa AZ VISN 18 (V18)',449,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Glendale CO VISN 19 (V19)',450,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Portland OR VISN 20 (V20)',451,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Francisco CA VISN 21 (V21)',452,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Long Beach CA VISN 22 (V22)',453,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minneapolis MN VISN 23 (V23)',454,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Vancouver WA ORM (VAN)',455,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Vet Center (VAU)',456,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bossier City LA Vet Center (VBO)',457,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Harlingen TX Valley Coastal Bend HCS (VCB)',458,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Corpus Christi TX Vet Center (VCO)',459,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX Vet Center (VDA)',460,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('El Paso TX Vet Center (VEL)',461,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Houston TX Vet Center (VHO)',462,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Houston TX Vet Center (VVRC) (VHV)',463,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS Vet Center (VJK)',464,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jacksonville   Vet Center (VJV)',465,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Midland TX Vet Center (VMI)',466,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New Jersey NJ Vet Center (VNJ)',467,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Petersburg FL Vetsnet (St. Pete) (VNT)',468,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Antonio TX Vet Center (VSA)',469,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Petersburg FL Vet Center (VSP)',470,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Savannah GA Vet Center (VSV)',471,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC Virtual VA (VVA)',472,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Waco TX (WAC)',473,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC VAMC (WAS)',474,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('WilkesBarre PA (WBP)',475,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('White City OR (WCO)',476,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Warner Robbins GA (WGA)',477,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Haven CT (WHC)',478,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Wichita KS (WIC)',479,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Wilmington DE (WIM)',480,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Winston-Salem NC (WIN)',481,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Los Angeles CA (WLA)',482,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Buffalo NY Western New York HCS (WNY)',483,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Worchester MA Outpatient Clinic (WOR)',484,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Worchester MA Vet Center (WOV)',485,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Palm Beach FL (WPB)',486,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('White River Junction VT (WRJ)',487,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Roxbury MA (WRX)',488,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Waco TX (WTX)',489,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Walla Walla WA (WWW)',490,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('OTHER (ZZZ)',491,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());
GO
------------------------------------------------------------------
PRINT 'Adding Rows to  STD_PAYPLAN'
------------------------------------------------------------------
  SET IDENTITY_INSERT [AHOBPR].[STD_PAYPLAN] OFF
;WITH  MasterData
AS    ( select * 
		from (VALUES
				 ('1','ME','01','PTE','Private'),
                ('1','ME','02','PTE','Private'),
                ('1','ME','03','LCPL','Lance Corporal'),
                ('1','ME','04','CPL','Corporal'),
                ('1','ME','05','SGT','Sergeant'),
                ('1','ME','06','SGT','Sergeant'),
                ('1','ME','07','SSGT','Staff Sergeant'),
                ('1','ME','08','WO2','Warrant Officer Class 2'),
                ('1','ME','09','WO1','Warrant Officer Class 1'),
                ('1','MO','01','2LT','Second Lieutenant'),
                ('1','MO','02','LT','Lieutenant'),
                ('1','MO','03','CAPT','Captain'),
                ('1','MO','04','MAJ','Major'),
                ('1','MO','05','LTCOL','Lieutenant Colonel'),
                ('1','MO','06','COL','Colonel'),
                ('1','MO','07','BRIG','Brigadier'),
                ('1','MO','08','MAJGEN','Major General'),
                ('1','MO','09','LTGEN','Lieutenant General'),
                ('1','MO','10','GEN','General'),
                ('2','ME','01','ORD','Ordinary'),
                ('2','ME','02','AB','AB'),
                ('2','ME','03','AB','AB'),
                ('2','ME','04','LH','Leading Hand'),
                ('2','ME','05','PO','Petty Officer'),
                ('2','ME','06','PO','Petty Officer'),
                ('2','ME','07','CPO','Chief Petty Officer'),
                ('2','ME','08','CPO','Chief Petty Officer'),
                ('2','ME','09','WO','Warrant Officer'),
                ('2','MO','02','SLT','Sub Lieutenant'),
                ('2','MO','03','LT','Lieutenant'),
                ('2','MO','04','LTCDR','Lieutenant Commander'),
                ('2','MO','05','CDR','Commander'),
                ('2','MO','06','CAPT','Captain'),
                ('2','MO','07','CMDR','Commodore'),
                ('2','MO','08','RADM','Rear Admiral'),
                ('2','MO','09','VADM','Vice Admiral'),
                ('2','MO','10','ADM','Admiral'),
                ('3','ME','01','PTE','Private'),
                ('3','ME','02','PTE','Private'),
                ('3','ME','03','LCPL','Lance Corporal'),
                ('3','ME','04','CPL','Corporal'),
                ('3','ME','05','SGT','Sergeant'),
                ('3','ME','06','SGT','Sergeant'),
                ('3','ME','07','CSGT','Colour Sergeant'),
                ('3','ME','08','WO2','Warrant Officer Class 2'),
                ('3','ME','09','WO1','Warrant Officer Class 1'),
                ('3','MO','01','2LT','Second Lieutenant'),
                ('3','MO','02','LT','Lieutenant'),
                ('3','MO','03','CAPT','Captain'),
                ('3','MO','04','MAJ','Major'),
                ('3','MO','05','LTCOL','Lieutenant Colonel'),
                ('3','MO','06','COL','Colonel'),
                ('3','MO','07','BRIG','Brigadier'),
                ('3','MO','08','MAJGEN','Major General'),
                ('3','MO','09','LTGEN','Lieutenant General'),
                ('3','MO','10','GEN','General'),
                ('4','ME','01','AC','Aircraftsman'),
                ('4','ME','02','LAC','Leading Aircraftsman'),
                ('4','ME','03','SAC','Senior Aircraftsman'),
                ('4','ME','04','CPL','Corporal'),
                ('4','ME','05','SGT','Sergeant'),
                ('4','ME','06','SGT','Sergeant'),
                ('4','ME','07','FLTSGT','Flight Sergeant'),
                ('4','ME','08','FLTSGT','Flight Sergeant'),
                ('4','ME','09','WO','Warrant Officer'),
                ('4','MO','01','PLTOFF','Pilot Officer'),
                ('4','MO','02','FLFF','Flying Officer'),
                ('4','MO','03','FLTLT','Flight Lieutenant'),
                ('4','MO','04','SGNLDR','Squadron Leader'),
                ('4','MO','05','WGCDR','Wing Commander'),
                ('4','MO','06','GPCAPT','Group Captain'),
                ('4','MO','07','ACOMDR','Air Commodore'),
                ('4','MO','08','AVM','Air Vice Marshal'),
                ('4','MO','09','AMSHL','Air Marshal'),
                ('4','MO','10','ACMSHL','Air Chief Marshal'),
                ('A','CA','01','Judge','Judge'),
                ('A','CA','02','Judge','Judge'),
                ('A','CA','03','Judge','Judge'),
                ('A','MC','01','OC','Officer Candidate'),
                ('A','MC','01','ROTC','Reserve Officer Training Corps'),
                ('A','ME','01','NON-PO','Junior Enlisted'),
                ('A','ME','01','PV1','Private (no insignia)'),
                ('A','ME','02','PV2','Private'),
                ('A','ME','03','PFC','Private First Class'),
                ('A','ME','04','CPL','Corporal'),
                ('A','ME','04','SP4','Specialist 4'),
                ('A','ME','04','SPC','Specialist'),
                ('A','ME','05','SGT','Sergeant'),
                ('A','ME','05','SP5','Specialist 5'),
                ('A','ME','06','SP6','Specialist 6'),
                ('A','ME','06','SSG','Staff Sergeant'),
                ('A','ME','07','PSG','Platoon Sergeant'),
                ('A','ME','07','SFC','Sergeant First Class'),
                ('A','ME','07','SSG','Staff Sergeant (obsolete)'),
                ('A','ME','08','1SG','First Sergeant'),
                ('A','ME','08','MSG','Master Sergeant'),
                ('A','ME','09','CSM','Command Sergeant Major'),
                ('A','ME','09','SGM','Sergeant Major'),
                ('A','ME','09','SMA','Sergeant Major of the Army'),
                ('A','MO','01','2LT','Second Lieutenant'),
                ('A','MO','02','1LT','First Lieutenant'),
                ('A','MO','03','CPT','Captain'),
                ('A','MO','04','MAJ','Major'),
                ('A','MO','05','LTC','Lieutenant Colonel'),
                ('A','MO','06','COL','Colonel'),
                ('A','MO','07','BG','Brigadier General'),
                ('A','MO','08','MG','Major General'),
                ('A','MO','09','LTG','Lieutenant General'),
                ('A','MO','10','GEN','General'),
                ('A','MW','01','WO1','Warrant Officer'),
                ('A','MW','02','CW2','Chief Warrant Officer'),
                ('A','MW','03','CW3','Chief Warrant Officer'),
                ('A','MW','04','CW4','Chief Warrant Officer'),
                ('A','MW','05','CW5','Chief Warrant Officer'),
                ('A','NULL','05','CADET','Cadet'),
                ('A','NULL','05','OC','Officer Candidate'),
                ('A','NULL','05','ROTC','Reserve Officer Training Corps'),
                ('C','MC','01','MIDSHP','Midshipman'),
                ('C','ME','01','NON-PO','Junior Enlisted'),
                ('C','ME','01','SR','Seaman Recruit'),
                ('C','ME','02','SA','Seaman Apprentice'),
                ('C','ME','03','SN','Seaman'),
                ('C','ME','04','PO3','Petty Officer Third Class'),
                ('C','ME','05','PO2','Petty Officer Second Class'),
                ('C','ME','06','PO1','Petty Officer First Class'),
                ('C','ME','07','CPO','Chief Petty Officer'),
                ('C','ME','08','SCPO','Senior Chief Petty Officer'),
                ('C','ME','09','MCPO','Master Chief Petty Officer'),
                ('C','ME','09','MCPOCG','Master Chief Petty Officer of the Coast Guard'),
                ('C','MO','01','ENS','Ensign'),
                ('C','MO','02','LTJG','Lieutenant Junior Grade'),
                ('C','MO','03','LT','Lieutenant'),
                ('C','MO','04','LCDR','Lieutenant Commander'),
                ('C','MO','05','CDR','Commander'),
                ('C','MO','06','CAPT','Captain'),
                ('C','MO','07','RADM','Rear Admiral'),
                ('C','MO','08','RADM','Rear Admiral'),
                ('C','MO','09','VADM','Vice Admiral'),
                ('C','MO','10','ADM','Admiral'),
                ('C','MW','01','WO-1','Warrant Officer'),
                ('C','MW','02','CWO-2','Chief Warrant Officer'),
                ('C','MW','03','CWO-3','Chief Warrant Officer'),
                ('C','MW','04','CWO-4','Chief Warrant Officer'),
                ('C','MW','05','CWO-5','Chief Warrant Officer'),
                ('C','NULL','05','AOC','Aviation Officer Candidate'),
                ('C','NULL','05','MIDS','Midshipman'),
                ('C','NULL','05','OC','Officer Candidate'),
                ('C','NULL','05','ROTC','Reserve Officer Training Corps'),
                ('F','MC','01','AOC','Aviation Officer Candidate'),
                ('F','MC','01','OC','Officer Candidate'),
                ('F','ME','01','AB','Airman Basic'),
                ('F','ME','01','NON-PO','Junior Enlisted'),
                ('F','ME','02','AMN','Airman'),
                ('F','ME','03','A1C','Airman First Class'),
                ('F','ME','04','Sgt','Sergeant'),
                ('F','ME','04','SGT','Sergeant (OBSOLETE)'),
                ('F','ME','04','SRA','Senior Airman'),
                ('F','ME','05','SSGT','Staff Sergeant'),
                ('F','ME','06','TSGT','Technical Sergeant'),
                ('F','ME','07','MSGT','Master Sergeant'),
                ('F','ME','08','SMSGT','Senior Master Sergeant'),
                ('F','ME','09','CMSAF','Chief Master Sergeant of the Air Force'),
                ('F','ME','09','CMSG','Chief Master Sergeant'),
                ('F','MO','01','2NDLT','Second Lieutenant'),
                ('F','MO','02','1STLT','First Lieutenant'),
                ('F','MO','03','CAPT','Captain'),
                ('F','MO','04','MAJ','Major'),
                ('F','MO','05','LTCOL','Lieutenant Colonel'),
                ('F','MO','06','COL','Colonel'),
                ('F','MO','07','BGEN','Brigadier General'),
                ('F','MO','08','MAJGEN','Major General'),
                ('F','MO','09','LTGEN','Lieutenant General'),
                ('F','MO','10','GEN','General'),
                ('F','MW','01','WO','Warrant Officer'),
                ('F','MW','02','CWO-2','Chief Warrant Officer'),
                ('F','MW','03','CWO-3','Chief Warrant Officer'),
                ('F','MW','04','CWO-4','Chief Warrant Officer'),
                ('F','MW','05','CWO-5','Chief Warrant Officer'),
                ('F','NULL','05','AOC','Aviation Officer Candidate'),
                ('F','NULL','05','CADE','Cadet'),
                ('F','NULL','05','OC','Officer Candidate'),
                ('F','NULL','05','ROTC','Reserve Officer Training Corps'),
                ('H','CC','01','ENS','Ensign'),
                ('H','CC','02','LTJG','Lieutenant Junior Grade'),
                ('H','CC','03','LT','Lieutenant'),
                ('H','CC','04','LCDR','Lieutenant Commander'),
                ('H','CC','05','CDR','Commander'),
                ('H','CC','06','CAPT','Captain'),
                ('H','CC','07','RADL','Rear Admiral (Lower Half)'),
                ('H','CC','07','RADM','Rear Admiral (Lower Half)'),
                ('H','CC','08','RADM','Rear Admiral'),
                ('H','CC','09','VADM','Vice Admiral'),
                ('H','CC','10','ADM','Admiral'),
                ('M','MC','01','OC','Officer Candidate'),
                ('M','ME','01','NON-PO','Junior Enlisted'),
                ('M','ME','01','PVT','Private (no insignia)'),
                ('M','ME','02','PFC','Private First Class'),
                ('M','ME','03','LCPL','Lance Corporal'),
                ('M','ME','04','CPL','Corporal'),
                ('M','ME','05','SGT','Sergeant'),
                ('M','ME','06','SSGT','Staff Sergeant'),
                ('M','ME','07','GYSGT','Gunnery Sergeant'),
                ('M','ME','08','1STSGT','First Sergeant'),
                ('M','ME','08','MSGT','Master Sergeant'),
                ('M','ME','09','MGYSGT','Master Gunnery Sergeant'),
                ('M','ME','09','SGTMAJ','Sergeant Major'),
                ('M','ME','09','SMOFMC','Sergeant Major of the Marine Corps'),
                ('M','MO','01','2NDLT','Second Lieutenant'),
                ('M','MO','02','1STLT','First Lieutenant'),
                ('M','MO','03','CAPT','Captain'),
                ('M','MO','04','MAJ','Major'),
                ('M','MO','05','LTCOL','Lieutenant Colonel'),
                ('M','MO','06','COL','Colonel'),
                ('M','MO','07','BGEN','Brigadier General'),
                ('M','MO','08','MAJGEN','Major General'),
                ('M','MO','09','LTGEN','Lieutenant General'),
                ('M','MO','10','GEN','General'),
                ('M','MW','01','WO','Warrant Officer'),
                ('M','MW','02','CWO2','Chief Warrant Officer'),
                ('M','MW','03','CWO3','Chief Warrant Officer'),
                ('M','MW','04','CWO4','Chief Warrant Officer'),
                ('M','MW','05','CWO5','Chief Warrant Officer'),
                ('M','NULL','05','PLC','Platoon Leaders Class'),
                ('N','MC','01','MIDSHP','Midshipman'),
                ('N','ME','01','NON-PO','Junior Enlisted'),
                ('N','ME','01','SR','Seaman Recruit'),
                ('N','ME','02','SA','Seaman Apprentice'),
                ('N','ME','03','SN','Seaman'),
                ('N','ME','04','PO3','Petty Officer Third Class'),
                ('N','ME','05','PO2','Petty Officer Second Class'),
                ('N','ME','06','PO1','Petty Officer First Class'),
                ('N','ME','07','CPO','Chief Petty Officer'),
                ('N','ME','08','SCPO','Senior Chief Petty Officer'),
                ('N','ME','09','MCPO','Master Chief Petty Officer'),
                ('N','ME','09','MCPON','Master Chief Petty Officer of the Navy'),
                ('N','MO','01','ENS','Ensign'),
                ('N','MO','02','LTJG','Lieutenant Junior Grade'),
                ('N','MO','03','LT','Lieutenant'),
                ('N','MO','04','LCDR','Lieutenant Commander'),
                ('N','MO','05','CDR','Commander'),
                ('N','MO','06','CAPT','Captain'),
                ('N','MO','07','RADM','Rear Admiral'),
                ('N','MO','08','RADM','Rear Admiral'),
                ('N','MO','09','VADM','Vice Admiral'),
                ('N','MO','10','ADM','Admiral'),
                ('N','MW','01','WO-1','Warrant Officer'),
                ('N','MW','02','CWO-2','Chief Warrant Officer'),
                ('N','MW','03','CWO-3','Chief Warrant Officer'),
                ('N','MW','04','CWO-4','Chief Warrant Officer'),
                ('N','MW','05','CWO-5','Chief Warrant Officer'),
                ('N','NULL','05','AOC','Aviation Officer Candidate'),
                ('N','NULL','05','OC','Officer Candidate'),
                ('N','NULL','05','ROTC','Reserve Officer Training Corps'),
                ('O','MO','01','ENS','Ensign'),
                ('O','MO','02','LTJG','Lieutenant Junior Grade'),
                ('O','MO','03','LT','Lieutenant'),
                ('O','MO','04','LCDR','Lieutenant Commander'),
                ('O','MO','05','CDR','Commander'),
                ('O','MO','06','CAPT','Captain'),
                ('O','MO','07','RADL','Rear Admiral (Lower Half)'),
                ('O','MO','07','RADM','Rear Admiral (Lower Half)'),
                ('O','MO','08','RADM','Rear Admiral'),
                ('U','NULL','NULL','UNK','Unknown')
			) AS MasterRecord(SERVICE_CODE,PAY_PLAN_CODE_SHORT,PAYGRADE_CODE,RANK_CODE,RANK_TEXT)
)
MERGE INTO [AHOBPR].[STD_PAYPLAN] as Tgt
USING MasterData as Src
ON Tgt.[SERVICE_CODE] = Src.SERVICE_CODE
AND Tgt.[PAY_PLAN_CODE_SHORT] = Src.PAY_PLAN_CODE_SHORT
AND Tgt.[PAYGRADE_CODE] = Src.PAYGRADE_CODE
AND Tgt.[RANK_CODE] = Src.RANK_CODE
AND Tgt.[RANK_TEXT] = Src.RANK_TEXT
WHEN NOT MATCHED
THEN INSERT
-- INSERT STD_DEPLOYMENT_STAGE values
 ([SERVICE_CODE], [PAY_PLAN_CODE_SHORT],[PAYGRADE_CODE], [RANK_CODE], [RANK_TEXT], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED]) 
  VALUES
  (Src.SERVICE_CODE, Src.PAY_PLAN_CODE_SHORT, Src.PAYGRADE_CODE, Src.RANK_CODE, Src.RANK_TEXT, 'AHOBPR DBA','AHOBPR DBA', getdate(), getdate());
GO
---------------------------------------------------------------------------------------------------------
PRINT 'UPDATE [dbo].[STD_ROLE]';
GO
---------------------------------------------------------------------------------------------------------
DECLARE @PageId INT, @AdminRoleId INT, @AdvancedUserRoleId INT, @CareTeamRoleId INT, @RegistryId INT, @HelpDeskRoleId INT;
DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();

SET @RegistryId  = (SELECT ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR');

-- Load STD_ROLE
WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES  
               (N'AHOBPR_REGISTRY_MANAGER', N'AHOBPR Registry Manager', N'AHOBPR Registry Manager who is a super user of the registry', 1, 1),
               (N'AHOBPR_ADVANCED_USER', N'AHOBPR Advanced User', N'AHOBPR Advanced User', 2, 0),
               (N'AHOBPR_CARE_TEAM',    N'AHOBPR Care Team',    N'AHOBPR Care Team', 3, 0),
			   (N'AHOBPR_HELP_DESK',    N'AHOBPR Help Desk',    N'AHOBPR Help Desk', 4, 0))
       AS MasterRecord(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, SUPER_USER_FLAG)
       )
MERGE
  INTO  [dbo].[STD_ROLE] AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [PARENT_ROLE_ID], [STD_REGISTRY_ID], [SUPER_USER_FLAG]) 
        VALUES
        (Src.CODE, Src.NAME, Src.DESCRIPTION_TEXT, Src.SORT_ORDER, 0, NULL,  @UserName, @UserName, @Today,@Today, NULL, @RegistryId, Src.SUPER_USER_FLAG)
 WHEN MATCHED 
 THEN UPDATE SET Tgt.[NAME] = Src.Name,
                 Tgt.DESCRIPTION_TEXT = Src.DESCRIPTION_TEXT,
                 Tgt.SORT_ORDER = Src.SORT_ORDER,
                 Tgt.SUPER_USER_FLAG = Src.SUPER_USER_FLAG,
                 Tgt.STD_REGISTRY_ID = @RegistryId;

-- Load STD_APPPAGE
WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
				('AHOBPR ADMIN EDIT USERS','AHOBPR ADMIN EDIT USERS','AHOBPR Admin Edit Users',1),
				('AHOBPR ADMIN LIST USERS','AHOBPR ADMIN LIST USERS','AHOBPR Admin List Users',1),
				('AHOBPR ADMIN TRACKING','AHOBPR ADMIN TRACKING','AHOBPR ADMIN TRACKING',1),
				('AHOBPR ADMIN USER ROLE','AHOBPR ADMIN USER ROLE','AHOBPR Admin User Role',1),
				('AHOBPR CHANGE STATUS','AHOBPR CHANGE STATUS','AHOBPR CHANGE STATUS',1),
				('AHOBPR QUESTIONNAIRE FULL','AHOBPR QUESTIONNAIRE FULL','AHOBPR QUESTIONNAIRE FULL',1),
				('AHOBPR QUESTIONNAIRE SECTION','AHOBPR QUESTIONNAIRE SECTION','AHOBPR QUESTIONNAIRE SECTION',1),
				('AHOBPR QUESTIONNAIRE SUMMARY','AHOBPR QUESTIONNAIRE SUMMARY','AHOBPR QUESTIONNAIRE SUMMARY',1),
				('AHOBPR REGISTRANT SEARCH','AHOBPR REGISTRANT SEARCH','AHOBPR REGISTRANT SEARCH',1),
				('AHOBPR REGISTRANTS','AHOBPR REGISTRANTS','AHOBPR REGISTRANTS',1),
				('AHOBPR REGISTRY FLAG','AHOBPR REGISTRY FLAG','AHOBPR Registry Flag will be used to flag registrants',1),
				('AHOBPR Report Ad Hoc','AHOBPR Report Ad Hoc','AHOBPR Report Ad Hoc',1),
				('AHOBPR REPORT AGING','AHOBPR REPORT AGING','AHOBPR REPORT AGING',1),
				('AHOBPR Report Selected Questionnaire','AHOBPR Report Selected Questionnaire','AHOBPR Report Selected Questionnaire',1),
				('AHOBPR Report Status by Location','AHOBPR Report Status by Location','AHOBPR Report Status by Location',1),
				('AHOBPR SUBPOPULATION FLAG','AHOBPR SUBPOPULATION FLAG','AHOBPR SUBPOPULATION FLAG',1),
				('AHOBPR STATUS HISTORY','AHOBPR STATUS HISTORY', 'AHOBPR STATUS HISTORY',1),
				('AHOBPR REPORT PARTICIPATION','AHOBPR REPORT PARTICIPATION','AHOBPR REPORT PARTICIPATION',1),
				('AHOBPR REPORT CONTACT INFORMATION','AHOBPR REPORT CONTACT INFORMATION','AHOBPR REPORT CONTACT INFORMATION',1),
				('AHOBPR REPORT AD HOC BY LOCATION','AHOBPR REPORT AD HOC BY LOCATION','AHOBPR REPORT AD HOC BY LOCATION',1),
				('AHOBPR REPORT ELIGIBILITY REVIEW','AHOBPR REPORT ELIGIBILITY REVIEW','AHOBPR REPORT ELIGIBILITY REVIEW',1),
				('AHOBPR REGISTRANT INFORMATION','AHOBPR REGISTRANT INFORMATION','AHOBPR REGISTRANT INFORMATION',1),
				('AHOBPR REGISTRY MESSAGES','AHOBPR REGISTRY MESSAGES','AHOBPR REGISTRY MESSAGES',1),
				('AHOBPR ADMIN EDIT TEMPLATE','AHOBPR ADMIN EDIT TEMPLATE','AHOBPR ADMIN EDIT TEMPLATE',1),
				('AHOBPR SEND MESSAGE','AHOBPR SEND MESSAGE','AHOBPR SEND MESSAGE',1),
				('AHOBPR TOOL','AHOBPR TOOL','AHOBPR TOOL',1),
				('AHOBPR ADMIN ADD FLAGS','AHOBPR ADMIN ADD FLAGS','AHOBPR ADMIN ADD FLAGS',1),
				('AHOBPR MY TEMPLATES','AHOBPR MY TEMPLATES','AHOBPR MY TEMPLATES',1),
				('AHOBPR REPORT FOLLOW-UP QUESTIONS','AHOBPR REPORT FOLLOW-UP QUESTIONS','AHOBPR REPORT FOLLOW-UP QUESTIONS',1),
				('AHOBPR MY ACCOUNT','AHOBPR MY ACCOUNT','AHOBPR MY ACCOUNT',1),
				('AHOBPR NAME UPDATE','AHOBPR NAME UPDATE','AHOBPR NAME UPDATE',1),
        ('ERROR PAGE','ERROR PAGE','ERROR PAGE',1),
				('AHOBPR TIMEOUT','AHOBPR TIMEOUT','AHOBPR TIMEOUT',1),
				('AHOBPR SYSTEM CHECK','AHOBPR SYSTEM CHECK','AHOBPR SYSTEM CHECK',1),
				('AHOBPR ERROR PAGE','AHOBPR ERROR PAGE','AHOBPR ERROR PAGE',1),
				('AHOBPR CLINICAL USER AD-HOC REPORT','AHOBPR CLINICAL USER AD-HOC REPORT','AHOBPR CLINICAL USER AD-HOC REPORT',1),
				('AHOBPR DEPLOYMENT HISTORY','AHOBPR DEPLOYMENT HISTORY','AHOBPR DEPLOYMENT HISTORY',1))
   AS MasterRecord(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER)
       )
MERGE
  INTO  [dbo].STD_APPPAGE AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
        VALUES
        (Src.CODE, Src.NAME, Src.DESCRIPTION_TEXT, Src.SORT_ORDER, 0, NULL,  @UserName, @UserName, @Today,@Today);

-- Load ROLE_PERMISSIONS
SET @AdminRoleId 		= (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_REGISTRY_MANAGER'); --100
SET @AdvancedUserRoleId = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_ADVANCED_USER'); --101
SET @CareTeamRoleId     = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_CARE_TEAM');--102
SET @HelpDeskRoleId     = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_HELP_DESK');

DELETE FROM [dbo].ROLE_PERMISSIONS WHERE STD_ROLE_ID IN(@AdminRoleId, @AdvancedUserRoleId, @CareTeamRoleId, @HelpDeskRoleId);

WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
        -- Admin User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN EDIT USERS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN LIST USERS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN USER ROLE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR CHANGE STATUS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRY FLAG'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT PARTICIPATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT ELIGIBILITY REVIEW'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT FOLLOW-UP QUESTIONS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRY MESSAGES'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN EDIT TEMPLATE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SEND MESSAGE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TOOL'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN ADD FLAGS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR NAME UPDATE'),@AdminRoleId),				
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@AdminRoleId),
        (AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@AdminRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@AdminRoleId),			
				(AHOBPR.GetAppPageId('AHOBPR CLINICAL USER AD-HOC REPORT'),@AdminRoleId),				
        	-- Advanced User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@AdvancedUserRoleId),
        (AHOBPR.GetAppPageId('AHOBPR CHANGE STATUS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT PARTICIPATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT FOLLOW-UP QUESTIONS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN ADD FLAGS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY TEMPLATES'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@AdvancedUserRoleId),	
        (AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@AdvancedUserRoleId),				
		-- Care Team User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@CareTeamRoleId),
        (AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@CareTeamRoleId),							
		-- Help Desk User Role
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR NAME UPDATE'),@HelpDeskRoleId),				
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@HelpDeskRoleId),
        (AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@HelpDeskRoleId),		
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@HelpDeskRoleId)		
				)
   AS MasterRecord(AppPageId, RoleId)
       )
MERGE
  INTO  [dbo].ROLE_PERMISSIONS AS Tgt
  USING MasterData AS Src
  ON    Tgt.[STD_APPPAGE_ID] = Src.AppPageId
  AND   Tgt.STD_ROLE_ID = Src.RoleId
 WHEN  NOT MATCHED
 THEN  INSERT
	   ([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
	VALUES(Src.RoleId, Src.AppPageId, @UserName, @UserName, @Today,@Today, 1, 1, 1);

  -- Note if the INSERT, UPDATE And DELETE flags are ever used and different for each entry, we will need to move them up into the Master Data
GO
---------------------------------------------------------------------------------------------------------
PRINT 'PROCEDURE [AHOBPR].[SP_ReportRegistrantStatus]';
GO
---------------------------------------------------------------------------------------------------------

IF EXISTS (SELECT * FROM sys.objects WHERE type = 'P' AND name = 'SP_ReportRegistrantStatus')
	DROP PROCEDURE  [AHOBPR].[SP_ReportRegistrantStatus]
GO

CREATE procedure [AHOBPR].[SP_ReportRegistrantStatus]
    @ReportStartDate date, @ReportEndDate date = null
  as
  begin
/*
o	duringRangeCount = is the number of registrants who entered this status between @ReportStartDate and @ReportEndDate.
o	atEndOfRangeCount = is the total number of registrants in the status at the end of the day specified by @ReportEndDate.
o	Change status events were recorded from August 30, 2015 on.  The last status change event prior to August 30 was inferred and recorded.  There is no record of prior status changes.
o As of 1/29/2018, the[REGISTRANT_STATUS_LAST_UPDATED_DATE] column in the [AHOBPR].[REGISTRANT] table does not reflect the last status change date, so it is not used at all 
o If the Report Start Date is greater than Report End Date, an exception is raised.
*/
    set nocount on;

    declare @QueryReportEndDate datetime2(0);
    declare @row_count int;

    set @ReportEndDate = isnull(@ReportEndDate, cast(getdate() as date)); 
    set @QueryReportEndDate = dateadd(second, -1, dateadd(day, 1, cast(@ReportEndDate as datetime2(0))));
    
    declare @s1 as varchar(50) = cast(@ReportStartDate as varchar),@s2 as varchar(50) = cast(@ReportEndDate as varchar),@s3 as varchar(50)= cast(@QueryReportEndDate as varchar);

    raiserror('@ReportStartDate (%s); @ReportEndDate (%s); @QueryReportEndDate (%s)',0,0, @s1, @s2, @s3);

    begin try

      if @ReportEndDate < @ReportStartDate raiserror('Report Start Date is greater than Report End Date', 11, 0);

      with 
        registrantStatusChangeEvent       as (select * from [AHOBPR].[STD_PROCESS_METRICS_TYPE] where process_metrics = 'Registrant Status Change'),
        statusChangeEvent                 as (select pm.REGISTRANT_ID, rs.[REGISTRANT_STATUS], rs.ORDINAL_VALUE, pm.CREATED from [AHOBPR].[PROCESS_METRICS] pm join [AHOBPR].[STD_REGISTRANT_STATUS] rs on rs.[REGISTRANT_STATUS] = pm.[PROCESS_METRICS_VALUE] where pm.STD_PROCESS_METRICS_TYPE_ID = (select STD_PROCESS_METRICS_TYPE_ID from registrantStatusChangeEvent)), --select count(*) from statusChangeEvent;
        statusChangeInRange               as (select *  from statusChangeEvent where [CREATED] between @ReportStartDate and @QueryReportEndDate),
        statusChangeInRangeByStatus       as (select rs.[REGISTRANT_STATUS], rs.[ORDINAL_VALUE], count(sc.[REGISTRANT_STATUS]) duringRangeCount from [AHOBPR].[STD_REGISTRANT_STATUS] rs left join statusChangeInRange sc on sc.[REGISTRANT_STATUS] = rs.[REGISTRANT_STATUS] where rs.[REGISTRANT_STATUS] != 'Consent' group by rs.[REGISTRANT_STATUS], rs.[ORDINAL_VALUE]),
        statusChangeBeforeEndOfRange      as (select *, row_number() over(partition by [REGISTRANT_ID] order by CREATED desc) rowNum from statusChangeEvent where [CREATED] <= @QueryReportEndDate),
        lastStatusChangeBeforeEndOfRange  as (select * from statusChangeBeforeEndOfRange where rowNum = 1),
        registrant                        as (select r.*, rs.[REGISTRANT_STATUS], rs.[ORDINAL_VALUE] from [AHOBPR].REGISTRANT r join [AHOBPR].[STD_REGISTRANT_STATUS] rs on rs.[STD_REGISTRANT_STATUS_ID] = r.[STD_REGISTRANT_STATUS_ID] where r.created <= @QueryReportEndDate),
        registrantWithNoStatusChange      as (select * from registrant where not exists (select * from lastStatusChangeBeforeEndOfRange a where a.REGISTRANT_ID = registrant.registrant_id)),
        lastStatusChangeBeforeEndOfRangeIncludingInferred 
                                          as (select REGISTRANT_ID, [REGISTRANT_STATUS], ORDINAL_VALUE from lastStatusChangeBeforeEndOfRange union select REGISTRANT_ID, [REGISTRANT_STATUS], ORDINAL_VALUE from registrantWithNoStatusChange),
        lastStatusChangeBeforeEndOfRangeByStatus   as (select rs.[REGISTRANT_STATUS], rs.[ORDINAL_VALUE], count(*) atEndOfRangeCount from [AHOBPR].[STD_REGISTRANT_STATUS] rs left join lastStatusChangeBeforeEndOfRangeIncludingInferred a on a.[REGISTRANT_STATUS] = rs.[REGISTRANT_STATUS] where rs.[REGISTRANT_STATUS] != 'Consent' group by rs.[REGISTRANT_STATUS], rs.[ORDINAL_VALUE])
    
      select 
              isnull(a.[REGISTRANT_STATUS], b.[REGISTRANT_STATUS]) as 'Row Name', 
              isnull(a.[ORDINAL_VALUE], b.[ORDINAL_VALUE]) as sort_order, 
              a.atEndOfRangeCount, 
              b.duringRangeCount
        from  lastStatusChangeBeforeEndOfRangeByStatus a
        full outer join  statusChangeInRangeByStatus b
          on  a.[REGISTRANT_STATUS] = b.[REGISTRANT_STATUS]
      union
        select 
              'In-Person Evaluation' as 'Row Name', 
              0 sort_order, 
              count(*) atEndOfRangeCount, 
              isnull(sum(case when [VISIT_DATE_TIME] >= @ReportStartDate then 1 else 0 end),0) duringRangeCount
        from [AHOBPR].[REGISTRANT_VISIT] 
        where 
              [EVALUATION_FLAG] = 'Y'
          and [VISIT_DATE_TIME] <= @QueryReportEndDate
      order 
        by    sort_order desc;

      set @row_count = @@ROWCOUNT;
    end try
    begin catch
      throw;
    end catch

    return @row_count;
  end;
  /*
  declare @rtn int;
  execute @rtn = AHOBPR.SP_ReportRegistrantStatus
    @ReportStartDate = '2018-01-20', @ReportEndDate = '2017-01-20';

  select @rtn;
  */
GO


---------------------------------------------------------------------------------------------------------
PRINT 'PROCEDURE [AHOBPR].[SP_ClinicalUserAdHocReport]';
GO
---------------------------------------------------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE type = 'P' AND name = 'SP_ClinicalUserAdHocReport')
	DROP PROCEDURE  [AHOBPR].[SP_ClinicalUserAdHocReport]
GO

-- =============================================
-- Author:		Padmashri N. Valaparla
-- Create date: November 27, 2017
-- Description:	Used for the AHOBPR Clinical User Ad-Hoc Report
-- =============================================

CREATE PROCEDURE [AHOBPR].[SP_ClinicalUserAdHocReport]
  @actionTypeId varchar(30) = NULL, -- Action Type ID
  @fromDateText varchar(100) = NULL,
  @toDateText varchar(100) = NULL,
  @userRoleId varchar(30) = NULL, -- User role ID
  @StatusId varchar(30) = NULL, -- User Status ID
  @PrimaryJob varchar(8000) = NULL, -- Multiple Primary Job, comma-separated values when not NULL
  @WorkLocation varchar(8000) = NULL, -- Multiple Work Location, comma-separated values when not NULL  
  @SecondaryJob varchar(8000) = NULL, -- Multiple Secondary Job, comma-separated values when not NULL
  @ChangeStatusState  varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL 
  @JobTitle varchar(80) = NULL -- Job Title 
AS

BEGIN
 DECLARE @fromDate DATETIME2(0) = NULL,
          @toDate DATETIME2(0) = NULL,
		  @Query VARCHAR(8000),
		  @State varchar(30) = NULL;

--Temp table for holding the AUDIT_LOG 
  CREATE TABLE #AUDIT_LOG
  ( 	
	  [TYPE_ID]               [tinyint]       NOT NULL,
	  [USER_ID]               [int]           NULL,
	  [REGISTRANT_ID]         [int]           NULL,
	  [NUMBER_OF_REGISTRANTS] [int]           NULL,
	  [MESSAGE]               [varchar](1000) NULL,
	  [CREATED]               [datetime]      NOT NULL
	 );

  INSERT INTO #AUDIT_LOG
    SELECT [TYPE_ID], [USER_ID],[REGISTRANT_ID],[NUMBER_OF_REGISTRANTS],[MESSAGE],[CREATED] 
	  FROM AHOBPR.AUDIT_LOG
	  WHERE USER_ID IS NOT NULL;

  -- Convert date parameters      
  SET @fromDate = dbo.CleanDate(@fromDateText);
  SET @toDate = dbo.AddMaxTime(dbo.CleanDate(@toDateText));

 IF @fromDate IS NOT NULL 
	  DELETE FROM #AUDIT_LOG WHERE CREATED < @fromDate

 IF @toDate IS NOT NULL 
	  DELETE FROM #AUDIT_LOG WHERE CREATED > @toDate
  
 IF @actionTypeId IS NOT NULL AND @actionTypeId != ''
	  DELETE FROM #AUDIT_LOG WHERE TYPE_ID <> @actionTypeId

IF @userRoleId IS NOT NULL AND @userRoleId != ''
	  DELETE FROM #AUDIT_LOG 
	    WHERE USER_ID NOT IN (SELECT A.USER_ID FROM DBO.USER_ROLES A,  #AUDIT_LOG B 
													  WHERE A.STD_ROLE_ID = @userRoleId AND A.USER_ID = B.USER_ID);

  
SET @Query = 'SELECT U.LAST_NAME, U.FIRST_NAME, AHOBPR.GetUserRolesByID(U.USER_ID) AS ROLES,P.PRIMARY_JOB, U.JOB_TITLE,
				CASE WHEN (D.ACTIVE_FLAG = 1 AND D.PENDING_FLAG = 0) THEN ''Active'' 
					WHEN (D.ACTIVE_FLAG = 0 AND D.PENDING_FLAG = 0) THEN ''Inactive''
					WHEN D.PENDING_FLAG = 1 THEN ''Pending'' 
					END AS Status,  W.WORK_LOCATION,F.STATES	 
			   FROM [AHOBPR].[AHOBPR_USER] D
					LEFT OUTER JOIN DBO.USERS U ON D.USER_ID = U.USER_ID
					LEFT OUTER JOIN [AHOBPR].[STD_PRIMARY_JOB] P ON D.PRIMARY_JOB_ID = P.STD_PRIMARY_JOB_ID
					LEFT OUTER JOIN [AHOBPR].[STD_WORK_LOCATION] W ON D.WORK_LOCATION_ID = W.STD_WORK_LOCATION_ID ';

IF @ChangeStatusState IS NOT NULL
	BEGIN
		Select @State = AHOBPR.GetStateCodeByID (@ChangeStatusState);
		SET @Query = @Query + ' JOIN [AHOBPR].[USER_STATES_FILTER] F ON F.USER_ID = U.USER_ID';
		SET @Query = @Query + ' AND STATES LIKE (''%' + @State + '%'') ';
	END
ELSE
	SET @Query = @Query + ' LEFT JOIN [AHOBPR].[USER_STATES_FILTER] F ON F.USER_ID = U.USER_ID';


IF @actionTypeId IS NOT NULL OR (@fromDateText IS NOT NULL and @toDateText IS NOT NULL)
	BEGIN
		SET @Query = @Query + ' JOIN (select distinct USER_ID from #AUDIT_LOG ';
		SET @Query = @Query + ' ) L on L.USER_ID = U.USER_ID ';
	END

SET @Query = @Query + ' WHERE 1 = 1 ';

				
IF @userRoleId IS NOT NULL AND @userRoleId != ''
	SET @Query = @Query + 'AND EXISTS (SELECT 1 FROM [dbo].[USER_ROLES] WHERE [USER_ID] = U.USER_ID AND [STD_ROLE_ID] = ' + @userRoleId + ') ';


IF @StatusId = 1
     SET @Query = @Query + 'AND D.ACTIVE_FLAG = 1 AND D.PENDING_FLAG = 0';

IF @StatusId = 2
     SET @Query = @Query + 'AND D.ACTIVE_FLAG = 0 AND D.PENDING_FLAG = 0';

IF @StatusId = 3
     SET @Query = @Query + 'AND D.PENDING_FLAG = 1 ';


IF ISNULL(@PrimaryJob,'') > ''
    BEGIN
      SET @PrimaryJob = REPLACE(@PrimaryJob,',',''',''');
      SET @Query = @Query + ' AND PRIMARY_JOB_ID IN ( ''' + @PrimaryJob + ''') ';
		      		
	END

IF ISNULL(@SecondaryJob,'') > ''
    BEGIN
      SET @SecondaryJob = REPLACE(@SecondaryJob,',',''',''');
      SET @Query = @Query + ' AND SECONDARY_JOB_ID IN ( ''' + @SecondaryJob + ''') ';
		      		
	END

IF ISNULL(@WorkLocation,'') > ''
    BEGIN
      SET @WorkLocation = REPLACE(@WorkLocation,',',''',''');
      SET @Query = @Query + ' AND WORK_LOCATION_ID IN ( ''' + @WorkLocation + ''') ';
		      		
	END 		

IF @JobTitle IS NOT NULL
	SET @Query = @Query + 'AND JOB_TITLE like (''%' + @JobTitle + '%'') ';


PRINT  @Query;
  
EXECUTE (@Query);  
	
END

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

---------------------------------------------------------------------------------------------------------
PRINT 'ALTER PROCEDURE [AHOBPR].[SP_UpdateRegistrant]';
GO
---------------------------------------------------------------------------------------------------------
-- ALTER PROCEDURE [AHOBPR].[SP_UpdateRegistrant]
IF OBJECT_ID('[AHOBPR].[SP_UpdateRegistrant]') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE [AHOBPR].[SP_UpdateRegistrant] AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [AHOBPR].[SP_UpdateRegistrant] 
    @REGISTRANT_ID int,
    @RACE varchar(50),
    @ETHNICITY varchar(50),
    @DECEASED_FLAG bit,
    @DEATH_DATE date,
    @MARITAL_STATUS varchar(50),
    @EDUCATION_LEVEL varchar(50),
    @UPDATED datetime2(0),
	@UPDATEDBY varchar(30)
AS
BEGIN
    SET NOCOUNT ON;
	SET @UPDATEDBY = ISNULL(@UPDATEDBY, 'SP_UpdateRegistrant');
UPDATE [AHOBPR].[REGISTRANT]
   SET 
     [RACE] = @RACE
    ,[ETHNICITY] = @ETHNICITY
    ,[DECEASED_FLAG] = @DECEASED_FLAG
    ,[DEATH_DATE] = @DEATH_DATE
    ,[MARITAL_STATUS] = @MARITAL_STATUS
    ,[EDUCATION_LEVEL] = @EDUCATION_LEVEL
    ,[UPDATEDBY] = @UPDATEDBY
    ,[UPDATED] = @UPDATED

 WHERE [AHOBPR].[REGISTRANT].[REGISTRANT_ID] =  @REGISTRANT_ID;
END

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF OBJECT_ID('AHOBPR.SP_InsertIntoUpdatesProcessed') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE AHOBPR.SP_InsertIntoUpdatesProcessed AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO

ALTER PROCEDURE [AHOBPR].[SP_InsertIntoUpdatesProcessed]
	@notificationId			bigint,
	@registrantId			bigint,
	@edipi					VARCHAR(50),
  @processName			VARCHAR(100),
	@processStatus			VARCHAR(100),
	@processError			VARCHAR(4000) = NULL,
	@createdBy				VARCHAR(30)
AS
BEGIN

	SET NOCOUNT ON;

	INSERT INTO AHOBPR.UPDATES_PROCESSED_NOTIFICATION_STATUS (					  
		[UPDATES_BENS_REGISTRANT_NOTIFICATION_ID], 
		[REGISTRANT_ID],
		[EDIPI],
    [PROCESS_NAME],
		[PROCESS_STATUS],
		[PROCESS_ERROR],
		[CREATEDBY],
		[CREATED],
		[UPDATEDBY],
		[UPDATED])
	VALUES (			
		  @notificationId
		, @registrantId
		, @edipi
    , @processName
		, @processStatus
		, @processError
		, @createdBy
		, GETDATE()
		, @createdBy
		, GETDATE());

	SELECT SCOPE_IDENTITY();

END

---------------------------------------------------------------------------------------------------------
PRINT 'ALTER PROCEDURE [AHOBPR].[SP_GetPendingRegistrantUpdates]';
GO
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Leon Mansfield
-- Create date: 2017-11-01
-- Description:	
-- =============================================
IF OBJECT_ID('AHOBPR.SP_GetPendingRegistrantUpdates') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE AHOBPR.SP_GetPendingRegistrantUpdates AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO
ALTER PROCEDURE [AHOBPR].[SP_GetPendingRegistrantUpdates] 
	-- Add the parameters for the stored procedure here
AS
BEGIN
	DECLARE @MaxQueueId int;
	DECLARE @MaxProcessDate datetime2(0);
	DECLARE @CREATEDBY varchar(30);
	SET @CREATEDBY = ISNULL(@CREATEDBY, 'SP_GetPendingRegistrantUpdates');
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	SET @MaxProcessDate = (SELECT MAX(CREATED) 
						   FROM [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] WITH (READPAST));
	SET @MaxProcessDate = ISNULL(@MaxProcessDate, '1900-01-01');
	PRINT @MaxProcessDate;
	INSERT
	 INTO	[AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] 
			(EDIPI, REGISTRANT_ID, CREATED, CREATEDBY)
	 SELECT UQ.EDIPI, REG.REGISTRANT_ID, UQ.CREATED, @CREATEDBY 
	 FROM   [AHOBPR].[UPDATES_BENS_NOTIFICATION] as UQ
	 JOIN   [AHOBPR].[REGISTRANT] REG ON UQ.EDIPI = REG.EDIPI
	 WHERE  UQ.CREATED > @MaxProcessDate;

--Step 5

	SELECT 
	[UPDATES_BENS_REGISTRANT_NOTIFICATION_ID],[EDIPI],[REGISTRANT_ID],[CREATEDBY],[CREATED]
	FROM [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] q WITH (READPAST)
	WHERE NOT EXISTS (select * from [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS] s where s.[UPDATES_BENS_REGISTRANT_NOTIFICATION_ID] = q.[UPDATES_BENS_REGISTRANT_NOTIFICATION_ID]) ;
		
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'ALTER PROCEDURE [AHOBPR].[SP_InsertIntoBensUpdates]';
GO
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF OBJECT_ID('AHOBPR.SP_InsertIntoBensUpdates') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE AHOBPR.SP_InsertIntoBensUpdates AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO
ALTER PROCEDURE [AHOBPR].[SP_InsertIntoBensUpdates] 
	-- Add the parameters for the stored procedure here
    @edipi VARCHAR(50)
AS
BEGIN
    SET NOCOUNT ON;
	DECLARE @createdby varchar(30);
	SET @createdby = ISNULL(@CREATEDBY, 'SP_InsertIntoBensUpdates');
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
    INSERT INTO  [AHOBPR].[UPDATES_BENS_NOTIFICATION]  ([EDIPI], [CREATEDBY], [CREATED])
    VALUES(
        @edipi, @CREATEDBY, GETDATE()
    );
--Step 5	
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Adding STD_PAYPLAN_ID to [REGISTRANT_DEPLOYMENT]';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') 
         AND name = 'STD_PAYPLAN_ID')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] 
	ADD STD_PAYPLAN_ID int	
END
GO
-- Add the FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE foreign key constraint if it does not exist
IF (OBJECT_ID('ahobpr.[FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN]', 'F') IS NULL)
BEGIN
	Print N'Trying to add foreign key FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN'
	ALTER 
		TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]  
		ADD  CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN] 
		FOREIGN KEY([STD_PAYPLAN_ID])
		REFERENCES [AHOBPR].[STD_PAYPLAN] ([STD_PAYPLAN_ID]);
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
PRINT 'Adding FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE to REGISTRANT_DEPLOYMENT';
---------------------------------------------------------------------------------------------------------

ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]  WITH CHECK ADD  CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE] FOREIGN KEY([STD_DEPLOYMENT_STAGE_ID])
REFERENCES [AHOBPR].[STD_DEPLOYMENT_STAGE] ([STD_DEPLOYMENT_STAGE_ID])
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
PRINT 'Dropping  column MILITARY_RANK from REGISTRANT_DEPLOYMENT';
---------------------------------------------------------------------------------------------------------
IF  EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') 
         AND name = 'MILITARY_RANK')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]
		DROP COLUMN	[MILITARY_RANK]
END
GO

IF  EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT_H]') 
         AND name = 'MILITARY_RANK')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT_H]
		DROP COLUMN	[MILITARY_RANK]
END
GO

ALTER trigger [AHOBPR].[TRG_REGISTRANT_DEPLOYMENT_H] on [AHOBPR].[REGISTRANT_DEPLOYMENT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_DEPLOYMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

FROM INSERTED
End


GO


ALTER TRIGGER  [AHOBPR].[TRG_REGISTRANT_DEPLOYMENT_DEL_H]
on  [AHOBPR].[REGISTRANT_DEPLOYMENT] After DELETE
AS
BEGIN 
declare @pos int, @vchar varchar(128)
SET @pos = 1
    SET @vchar = CAST(CONTEXT_INFO()AS varchar(128))
    
    --Remove all 0x0 (keep only text)
    WHILE not ASCII(substring(@vchar,@pos,1))=0 
    BEGIN
         SET @pos = @pos + 1
    END
    
    SET @vchar = SUBSTRING(@vchar, 1, @pos - 1)
INSERT INTO [AHOBPR].[REGISTRANT_DEPLOYMENT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
)
SELECT getDate()
, lv_Change=  'DELETE'
, HCB= @vchar
, suser_sname()
, [REGISTRANT_DEPLOYMENT_ID]
, [REGISTRANT_ID]
, [STD_BRANCH_OF_SERVICE_ID]
, [DUTY_PROJECT_CODE]
, [DEPLOYMENT_UIC]
, [DEPLOYMENT_COUNTRY]
, [DEPLOYMENT_BASE]
, [DEPLOYMENT_START_DATE]
, [DEPLOYMENT_END_DATE]
, [IS_GULF_WAR_VETERAN_FLAG]
, [IS_ELIGIBLE_FLAG]
, [USER_ENTERED_FLAG]
, [USER_VERIFIED_FLAG]
, [LAST_UPDATED_DATE]
, [PREVIOUS_VALUES]
, [PREVIOUS_UPDATED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]

From Deleted
End
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Adding Deceased to [AHOBPR].[STD_SERVICE_STATUS]';
---------------------------------------------------------------------------------------------------------
;WITH  MasterData
AS    ( select * 
        from (VALUES 
                ('Deceased', 'AHOBPR DBA', 'AHOBPR DBA',GETDATE(), GETDATE())
              ) AS MasterRecord(SERVICE_STATUS,CREATEDBY,UPDATEDBY,CREATED,UPDATED) 
)
MERGE INTO [AHOBPR].[STD_SERVICE_STATUS] as Tgt
USING MasterData as Src
ON Tgt.[SERVICE_STATUS] = Src.SERVICE_STATUS
WHEN NOT MATCHED
THEN INSERT
  ([SERVICE_STATUS],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
  VALUES
   (Src.SERVICE_STATUS, Src.CREATEDBY, Src.UPDATEDBY, Src.CREATED, Src.UPDATED);

GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
PRINT 'Removing foreign keys for column STD_SERVICE_OCCUPATION_ID and constraints from REGISTRANT_DEPLOYMENT';
---------------------------------------------------------------------------------------------------------
-- Remove FK from REGISTRANT_DEPLOYMENT Table
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_OCCUPATION]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_OCCUPATION';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_OCCUPATION;
END
GO
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_OCCUPATION]', 'D') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_OCCUPATION';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_OCCUPATION;
END
GO
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_OCCUPATION]', 'C') IS NOT  NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_OCCUPATION';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_OCCUPATION;
END
GO
ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_OCCUPATION;
GO
IF EXISTS (SELECT *  FROM  [sys].[default_constraints] 
		   WHERE  object_id = OBJECT_ID(N'ahobpr.FK_REGISTRANT_DEPLOYMENT_OCCUPATION') )
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] 
		DROP CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_OCCUPATION];
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Dropping  column STD_SERVICE_OCCUPATION_ID and constraints from REGISTRANT_DEPLOYMENT';
---------------------------------------------------------------------------------------------------------
IF  EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') 
         AND name = 'STD_SERVICE_OCCUPATION_ID')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]
		DROP COLUMN	[STD_SERVICE_OCCUPATION_ID]
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Add Columns PERSONNEL_CATEGORY_TYPE_CODE to [AHOBPR].[REGISTRANT_SERVICE_EPISODE] if it does not exist';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_SERVICE_EPISODE]') 
         AND name = 'PERSONNEL_CATEGORY_TYPE_CODE')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE]
		ADD	[PERSONNEL_CATEGORY_TYPE_CODE] int NULL
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Add constraint PERSONNEL_CATEGORY_TYPE_CODE to [AHOBPR].[REGISTRANT_SERVICE_EPISODE] if it does not exist';
---------------------------------------------------------------------------------------------------------
ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE]  WITH CHECK ADD  CONSTRAINT FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT FOREIGN KEY([PERSONNEL_CATEGORY_TYPE_CODE])
REFERENCES [AHOBPR].[STD_COMPONENT] ([STD_COMPONENT_ID])
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Add constraint NARRATIVE_REASON_FOR_SEPARATION_TEXT to [AHOBPR].[REGISTRANT_SERVICE_EPISODE] if it does not exist';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'REGISTRANT_SERVICE_EPISODE') 
         AND name = 'NARRATIVE_REASON_FOR_SEPARATION_TEXT')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE]
		ADD	[NARRATIVE_REASON_FOR_SEPARATION_TEXT] [varchar](500) NULL
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Create table [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION]';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'AHOBPR.REGISTRANT_SERVICE_SPECIFIC_OCCUPATION') AND type in (N'U'))
BEGIN
CREATE TABLE [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION]
(
	[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_ID] INT NOT NULL IDENTITY, 
  [STD_SERVICE_OCCUPATION_ID] INT NOT NULL, 
	[REGISTRANT_DEPLOYMENT_ID] INT NOT NULL,
	[OCCUPATION_TYPE] CHAR(1) NOT NULL,
	[START_DATE] [datetime2](0) NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime2](0) NOT NULL,
	[UPDATED] [datetime2](0) NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	 CONSTRAINT [PK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] PRIMARY KEY CLUSTERED 
(
	[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
) ON [AHOBPR]
END
 ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] WITH CHECK 
	ADD  CONSTRAINT [FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION] FOREIGN KEY ([STD_SERVICE_OCCUPATION_ID]) 
	REFERENCES [AHOBPR].[STD_SERVICE_OCCUPATION] ([STD_SERVICE_OCCUPATION_ID])

ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] WITH CHECK 
    ADD CONSTRAINT [FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT] FOREIGN KEY([REGISTRANT_DEPLOYMENT_ID]) REFERENCES [AHOBPR].[REGISTRANT_DEPLOYMENT] ([REGISTRANT_DEPLOYMENT_ID])

GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'AHOBPR.STD_ETHNICITY') AND type in (N'U'))
BEGIN
CREATE TABLE [AHOBPR].[STD_ETHNICITY](
	[STD_ETHNICITY_ID] [int] IDENTITY(1,1) NOT NULL,
	[CODE] [varchar](5) NOT NULL,
	[TEXT] [varchar](50) NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime2](0) NOT NULL DEFAULT (getdate()),
	[UPDATED] [datetime2](0) NOT NULL DEFAULT (getdate()),
	[ROW_VERSION] [timestamp] NOT NULL,
 CONSTRAINT [STD_ETHNICITY_PK] PRIMARY KEY CLUSTERED 
(
	[STD_ETHNICITY_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
) ON [AHOBPR]
END

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ('Other Hispanic descent'   , '1' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ('United States/Canadian Indian Tribes' , '2' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Other Asian descent'  ,'3'  ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Puerto Rican'  , '4' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Filipino'  , '5' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Mexican'  , '6' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Eskimo'  , '7' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Aleut'  , '8' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Cuban'  , '9' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Indian'  ,'D'  ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES (  'Melanesian' , 'E' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Chinese'  , 'G' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Guamanian'  ,'H'  ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES (  'Japanese' ,'J'  ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
 
INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ('Korean'   , 'K' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES (  'Polynesian' , 'L' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Other Pacific Island descent'  , 'Q' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Latin American with Hispanic descent'  ,'S'  ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ('Vietnamese'   , 'V' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ('Micronesian'   ,'W'  ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES (  'Other' ,'X'  ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'None'  , 'Y' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_ETHNICITY]  ([TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Unknown'  , 'Z' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

INSERT INTO [AHOBPR].[STD_RACE]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'White'  , 'C' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_RACE]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Asian or Pacific Islander'  , 'M' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_RACE]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Black'  , 'N' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_RACE]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'American Indian or Alaskan Native'  , 'R' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_RACE]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Other'  , 'X' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_RACE]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
   VALUES ( 'Unknown'  , 'Z' ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO


---------------------------------------------------------------------------------------------------------
PRINT 'Create Table [AHOBPR].[STD_EDUCATION_LEVEL]';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_EDUCATION_LEVEL]') AND type in (N'U'))
BEGIN
CREATE TABLE [AHOBPR].[STD_EDUCATION_LEVEL](
	[STD_EDUCATION_LEVEL_ID]  [int] IDENTITY(1,1) NOT NULL,
	[CODE] [int] NOT NULL,
	[DESCRIPTION_TEXT] [varchar](200) NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL DEFAULT ('AHOBPR DBA'),
	[UPDATEDBY] [varchar](30) NOT NULL DEFAULT ('AHOBPR DBA'),
	[CREATED] [datetime] NOT NULL DEFAULT (getdate()),
	[UPDATED] [datetime] NOT NULL DEFAULT (getdate()),

 CONSTRAINT [AHBOPRSTD_EDUCATION_LEVEL_PK] PRIMARY KEY CLUSTERED 
(
	[STD_EDUCATION_LEVEL_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Less than high school diploma'  , 11 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Attending high school, junior or less'  , 12 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Attending high school, senior'  , 13 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Secondary school credential near completion'  , 14 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Test-based equivalency diploma'  , 21 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Occupational program certificate'  , 22 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Correspondence school diploma'  , 23 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'High school certificate of attendance'  , 24 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Home study diploma'  , 25 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Adult education diploma'  , 26 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'ARNG Challenge Program GED Certificate'  , 27 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Other Non-Traditional High School Credential'  , 28 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'High school diploma'  , 31 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Completed High School (No diploma)'  , 32 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Completed one semester of college, no high school diploma'  , 41 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'One year of college certificate of equivalency'  , 42 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( '1-2 years college, no degree'  , 43 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Associate degree'  , 44 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Professional nursing diploma'  , 45 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( '3-4 year college, no degree'  , 46 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Baccalaureate'  , 51 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( '1 or more years of graduate school, no degree'  , 52 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Master Degree'  , 61 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Post Master Degree'  , 62 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'First professional degree'  , 63 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Doctorate Degree'  , 64 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Post doctorate degree'  , 65 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO
INSERT INTO [AHOBPR].[STD_EDUCATION_LEVEL]  ([DESCRIPTION_TEXT],[CODE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES ( 'Unknown'  , 99 ,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate())
GO

/****** Object:  StoredProcedure [AHOBPR].[SP_DeleteRegistrantAndResponse]    Script Date: 2/8/2018 4:06:16 PM ******/
SET ANSI_NULLS OFF
GO

SET QUOTED_IDENTIFIER OFF
GO


-- =============================================
-- Author:		Bruce Clegg
-- Edited:      Leon Mansfield
-- Create date: 4/24/2015
-- Last Edit:   2/08/2018
-- Description:	Called after loading Response
-- =============================================
ALTER PROCEDURE [AHOBPR].[SP_DeleteRegistrantAndResponse]
 @registrantId INT = NULL 
AS
BEGIN

  DELETE 
    FROM  AHOBPR.FORM_RESPONSE_ANSWER
    WHERE FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FORM_RESPONSE_ANSWER_ID
          FROM AHOBPR.FORM_RESPONSE r
          JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
          JOIN AHOBPR.FORM_RESPONSE_ANSWER c ON a.FORM_RESPONSE_QUESTION_ID = c.FORM_RESPONSE_QUESTION_ID
          WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE 
    FROM  AHOBPR.FORM_RESPONSE_QUESTION
    WHERE FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FORM_RESPONSE_QUESTION_ID
          FROM AHOBPR.FORM_RESPONSE r
          JOIN AHOBPR.FORM_RESPONSE_QUESTION a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
          WHERE  r.REGISTRANT_ID = @registrantId
         );      
            
  DELETE 
    FROM  AHOBPR.FORM_RESPONSE_STATUS
    WHERE FORM_RESPONSE_STATUS_ID IN
         ( 
          SELECT a.FORM_RESPONSE_STATUS_ID
          FROM AHOBPR.FORM_RESPONSE r
          JOIN AHOBPR.FORM_RESPONSE_STATUS a ON r.FORM_RESPONSE_ID = a.FORM_RESPONSE_ID
          WHERE  r.REGISTRANT_ID = @registrantId
         );      

  DELETE 
    FROM  AHOBPR.FORM_RESPONSE   
    WHERE REGISTRANT_ID  = @registrantId;
 
   DELETE 
    FROM  AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER
    WHERE FOLLOWUP_FORM_RESPONSE_ANSWER_ID IN
         ( 
          SELECT c.FOLLOWUP_FORM_RESPONSE_ANSWER_ID
          FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
          JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
          JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_ANSWER c ON a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID = c.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
          WHERE  r.REGISTRANT_ID = @registrantId
         );
         
  DELETE 
    FROM AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION
    WHERE FOLLOWUP_FORM_RESPONSE_QUESTION_ID IN
         ( 
          SELECT a.FOLLOWUP_FORM_RESPONSE_QUESTION_ID
            FROM AHOBPR.FOLLOWUP_FORM_RESPONSE r
            JOIN AHOBPR.FOLLOWUP_FORM_RESPONSE_QUESTION a ON r.FOLLOWUP_FORM_RESPONSE_ID = a.FOLLOWUP_FORM_RESPONSE_ID
           WHERE  r.REGISTRANT_ID = @registrantId
         );      
            

  DELETE 
    FROM  AHOBPR.FOLLOWUP_FORM_RESPONSE   
    WHERE REGISTRANT_ID  = @registrantId;
 
 DELETE 
    FROM AHOBPR.REGISTRANT_SERVICE_SPECIFIC_OCCUPATION
    WHERE REGISTRANT_DEPLOYMENT_ID IN
    (
        SELECT a.REGISTRANT_DEPLOYMENT_ID
            FROM AHOBPR.REGISTRANT_DEPLOYMENT b
            JOIN AHOBPR.REGISTRANT_SERVICE_SPECIFIC_OCCUPATION a ON b.REGISTRANT_DEPLOYMENT_ID = a.REGISTRANT_DEPLOYMENT_ID
            WHERE b.REGISTRANT_ID = @registrantId 
    );
  DELETE 
    FROM AHOBPR.REGISTRANT_RETIREMENT
    WHERE REGISTRANT_ID  = @registrantId; 

  DELETE 
    FROM  AHOBPR.REGISTRANT_DEPLOYMENT   
    WHERE REGISTRANT_ID  = @registrantId;

  DELETE 
    FROM  AHOBPR.REGISTRANT_ADDRESS   
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_PHONE
    WHERE REGISTRANT_ID  = @registrantId;  
        
   DELETE 
    FROM  AHOBPR.REGISTRANT_EMAIL     
    WHERE REGISTRANT_ID  = @registrantId;  
        
      
  DELETE 
    FROM  AHOBPR.REGISTRANT_CONTACT_INFO
    WHERE REGISTRANT_ID  = @registrantId;  
     
  --DELETE 
  --  FROM AHOBPR.REGISTRANT_HEALTH_FACTOR
  --  WHERE REGISTRANT_VISIT_ID IN
  --                          (SELECT REGISTRANT_VISIT_ID
  --                              FROM AHOBPR.REGISTRANT_VISIT
  --                            WHERE REGISTRANT_ID = @registrantId
  --                          );  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_VISIT
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_RECORD_INFO
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_REGISTRY_FLAG
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.REGISTRANT_SERVICE_EPISODE
    WHERE REGISTRANT_ID  = @registrantId;  
    
  DELETE 
    FROM  AHOBPR.PROCESS_METRICS
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.EMAIL_LOG
    WHERE REGISTRANT_ID  = @registrantId;  
        
  DELETE 
    FROM  AHOBPR.QUEUE_STATUS
    WHERE REGISTRANT_ID  = @registrantId;              

  DELETE 
    FROM  AHOBPR.QUEUE
    WHERE REGISTRANT_ID  = @registrantId;      

  DELETE 
    FROM [AHOBPR].[PROCESS_METRICS] 
	  WHERE REGISTRANT_ID  = @registrantId;  

  DELETE 
    FROM [AHOBPR].[CPRS_LOG] 
		WHERE REGISTRANT_ID = @registrantId;

  DELETE 
    FROM AHOBPR.REGISTRANT_FACILITY
    WHERE REGISTRANT_ID  = @registrantId;    
	
  DELETE 
    FROM AHOBPR.REGISTRANT
    WHERE REGISTRANT_ID  = @registrantId;              
END;
-- EXECUTE [AHOBPR].[SP_DeleteRegistrantAndResponse]  140
GO
UPDATE [AHOBPR].[STD_DISCHARGE_CHARACTER] SET [DISCHARGE_CHARACTER] = 'Honorable (VA)'WHERE [DISCHARGE_CHARACTER_CODE] = 'j'
IF @@ROWCOUNT=0
    INSERT INTO  [AHOBPR].[STD_DISCHARGE_CHARACTER] ([DISCHARGE_CHARACTER_CODE],[DISCHARGE_CHARACTER],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED]) 
    VALUES ('J', 'honorable (VA)','AHOBPR DBA','AHOBPR DBA',getdate(),getdate());
GO
UPDATE [AHOBPR].[STD_DISCHARGE_CHARACTER] SET [DISCHARGE_CHARACTER] = 'Dishonorable (VA)' WHERE [DISCHARGE_CHARACTER_CODE] ='K'
IF @@ROWCOUNT=0
    INSERT INTO  [AHOBPR].[STD_DISCHARGE_CHARACTER] ([DISCHARGE_CHARACTER_CODE],[DISCHARGE_CHARACTER],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED]) 
    VALUES ('K', 'Dishonorable (VA)','AHOBPR DBA','AHOBPR DBA',getdate(),getdate());
GO
UPDATE [AHOBPR].[STD_DISCHARGE_CHARACTER] SET [DISCHARGE_CHARACTER] = 'Honorable' WHERE [DISCHARGE_CHARACTER_CODE] ='H'
IF @@ROWCOUNT=0
    INSERT INTO  [AHOBPR].[STD_DISCHARGE_CHARACTER] ([DISCHARGE_CHARACTER_CODE],[DISCHARGE_CHARACTER],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED]) 
    VALUES ('H', 'Honorable','AHOBPR DBA','AHOBPR DBA',getdate(),getdate());
GO
---------------------------------------------------------
PRINT 'Procedure SP_ReportAdHocByIndividual'
GO
---------------------------------------------------------
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters and remove NULLs from display where possible
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-03-30 - Bruce Clegg - Added VisnId value of NLA to find Null locations
-- 2015-04-27 - Bruce Clegg - Change to LocationType and Key, for both Assigned and Evaluated Locations
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce CLegg - Rewrote as Dynamic SQL for performance
-- 2016-02-03 - D. Barr - Fixed logic on Evaluation Location (Script 2.0.32.1)
-- 2016-02-07 - D. May - Addressed performance of specific question query (Script 2.0.32.2)
-- 2016-05-24 - D. Barr - Add Date Range Registrant at current status filter (Build 3.0.13)
-- 2016-06-23 - Sherry Wang - Add Closest Facility filter (Build 3.0.17)
-- =============================================
ALTER PROCEDURE [AHOBPR].[SP_ReportAdHocByIndividual]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       @dutyStatusAtFirstLogin char(1) = 'N', --Y or N.  If no, use current
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(100) = 'All', 
       @requestToBeSeen varchar(100) = 'All',
       @AssignedLocationType  VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @AssignedLocationKey   VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @EvaluatedLocationType VARCHAR(20) = NULL,  -- 'VISN', 'Base', 'Institution', 'NLA' = No Location Assigned
       @EvaluatedLocationKey  VARCHAR(50) = NULL,  -- 'V16', 'V01'    1000109,  1000089
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All',
	     @StatusFromDateText varchar(100) = NULL,
       @StatusToDateText varchar(100) = NULL,
	     @closestFacilityId  VARCHAR(50) = NULL,
       -- new filters for release 5.0       
       @DeploymentVerificationState varchar(100) = NULL, --registrant has at least one deployment with this verification state (deployment stage)
                                                        --from std_deployment_stage.deployment_stage, plus All Eligible 
                                                        --All Eligible includes New, Verified, Refuted, Accepted, but not Rejected
       @DeploymentEraIndicator varchar(50) = 'All', --'Pre 911' or 'Post 911' (anything else translates to All/No Filter)
       @email varchar(100) = 'All', --Yes or No (anything else translates to All/No Filter)
       @contactPreference varchar(100) = '',
       @stateAbbvs varchar(8000) = NULL -- One or more state two-char abbreviations, comma-separated values when not NULL 
                                        -- Special case: 'Foreign Country/Other'.  Do not include string quotes, they will be added programmatically.
AS

BEGIN

-- Convert date parameters from VARCHAR to DATETIME2(0)    
  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
		  @StatusFromDate DATETIME2(0) = NULL,
          @StatusToDate DATETIME2(0) = NULL;

  DECLARE @Query VARCHAR(8000);                
  DECLARE @MainQuery VARCHAR(8000);                
  DECLARE @RegCriteria VARCHAR(8000) = '';                
  DECLARE @AdminWith VARCHAR(8000);                
  DECLARE @SubPopWith VARCHAR(8000);                
  DECLARE @DeployWith VARCHAR(8000);                
  DECLARE @AnswerWith VARCHAR(8000) = '';             

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
	SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText)); 
  SET @StatusFromDate = dbo.CleanDate(@StatusFromDateText);
  SET @StatusToDate = dbo.AddMaxTime(dbo.CleanDate(@StatusToDateText)); 

	DECLARE @AdminType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'Administrative Flag');
	                           
	DECLARE @SubPopType INT = (SELECT STD_REGISTRY_FLAG_TYPE_ID
	                            FROM AHOBPR.STD_REGISTRY_FLAG_TYPE 
	                           WHERE REGISTRY_FLAG_TYPE = 'SubPopulation Flag');	                           
	                            	
-- Set InstitutionID values if needed.
DECLARE @AssignedInstitutionId INT = 0,
        @EvaluatedInstitutionId INT = 0,
		@ClosestInstitutionId INT = 0;


IF @AssignedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@AssignedLocationKey) = 1
  SET @AssignedInstitutionId = CONVERT(INT,@AssignedLocationKey);
  
IF @EvaluatedLocationType IN ('Base','Institution') 
AND ISNUMERIC(@EvaluatedLocationKey) = 1
  SET @EvaluatedInstitutionId = CONVERT(INT,@EvaluatedLocationKey);

IF ISNULL(@closestFacilityId, '') != ''
  SET @ClosestInstitutionId = CONVERT(INT,@closestFacilityId);
  
  --Concatenate one or more Sub-population flags for Registrants with flags
  SET @SubPopWith = '
WITH SubPop AS 
     ( 
      SELECT a.REGISTRANT_ID, 
             STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME 
                    FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b 
                    JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID 
                    WHERE a.REGISTRANT_ID = b.REGISTRANT_ID 
                       AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@SubPopType) + '
                   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] 
      FROM AHOBPR.REGISTRANT a 
      WHERE 1 = 1 ';
                                     
  --Concatenate one or more Admin flags for Registrants with flags
  SET @AdminWith = '
                    , Admin AS (  SELECT a.REGISTRANT_ID, ' +
                                 ' STUFF((SELECT '', '' + c.REGISTRY_FLAG_NAME ' +
                                         '  FROM AHOBPR.REGISTRANT_REGISTRY_FLAG b ' +
                                         '  JOIN AHOBPR.STD_REGISTRY_FLAG c ON b.STD_REGISTRY_FLAG_ID = c.STD_REGISTRY_FLAG_ID ' +
                                         ' WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                         '   AND c.STD_REGISTRY_FLAG_TYPE_ID = ' + CONVERT(VARCHAR(3),@AdminType) +
                                         '   AND b.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                           ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + '''' + 
                                         '   FOR XML PATH('''')), 1, 1, '''') AS [REGISTRY_FLAG_NAME] ' +
                               '  FROM AHOBPR.REGISTRANT a ' +
                              '  WHERE 1 = 1 ';

  --Concatenate one or more Deployment Countries for Registrants with Deployments
  SET @DeployWith = '
                    , Deploy AS (SELECT a.REGISTRANT_ID,  ' +
                                       ' STUFF((SELECT '', '' + b.DEPLOYMENT_COUNTRY ' + 
                                               '  FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' +
                                              '  WHERE a.REGISTRANT_ID = b.REGISTRANT_ID ' +
                                              '    FOR XML PATH('''')), 1, 1, '''') AS DEPLOYMENT_COUNTRY ' +
                                  ' FROM AHOBPR.REGISTRANT a ' +
                                '  WHERE 1 = 1 ';

  SET @MainQuery = '  SELECT DISTINCT a.REGISTRANT_ID ' +
                            ',(a.LAST_NAME + '', '' + a.FIRST_NAME) AS Name ' +
                            ',b.REGISTRANT_STATUS AS Status ' +
                            ',c.SERVICE_STATUS AS DutyStatus ' +
                            ',e.QUESTIONNAIRE_STARTED_DATE AS QuestionStartDate ' +
                            ',e.QUESTIONNAIRE_COMPLETED_DATE AS QuestionCompleteDate ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_STARTED_DATE, 101),'''') AS QuestionStartDateDisplay ' +
                            ',ISNULL(CONVERT(VARCHAR(10), e.QUESTIONNAIRE_COMPLETED_DATE, 101),'''') AS QuestionCompleteDateDisplay ';
--Decide which query to run depending on if a question was selected as a parameter for the report
  IF ISNULL(@questionNumber, '') = ''
    SET @MainQuery = @MainQuery + ','''' AS QuestionNumber ' +
                                  ','''' AS Answer '
  ELSE                                  
    SET @MainQuery = @MainQuery + ',''' + @questionNumber + ''' AS QuestionNumber ' +
                                  ',STUFF((SELECT '', '' + stdAnswer.TEXT ' +
                                          '  FROM AHOBPR.FORM_RESPONSE_ANSWER answer ' + 
                                          '  JOIN AHOBPR.STD_FORM_ANSWER stdAnswer ON answer.STD_FORM_ANSWER_ID = stdAnswer.STD_FORM_ANSWER_ID ' +
                                          ' WHERE formQuestion.FORM_RESPONSE_QUESTION_ID = answer.FORM_RESPONSE_QUESTION_ID ' +
                                          ' FOR XML PATH('''')), 1, 1, '''') AS Answer ' ;                  
    
  SET @MainQuery = @MainQuery + ',ISNULL(a.HEALTH_CONCERNS_RESPONSE,'''') AS HealthConcerns ' +
                                ',ISNULL(a.REQUEST_SEEN_RESPONSE,'''')  AS RequestBeSeen  ' +
                                ',RTRIM(LTRIM(ISNULL(SubPop.REGISTRY_FLAG_NAME,''''))) AS SubpopulationFlag  ' +
                                ',RTRIM(LTRIM(ISNULL(Admin.REGISTRY_FLAG_NAME,''''))) AS AdminFlag  ' +
                                ',ISNULL(Deploy.DEPLOYMENT_COUNTRY,'''') AS DeploymentCountry		 ' +
		                            ',a.BIRTH_DATE AS BirthDate  ' +
		                            ',CONVERT(VARCHAR(10), a.BIRTH_DATE, 101) AS BirthDateDisplay ' +
	                        'FROM AHOBPR.REGISTRANT a '
	                        
  SET @MainQuery = @MainQuery + ' JOIN AHOBPR.STD_REGISTRANT_STATUS b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID ' +
	                              ' JOIN AHOBPR.STD_SERVICE_STATUS c ON a.STD_SERVICE_STATUS_ID = c.STD_SERVICE_STATUS_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE d ON a.REGISTRANT_ID =  d.REGISTRANT_ID ' +
		                            ' LEFT JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID ' +
		                            ' LEFT JOIN SubPop  ON a.REGISTRANT_ID = SubPop.REGISTRANT_ID ' +
		                            ' LEFT JOIN Admin   ON a.REGISTRANT_ID = Admin.REGISTRANT_ID ' +
		                            ' LEFT JOIN Deploy  ON a.REGISTRANT_ID = Deploy.REGISTRANT_ID ';

  IF ISNULL(@questionNumber, '') != ''
    SET @MainQuery = @MainQuery + ' JOIN AHOBPR.FORM_RESPONSE_QUESTION formQuestion ON d.FORM_RESPONSE_ID = formQuestion.FORM_RESPONSE_ID ' +
                                  ' JOIN AHOBPR.STD_FORM_QUESTION stdQuestion ON formQuestion.STD_FORM_QUESTION_ID = stdQuestion.STD_FORM_QUESTION_ID ';

  SET @MainQuery = @MainQuery + ' WHERE 1 = 1 ';
  

  -- Question Number and Answer criteria are only used against Main Query		  
  IF ISNULL(@questionNumber, '') > ''
	  SET @MainQuery = @MainQuery + ' AND stdQuestion.FORM_QUESTION_UNIQUE_ID = ''' + @questionNumber + ''' ';
	  
  IF ISNULL(@answer,'') != '' 
  BEGIN    
      SET @AnswerWith = '
, selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
) ';
    SET @MainQuery = @MainQuery +  '
  AND EXISTS(select *
              from AHOBPR.FORM_RESPONSE_ANSWER a 
              join selectedAnswer on selectedAnswer.STD_FORM_ANSWER_ID = a.STD_FORM_ANSWER_ID
              where a.FORM_RESPONSE_QUESTION_ID = formQuestion.FORM_RESPONSE_QUESTION_ID
            )'; 
  END;                                                   

  IF @formStartFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
     
  IF @formStartToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
    
  IF @formCompletionFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';

  IF @formCompletionToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';

 IF @StatusFromDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.REGISTRANT_STATUS_LAST_UPDATED_DATE >= ''' + CONVERT(VARCHAR(20),@StatusFromDate,121) + '''';
     
  IF @StatusToDate IS NOT NULL                     
     SET @MainQuery = @MainQuery + ' AND a.REGISTRANT_STATUS_LAST_UPDATED_DATE  <= ''' + CONVERT(VARCHAR(20),@StatusToDate,121) + '''';

  IF ISNULL(@subpopulationFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                                              
  IF ISNULL(@deploymentAll,'') != '' 
    SET @MainQuery = @MainQuery + 'AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                                  ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                                      AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;
                                                    
  IF ISNULL(@healthFactor,'') != ''
    SET @MainQuery = @MainQuery + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

 
  IF ISNULL(@deploymentExposure,'') != '' 
    SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID like ''1.2%'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
  IF (@evaluation = 'Yes') 
		 SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;     

  IF (@email = 'Yes') 
		SET @MainQuery = @MainQuery + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                      ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                        ' AND em.EMAIL != '''') '
  ELSE IF (@email = 'No')   
        SET @MainQuery = @MainQuery + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                      ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                        ' AND em.EMAIL != '''') ' ;
                         
  IF @DeploymentVerificationState = 'All Eligible'
    SET @MainQuery = @MainQuery +' AND EXISTS ( SELECT * ' + 
                                              ' FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' + 
                                              ' JOIN [AHOBPR].[STD_DEPLOYMENT_STAGE] ds ' +
                                              '   ON ds.[STD_DEPLOYMENT_STAGE_ID] = b.[STD_DEPLOYMENT_STAGE_ID] ' +
                                              ' WHERE b.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                              '   AND ds.[DEPLOYMENT_STAGE] IN (''New'', ''Verified'', ''Refuted'', ''Accepted''))';   
                                               
  ELSE IF @DeploymentVerificationState IS NOT NULL
    SET @MainQuery = @MainQuery +' AND EXISTS ( SELECT * ' + 
                                              ' FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' + 
                                              ' JOIN [AHOBPR].[STD_DEPLOYMENT_STAGE] ds ' +
                                              '   ON ds.[STD_DEPLOYMENT_STAGE_ID] = b.[STD_DEPLOYMENT_STAGE_ID] ' +
                                              ' WHERE b.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                              '   AND ds.[DEPLOYMENT_STAGE] = ''' + @DeploymentVerificationState + ''')';

  IF ISNULL(@stateAbbvs,'') > ''
  BEGIN
    SET @stateAbbvs = REPLACE(@stateAbbvs,',',''',''');
    SET @MainQuery = @MainQuery +' AND EXISTS ( SELECT * ' + 
                                              ' FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                              ' WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                                ' AND addr.STATE  IN ( ''' + @stateAbbvs + ''') ) ';
 END            
 
  IF ISNULL(@contactPreference,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';                                         
   
  IF (@DeploymentEraIndicator = 'Pre 911') 
		SET @RegCriteria = @RegCriteria + ' AND isnull([PRE_911_DEPLOYMENT],''*'') = ''Y''';
  ELSE IF (@DeploymentEraIndicator =  'Post 911')   
    SET @RegCriteria = @RegCriteria + ' AND isnull([POST_911_DEPLOYMENT],''*'') = ''Y'''; 

 -- The rest of the criteria will be applied to Main Query and With statememts 
  IF @status IS NOT NULL
    SET @RegCriteria = @RegCriteria + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > '' AND @dutyStatusAtFirstLogin = 'N'
    SET @RegCriteria = @RegCriteria + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
  ELSE IF ISNULL(@dutyStatus,'') > '' AND @dutyStatusAtFirstLogin = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.[STD_SERVICE_STATUS_ID_WHEN_ENROLLED] IN (' + @dutyStatus + ')';
          
  IF @healthConcerns != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @RegCriteria = @RegCriteria + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';
                                                                    
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @RegCriteria = @RegCriteria + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @RegCriteria = @RegCriteria + ' AND ''' + @separationType + ' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @RegCriteria = @RegCriteria + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
    
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @RegCriteria = @RegCriteria + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  IF @AssignedLocationType IS NOT NULL
    BEGIN
      IF @AssignedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID IS NULL ' ;
      ELSE
      IF @AssignedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                             ' WHERE inst.ID = a.STD_INSTITUTION_ID ' + 
                                                             '   AND inst.VisnID = ''' + @AssignedLocationKey + ''') ';
      ELSE
      IF @AssignedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_FACILITY_LOOKUP inst ' +
                                                      ' WHERE inst.ID = a.STD_INSTITUTION_ID ' +
                                                      '   AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId) + ') '
      ELSE
      IF @AssignedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria + ' AND a.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@AssignedInstitutionId);
   END;
  
  -- Closest Facility
  IF @ClosestInstitutionId > 0
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.VIEW_REGISTRANT_CLOSEST_FACILITY closest ' +
                                                      ' WHERE closest.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20), @ClosestInstitutionId) +
                                                      '   AND closest.REGISTRANT_ID = a.REGISTRANT_ID) ';	 
  IF @EvaluatedLocationType IS NOT NULL
    BEGIN
      IF @EvaluatedLocationType = 'NLA' 
        SET @RegCriteria = @RegCriteria + ' AND NOT EXISTS( SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                           ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                           '   AND eval.EVALUATION_FLAG = ''Y'') ' ; 
      ELSE
      IF @EvaluatedLocationType = 'VISN' 
        SET @RegCriteria = @RegCriteria + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.VisnID = ''' + @EvaluatedLocationKey + ''') '; 
      ELSE
      IF @EvaluatedLocationType = 'Base' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND inst.BASE_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId) + ') ';
      ELSE
      IF @EvaluatedLocationType = 'Institution' 
        SET @RegCriteria = @RegCriteria +  ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT eval ' +
                                                       ' JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = eval.STD_INSTITUTION_ID ' +
                                                      ' WHERE eval.REGISTRANT_ID = a.REGISTRANT_ID ' +
                                                        ' AND eval.EVALUATION_FLAG = ''Y'' ' +
                                                        ' AND eval.STD_INSTITUTION_ID = ' + CONVERT(VARCHAR(20),@EvaluatedInstitutionId)  + ') '; 
    END;
    
-- Add criteria and Close With Statement
  SET @DeployWith = @DeployWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @SubPopWith = @SubPopWith + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 
  SET @AdminWith =  @AdminWith  + @RegCriteria + ' GROUP BY a.REGISTRANT_ID ) ' 

  SET @Query =  @SubPopWith +  @AdminWith + @DeployWith + @AnswerWith +  @MainQuery + @RegCriteria;            

  PRINT  @Query;
  
 EXECUTE (@Query);  
END;



-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '6,7'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @healthConcerns = 'Yes'     , 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @requestToBeSeen = 'Yes
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentAll = 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @questionNumber = '5.4.A'  , @answer = '2221'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'VISN', @AssignedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Base', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @AssignedLocationType = 'Institution', @AssignedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual]  @ethnicity = 'JEWISH'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'NLA'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'VISN', @EvaluatedLocationKey = 'V16'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Base', @EvaluatedLocationKey = '1000089'
-- exec [AHOBPR].[SP_ReportAdHocByIndividual] @EvaluatedLocationType = 'Institution', @EvaluatedLocationKey = '1000089'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @status = '5',   @StatusFromDateText  = '20160501'
--EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual]  @status = '7', @questionNumber = '1.3.A'  , @answer = '39'; --4:08 atfer index
--EXECUTE [AHOBPR].[SP_ReportAdHocByIndividual] @closestFacilityId = '1000088'

GO

---------------------------------------------------------------------------------------------------------
print 'Procedure [AHOBPR].[SP_ReportAdHocByLocation]'
GO
---------------------------------------------------------------------------------------------------------
-- =============================================
-- Author:		Deborah Barr
-- Create date: November 12, 2014
-- Description:	Used for the AHOBPR Ad Hoc Report  

-- Modification log
-- 2014-12-31 - Changed from FLAG to RESPONSE for Health Concerns and REQUEST_SEEN, Reformatted statements for readability
-- 2015-01-05 - Change Date Format to MM/DD/YYYY
-- 2015-01-14 - Sherry Wang Add more parameters: @healthFactor, @formStartFromDate, @formStartToDate, @subpopulationFlag
-- 2015-01-14 - Sherry Wang Add more parameters: @adminFlag, @deploymentAll, @deploymentExposure, @adminFlagFromDate, @adminFlagToDate
-- 2015-01-16 - Bruce Clegg - Fix parameters, Add distinct and outer query to group counts.
-- 2015-02-09 - Bruce Clegg - Change Health Factor Exists statements to use new REGISTRANT_VISIT
-- 2015-05-07 - Bruce Clegg - Change Facility name from "Other" to "No Facitilty Assigned" when not found
-- 2015-06-04 - Bruce Clegg - Add more parameters
-- 2015-06-18 - Bruce Clegg - Changed @separationType to an Integer 
-- 2015-07-09 - Bruce Clegg - Rewrote as Dynamic SQL for performance
-- 2015-08-05 - Bruce Clegg - Fix bug with AdminFlag - Set From and To date defaults
-- 2015-12-11 - D Barr      - added evaluation parameter
-- Deborah Barr - Script 2.0.16.1
-- 2016-02-08    D May - Performance Improvement when answer is specified. Script 2.0.32.2
-- 2016-05-26 - D, Barr - Add Date Range Registrant at current status filter (Build 3.0.13)
-- =============================================
ALTER PROCEDURE [AHOBPR].[SP_ReportAdHocByLocation]
       @status varchar(100) = NULL, -- Multiple statues, comma-separated values when not NULL
       @dutyStatus varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL  
       -- new filter for release 5.0        
       @dutyStatusAtFirstLogin char(1) = 'N', --Y or N.  If no, use current
       @formStartFromDateText varchar(100) = NULL,
       @formStartToDateText varchar(100) = NULL,
       @healthFactor varchar(100) = NULL, -- Multiple health factor IDs, comma-separated values when not NULL
       @formCompletionFromDateText varchar(100) = NULL,
       @formCompletionToDateText varchar(100) = NULL,
       @questionNumber varchar(100) = NULL,
       @answer varchar(100) = NULL,
       @healthConcerns varchar(10) = 'All', 
       @requestToBeSeen varchar(10) = 'All',
       @groupBy VARCHAR(50) = '',                 -- 'VISN' or 'Facility'   
       @subpopulationFlag varchar (10) = NULL, 
       @adminFlag varchar (10) = NULL, 
       @deploymentAll varchar (256) = NULL, 
       @deploymentExposure varchar (256) = NULL, 
       @adminFlagFromDateText varchar (20) = NULL, 
       @adminFlagToDateText varchar (20) = NULL,
       @excludeDead varchar(1) = 'N',
       @gender varchar(50) = '',
       @race varchar(50) = '',
       @ethnicity varchar(50) = '',
       @separationType INT = 0,
       @separationFromDateText varchar (20) = NULL, 
       @separationToDateText varchar (20) = NULL, 
       @enrollmentStatus varchar(50) = '',
       @evaluation varchar(100) = 'All',
	   @StatusFromDateText varchar(100) = NULL,
       @StatusToDateText varchar(100) = NULL,
       -- new filters for release 5.0       
       @DeploymentVerificationState varchar(100) = NULL, --registrant has at least one deployment with this verification state (deployment stage)
                                                        --from std_deployment_stage.deployment_stage, plus All Eligible 
                                                        --All Eligible includes New, Verified, Refuted, Accepted, but not Rejected
       @DeploymentEraIndicator varchar(50) = 'All', --'Pre 911' or 'Post 911' (anything else translates to All/No Filter)
       @email varchar(100) = 'All', --Yes or No (anything else translates to All/No Filter)
       @contactPreference varchar(100) = '',
       @stateAbbvs varchar(8000) = NULL -- One or more state two-char abbreviations, comma-separated values when not NULL 
                                        -- Special case: 'Foreign Country/Other'.  Do not include string quotes, they will be added programmatically.
AS

BEGIN

  DECLARE @formStartFromDate DATETIME2(0) = NULL,
          @formStartToDate DATETIME2(0) = NULL,
          @formCompletionFromDate DATETIME2(0) = NULL,
          @formCompletionToDate DATETIME2(0) = NULL,
          @adminFlagFromDate DATETIME2(0) = NULL,
          @adminFlagToDate DATETIME2(0) = NULL,
          @separationFromDate DATETIME2(0) = NULL,
          @separationToDate DATETIME2(0) = NULL,
		  @StatusFromDate DATETIME2(0) = NULL,
          @StatusToDate DATETIME2(0) = NULL;
          
  DECLARE @Query VARCHAR(8000);         
  DECLARE @AnswerWith VARCHAR(8000) = '';

  -- Convert date parameters      

  SET @formStartFromDate = dbo.CleanDate(@formStartFromDateText);
  SET @formStartToDate = dbo.AddMaxTime(dbo.CleanDate(@formStartToDateText));
  SET @formCompletionFromDate = dbo.CleanDate(@formCompletionFromDateText);
  SET @formCompletionToDate = dbo.AddMaxTime(dbo.CleanDate(@formCompletionToDateText));     
  SET @adminFlagFromDate = ISNULL(dbo.CleanDate(@adminFlagFromDateText),'19000101');
  SET @adminFlagToDate = dbo.AddMaxTime(ISNULL(dbo.CleanDate(@adminFlagToDateText),GETDATE())); 
  SET @separationFromDate = dbo.CleanDate(@separationFromDateText);
  SET @separationToDate = dbo.AddMaxTime(dbo.CleanDate(@separationToDateText));
  SET @StatusFromDate = dbo.CleanDate(@StatusFromDateText);
  SET @StatusToDate = dbo.AddMaxTime(dbo.CleanDate(@StatusToDateText));   

  -- Build Src TDE
  SET @Query = 'WITH ';

  IF ISNULL(@answer,'') != ''
    SET @Query = @Query + '
selectedAnswerInstance as
(
  select BRP_FORM_ANSWER_ID, A.STD_FORM_QUESTION_ID, Q.FORM_QUESTION_UNIQUE_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on Q.STD_FORM_QUESTION_ID = A.STD_FORM_QUESTION_ID
  where a.STD_FORM_ANSWER_ID IN (' + @answer + ')--user specified answer
)
, selectedAnswer as
(
  select STD_FORM_ANSWER_ID
  from AHOBPR.STD_FORM_ANSWER A 
  join AHOBPR.STD_FORM_QUESTION Q on A.STD_FORM_QUESTION_ID = Q.STD_FORM_QUESTION_ID
  where EXISTS (select * from selectedAnswerInstance --1:39 w/o brp_form_answer_id index 0:37 with
                where A.BRP_FORM_ANSWER_ID      = selectedAnswerInstance.BRP_FORM_ANSWER_ID
                  and Q.FORM_QUESTION_UNIQUE_ID = selectedAnswerInstance.FORM_QUESTION_UNIQUE_ID
                )
), ';

 SET @Query = @Query + '
 Src 
    AS( SELECT a.REGISTRANT_ID, a.STD_INSTITUTION_ID 
        FROM AHOBPR.REGISTRANT a 
        WHERE 1 = 1 
';
                                   
  IF @status IS NOT NULL
    SET @Query = @Query + ' AND a.STD_REGISTRANT_STATUS_ID IN (' + @status + ')';

  IF ISNULL(@dutyStatus,'') > '' AND @dutyStatusAtFirstLogin = 'N'
    SET @Query = @Query + ' AND a.STD_SERVICE_STATUS_ID IN (' + @dutyStatus + ')';
  ELSE IF ISNULL(@dutyStatus,'') > '' AND @dutyStatusAtFirstLogin = 'Y'
    SET @Query = @Query + ' AND a.[STD_SERVICE_STATUS_ID_WHEN_ENROLLED] IN (' + @dutyStatus + ')';
               
  IF @healthConcerns != 'All'
    SET @Query = @Query + ' AND a.HEALTH_CONCERNS_RESPONSE = ''' + @healthConcerns + ''''; 
  
  IF @requestToBeSeen != 'All'
    SET @Query = @Query + ' AND a.REQUEST_SEEN_RESPONSE = ''' + @requestToBeSeen  + '''';

IF @StatusFromDate IS NOT NULL                     
     SET @Query = @Query + ' AND a.REGISTRANT_STATUS_LAST_UPDATED_DATE >= ''' + CONVERT(VARCHAR(20),@StatusFromDate,121) + '''';
     
  IF @StatusToDate IS NOT NULL                     
     SET @Query = @Query + ' AND a.REGISTRANT_STATUS_LAST_UPDATED_DATE  <= ''' + CONVERT(VARCHAR(20),@StatusToDate,121) + '''';
	     
  IF @formStartFromDate IS NOT NULL OR @formStartToDate IS NOT NULL 
    OR @formCompletionFromDate IS NOT NULL OR @formCompletionToDate IS NOT NULL
  BEGIN
    SET @Query = @Query + '
AND EXISTS( SELECT d.REGISTRANT_ID 
            FROM AHOBPR.FORM_RESPONSE d 
		        JOIN AHOBPR.FORM_RESPONSE_STATUS e ON d.FORM_RESPONSE_ID = e.FORM_RESPONSE_ID	
		        WHERE a.REGISTRANT_ID = d.REGISTRANT_ID ';
		IF @formStartFromDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE >= ''' + CONVERT(VARCHAR(20),@formStartFromDate,121) + '''';
		IF @formStartToDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_STARTED_DATE <= ''' + CONVERT(VARCHAR(20),@formStartToDate,121) + '''';
		IF @formCompletionFromDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE >= ''' + CONVERT(VARCHAR(20),@formCompletionFromDate,121) + '''';
		IF @formCompletionToDate IS NOT NULL                     
		    SET @Query = @Query + ' AND e.QUESTIONNAIRE_COMPLETED_DATE <= ''' + CONVERT(VARCHAR(20),@formCompletionToDate,121) + '''';
		SET @Query = @Query + ' ) ' -- Close Exists statement
  END    
    
  IF ISNULL(@answer,'') != '' 
  BEGIN
    SET @Query = @Query +  '
and exists( select *
            from AHOBPR.FORM_RESPONSE_ANSWER fra 
            join AHOBPR.FORM_RESPONSE_QUESTION frq  on frq.FORM_RESPONSE_QUESTION_ID = fra.FORM_RESPONSE_QUESTION_id
            join AHOBPR.FORM_RESPONSE fr           on fr.FORM_RESPONSE_ID = frq.FORM_RESPONSE_ID
            join selectedAnswer                   on selectedAnswer.STD_FORM_ANSWER_ID = fra.STD_FORM_ANSWER_ID
            where a.REGISTRANT_ID = fr.REGISTRANT_ID
          )'; 
                 
--  SET @Query = @Query + '
--AND EXISTS(SELECT fr.REGISTRANT_ID FROM AHOBPR.FORM_RESPONSE_ANSWER ra ' + 
--                        'JOIN AHOBPR.FORM_RESPONSE_QUESTION rq ON rq.FORM_RESPONSE_QUESTION_ID = ra.FORM_RESPONSE_QUESTION_ID  ' + 
--                        'JOIN AHOBPR.FORM_RESPONSE fr ON fr.FORM_RESPONSE_ID = rq.FORM_RESPONSE_ID  ' + 
--                        'JOIN AHOBPR.STD_FORM_ANSWER A1 ON A1.STD_FORM_ANSWER_ID = ra.STD_FORM_ANSWER_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_QUESTION Q1 ON Q1.STD_FORM_QUESTION_ID = rq.STD_FORM_QUESTION_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_QUESTION Q2 ON Q2.FORM_QUESTION_UNIQUE_ID = Q1.FORM_QUESTION_UNIQUE_ID ' + 
--                        'JOIN AHOBPR.STD_FORM_ANSWER A2 ON A2.STD_FORM_QUESTION_ID = Q2.STD_FORM_QUESTION_ID ' + 
--                        ' AND A1.BRP_FORM_ANSWER_ID = A2.BRP_FORM_ANSWER_ID ' + 
--                      ' WHERE A2.STD_FORM_ANSWER_ID IN (' + @answer + ') AND fr.REGISTRANT_ID = a.REGISTRANT_ID )';                         
  END;                       
  
  IF ISNULL(@subpopulationFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG subpop ' +
                                      ' WHERE subpop.STD_REGISTRY_FLAG_ID IN (' + @subpopulationFlag + ') ' +
                                        ' AND subpop.REGISTRANT_ID = a.REGISTRANT_ID ) ';

	IF ISNULL(@adminFlag,'') != ''
    SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_REGISTRY_FLAG adminflag ' +
                        ' WHERE adminflag.STD_REGISTRY_FLAG_ID IN (' + @adminFlag + ') ' +
                          ' AND adminflag.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND adminflag.CREATED BETWEEN ''' + CONVERT(VARCHAR(20),@adminFlagFromDate,121) + 
                                                  ''' AND ''' + CONVERT(VARCHAR(20),@adminFlagToDate,121) + ''' ) ';  
                            
  IF ISNULL(@healthFactor,'') != ''
    SET @Query = @Query + ' AND EXISTS (SELECT re.REGISTRANT_ID FROM AHOBPR.REGISTRANT_VISIT re ' +
                                        ' JOIN AHOBPR.REGISTRANT_HEALTH_FACTOR hf ON re.REGISTRANT_VISIT_ID = hf.REGISTRANT_VISIT_ID ' +
                                       ' WHERE a.REGISTRANT_ID = re.REGISTRANT_ID AND re.EVALUATION_FLAG = ''Y'' ' +
                                       '   AND hf.STD_HEALTH_FACTOR_ID IN (' + @healthFactor + ') ) '

  IF ISNULL(@deploymentAll,'') != '' 
    SET @Query = @Query + ' AND EXISTS (SELECT depl.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT depl ' +
                                       ' WHERE a.REGISTRANT_ID = depl.REGISTRANT_ID
                                           AND depl.DEPLOYMENT_COUNTRY = ''' + @deploymentAll + ''') ' ;

  IF ISNULL(@deploymentExposure,'') != '' 
    SET @Query = @Query + ' AND EXISTS(SELECT deploymentExposure.REGISTRANT_ID FROM AHOBPR.REGISTRANT_DEPLOYMENT deploymentExposure ' +
                                        '  JOIN AHOBPR.FORM_RESPONSE_QUESTION exposure ON deploymentExposure.REGISTRANT_DEPLOYMENT_ID = exposure.REGISTRANT_DEPLOYMENT_ID ' +
                                        '  JOIN AHOBPR.STD_FORM_QUESTION quest ON exposure.STD_FORM_QUESTION_ID = quest.STD_FORM_QUESTION_ID ' +
                                        ' WHERE quest.FORM_QUESTION_UNIQUE_ID = ''1.2.A'' ' +
                                        '   AND deploymentExposure.DEPLOYMENT_COUNTRY = ''' + @deploymentExposure + '''' + 
                                        '   AND deploymentExposure.REGISTRANT_ID = a.REGISTRANT_ID ) ';
                                        
IF (@evaluation = 'Yes') 
		 SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') '
   ELSE IF (@evaluation = 'No')   
         SET @Query = @Query + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_VISIT ev ' +
                        ' WHERE ev.REGISTRANT_ID = a.REGISTRANT_ID ' +
                          ' AND ev.EVALUATION_FLAG = ''Y'') ' ;                                    
                                      
  IF ISNULL(@excludeDead,'N') = 'Y'
    SET @Query = @Query + ' AND a.DECEASED_FLAG = 0 ';
  
  IF ISNULL(@gender,'') != ''
    SET @Query = @Query + ' AND ''' + @gender + ''' = ISNULL(a.GENDER,''No Data Available'') ';
    
  IF ISNULL(@ethnicity,'') != ''
    SET @Query = @Query + ' AND ''' + @ethnicity + ''' = ISNULL(a.ETHNICITY,''No Data Available'') ';
  
  IF ISNULL(@separationType,0) != 0
    SET @Query = @Query + ' AND ''' + @separationType + ''' = ISNULL(a.STD_SEPARATION_REASON_ID_CURRENT,0) ';

  IF @separationFromDate IS NOT NULL 
    SET @Query = @Query + ' AND a.SEPARATION_DATE_CURRENT >= ''' + CONVERT(VARCHAR(20),@separationFromDate,121) + '''';
  
  IF @separationToDate IS NOT NULL 
    SET @Query = @Query + ' AND  a.SEPARATION_DATE_CURRENT <= ''' + CONVERT(VARCHAR(20),@separationToDate,121) + '''';
  
  IF ISNULL(@race,'') != ''
    SET @Query = @Query + ' AND ''' + @race + ''' =  ISNULL(a.RACE ,''No Data Available'') ';
-----    

  IF (@email = 'Yes') 
		SET @Query = @Query + ' AND EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                      ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                        ' AND em.EMAIL != '''') '
  ELSE IF (@email = 'No')   
        SET @Query = @Query + ' AND NOT EXISTS(SELECT * FROM AHOBPR.REGISTRANT_EMAIL em ' +
                      ' WHERE em.REGISTRANT_ID = a.REGISTRANT_ID ' +
                        ' AND em.EMAIL != '''') ' ;
                                              
  IF @DeploymentVerificationState = 'All Eligible'
    SET @Query = @Query +' AND EXISTS ( SELECT * ' + 
                                              ' FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' + 
                                              ' JOIN [AHOBPR].[STD_DEPLOYMENT_STAGE] ds ' +
                                              '   ON ds.[STD_DEPLOYMENT_STAGE_ID] = b.[STD_DEPLOYMENT_STAGE_ID] ' +
                                              ' WHERE b.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                              '   AND ds.[DEPLOYMENT_STAGE] IN (''New'', ''Verified'', ''Refuted'', ''Accepted''))';   
                                               
  ELSE IF @DeploymentVerificationState IS NOT NULL
    SET @Query = @Query +' AND EXISTS ( SELECT * ' + 
                                              ' FROM AHOBPR.REGISTRANT_DEPLOYMENT b ' + 
                                              ' JOIN [AHOBPR].[STD_DEPLOYMENT_STAGE] ds ' +
                                              '   ON ds.[STD_DEPLOYMENT_STAGE_ID] = b.[STD_DEPLOYMENT_STAGE_ID] ' +
                                              ' WHERE b.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                              '   AND ds.[DEPLOYMENT_STAGE] = ''' + @DeploymentVerificationState + ''')';

  IF ISNULL(@stateAbbvs,'') > ''
  BEGIN
    SET @stateAbbvs = REPLACE(@stateAbbvs,',',''',''');
    SET @Query = @Query +' AND EXISTS ( SELECT * ' + 
                                              ' FROM AHOBPR.REGISTRANT_ADDRESS addr ' + 
                                              ' WHERE addr.REGISTRANT_ID = a.REGISTRANT_ID ' + 
                                                ' AND addr.STATE  IN ( ''' + @stateAbbvs + ''') ) ';
 END            
 
  IF ISNULL(@contactPreference,'') != ''
    SET @Query = @Query + ' AND ''' + @contactPreference + ''' = ISNULL(a.CONTACT_PREFERENCE,''No Data Available'') ';                                         
   
  IF (@DeploymentEraIndicator = 'Pre 911') 
		SET @Query = @Query + ' AND isnull([PRE_911_DEPLOYMENT],''*'') = ''Y''';
  ELSE IF (@DeploymentEraIndicator =  'Post 911')   
    SET @Query = @Query + ' AND isnull([POST_911_DEPLOYMENT],''*'') = ''Y'''; 
------
  IF ISNULL(@enrollmentStatus,'') != ''
    SET @Query = @Query + ' AND ''' + @enrollmentStatus + ''' = ISNULL(a.ENROLLMENT_STATUS,''No Data Available'') ';

  -- Add Summary TDE                   
  SET @Query = @Query + '  )	,Summary  AS( ' + 
                        ' SELECT Src.STD_INSTITUTION_ID, COUNT(*) AS TotalRegistrants FROM Src ' +
                        ' GROUP BY STD_INSTITUTION_ID ) ';
-- By Facility 
	IF @groupBy = 'Facility'
	BEGIN  SET @Query = @Query + ' 
SELECT  inst.Name AS Location, 
        ISNULL(CONVERT(VARCHAR(10),Summary.STD_INSTITUTION_ID),''-1'') AS LocationId, 
        SUM(TotalRegistrants) AS TotalRegistrants 
FROM      Summary
JOIN      AHOBPR.VIEW_INSTITUTION_NAME inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1) 
GROUP BY  inst.Name,STD_INSTITUTION_ID 
OPTION    (OPTIMIZE FOR UNKNOWN);';
  END
  ELSE -- By VISN
  BEGIN
	  IF @groupBy = 'VISN'
	     SET @Query = @Query + '
,VisnSummary AS 
 ( 
  SELECT ISNULL(inst.VisnID,''NLA'') AS Location, 
        ISNULL(inst.VisnID, ''-1'') AS LocationId, 
        SUM(TotalRegistrants) AS TotalRegistrants        
   FROM Summary 
   LEFT JOIN AHOBPR.VIEW_FACILITY_LOOKUP inst ON inst.ID = ISNULL(Summary.STD_INSTITUTION_ID,-1)  
   GROUP BY inst.VisnID  
 ) --close the WITH
 SELECT REPLACE(Location,''NLA'',''No Facitilty Assigned'') AS Location,
        CONVERT(VARCHAR(10),LocationId) AS LocationId, TotalRegistrants 
   FROM VisnSummary  
  ORDER BY Location 
  OPTION (OPTIMIZE FOR UNKNOWN); ' ;
	END;

  PRINT @Query;		
  		                     
  EXECUTE (@Query);  		                     		
END
-- Parameters
  --@status, @dutyStatus ,@questionnaireStartDate, @questionnaireCompleteDate, 
  --@questionNumber, @answer, @healthConcerns= 'All', @requestToBeSeen = 'All',
  --@registryFlag,@InstitutionId = 0, @VisnId = '' 
-- Test Cases
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @evaluation = 'No'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @dutyStatus = '1,2'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formStartToDateText = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthFactor = '44,45,46,47' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionFromDateText  = '20010101'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @formCompletionToDateText  = '20141231'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @healthConcerns = 'Yes' 
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @requestToBeSeen = 'Yes'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @subpopulationFlag = '64,65,66,67'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentAll = 'Iraq'    -- 'Egypt'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @deploymentExposure  = 'Iraq'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @adminFlag = '59,60' ,@adminFlagFromDateText = '20150101' , @adminFlagToDateText = '20150201'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy = 'VISN',  @answer = '39'
-- EXECUTE [AHOBPR].[SP_ReportAdHocByLocation] @groupBy =  'Facility' , @status = '6,7' ,@answer = '2346,1571,17'   -- '20,795,1570' 
GO
---------------------------------------------------------
PRINT 'Alter table [AHOBPR].[REGISTRANT_H]'
GO
---------------------------------------------------------
ALTER
  TABLE [AHOBPR].[REGISTRANT_H]
  ADD   [PRE_911_DEPLOYMENT] varchar(3) null,
        [POST_911_DEPLOYMENT] varchar(3) null;
 GO
Print 'Done'

---------------------------------------------------------
PRINT 'Procedure [AHOBPR].[SP_ReportMilitaryStatus]'
GO
---------------------------------------------------------

IF EXISTS (SELECT * FROM sys.objects WHERE type = 'P' AND name = 'SP_ReportMilitaryStatus')
	DROP PROCEDURE  [AHOBPR].[SP_ReportMilitaryStatus]
GO

-- =============================================
-- Author:		Padmashri Valaparla
-- Create date: 1/26/2017
-- Description:	Used for Military Status Report
-- =============================================

CREATE PROCEDURE [AHOBPR].[SP_ReportMilitaryStatus]
	@dutyStatusAtFirstLogin char(1) = 'N' --Y or N.  If no, use current
AS
BEGIN
	DECLARE @Query VARCHAR(8000);
	DECLARE @dutyAtFirstLoginVariable VARCHAR(50) = 'b.STD_SERVICE_STATUS_ID';

IF @dutyStatusAtFirstLogin <> '' and @dutyStatusAtFirstLogin = 'N'
	SET @dutyAtFirstLoginVariable = 'b.STD_SERVICE_STATUS_ID';
ELSE
	SET @dutyAtFirstLoginVariable = 'b.STD_SERVICE_STATUS_ID_WHEN_ENROLLED';

	SET @Query = ' SELECT case(s.STD_SERVICE_STATUS_ID) WHEN 3 THEN s.SERVICE_STATUS WHEN 5 THEN s.SERVICE_STATUS  WHEN 2 THEN s.SERVICE_STATUS
		  WHEN 1 THEN s.SERVICE_STATUS WHEN 4 THEN s.SERVICE_STATUS ELSE ''Deceased'' END AS ''Duty Status''
		  ,IsNull(A.CountOfStatus,0) AS Participant, IsNull(B.CountOfStatus,0) AS ''Eligible/Reviewed-Eligible''
		  ,IsNull(C.CountOfStatus,0) AS ''Not Eligible/Reviewed-Not Eligible'',IsNull(D.CountOfStatus,0) AS ''Review''
		  ,IsNull(E.CountOfStatus,0) AS ''No Consent'', IsNull(F.Total,0) as Total
	  FROM [AHOBPR].[STD_SERVICE_STATUS] s 
	  LEFT JOIN (
					SELECT a.REGISTRANT_STATUS,c.SERVICE_STATUS,COUNT(a.REGISTRANT_STATUS) AS CountOfStatus 
					FROM [AHOBPR].[STD_REGISTRANT_STATUS] a 
						LEFT JOIN [AHOBPR].[REGISTRANT] b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID 
						LEFT JOIN [AHOBPR].[STD_SERVICE_STATUS] c ON c.STD_SERVICE_STATUS_ID = ' + @dutyAtFirstLoginVariable + '
					GROUP BY c.SERVICE_STATUS,a.REGISTRANT_STATUS
					HAVING a.REGISTRANT_STATUS = ''Participant'' 
				) A 
				on A.Service_Status = s.SERVICE_STATUS
		LEFT JOIN (
					SELECT ReviewedEligible.SERVICE_STATUS, SUM(CountOfStatus) AS CountOfStatus from
					(
						SELECT a.REGISTRANT_STATUS,c.SERVICE_STATUS,COUNT(a.REGISTRANT_STATUS) AS CountOfStatus 
						FROM [AHOBPR].[STD_REGISTRANT_STATUS] a 
							LEFT JOIN [AHOBPR].[REGISTRANT] b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID 
							LEFT JOIN [AHOBPR].[STD_SERVICE_STATUS] c ON c.STD_SERVICE_STATUS_ID = ' + @dutyAtFirstLoginVariable + '
						GROUP BY c.STD_SERVICE_STATUS_ID,c.SERVICE_STATUS,a.REGISTRANT_STATUS
						HAVING a.REGISTRANT_STATUS in (''Reviewed - Eligible'', ''Eligible'')
					) ReviewedEligible
					GROUP BY ReviewedEligible.SERVICE_STATUS
				) B 
				ON B.Service_Status = s.SERVICE_STATUS
		LEFT JOIN (
					SELECT ReviewedNotEligible.SERVICE_STATUS, SUM(CountOfStatus) AS CountOfStatus from
					(
						SELECT a.REGISTRANT_STATUS,c.SERVICE_STATUS,COUNT(a.REGISTRANT_STATUS) AS CountOfStatus 
						FROM [AHOBPR].[STD_REGISTRANT_STATUS] a 
							LEFT JOIN [AHOBPR].[REGISTRANT] b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID 
							LEFT JOIN [AHOBPR].[STD_SERVICE_STATUS] c ON c.STD_SERVICE_STATUS_ID = ' + @dutyAtFirstLoginVariable + '
						GROUP BY c.SERVICE_STATUS,a.REGISTRANT_STATUS
						HAVING a.REGISTRANT_STATUS in (''Reviewed - Not Eligible'', ''Not Eligible'')
					) ReviewedNotEligible
					GROUP BY ReviewedNotEligible.SERVICE_STATUS
				) C 
				ON C.Service_Status = s.SERVICE_STATUS
		LEFT JOIN (
					SELECT a.REGISTRANT_STATUS,c.SERVICE_STATUS,COUNT(a.REGISTRANT_STATUS) AS CountOfStatus 
					FROM [AHOBPR].[STD_REGISTRANT_STATUS] a 
						LEFT JOIN [AHOBPR].[REGISTRANT] b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID 
						LEFT JOIN [AHOBPR].[STD_SERVICE_STATUS] c ON c.STD_SERVICE_STATUS_ID = ' + @dutyAtFirstLoginVariable + '
					GROUP BY c.SERVICE_STATUS,a.REGISTRANT_STATUS
					HAVING a.REGISTRANT_STATUS = ''Review''
				) D 
				ON D.Service_Status = s.SERVICE_STATUS
		LEFT JOIN (
					SELECT a.REGISTRANT_STATUS,c.SERVICE_STATUS,COUNT(a.REGISTRANT_STATUS) as CountOfStatus 
					FROM [AHOBPR].[STD_REGISTRANT_STATUS] a 
						LEFT JOIN [AHOBPR].[REGISTRANT] b ON a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID 
						LEFT JOIN [AHOBPR].[STD_SERVICE_STATUS] c ON c.STD_SERVICE_STATUS_ID = ' + @dutyAtFirstLoginVariable + '
					GROUP BY c.SERVICE_STATUS,a.REGISTRANT_STATUS
					HAVING a.REGISTRANT_STATUS = ''No Consent''
				) E 
				ON E.Service_Status = s.SERVICE_STATUS
		LEFT JOIN 
				(	SELECT c.SERVICE_STATUS,COUNT(C.SERVICE_STATUS) as Total
					FROM [AHOBPR].[STD_REGISTRANT_STATUS] a 
						LEFT JOIN [AHOBPR].[REGISTRANT] b on a.STD_REGISTRANT_STATUS_ID = b.STD_REGISTRANT_STATUS_ID 
						LEFT JOIN [AHOBPR].[STD_SERVICE_STATUS] c on c.STD_SERVICE_STATUS_ID = ' + @dutyAtFirstLoginVariable + '
					group by c.SERVICE_STATUS
				)F
			ON F.Service_Status = s.SERVICE_STATUS';


PRINT @Query;
   
EXECUTE(@Query);      

END 
GO




---------------------------------------------------------
PRINT 'VIEW [AHOBPR].[VIEW_LOOKUP]'
GO
---------------------------------------------------------

--last updated in 3.0.10  script
ALTER VIEW [AHOBPR].[VIEW_LOOKUP] 
WITH SCHEMABINDING 
AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
		OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME = 'Eligibility Review - More Documentation Needed'))--2.0.13.1 changed this line
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 0 AND USER_FLAG = 0  -- Build 3.0.10
  AND TITLE NOT IN ('Eligible for Burn Pit Registry', 'Not Eligible for Burn Pit Registry', 
	'New Follow-up Questions', 'Need More Documentation', 'Name Updated')  -- Build 3.0.6 add 'Name Updated'
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM A
  WHERE FOLLOWUP_FLAG = 1
  --Follow up Send Page > Deactivated groups showing in Drop down (272277)
   AND NOT EXISTS (SELECT 'X' FROM AHOBPR.TOOL_FORM WHERE TOOL_FORM_ID = A.TOOL_FORM_ID AND (ACTIVE_FLAG = 0 OR SYSTEM_WIDE_FLAG = 1))
UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''
UNION ALL
SELECT 'MY_TEMPLATES_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,CREATEDBY AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 1
UNION ALL
SELECT DISTINCT 'ENROLLMENT_STATUS' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[ENROLLMENT_STATUS] AS CODE
       ,[ENROLLMENT_STATUS] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
   WHERE ENROLLMENT_STATUS > ''
UNION ALL
SELECT 'USER_ROLE' AS LOOKUP_TYPE    -- Build 3.0.7
	     ,A.ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [dbo].[STD_ROLE] A, [dbo].[STD_REGISTRY] B
  WHERE A.STD_REGISTRY_ID = B.ID AND B.CODE = 'AHOBPR'
UNION ALL
  SELECT DISTINCT 'AUDIT_ACTION_TYPE' AS LOOKUP_TYPE   -- Build 3.0.7
	     ,TYPE_ID AS ID
       , [DESCRIPTION] AS CODE
       , [DESCRIPTION] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[AUDIT_LOG_TYPE]
  WHERE [DESCRIPTION] <> 'Data Maintenance'  
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_DROPDOWN' AS LOOKUP_TYPE   -- Build 3.0.8 
          ,STD_FORM_ID AS ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM A, AHOBPR.TOOL_FORM B
  WHERE A.FOLLOWUP_FLAG = 1 AND A.TOOL_FORM_ID = B.TOOL_FORM_ID
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,0 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,1 AS ID
       ,'Active' AS CODE
       ,'Active' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,2 AS ID
       ,'Inactive' AS CODE
       ,'Inactive' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,3 AS ID
       ,'Pending' AS CODE
       ,'Pending' AS NAME
       ,0 AS PARENT_ID
       ,4 AS SORT_ORDER
UNION ALL
SELECT 'USER_EMAIL_TEMPLATE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND USER_FLAG = 1  -- Build 3.0.10 
UNION ALL
SELECT 'USER_ROLE_ALL' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,0 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,0 AS SORT_ORDER
UNION ALL
SELECT 'USER_ROLE_ALL' AS LOOKUP_TYPE    -- Build 3.0.10
	     ,A.ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [dbo].[STD_ROLE] A, [dbo].[STD_REGISTRY] B
  WHERE A.STD_REGISTRY_ID = B.ID AND B.CODE = 'AHOBPR'
UNION ALL
SELECT 'STD_PRIMARY_JOB' AS LOOKUP_TYPE  -- PNV
	     ,STD_PRIMARY_JOB_ID AS ID
       ,PRIMARY_JOB AS CODE
       ,PRIMARY_JOB AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_PRIMARY_JOB
 WHERE STD_PRIMARY_JOB_ID > 0
UNION ALL
SELECT 'STD_SECONDARY_JOB' AS LOOKUP_TYPE  -- PNV
	     ,STD_SECONDARY_JOB_ID AS ID
       ,SECONDARY_JOB AS CODE
       ,SECONDARY_JOB AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SECONDARY_JOB
 WHERE STD_SECONDARY_JOB_ID > 0
UNION ALL
SELECT 'STD_WORK_LOCATION' AS LOOKUP_TYPE  -- PNV
	     ,STD_WORK_LOCATION_ID AS ID
       ,WORK_LOCATION AS CODE
       ,WORK_LOCATION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_WORK_LOCATION
 WHERE STD_WORK_LOCATION_ID > 0
 UNION ALL
 SELECT 'STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,1 AS ID
       ,'Active' AS CODE
       ,'Active' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,2 AS ID
       ,'Inactive' AS CODE
       ,'Inactive' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,3 AS ID
       ,'Pending' AS CODE
       ,'Pending' AS NAME
       ,0 AS PARENT_ID
       ,4 AS SORT_ORDER
UNION ALL
SELECT 'DEPLOYMENT_STAGE' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,0 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,0 AS SORT_ORDER
UNION ALL
SELECT 'DEPLOYMENT_STAGE' AS LOOKUP_TYPE  -- PNV
	     ,STD_DEPLOYMENT_STAGE_ID AS ID
       ,DEPLOYMENT_STAGE AS CODE
       ,DEPLOYMENT_STAGE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DEPLOYMENT_STAGE
 WHERE STD_DEPLOYMENT_STAGE_ID > 0
-- select * from  [AHOBPR].[VIEW_LOOKUP]

GO
Print 'Done';

Print 'Update [AHOBPR].[TRG_REGISTRANT_H]';
/****** Object:  Trigger [AHOBPR].[TRG_REGISTRANT_H]    Script Date: 3/25/2018 3:04:09 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

ALTER trigger [AHOBPR].[TRG_REGISTRANT_H] on [AHOBPR].[REGISTRANT]
after Update, Insert
AS 
Begin
declare @lv_change varchar(15)
, @cdeleted int
, @cinserted int
, @cSftDelete int
SELECT @cdeleted =count(*) FROM DELETED
SELECT @cinserted =count(*) FROM INSERTED
INSERT INTO [AHOBPR].[REGISTRANT_H]
( [Audit_Date]
, [Audit_Type]
, [Audit_ApplicationUser]
, [Audit_SQLUser] 
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [RACE]
, [ETHNICITY]
, [STD_SERVICE_STATUS_ID]
, [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS]
, [EDUCATION_LEVEL]
, [STD_SEPARATION_REASON_ID_CURRENT]
, [SEPARATION_DATE_CURRENT]
, [STD_SEPARATION_REASON_ID_WHEN_ENROLLED]
, [SEPARATION_DATE_WHEN_ENROLLED]
, [STD_DISCHARGE_CHARACTER_ID]
, [STD_COMPONENT_ID_CURRENT]
, [STD_COMPONENT_ID_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [ELIGIBILITY_STATUS]
, [ELIGIBILITY]
, [CONTACT_PREFERENCE]
, [ETL_UPDATED]
, [ENROLLMENT_STATUS]
, [ENROLLED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PRE_911_DEPLOYMENT]
, [POST_911_DEPLOYMENT]
)
SELECT getDate()
, lv_Change= case 
WHEN @cdeleted=0 and @cinserted>0 then 'INSERT'
when @cdeleted>0 and @cinserted>0 then 'UPDATE'
else NULL
end
, HCB= case 
WHEN @cdeleted=0 and @cinserted>0 then CreatedBy
when @cdeleted>0 and @cinserted>0 then UpdatedBy
else NULL
end
, suser_sname()
, [REGISTRANT_ID]
, [USER_ID]
, [EDIPI]
, [ICN]
, [SSN]
, [FIRST_NAME]
, [MIDDLE_NAME]
, [LAST_NAME]
, [BIRTH_DATE]
, [GENDER]
, [RACE]
, [ETHNICITY]
, [STD_SERVICE_STATUS_ID]
, [STD_SERVICE_STATUS_ID_WHEN_ENROLLED]
, [STD_BRANCH_OF_SERVICE_ID_CURRENT]
, [STD_BRANCH_OF_SERVICE_ID_WHEN_ENROLLED]
, [UIC_CURRENT]
, [UIC_WHEN_ENROLLED]
, [STD_REGISTRANT_STATUS_ID]
, [REGISTRANT_STATUS_LAST_UPDATED_DATE]
, [STD_INSTITUTION_ID]
, [MARITAL_STATUS]
, [EDUCATION_LEVEL]
, [STD_SEPARATION_REASON_ID_CURRENT]
, [SEPARATION_DATE_CURRENT]
, [STD_SEPARATION_REASON_ID_WHEN_ENROLLED]
, [SEPARATION_DATE_WHEN_ENROLLED]
, [STD_DISCHARGE_CHARACTER_ID]
, [STD_COMPONENT_ID_CURRENT]
, [STD_COMPONENT_ID_WHEN_ENROLLED]
, [HEALTH_CONCERNS_RESPONSE]
, [REQUEST_SEEN_RESPONSE]
, [DECEASED_FLAG]
, [DEATH_DATE]
, [ELIGIBILITY_STATUS]
, [ELIGIBILITY]
, [CONTACT_PREFERENCE]
, [ETL_UPDATED]
, [ENROLLMENT_STATUS]
, [ENROLLED_DATE]
, [CREATEDBY]
, [UPDATEDBY]
, [CREATED]
, [UPDATED]
, [PRE_911_DEPLOYMENT]
, [POST_911_DEPLOYMENT]

FROM INSERTED
End
GO
Print 'Done';

---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------
go

update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';  
go
