/* 
Author: L. Mansfield
Date: 9-14-2017
Description: Create new tables: STD_DEPLOYMENT_STAGE, STD_RETIREMENT_TERMINATION_REASON, STD_RETIREMENT_TYPE, REGISTRANT_RETIREMENT,
			and USER_STATES_FILTER.
			Alter tables: REGISTRANT and REGISTRANT_DEPLOYMENT
*/
:setvar DatabaseName "REGISTRYHRE"
:setvar MajorReleaseNumber "4" 
:setvar MinorReleaseNumber "0" 
:setvar PointReleaseNumber "9"
:setvar ScriptName "1_INSTALL.sql"

PRINT ' 
------------------------------------------------------------------------------------------------
$(ScriptName)

Script in support of AHOBPR Release $(MajorReleaseNumber).$(MinorReleaseNumber).$(PointReleaseNumber)

------------------------------------------------------------------------------------------------
 ';
PRINT 'Started ' + CAST(GETDATE() as varchar(20)) + '.';
PRINT ' 
*********************************************************
NOTE: This script must be run with SQLCMD Mode turned on.
*********************************************************

';
GO
:on error exit
GO
:setvar __IsSqlCmdEnabled "True"
/*
Detect SQLCMD mode and disable script execution if SQLCMD mode is not supported.
To re-enable the script after enabling SQLCMD mode, execute the following two lines:
*/
SET NOEXEC OFF; 
SET NOCOUNT OFF;
GO
IF N'$(__IsSqlCmdEnabled)' NOT LIKE N'True'
    BEGIN
        PRINT N'SQLCMD mode must be enabled to successfully execute this script.';
        SET NOCOUNT ON;
        SET NOEXEC ON; --When SET NOEXEC is ON, SQL Server compiles each batch of Transact-SQL statements but does not execute them.
    END

GO
USE $(DatabaseName)
GO

IF EXISTS ( select * from [dbo].[DatabaseChangeLog]
            where [MajorReleaseNumber]	= '$(MajorReleaseNumber)'
              and [MinorReleaseNumber]	= '$(MinorReleaseNumber)'
              and [PointReleaseNumber]	= '$(PointReleaseNumber)'
			  and [TargetRegistry]		= 'AHOBPR'
              and [ScriptName]			= '$(ScriptName)'
          )
BEGIN
   RAISERROR('!!!!The deployment script may not be rerun without first backing out the changes, including the DatabaseChangeLog record.!!!!'
              ,11
              ,1);
END
ELSE
  INSERT 
    INTO [dbo].[DatabaseChangeLog]
             ([MajorReleaseNumber]
             ,[MinorReleaseNumber]
             ,[PointReleaseNumber]
             ,[Hotfix]
             ,[ScriptName]
             ,[ScriptDescription]
             ,[TargetRegistry]
             ,[DateApplied])
       VALUES
             ('$(MajorReleaseNumber)'
             ,'$(MinorReleaseNumber)'
             ,'$(PointReleaseNumber)'
             ,0
             ,'$(ScriptName)'
		         ,'Script Started...'
             ,'AHOBPR'
             ,GETDATE()
            );

GO
---------------------------------------------------------------------------------------------------------
PRINT '$(ScriptName) script started...';
PRINT GETDATE();
GO
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS OFF
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Table UPDATES_BENS_REGISTRANT_NOTIFICATION';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION](
    [UPDATES_BENS_REGISTRANT_NOTIFICATION_ID] [bigint] IDENTITY(1,1) NOT NULL,
    [EDIPI] [varchar](50) NOT NULL,
    [REGISTRANT_ID] int NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL,
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [UPDATES_BENS_REGISTRANT_NOTIFICATION_PK] PRIMARY KEY CLUSTERED 
  (
    [UPDATES_BENS_REGISTRANT_NOTIFICATION_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Table UPDATES_BENS_NOTIFICATION';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_BENS_NOTIFICATION]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[UPDATES_BENS_NOTIFICATION](
    [UPDATES_BENS_NOTIFICATION_ID] [bigint] IDENTITY(1,1) NOT NULL,
    [EDIPI] [varchar](50) NOT NULL,	
    [CREATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL,
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [UPDATES_BENS_NOTIFICATION_PK] PRIMARY KEY CLUSTERED 
  (
    [UPDATES_BENS_NOTIFICATION_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Table UPDATES_PROCESSED_NOTIFICATION_STATUS';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS](
    [UPDATES_PROCESSED_NOTIFICATION_STATUS_ID] [bigint] IDENTITY(1,1) NOT NULL,
    [UPDATES_BENS_REGISTRANT_NOTIFICATION_ID] [bigint] NOT NULL,
    [REGISTRANT_ID] int NOT NULL,
    [EDIPI] [varchar](50) NOT NULL,
    [PROCESS_NAME] [varchar](100) NOT NULL,
    [PROCESS_STATUS] [varchar](100) NOT NULL,
    [PROCESS_ERROR] [varchar](4000) NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL,
    [UPDATED] [datetime2](0) NOT NULL,
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [UPDATES_PROCESSED_NOTIFICATION_STATUS_PK] PRIMARY KEY CLUSTERED 
  (
    [UPDATES_PROCESSED_NOTIFICATION_STATUS_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]

  ALTER TABLE [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS]  WITH CHECK ADD  CONSTRAINT [FK_UPDATES_PROCESSED_REGISTRANT_NOTIFICATION] FOREIGN KEY([UPDATES_BENS_REGISTRANT_NOTIFICATION_ID])
  REFERENCES [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] ([UPDATES_BENS_REGISTRANT_NOTIFICATION_ID])
END
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Table STD_SECONDARY_JOB';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_SECONDARY_JOB]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[STD_SECONDARY_JOB](
    [STD_SECONDARY_JOB_ID] [int] IDENTITY(1,1) NOT NULL,
    [SECONDARY_JOB] [varchar](100) NOT NULL,
    [ORDINAL_VALUE] [tinyint] NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdSecondaryJob_Created]  DEFAULT (getdate()),
    [UPDATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdSecondaryJob_Updated]  DEFAULT (getdate()),
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [STD_SECONDARY_JOB_PK] PRIMARY KEY CLUSTERED 
  (
    [STD_SECONDARY_JOB_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An IDENTITY surrogate key acting as the PK for the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'STD_SECONDARY_JOB_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the status, unique within the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'SECONDARY_JOB'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A value indicating the relative position in the registration workflow.  Higher values are later in the workflow.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'ORDINAL_VALUE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that created the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that updated the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'CREATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique row identifier required by LINQ to SQL' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_SECONDARY_JOB', @level2type=N'COLUMN',@level2name=N'ROW_VERSION'
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Create Table STD_PRIMARY_JOB';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_PRIMARY_JOB]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[STD_PRIMARY_JOB](
    [STD_PRIMARY_JOB_ID] [int] IDENTITY(1,1) NOT NULL,
    [PRIMARY_JOB] [varchar](100) NOT NULL,
    [ORDINAL_VALUE] [tinyint] NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdPrimaryJob_Created]  DEFAULT (getdate()),
    [UPDATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdPrimaryJob_Updated]  DEFAULT (getdate()),
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [STD_PRIMARY_JOB_PK] PRIMARY KEY CLUSTERED 
  (
    [STD_PRIMARY_JOB_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

SET ANSI_PADDING OFF
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An IDENTITY surrogate key acting as the PK for the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'STD_PRIMARY_JOB_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the status, unique within the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'PRIMARY_JOB'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A value indicating the relative position in the registration workflow.  Higher values are later in 

the workflow.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'ORDINAL_VALUE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that created the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that updated the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'CREATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique row identifier required by LINQ to SQL' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_PRIMARY_JOB', @level2type=N'COLUMN',@level2name=N'ROW_VERSION'
GO

-- Create Table STD_WORK_LOCATION
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Create Table STD_WORK_LOCATION';
GO
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[AHOBPR].[STD_WORK_LOCATION]') AND type in (N'U'))
BEGIN
  CREATE TABLE [AHOBPR].[STD_WORK_LOCATION](
    [STD_WORK_LOCATION_ID] [int] IDENTITY(1,1) NOT NULL,
    [WORK_LOCATION] [varchar](100) NOT NULL,
    [ORDINAL_VALUE] [int] NOT NULL,
    [CREATEDBY] [varchar](30) NOT NULL,
    [UPDATEDBY] [varchar](30) NOT NULL,
    [CREATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdWorkLocation_Created]  DEFAULT (getdate()),
    [UPDATED] [datetime2](0) NOT NULL CONSTRAINT [DF_StdWorkLocation_Updated]  DEFAULT (getdate()),
    [ROW_VERSION] [timestamp] NOT NULL,
  CONSTRAINT [STD_WORK_LOCATION_PK] PRIMARY KEY CLUSTERED 
  (
    [STD_WORK_LOCATION_ID] ASC
  )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
  ) ON [AHOBPR]
END
GO

SET ANSI_PADDING OFF
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'An IDENTITY surrogate key acting as the PK for the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'STD_WORK_LOCATION_ID'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The name of the status, unique within the table.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'WORK_LOCATION'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A value indicating the relative position in the registration workflow.  Higher values are later in the workflow.' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'ORDINAL_VALUE'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that created the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The person or program that updated the record' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'CREATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time to the second when the record was created' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'UPDATED'
GO

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A unique row identifier required by LINQ to SQL' , @level0type=N'SCHEMA',@level0name=N'AHOBPR', @level1type=N'TABLE',@level1name=N'STD_WORK_LOCATION', @level2type=N'COLUMN',@level2name=N'ROW_VERSION'
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Create Trigger TRG_AddToNotificationQueue';
GO
---------------------------------------------------------------------------------------------------------
IF (OBJECT_ID('[AHOBPR].[TRG_AddToNotificationQueue]') IS NOT NULL) 
	EXEC('DROP TRIGGER [AHOBPR].[TRG_AddToNotificationQueue];')
GO
CREATE TRIGGER [AHOBPR].[TRG_AddToNotificationQueue]
ON [AHOBPR].[REGISTRANT] 
AFTER INSERT
AS
BEGIN
SET NOCOUNT ON

DECLARE @i TABLE (
     EDIPI varchar(50) PRIMARY KEY CLUSTERED,
    CREATED datetime2,
    CREATEDBY varchar(30)
)
INSERT INTO @i
SELECT EDIPI, CREATED, CREATEDBY FROM INSERTED

    --Insert the Notification record
    INSERT INTO UPDATES_BENS_NOTIFICATION (
        EDIPI,
        CREATED,
        CREATEDBY
    )
    SELECT
        EDIPI,
        CREATED,
        'TR_REGISTRANT'
    FROM @i;
END

-- ALTER AHOBPR_USER table
---------------------------------------------------------------------------------------------------------
PRINT 'ALTER AHOBPR_USER table';
GO
---------------------------------------------------------------------------------------------------------
ALTER TABLE [AHOBPR].[AHOBPR_USER] 
ADD PRIMARY_JOB_ID INT NULL;

ALTER TABLE [AHOBPR].[AHOBPR_USER]  
ADD CONSTRAINT FK_PRIMARY_JOB_ID
FOREIGN KEY(PRIMARY_JOB_ID) REFERENCES [AHOBPR].[STD_PRIMARY_JOB](STD_PRIMARY_JOB_ID);

ALTER TABLE [AHOBPR].[AHOBPR_USER] 
ADD SECONDARY_JOB_ID INT NULL;

ALTER TABLE [AHOBPR].[AHOBPR_USER]
ADD CONSTRAINT FK_SECONDARY_JOB_ID
FOREIGN KEY(SECONDARY_JOB_ID) REFERENCES [AHOBPR].[STD_SECONDARY_JOB](STD_SECONDARY_JOB_ID);

ALTER TABLE [AHOBPR].[AHOBPR_USER] 
ADD  WORK_LOCATION_ID INT NULL;

ALTER TABLE [AHOBPR].[AHOBPR_USER]
ADD CONSTRAINT FK_WORK_LOCATION_ID
FOREIGN KEY(WORK_LOCATION_ID) REFERENCES [AHOBPR].[STD_WORK_LOCATION](STD_WORK_LOCATION_ID);
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data into STD_RETIREMENT_TERMINATION_REASON';
GO
---------------------------------------------------------------------------------------------------------

SET IDENTITY_INSERT [AHOBPR].[STD_RETIREMENT_TERMINATION_REASON] ON 
;WITH  MasterData
AS    ( select * 
        from (VALUES 
                (1, N'D', N'Death while in personnel category or organization', N'DBADMIN', N'DBADMIN', GETDATE(), GETDATE()),
                (2, N'F', N'Invalid entry into segment', N'DBADMIN', N'DBADMIN', GETDATE(), GETDATE()),
                (3, N'S', N'Separation from personnel category or organization', N'DBADMIN', N'DBADMIN', GETDATE(), GETDATE()),
                (4, N'W', N'Not applicable', N'DBADMIN', N'DBADMIN', GETDATE(), GETDATE())
              ) AS MasterRecord(STD_RETIREMENT_TERMINATION_REASON_ID, RETIREMENT_TERMINATION_REASON_CODE, RETIREMENT_TERMINATION_REASON_DESCRIPTION, CREATEDBY, UPDATEDBY, CREATED, UPDATED) 
)
MERGE INTO [AHOBPR].[STD_RETIREMENT_TERMINATION_REASON] as Tgt
USING MasterData as Src
ON Tgt.[STD_RETIREMENT_TERMINATION_REASON_ID] = Src.STD_RETIREMENT_TERMINATION_REASON_ID
WHEN NOT MATCHED
THEN INSERT
  ([STD_RETIREMENT_TERMINATION_REASON_ID], [RETIREMENT_TERMINATION_REASON_CODE], [RETIREMENT_TERMINATION_REASON_DESCRIPTION], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED])
  VALUES
   (Src.STD_RETIREMENT_TERMINATION_REASON_ID, Src.RETIREMENT_TERMINATION_REASON_CODE, Src.RETIREMENT_TERMINATION_REASON_DESCRIPTION, Src.CREATEDBY, Src.UPDATEDBY, Src.CREATED, Src.UPDATED)
WHEN MATCHED
THEN UPDATE SET 
        Tgt.[RETIREMENT_TERMINATION_REASON_CODE] = Src.RETIREMENT_TERMINATION_REASON_CODE,
        Tgt.[RETIREMENT_TERMINATION_REASON_DESCRIPTION] = Src.RETIREMENT_TERMINATION_REASON_DESCRIPTION,
				Tgt.[CREATEDBY] = Src.CREATEDBY, 
				Tgt.[UPDATEDBY] = Src.UPDATEDBY, 
				Tgt.[CREATED] = Src.CREATED,
				Tgt.[UPDATED] = Src.UPDATED;
SET IDENTITY_INSERT [AHOBPR].[STD_RETIREMENT_TERMINATION_REASON] OFF
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data into STD_GUI_CONTROLS';
GO
---------------------------------------------------------------------------------------------------------
DECLARE  @RegistryId int
BEGIN

	SELECT @RegistryId = ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR'
	-- Delete the previously inserted AHOBPR GUI control entries...
	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
		and CATEGORY = 'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION' 
		AND [NAME] IN ('My Account Primary Job Parameters', 'My Account Secondary Job Parameters', 'My Account Work Location Parameters')
INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION','My Account Primary Job Parameters',4,'BaseControlDropdownListPrimaryJob', 'Primary Job is required',null,'Admin Users Primary Job',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_PRIMARY_JOB', null,null,1,1,'Primary Job: </br>',null,null,'UserSave',null,'PanelUserInformation');

INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION','My Account Secondary Job Parameters',4,'BaseControlDropdownListSecondaryJob', 'Secondary Job is required',null,'Admin Users Secondary Job',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_SECONDARY_JOB', null,null,1,1,'Secondary Job: </br>',null,null,'UserSave',null,'PanelUserInformation');

INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_MYACCOUNT_ACCOUNTINFORMATION','My Account Work Location Parameters',4,'BaseControlDropdownListWorkLocation', 'Work Location is required',null,'Admin Users Work Location',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_WORK_LOCATION', null,null,1,1,'Work Location: </br>',null,null,'UserSave',null,'PanelUserInformation');
END

BEGIN

	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
  	and CATEGORY = 'AHOBPR_CREATE_ACCOUNT'
		AND [NAME] IN ('My Account Primary Job Parameters', 'My Account Secondary Job Parameters', 'My Account Work Location Parameters')

INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CREATE_ACCOUNT','My Account Primary Job Parameters',4,'BaseControlDropdownListPrimaryJob', 'Primary Job is required',null,'Primary Job',@RegistryId,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_PRIMARY_JOB', null,null,1,1,'Primary Job: ',null,null,'alpha',null,'entryPanel');
	  
INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CREATE_ACCOUNT','My Account Secondary Job Parameters',4,'BaseControlDropdownListSecondaryJob', 'Secondary Job is required',null,'Secondary Job',11,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_SECONDARY_JOB', null,null,1,1,'Secondary Job: ',null,null,'alpha',null,'entryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]  ([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CREATE_ACCOUNT','My Account Work Location Parameters',4,'BaseControlDropdownListWorkLocation', 'Work Location is required',null,'Work Location',12,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_WORK_LOCATION', null,null,1,1,'Work Location: ',null,null,'alpha',null,'entryPanel');
END

BEGIN 
	DELETE FROM [dbo].[STD_GUI_CONTROLS] 
	WHERE [STD_REGISTRY_ID] = @RegistryId 
  	and CATEGORY = 'AHOBPR_CLINICAL_USER_ADHOC_REPORT'
		AND [NAME] IN ('Ad-Hoc Report', 'Primary Job parameters', 'Status parameters','Secondary Job parameters','Work Location parameters','Job Title parameters','Change Status State parameters')

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Ad-Hoc Report',4,'BaseControlDropdownListActionType',null,null,'The Selection Criteria allows the user to filter by one user action type.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','AUDIT_ACTION_TYPE',null,null,0,1,'Action Type: </br>',null,null,null,null,'PanelSearchCriteriaAction');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Ad-Hoc Report',4,'BaseControlDropdownListRole',null,null,'The Selection Criteria allows the user to filter by one user role.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','USER_ROLE',null,null,0,1,'Role: </br>',null,null,null,null,'SecondaryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Primary Job parameters',5,'BaseControlListBoxPrimaryJob',null,null,'The Selection Criteria allows the user to filter by one or more Primary Jobs.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_PRIMARY_JOB',  170,170,0,1,'Primary Job: </br>',null,null,null,null,'SecondaryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Status parameters',4,'BaseControlDropDownListStatus',null,null,'The Selection Criteria allows the user to filter by one user account status.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STATUS',null,null,0,1,'Status: </br>',null,null,null,null,'MainPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Secondary Job parameters',5,'BaseControlListBoxSecondaryJob',null,null,'The Selection Criteria allows the user to filter by one or more Secondary Jobs.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_SECONDARY_JOB',  170,170,0,1,'Secondary Job: </br>',null,null,null,null,'SecondaryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Work Location parameters',5,'BaseControlListBoxWorkLocation',null,null,'The Selection Criteria allows the user to filter by one or more Work Locations.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_WORK_LOCATION',  170,170,0,1,'Work Location: </br>',null,null,null,null,'SecondaryPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Job Title parameters',2,'BaseControlTextBoxJobTitle',null,null,'The Selection Criteria allows the user to filter by words in Job Title.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA',NULL,null,null,0,1,'Job Title Keyword search: ',null,null,null,null,'MainPanel');

INSERT into [dbo].[STD_GUI_CONTROLS]([STD_REGISTRY_ID],[CATEGORY],[NAME],[BASE_CONTROL_TYPE],[USER_CONTROL_ID],[VALIDATION_ERROR_MESSAGE],[VALIDATION_REGULAR_EXPRESSION],[TOOL_TIP],[SORT_ORDER],[CREATED],[UPDATED],[CREATEDBY],[UPDATEDBY],[LOOKUP_LIST_CATEGORY],[BASE_CONTROL_WIDTH],[DATA_ELEMENT_WIDTH],[REQUIRED],[INCLUDE_LABEL],[LABEL_TEXT],[LOOKUP_LIST_CATEGORY2],[LOOKUP_LIST_CATEGORY3],[VALIDATION_GROUP],[DATA_TYPE_MAX_LENGTH],[PANEL_NAME]) 
	  VALUES (@RegistryId,'AHOBPR_CLINICAL_USER_ADHOC_REPORT','Change Status State parameters',4,'BaseControlDropDownListChangeStatusState',null,null,'Change Status State is the State selected by Advanced Users to display Registrants on the Change Status page. The Selection Criteria all a user to filter by one State.',0,getdate(),getdate(),'AHOBPR DBA','AHOBPR DBA','STD_STATE',null,null,0,1,'Change Status State: <br>',null,null,null,null,'MainPanel');
END
GO



---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data into STD_PRIMARY_JOB';
GO
---------------------------------------------------------------------------------------------------------
DELETE from [AHOBPR].[STD_PRIMARY_JOB];
GO

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Administrator',1,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Assoc./Allied Health',2,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('OEF/OIF/OND Case Manager',3,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Clinical Psychologist',4,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Licensed Clinical Social Worker',5,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Licensed Counselor(MFT or other)',6,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Occupational Therapist',7,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('PDICI Champ',8,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Recreational Therapist',9,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('VHA Mental Health',10,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Intensive Case Manager',11,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Chief/Director',13,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('VHA Social Work Service Manager',14,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Physician Assistant',15,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Nurse Practitioner',16,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Registered Nurse',17,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Vocational Nurse',18,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Environmental Health Clinician',19,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Environmental Health Coordinator',20,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Primary Care Physician',21,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Physician',22,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_PRIMARY_JOB](PRIMARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Other',23,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());
GO

---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data into STD_SECONDARY_JOB';
GO
---------------------------------------------------------------------------------------------------------
DELETE from [AHOBPR].[STD_SECONDARY_JOB];
GO
INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Not Applicable',1,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Administrator',2,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Assoc./Allied Health',3,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('OEF/OIF/OND Case Manager',4,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Clinical Psychologist',5,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Licensed Clinical Social Worker',6,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Licensed Counselor(MFT or other)',7,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Occupational Therapist',8,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('PDICI Champ',9,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Recreational Therapist',10,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('VHA Mental Health',11,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Intensive Case Manager',12,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Chief/Director',14,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('VHA Social Work Service Manager',15,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Physician Assistant',16,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Nurse Practitioner',17,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Registered Nurse',18,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Vocational Nurse',19,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Environmental Health Clinician',20,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Environmental Health Coordinator',21,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Primary Care Physician',22,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Physician',23,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_SECONDARY_JOB](SECONDARY_JOB,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED)
VALUES('Other',24,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());


---------------------------------------------------------------------------------------------------------
PRINT 'Insert Data for STD_WORK_LOCATION';
GO
---------------------------------------------------------------------------------------------------------
DELETE from [AHOBPR].[STD_WORK_LOCATION];
GO
INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Austin TX Automation Center(AAC)',1,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Albuquerque NM (ABQ)',2,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Baltimore MD Baltimore Academy (ACD)',3,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Austin TX AIM Center (AIM)',4,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Albuquerque NM (ALB)',5,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Allen Park MI (ALL)',6,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Albany NY VAMC (ALN)',7,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Altoona PA (ALT)',8,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Alexandria LA (ALX)',9,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Amarillo TX (AMA)',10,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Anchorage AK (ANC)',11,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Ann Arbor MI (ANN)',12,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Boston MA Allocation Resource Center (ARC)',13,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Asheville NC (ASH)',14,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Atlanta GA (ATG)',15,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Atwater CA (ATW)',16,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Austin TX (ATX)',17,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Auburn CA (AUB)',18,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Augusta GA (AUG)',19,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Austin TX Austin (AUS)',20,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Battle Creek MI VAMC (BAC)',21,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Baltimore MD (BAL)',22,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Bath NY (BAN)',23,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Batavia NY (BAT)',24,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Bay Pines FL (BAY)',25,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Beckley WV (BEC)',26,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Bedford MA (BED)',27,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Fort Meade SD Black Hills HCS (BHH)',28,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Boston MA Boston HCS (BHS)',29,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION](WORK_LOCATION,ORDINAL_VALUE,CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES('Big Spring TX (BIG)',30,'AHOBPR DBA','AHOBPR DBA',getdate(),getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Biloxi MS(BIL)',31,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Birmingham AL (BIR)',32,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boise ID (BOI)',33,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bonham TX (BON)',34,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA (BOS)',35,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA Vet Center (BOV)',36,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brecksville OH ORM (BRE)',37,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brockton MA (BRK)',38,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Branson MO CBOC (BRN)',39,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brockton MA Vet Center (BRV)',40,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bronx NY (BRX)',41,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Buffalo NY (BUF)',42,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Butler PA (BUT)',43,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brooklyn NY (BYN)',44,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Amazon Cloud US Amazon Cloud (C10)',45,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Microsoft Government Cloud US Microsoft Government Cloud (C20)',46,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Microsoft Office365 Cloud US Microsoft Office365 Cloud (C40)',47,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Montgomery AL Central Alabama HCS (CAH)',48,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cambridge MD (CAM)',49,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Canandaigua NY (CAN)',50,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Capitola CA (CAP)',51,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Castle Point NY (CAS)',52,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA Outpatient Clinic (CAU)',53,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Montgomery AL Central Alabama HCS (CAV)',54,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Columbus GA CAVHCS (CBS)',55,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO CEOSH (CEO)',56,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV Office of Cyber and Information Security (CFW)',57,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Charleston SC (CHA)',58,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chico CA (CHC)',59,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chelsea MA Vet Center (CHE)',60,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL (CHI)',61,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL (Lakeside) (CHL)',62,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL Chicago HCS (CHS)',63,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL (Westside) (CHW)',64,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cheyenne WY VAM&ROC (CHY)',65,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Des Moines IA Central Iowa HCS (CIH)',66,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cincinnati OH (CIN)',67,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Clarksburg WV (CLA)',68,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX Co-located with national gateway (CLD)',69,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cleveland OH (CLE)',70,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kansas City KS Co-located with national gateway (CLK)',71,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chillicothe OH (CLL)',72,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Reston VA Co-located with national gateway (CLR)',73,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Santa Rosa CA Co-located with national gateway (CLS)',74,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chelmsford MA CMOP (CMB)',75,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('North Charleston SC CMOP (CMC)',76,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX CMOP (CMD)',77,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL CMOP (CMH)',78,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Leavenworth KS CMOP (CML)',79,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Murfreesboro TN CMOP (CMM)',80,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tucson AZ National (CMOP) IT Program Office (CMN)',81,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Columbia MO Harry S. Truman Memorial Veterans Hospital (CMO)',82,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tucson AZ Southwest CMOP (CMP)',83,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Columbia SC (CMS)',84,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Community Nursing Home (CNH)',85,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC VACO (CO)',86,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Coatesville PA (COA)',87,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV VA COOP/COG Center (COG)',88,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Haven CT Connecticut HCS (CON)',89,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA Outpatient Clinic (COR)',90,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Columbus OH NULL (COS)',91,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Asheville NC Consolidated Patient Account Center (CPA)',92,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA Compensation & Pension Exam (CPE)',93,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Orlando FL Florida CPAC (CPF)',94,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Leavenworth KS Central Plains CPAC (CPK)',95,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Las Vegas NV West CPAC (CPN)',96,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lebenon PA CPAC (CPP)',97,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Murfreesboro TN Mid-South CPAC (CPT)',98,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Madison WI North Central CPAC (CPW)',99,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV (CRD)',100,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV National Capital Region Readiness Center (CRR)',101,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Albuquerque NM VA Cooperative Studies Program (CSP)',102,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Temple TX Central Texas HCS (CTX)',103,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Culpeper VA QITC COOP location (CUL)',104,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO CHAMPVA (CVA)',105,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northampton MA Central Western Massachusetts (CWM)',106,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX (DAL)',107,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Danville IL VAMC (DAN)',108,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA DSS (DAT)',109,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dayton OH (DAY)',110,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bedford MA DSS (DBE)',111,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cleveland OH DSS (DCL)',112,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO (DCO)',113,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Distribution Center (DDC)',114,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO (DEN)',115,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Des Moines IA (DES)',116,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Detroit MI (DET)',117,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Denver Acquisition & Logistics Center (DLC)',118,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Manassas VA DSS (DMA)',119,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Murfreesboro TN DSS (DMU)',120,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dorchester MA Outpatient Clinic (DOR)',121,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dothan AL CAVHCS (DOT)',122,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bedford MA Decision Support System (DSO)',123,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dublin GA (DUB)',124,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC (DUR)',125,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Region 1 Data Center (DVR)',126,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Disability Examination Management Office (DXM)',127,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('East Orange NJ (EAS)',128,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Birmingham AL Ed Center (EBI)',129,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boise ID CHEP Ed. Center (EBO)',130,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Colorado Springs CO Eastern Colorado Health Care System (ECH)',131,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cleveland OH Ed Center (ECL)',132,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV ECSIP (ECS)',133,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dublin GA CHEP Ed. Center (EDB)',134,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC Ed Center (EDH)',135,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Erie PA CHEP Ed. Center (EER)',136,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Meade SD CHEP Ed. Center (EFM)',137,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('KS Eastern Kansas HCS (EKS)',138,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Long Beach CA Ed Center (ELB)',139,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lincoln NE CHEP Ed. Center (ELI)',140,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('El Paso TX (ELP)',141,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Little Rock AR Ed Center (ELR)',142,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minneapolis MN Ed Center (EMN)',143,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northport NY Ed Center (ENP)',144,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Orlando FL Ed Center - Orlando (EOR)',145,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Perry Point MD CHEP Ed. Center (EPP)',146,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Prescott AZ CHEP Ed. Center (EPR)',147,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Erie PA (ERI)',148,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO Engineering Training Center (ESC)',149,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT Ed Center (ESL)',150,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO Employee Education System (EST)',151,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('LittleRock AR Engineering Training Center (ETC)',152,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT Enterprise Test Center (ETL)',153,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Enterprise Test Center (ETN)',154,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Togus ME CHEP Ed. Center (ETO)',155,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA Enterprise Test Center (ETP)',156,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tuskegee AL CHEP Ed. Center (ETU)',157,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Albany NY Enterprise Test Center (ETY)',158,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Eureka CA (EUR)',159,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC Ed Center (EWA)',160,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV Enterprise Web Hosting (EWH)',161,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fairfield CA (FAI)',162,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fargo ND (FAR)',163,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fayetteville AR (FAV)',164,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Harrison MT (FHM)',165,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fayetteville NC (FNC)',166,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Framingham MA Outpatient Clinic (FRA)',167,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fresno CA (FRE)',168,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Financial Services Center (FSC)',169,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ft. Smith AR CBOC (FSM)',170,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Howard MD (FTH)',171,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Lyon CO DO NOT USE. Code is decomissioned 1/2011 (FTL)',172,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Meade SD (FTM)',173,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Rucker AL CAVHCS (FTR)',174,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fort Worth TX (FWO)',175,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Gainesville FL (GAI)',176,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA OGC Atlanta (GAT)',177,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD OGC Baltimore (GBA)',178,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Glen Burnie MD (GBC)',179,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA OGC Boston (GBO)',180,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bay Pines FL OGC Bay Pines (GBP)',181,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Buffalo NY OGC Buffalo (GBU)',182,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL OGC Chicago (GCH)',183,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cleveland OH OGC Cleveland (GCL)',184,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Detroit MI OGC Detroit (GDE)',185,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO OGC Denver (GDV)',186,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Houston TX OGC Houston (GHO)',187,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Indianapolis IN OGC Indianapolis (GIN)',188,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS OGC Jackson (GJA)',189,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minneapolis MN OGC Minneapolis (GMI)',190,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Nashville TN OGC Nashville (GNA)',191,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Brooklyn NY OGC Brooklyn (GNY)',192,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA OGC Philadelphia (GPH)',193,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Portland OR OGC Portland (GPO)',194,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Phoenix AZ OGC Phoenix (GPX)',195,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fresno CA (GRE)',196,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Grand Island NE (GRI)',197,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Grand Junction CO (GRJ)',198,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Francisco CA OGC San Francisco (GSF)',199,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO OGC St. Louis (GST)',200,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Guam   (GUA)',201,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Waco TX OGC Waco (GWA)',202,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sterling VA National Gateway East (GWE)',203,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Winston-Salem NC OGC Winston-Salem (GWI)',204,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL National Gateway North (GWN)',205,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX National Gateway South (GWS)',206,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Jose CA National Gateway West (GWW)',207,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Health Administration Center (HAC)',208,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hampton VA (HAM)',209,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hartford CT (HAR)',210,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Denver HRC (HCO)',211,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA Health Eligibility Center (HEC)',212,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Hines Finance Center (HFC)',213,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hilo HI Outpatient Clinic (HIL)',214,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL (HIN)',215,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD Baltimore HRC (HMD)',216,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Detroit MI Detroit HRC (HMI)',217,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS Jackson HRC (HMS)',218,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Honolulu HI NCPTSD (HNC)',219,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Honolulu HI (HON)',220,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hot Springs SD (HOT)',221,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Houston TX (HOU)',222,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hilo HI PRRP (HPR)',223,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Hines Remote Access (HRA)',224,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Topeka KS Health Revenue Center (HRC)',225,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Harrison AR CBOC (HRS)',226,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Oklahoma City OK Healthcare Talent Management Program Office (HTM)',227,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Huntington WV (HUN)',228,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hudson Valley NY Hudson Valley HCS (HVH)',229,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Indianapolis IN (IND)',230,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA Philadelphia Insurance Center (INS)',231,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Iowa City IA (IOW)',232,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Iron Mountain MI VAMC (IRO)',233,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Albany NY CIO Field Office (ISA)',234,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Birmingham AL CIO Field Office (ISB)',235,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX CIO Field Office (ISD)',236,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Francisco CA CIO Field Office (ISF)',237,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL CIO Field Office (ISH)',238,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT CIO Field Office (ISL)',239,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bay Pines FL CIO Field Office (ISP)',240,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tuscaloosa AL CIO Field Office (IST)',241,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Silver Spring MD CIO Field Office (ISW)',242,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Birmingham AL IVM (IVB)',243,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA IVM (IVM)',244,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS (JAC)',245,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jacksonville FL Outpatient Clinic (JAX)',246,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jay OK CBOC (JAY)',247,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kansas City MO (KAN)',248,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kauai HI (KAU)',249,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Knoxville IA (KNX)',250,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kona HI (KON)',251,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lake City FL (LAK)',252,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Los Angeles CA (LAN)',253,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Las Vegas NV (LAS)',254,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Leavenworth KS (LEA)',255,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lebanon PA (LEB)',256,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lexington KY (LEX)',257,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lincoln NE (LIN)',258,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Little Rock AR (LIT)',259,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Livermore CA (LIV)',260,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Langley MD (LNG)',261,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Loma Linda CA (LOM)',262,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Long Beach CA (LON)',263,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Los Angeles CA (LOS)',264,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Louisville KY (LOU)',265,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Loch Raven MD (LRC)',266,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lowell MA Outpatient Clinic (LWL)',267,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Lyons NJ (LYN)',268,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinez CA Northern California Health System (MAC)',269,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Madison WI (MAD)',270,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mare Island CA (MAI)',271,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Manchester NH (MAN)',272,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD Maryland HCS (MAR)',273,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC VACO (MAS)',274,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Maui HI (MAU)',275,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Miles City MT (MCM)',276,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minden CA (MDN)',277,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Memphis TN (MEM)',278,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Montgomery AL (MGY)',279,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD Maryland HCS (MHS)',280,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Miami FL (MIA)',281,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minneapolis MN (MIN)',282,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC VACO (CIO) (MIR)',283,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mission CA (MIS)',284,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Milwaukee WI (MIW)',285,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Austin MLAC (MLA)',286,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Manassas VA DSS (MNS)',287,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV Operations Center (MOC)',288,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Modesto CA (MOD)',289,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Monterey CA (MON)',290,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Montrose NY (MOR)',291,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mountain Home TN (MOU)',292,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Menlo Park CA (MPD)',293,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Manila PI (MPI)',294,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Marion IL (MRN)',295,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Milwaukee WI Contract Service Center (MSC)',296,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT NMDC (MSL)',297,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO NMDC (MST)',298,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mt. Vernon AR CBOC (MTV)',299,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Murfreesboro TN (MUR)',300,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Muskogee OK (MUS)',301,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC NMDC (MWA)',302,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV (MWV)',303,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Maxwell AFB AL CAVHCS (MXL)',304,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Nashville TN (NAS)',305,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('North Chicago IL (NCH)',306,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ann Arbor MI National Center for Patient Safety (NCP)',307,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV National Capital Regional Data Center (NCR)',308,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Newington CT (NCT)',309,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Newark NJ (NEW)',310,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Gainesville FL North Florida HCS (NFL)',311,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northampton MA (NHM)',312,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northern Indiana IN Northern Indiana HCS (NIN)',313,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New Jersey NJ New Jersey HCS (NJH)',314,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('North Little Rock AR ORM (NLR)',315,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV Network Operations Center (NOC)',316,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New Orleans LA (NOL)',317,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Northport NY (NOP)',318,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Falling Waters WV NSOC (NSF)',319,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL NSOC (NSH)',320,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Martinsburg WV  NSOC (NSM)',321,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX North Texas HCS (NTX)',322,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New York NY New York Harbor HCS (NYH)',323,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New York NY (NYN)',324,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Oakland CA (OAK)',325,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Oklahoma City OK (OKL)',326,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Omaha NE (OMA)',327,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Oakland CA Oakland Outpatient Center (OPC)',328,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Morrisville NC DO NOT USE. Code is decommissioned (OQP)',329,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Baltimore MD Office of Research & Development (ORD)',330,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Orlando FL (ORL)',331,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ozark AR CBOC (OZK)',332,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Palo Alto CA (PAL)',333,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pasay City Philippines (PAS)',334,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Pharmacy Benefits Management (PBM)',335,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Culpeper VA Terremark location (PCP)',336,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Miami FL Terremark location (PCS)',337,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Fairfax VA Fairfax PEC (PEC)',338,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Perry Point MD (PER)',339,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA Philadelphia ITC (PHC)',340,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA (PHI)',341,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Phoenix AZ (PHO)',342,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Secaucus NJ R04 Data Center (PHS)',343,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA Highland Dr (PIH)',344,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA (PIT)',345,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('National USA Perimeter Network - East (PNE)',346,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('National USA Perimeter Network - North (PNN)',347,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('National USA Perimeter Network - South (PNS)',348,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('National USA Perimeter Network - West (PNW)',349,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pocomoke MD (POC)',350,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Poplar Bluff MO (POP)',351,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Portland OR (POR)',352,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA (PPA)',353,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Hines Pre-Production (PPP)',354,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Prescott AZ (PRE)',355,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Providence RI (PRO)',356,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA (PRS)',357,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC VA Nat. Center for Health Promotion & Disease Prev (PRV)',358,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC (PSG)',359,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA (Aspinwall) (PTA)',360,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA (PTB)',361,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA Pittsburgh HCS (PTH)',362,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Seattle WA Puget Sound HCS (PUG)',363,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC QMI Center (QMI)',364,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Quantico VA NULL (QUA)',365,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Quincy MA Outpatient Clinic (QUI)',366,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Richmond VA Rehab (RBA)',367,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Benetia CA Rehab (RBE)',368,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bay Pines FL Rehab (RBP)',369,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Chicago IL Rehab (RCH)',370,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX Rehab (RDA)',371,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Denver CO Rehab (RDE)',372,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Reno NV Reno Eye Clinic (REC)',373,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Redding CA (RED)',374,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Reno NV (REN)',375,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Richmond VA (RIC)',376,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Saint Louis MO Records Management Center (RMC)',377,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Roanoke VA (ROA)',378,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Roseburg OR (ROS)',379,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Providence RI Rehab (RPR)',380,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Research Triangle Park NC R06 (RTP)',381,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA (SAC)',382,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Saginaw MI (SAG)',383,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Juan PR (SAJ)',384,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salem VA (SAM)',385,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Antonio TX (SAT)',386,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salisbury NC (SBY)',387,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Los Angeles CA Southern California System of Clinics (SC2)',388,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ft. Lyons CO Southern Colorado Health Care System (SCH)',389,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA Region 1 Data Center (SCR)',390,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Diego CA (SDC)',391,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL S&D (SDH)',392,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Philadelphia PA Philly SDT (SDT)',393,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Seattle WA (SEA)',394,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sepulveda CA (SEP)',395,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Francisco CA (SFC)',396,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sioux Falls SD VAM&ROC (SFX)',397,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sheridan WY (SHE)',398,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Shreveport LA (SHR)',399,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Hines SIE (SIE)',400,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Jose CA (SJC)',401,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Salt Lake City UT (SLC)',402,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA Sacramento (McClellan) (SMC)',403,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA Sacramento Mental Health Clinic (SMH)',404,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sacramento CA Sacramento (McClellan New) (SMN)',405,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Saint Louis MO (SMO)',406,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL Security Operations Center (SOC)',407,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sonora CA (SON)',408,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Paul MN (SPL)',409,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Spokane WA (SPO)',410,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Petersburg FL (SPT)',411,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Santa Rosa CA (SRO)',412,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('South San Francisco CA (SSF)',413,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Cloud MN (STC)',414,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Stockton CA (STK)',415,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Louis MO (STL)',416,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('South Texas TX HCS (STX)',417,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Sioux Falls SD (SUX)',418,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Syracuse NY (SYR)',419,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tallahassee FL Outpatient Clinic (TAL)',420,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tampa FL (TAM)',421,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Temple TX (TEM)',422,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Togus ME (TOG)',423,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tomah WI (TOM)',424,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Topeka KS (TOP)',425,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('VACO DC Telecommunications Support Office (TSO)',426,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tuscaloosa AL (TUA)',427,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tucson AZ (TUC)',428,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tuskegee AL CAVHCS (TUG)',429,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Tulare CA (TUL)',430,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Nashville TN Tennesee Valley HCS (TVH)',431,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ukiah CA (UKI)',432,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Buffalo NY Upstate New York (UNY)',433,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Boston MA VISN 01 (V01)',434,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Albany NY VISN 02 (V02)',435,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bronx NY VISN 03 (V03)',436,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Pittsburgh PA VISN 04 (V04)',437,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Linthicum MD VISN 05 (V05)',438,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Durham NC VISN 06 (V06)',439,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Atlanta GA VISN 07 (V07)',440,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bay Pines FL VISN 08 (V08)',441,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Nashville TN VISN 09 (V09)',442,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Cincinnati OH VISN 10 (V10)',443,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Ann Arbor MI VISN 11 (V11)',444,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Hines IL VISN 12 (V12)',445,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Kansas City MO VISN 15 (V15)',446,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS VISN 16 (V16)',447,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Grand Prairie TX VISN 17 (V17)',448,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Mesa AZ VISN 18 (V18)',449,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Glendale CO VISN 19 (V19)',450,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Portland OR VISN 20 (V20)',451,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Francisco CA VISN 21 (V21)',452,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Long Beach CA VISN 22 (V22)',453,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Minneapolis MN VISN 23 (V23)',454,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Vancouver WA ORM (VAN)',455,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Austin TX Vet Center (VAU)',456,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Bossier City LA Vet Center (VBO)',457,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Harlingen TX Valley Coastal Bend HCS (VCB)',458,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Corpus Christi TX Vet Center (VCO)',459,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Dallas TX Vet Center (VDA)',460,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('El Paso TX Vet Center (VEL)',461,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Houston TX Vet Center (VHO)',462,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Houston TX Vet Center (VVRC) (VHV)',463,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jackson MS Vet Center (VJK)',464,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Jacksonville   Vet Center (VJV)',465,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Midland TX Vet Center (VMI)',466,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('New Jersey NJ Vet Center (VNJ)',467,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Petersburg FL Vetsnet (St. Pete) (VNT)',468,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('San Antonio TX Vet Center (VSA)',469,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('St. Petersburg FL Vet Center (VSP)',470,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Savannah GA Vet Center (VSV)',471,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC Virtual VA (VVA)',472,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Waco TX (WAC)',473,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Washington DC VAMC (WAS)',474,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('WilkesBarre PA (WBP)',475,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('White City OR (WCO)',476,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Warner Robbins GA (WGA)',477,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Haven CT (WHC)',478,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Wichita KS (WIC)',479,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Wilmington DE (WIM)',480,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Winston-Salem NC (WIN)',481,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Los Angeles CA (WLA)',482,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Buffalo NY Western New York HCS (WNY)',483,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Worchester MA Outpatient Clinic (WOR)',484,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Worchester MA Vet Center (WOV)',485,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Palm Beach FL (WPB)',486,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('White River Junction VT (WRJ)',487,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('West Roxbury MA (WRX)',488,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Waco TX (WTX)',489,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('Walla Walla WA (WWW)',490,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());

INSERT INTO [AHOBPR].[STD_WORK_LOCATION] (WORK_LOCATION,ORDINAL_VALUE, CREATEDBY,UPDATEDBY,CREATED,UPDATED) VALUES ('OTHER (ZZZ)',491,'AHOBPR DBA', 'AHOBPR DBA', getdate(), getdate());
GO

---------------------------------------------------------------------------------------------------------
PRINT 'UPDATE [dbo].[STD_ROLE]';
GO
---------------------------------------------------------------------------------------------------------
DECLARE @PageId INT, @AdminRoleId INT, @AdvancedUserRoleId INT, @CareTeamRoleId INT, @RegistryId INT, @HelpDeskRoleId INT;
DECLARE @UserName VARCHAR(10) = 'AHOBPR DBA';
DECLARE @Today DateTime2 = GETDATE();

SET @RegistryId  = (SELECT ID FROM [dbo].[STD_REGISTRY] where [CODE] = N'AHOBPR');

-- Load STD_ROLE
WITH  MasterData
AS    ( 
        SELECT *
        FROM    ( VALUES  
               (N'AHOBPR_REGISTRY_MANAGER', N'AHOBPR Registry Manager', N'AHOBPR Registry Manager who is a super user of the registry', 1, 1),
               (N'AHOBPR_ADVANCED_USER', N'AHOBPR Advanced User', N'AHOBPR Advanced User', 2, 0),
               (N'AHOBPR_CARE_TEAM',    N'AHOBPR Care Team',    N'AHOBPR Care Team', 3, 0),
			   (N'AHOBPR_HELP_DESK',    N'AHOBPR Help Desk',    N'AHOBPR Help Desk', 4, 0))
       AS MasterRecord(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER, SUPER_USER_FLAG)
       )
MERGE
  INTO  [dbo].[STD_ROLE] AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE], [NAME], [DESCRIPTION_TEXT], [SORT_ORDER], [INACTIVE_FLAG], [INACTIVE_DATE], [CREATEDBY], [UPDATEDBY], [CREATED], [UPDATED], [PARENT_ROLE_ID], [STD_REGISTRY_ID], [SUPER_USER_FLAG]) 
        VALUES
        (Src.CODE, Src.NAME, Src.DESCRIPTION_TEXT, Src.SORT_ORDER, 0, NULL,  @UserName, @UserName, @Today,@Today, NULL, @RegistryId, Src.SUPER_USER_FLAG)
 WHEN MATCHED 
 THEN UPDATE SET Tgt.[NAME] = Src.Name,
                 Tgt.DESCRIPTION_TEXT = Src.DESCRIPTION_TEXT,
                 Tgt.SORT_ORDER = Src.SORT_ORDER,
                 Tgt.SUPER_USER_FLAG = Src.SUPER_USER_FLAG,
                 Tgt.STD_REGISTRY_ID = @RegistryId;

-- Load STD_APPPAGE
WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
				('AHOBPR ADMIN EDIT USERS','AHOBPR ADMIN EDIT USERS','AHOBPR Admin Edit Users',1),
				('AHOBPR ADMIN LIST USERS','AHOBPR ADMIN LIST USERS','AHOBPR Admin List Users',1),
				('AHOBPR ADMIN TRACKING','AHOBPR ADMIN TRACKING','AHOBPR ADMIN TRACKING',1),
				('AHOBPR ADMIN USER ROLE','AHOBPR ADMIN USER ROLE','AHOBPR Admin User Role',1),
				('AHOBPR CHANGE STATUS','AHOBPR CHANGE STATUS','AHOBPR CHANGE STATUS',1),
				('AHOBPR QUESTIONNAIRE FULL','AHOBPR QUESTIONNAIRE FULL','AHOBPR QUESTIONNAIRE FULL',1),
				('AHOBPR QUESTIONNAIRE SECTION','AHOBPR QUESTIONNAIRE SECTION','AHOBPR QUESTIONNAIRE SECTION',1),
				('AHOBPR QUESTIONNAIRE SUMMARY','AHOBPR QUESTIONNAIRE SUMMARY','AHOBPR QUESTIONNAIRE SUMMARY',1),
				('AHOBPR REGISTRANT SEARCH','AHOBPR REGISTRANT SEARCH','AHOBPR REGISTRANT SEARCH',1),
				('AHOBPR REGISTRANTS','AHOBPR REGISTRANTS','AHOBPR REGISTRANTS',1),
				('AHOBPR REGISTRY FLAG','AHOBPR REGISTRY FLAG','AHOBPR Registry Flag will be used to flag registrants',1),
				('AHOBPR Report Ad Hoc','AHOBPR Report Ad Hoc','AHOBPR Report Ad Hoc',1),
				('AHOBPR REPORT AGING','AHOBPR REPORT AGING','AHOBPR REPORT AGING',1),
				('AHOBPR Report Selected Questionnaire','AHOBPR Report Selected Questionnaire','AHOBPR Report Selected Questionnaire',1),
				('AHOBPR Report Status by Location','AHOBPR Report Status by Location','AHOBPR Report Status by Location',1),
				('AHOBPR SUBPOPULATION FLAG','AHOBPR SUBPOPULATION FLAG','AHOBPR SUBPOPULATION FLAG',1),
				('AHOBPR STATUS HISTORY','AHOBPR STATUS HISTORY', 'AHOBPR STATUS HISTORY',1),
				('AHOBPR REPORT PARTICIPATION','AHOBPR REPORT PARTICIPATION','AHOBPR REPORT PARTICIPATION',1),
				('AHOBPR REPORT CONTACT INFORMATION','AHOBPR REPORT CONTACT INFORMATION','AHOBPR REPORT CONTACT INFORMATION',1),
				('AHOBPR REPORT AD HOC BY LOCATION','AHOBPR REPORT AD HOC BY LOCATION','AHOBPR REPORT AD HOC BY LOCATION',1),
				('AHOBPR REPORT ELIGIBILITY REVIEW','AHOBPR REPORT ELIGIBILITY REVIEW','AHOBPR REPORT ELIGIBILITY REVIEW',1),
				('AHOBPR REGISTRANT INFORMATION','AHOBPR REGISTRANT INFORMATION','AHOBPR REGISTRANT INFORMATION',1),
				('AHOBPR REGISTRY MESSAGES','AHOBPR REGISTRY MESSAGES','AHOBPR REGISTRY MESSAGES',1),
				('AHOBPR ADMIN EDIT TEMPLATE','AHOBPR ADMIN EDIT TEMPLATE','AHOBPR ADMIN EDIT TEMPLATE',1),
				('AHOBPR SEND MESSAGE','AHOBPR SEND MESSAGE','AHOBPR SEND MESSAGE',1),
				('AHOBPR TOOL','AHOBPR TOOL','AHOBPR TOOL',1),
				('AHOBPR ADMIN ADD FLAGS','AHOBPR ADMIN ADD FLAGS','AHOBPR ADMIN ADD FLAGS',1),
				('AHOBPR MY TEMPLATES','AHOBPR MY TEMPLATES','AHOBPR MY TEMPLATES',1),
				('AHOBPR REPORT FOLLOW-UP QUESTIONS','AHOBPR REPORT FOLLOW-UP QUESTIONS','AHOBPR REPORT FOLLOW-UP QUESTIONS',1),
				('AHOBPR MY ACCOUNT','AHOBPR MY ACCOUNT','AHOBPR MY ACCOUNT',1),
				('AHOBPR NAME UPDATE','AHOBPR NAME UPDATE','AHOBPR NAME UPDATE',1),
        ('ERROR PAGE','ERROR PAGE','ERROR PAGE',1),
				('AHOBPR TIMEOUT','AHOBPR TIMEOUT','AHOBPR TIMEOUT',1),
				('AHOBPR SYSTEM CHECK','AHOBPR SYSTEM CHECK','AHOBPR SYSTEM CHECK',1),
				('AHOBPR ERROR PAGE','AHOBPR ERROR PAGE','AHOBPR ERROR PAGE',1),
				('AHOBPR CLINICAL USER AD-HOC REPORT','AHOBPR CLINICAL USER AD-HOC REPORT','AHOBPR CLINICAL USER AD-HOC REPORT',1),
				('AHOBPR DEPLOYMENT HISTORY','AHOBPR DEPLOYMENT HISTORY','AHOBPR DEPLOYMENT HISTORY',1))
   AS MasterRecord(CODE, NAME, DESCRIPTION_TEXT, SORT_ORDER)
       )
MERGE
  INTO  [dbo].STD_APPPAGE AS Tgt
  USING MasterData AS Src
  ON    Tgt.[CODE] = Src.CODE
 WHEN  NOT MATCHED
 THEN  INSERT
        ([CODE],[NAME],[DESCRIPTION_TEXT],[SORT_ORDER],[INACTIVE_FLAG],[INACTIVE_DATE],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
        VALUES
        (Src.CODE, Src.NAME, Src.DESCRIPTION_TEXT, Src.SORT_ORDER, 0, NULL,  @UserName, @UserName, @Today,@Today);

-- Load ROLE_PERMISSIONS
SET @AdminRoleId 		= (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_REGISTRY_MANAGER'); --100
SET @AdvancedUserRoleId = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_ADVANCED_USER'); --101
SET @CareTeamRoleId     = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_CARE_TEAM');--102
SET @HelpDeskRoleId     = (SELECT ID FROM STD_ROLE WHERE CODE = 'AHOBPR_HELP_DESK');

DELETE FROM [dbo].ROLE_PERMISSIONS WHERE STD_ROLE_ID IN(@AdminRoleId, @AdvancedUserRoleId, @CareTeamRoleId, @HelpDeskRoleId);

WITH  MasterData
AS    ( 
        SELECT *
        FROM   ( VALUES  
        -- Admin User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN EDIT USERS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN LIST USERS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN USER ROLE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR CHANGE STATUS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRY FLAG'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT PARTICIPATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT ELIGIBILITY REVIEW'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT FOLLOW-UP QUESTIONS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRY MESSAGES'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN EDIT TEMPLATE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SEND MESSAGE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TOOL'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN ADD FLAGS'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR NAME UPDATE'),@AdminRoleId),				
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@AdminRoleId),
        (AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@AdminRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@AdminRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@AdminRoleId),			
				(AHOBPR.GetAppPageId('AHOBPR CLINICAL USER AD-HOC REPORT'),@AdminRoleId),				
        	-- Advanced User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@AdvancedUserRoleId),
        (AHOBPR.GetAppPageId('AHOBPR CHANGE STATUS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT PARTICIPATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT FOLLOW-UP QUESTIONS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN ADD FLAGS'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY TEMPLATES'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@AdvancedUserRoleId),	
        (AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@AdvancedUserRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@AdvancedUserRoleId),				
		-- Care Team User Role
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE FULL'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SECTION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR QUESTIONNAIRE SUMMARY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANTS'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Ad Hoc'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AGING'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Selected Questionnaire'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR Report Status by Location'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT CONTACT INFORMATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REPORT AD HOC BY LOCATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@CareTeamRoleId),
        (AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@CareTeamRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@CareTeamRoleId),							
		-- Help Desk User Role
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT SEARCH'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR REGISTRANT INFORMATION'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ADMIN TRACKING'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR SUBPOPULATION FLAG'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR STATUS HISTORY'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR NAME UPDATE'),@HelpDeskRoleId),				
				(AHOBPR.GetAppPageId('AHOBPR MY ACCOUNT'),@HelpDeskRoleId),
        (AHOBPR.GetAppPageId('AHOBPR SYSTEM CHECK'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR TIMEOUT'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('AHOBPR ERROR PAGE'),@HelpDeskRoleId),
				(AHOBPR.GetAppPageId('ERROR PAGE'),@HelpDeskRoleId),		
				(AHOBPR.GetAppPageId('AHOBPR DEPLOYMENT HISTORY'),@HelpDeskRoleId)		
				)
   AS MasterRecord(AppPageId, RoleId)
       )
MERGE
  INTO  [dbo].ROLE_PERMISSIONS AS Tgt
  USING MasterData AS Src
  ON    Tgt.[STD_APPPAGE_ID] = Src.AppPageId
  AND   Tgt.STD_ROLE_ID = Src.RoleId
 WHEN  NOT MATCHED
 THEN  INSERT
	   ([STD_ROLE_ID],[STD_APPPAGE_ID],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED],[INSERT_FLAG],[UPDATE_FLAG],[DELETE_FLAG])
	VALUES(Src.RoleId, Src.AppPageId, @UserName, @UserName, @Today,@Today, 1, 1, 1);

  -- Note if the INSERT, UPDATE And DELETE flags are ever used and different for each entry, we will need to move them up into the Master Data
GO
---------------------------------------------------------------------------------------------------------
PRINT 'ALTER VIEW [AHOBPR].[VIEW_LOOKUP]';
GO
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO





--last updated in 3.0.10  script
ALTER VIEW [AHOBPR].[VIEW_LOOKUP] 
WITH SCHEMABINDING 
AS
SELECT 'REGISTRY_FLAG' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG
 WHERE STD_REGISTRY_FLAG_ID > 0
UNION ALL
SELECT 'REGISTRY_STATUS' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,ORDINAL_VALUE AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
 WHERE STD_REGISTRANT_STATUS_ID > 0
UNION ALL
SELECT 'REGISTRY_FLAG_TYPE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_TYPE_ID AS ID
       ,REGISTRY_FLAG_TYPE AS CODE
       ,REGISTRY_FLAG_TYPE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRY_FLAG_TYPE
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1 AND STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,ID 
       ,POSTALNAME AS CODE
       ,POSTALNAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM DBO.STD_STATE
WHERE COUNTRY_ID = 1006840
	  AND POSTALNAME IN ('AL', 'AK', 'AR', 'AZ', 'CA', 'CO', 'CT', 'DE', 'FL', 'GA', 'HI', 
	  'IA', 'ID', 'IL', 'IN', 'KS', 'KY', 'LA', 'MA', 'MD', 'ME', 'MI', 'MN', 'MO', 'MS', 
	  'MT', 'NC', 'ND', 'NE', 'NH', 'NJ', 'NM', 'NV', 'NY', 'OH', 'OK', 'OR', 'PA', 'RI', 
	  'SC', 'SD', 'TN', 'TX', 'UT', 'VA', 'VT', 'WA', 'WI', 'WV', 'WY', 'DC', 'AS', 'GU', 'PR', 'VI', 'MP', 'AA', 'AE', 'AP')
UNION ALL
SELECT 'STD_STATE' AS LOOKUP_TYPE  
	   ,0 
       ,'Foreign Country/Other' AS CODE
       ,'Foreign Country/Other' AS NAME
       ,0 AS PARENT_ID
       ,9999 AS SORT_ORDER 
UNION ALL
SELECT 'ADMINTRACKING_FLAG_ACTIVE' AS LOOKUP_TYPE  
	   ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE ACTIVE_FLAG = 1
  AND STD_REGISTRY_FLAG_TYPE_ID = 1 
  AND (PREDEFINED = 0 
		OR (PREDEFINED = 1 AND REGISTRY_FLAG_NAME = 'Eligibility Review - More Documentation Needed'))--2.0.13.1 changed this line
UNION ALL
SELECT 'STD_SERVICE_STATUS' AS LOOKUP_TYPE  
	   ,STD_SERVICE_STATUS_ID As ID
       ,SERVICE_STATUS AS CODE
       ,SERVICE_STATUS AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SERVICE_STATUS
 WHERE STD_SERVICE_STATUS_ID > 0
  UNION ALL
SELECT 'STD_FORM_QUESTION' AS LOOKUP_TYPE  
	     ,STD_FORM_QUESTION_ID As ID
       ,FORM_QUESTION_UNIQUE_ID AS CODE
       ,FORM_QUESTION_UNIQUE_ID AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM_QUESTION
UNION ALL
SELECT 'REGISTRY_STATUS_INELIGIBLE' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (3, 4, 5)
UNION ALL
SELECT 'REGISTRY_STATUS_REVIEWED' AS LOOKUP_TYPE  
	   ,STD_REGISTRANT_STATUS_ID AS ID
       ,REGISTRANT_STATUS AS CODE
       ,REGISTRANT_STATUS AS NAME
       ,0 AS PARENT_ID
       ,STD_REGISTRANT_STATUS_ID AS SORT_ORDER
  FROM AHOBPR.STD_REGISTRANT_STATUS
  WHERE STD_REGISTRANT_STATUS_ID IN (5, 8)
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,1 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,2 AS ID
       ,'Facility' AS CODE
       ,'Facility' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'REPORT_LOCATION' AS LOOKUP_TYPE  
	     ,3 AS ID
       ,'VISN' AS CODE
       ,'VISN' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'SUBPOPULATION_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 2
UNION ALL
SELECT 'ADMIN_FLAG_ALL' AS LOOKUP_TYPE  
	     ,STD_REGISTRY_FLAG_ID AS ID
       ,REGISTRY_FLAG_NAME AS CODE
       ,REGISTRY_FLAG_NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.STD_REGISTRY_FLAG
WHERE STD_REGISTRY_FLAG_TYPE_ID = 1
UNION ALL
SELECT 'HEALTH_FACTOR' AS LOOKUP_TYPE
	     ,A.[STD_HEALTH_FACTOR_ID] AS ID
       ,A.[NAME] AS CODE
       ,B.[DESCRIPTION] + ': ' + A.DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[STD_HEALTH_FACTOR] A INNER JOIN [AHOBPR].[STD_HEALTH_FACTOR_CATEGORY] B ON A.STD_HEALTH_FACTOR_CATEGORY_ID = B.STD_HEALTH_FACTOR_CATEGORY_ID
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT]
UNION ALL
SELECT DISTINCT 'DEPLOYMENT_COUNTRY_EXPOSURE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[DEPLOYMENT_COUNTRY] AS CODE
       ,[DEPLOYMENT_COUNTRY] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT_DEPLOYMENT] A JOIN AHOBPR.FORM_RESPONSE_QUESTION B
	ON A.REGISTRANT_DEPLOYMENT_ID = B.REGISTRANT_DEPLOYMENT_ID
	UNION ALL
SELECT 'STD_RACE' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_RACE'
  AND ID > 0
UNION ALL
SELECT 'STD_GENDER' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_GENDER'
  AND ID > 0
UNION ALL
SELECT 'STD_SEPARATIONFAMILY' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_FAMILY_ID] AS ID
        ,[FAMILY_CODE] AS CODE
        ,[FAMILY]  AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_FAMILY
  WHERE  [STD_SEPARATION_FAMILY_ID] > 0
 UNION ALL  
 SELECT 'STD_SEPARATIONREASON' AS LOOKUP_TYPE 
        ,[STD_SEPARATION_REASON_ID] AS ID
        ,[REASON_CODE] AS CODE
        ,[REASON] AS NAME
        ,0 AS PARENT_ID
        ,1 AS SORT_ORDER
   FROM AHOBPR.STD_SEPARATION_REASON
  WHERE  [STD_SEPARATION_REASON_ID] > 0
UNION ALL
SELECT 'STD_ELIGIBLITYSTATUS' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ELIGIBLITYSTATUS'
  AND ID > 0
UNION ALL
SELECT 'STD_ETHNICITY' AS LOOKUP_TYPE 
	     ,ID
       ,DESCRIPTION AS CODE
       ,DESCRIPTION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
FROM AHOBPR.VIEW_ETL_LOOKUP
WHERE TYPE = 'STD_ETHNICITY'
  AND ID > 0
UNION ALL 
 SELECT 'STD_CHARACTEROFSERVICE' AS LOOKUP_TYPE  
	     ,STD_DISCHARGE_CHARACTER_ID As ID
       ,DISCHARGE_CHARACTER_CODE AS CODE
       ,DISCHARGE_CHARACTER AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DISCHARGE_CHARACTER
UNION ALL
SELECT 'TEMPLATE_MESSAGE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 0 AND USER_FLAG = 0  -- Build 3.0.10
  AND TITLE NOT IN ('Eligible for Burn Pit Registry', 'Not Eligible for Burn Pit Registry', 
	'New Follow-up Questions', 'Need More Documentation', 'Name Updated')  -- Build 3.0.6 add 'Name Updated'
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,2 As ID,'multipleChoice' AS CODE,'Dropdown List - Multiple Choice' AS NAME,0 AS PARENT_ID,1 AS SORT_ORDER
UNION ALL
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,1 As ID,'multiSelect' AS CODE,'Checkboxes - Multiple Select' AS NAME,0 AS PARENT_ID,2 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,3 As ID,'text' AS CODE,'Radio Buttons with Free Text' AS NAME,0 AS PARENT_ID,3 AS SORT_ORDER
UNION ALL 
 SELECT 'TOOL_QUESTION_TYPE' AS LOOKUP_TYPE  
	     ,4 As ID,'number' AS CODE,'Radio Buttons with Numeric Value' AS NAME,0 AS PARENT_ID,4 AS SORT_ORDER
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_LIST' AS LOOKUP_TYPE  
	   ,STD_FORM_ID AS ID
       ,NAME AS CODE
       ,NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM A
  WHERE FOLLOWUP_FLAG = 1
  --Follow up Send Page > Deactivated groups showing in Drop down (272277)
   AND NOT EXISTS (SELECT 'X' FROM AHOBPR.TOOL_FORM WHERE TOOL_FORM_ID = A.TOOL_FORM_ID AND (ACTIVE_FLAG = 0 OR SYSTEM_WIDE_FLAG = 1))
UNION ALL
SELECT DISTINCT 'CONTACT_PREFERENCE' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[CONTACT_PREFERENCE] AS CODE
       ,[CONTACT_PREFERENCE] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
  WHERE CONTACT_PREFERENCE > ''
UNION ALL
SELECT 'MY_TEMPLATES_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,CREATEDBY AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND CREATEDBY_ADVANCED_USER_FLAG = 1
UNION ALL
SELECT DISTINCT 'ENROLLMENT_STATUS' AS LOOKUP_TYPE
	     ,0 AS ID
       ,[ENROLLMENT_STATUS] AS CODE
       ,[ENROLLMENT_STATUS] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[REGISTRANT]
   WHERE ENROLLMENT_STATUS > ''
UNION ALL
SELECT 'USER_ROLE' AS LOOKUP_TYPE    -- Build 3.0.7
	     ,A.ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [dbo].[STD_ROLE] A, [dbo].[STD_REGISTRY] B
  WHERE A.STD_REGISTRY_ID = B.ID AND B.CODE = 'AHOBPR'
UNION ALL
  SELECT DISTINCT 'AUDIT_ACTION_TYPE' AS LOOKUP_TYPE   -- Build 3.0.7
	     ,TYPE_ID AS ID
       , [DESCRIPTION] AS CODE
       , [DESCRIPTION] AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [AHOBPR].[AUDIT_LOG_TYPE]
  WHERE [DESCRIPTION] <> 'Data Maintenance'  
UNION ALL
SELECT 'FOLLOWUP_QUESTION_GROUP_DROPDOWN' AS LOOKUP_TYPE   -- Build 3.0.8 
          ,STD_FORM_ID AS ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_FORM A, AHOBPR.TOOL_FORM B
  WHERE A.FOLLOWUP_FLAG = 1 AND A.TOOL_FORM_ID = B.TOOL_FORM_ID
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,0 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,1 AS ID
       ,'Active' AS CODE
       ,'Active' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,2 AS ID
       ,'Inactive' AS CODE
       ,'Inactive' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'USER_STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,3 AS ID
       ,'Pending' AS CODE
       ,'Pending' AS NAME
       ,0 AS PARENT_ID
       ,4 AS SORT_ORDER
UNION ALL
SELECT 'USER_EMAIL_TEMPLATE_TITLE' AS LOOKUP_TYPE  
	   ,TEMPLATE_ID AS ID
       ,TITLE AS CODE
       ,TITLE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.EMAIL_TEMPLATES
  WHERE ACTIVE = 'True' AND USER_FLAG = 1  -- Build 3.0.10 
UNION ALL
SELECT 'USER_ROLE_ALL' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,0 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,0 AS SORT_ORDER
UNION ALL
SELECT 'USER_ROLE_ALL' AS LOOKUP_TYPE    -- Build 3.0.10
	     ,A.ID
       ,A.NAME AS CODE
       ,A.NAME AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM [dbo].[STD_ROLE] A, [dbo].[STD_REGISTRY] B
  WHERE A.STD_REGISTRY_ID = B.ID AND B.CODE = 'AHOBPR'
UNION ALL
SELECT 'STD_PRIMARY_JOB' AS LOOKUP_TYPE  -- PNV
	     ,STD_PRIMARY_JOB_ID AS ID
       ,PRIMARY_JOB AS CODE
       ,PRIMARY_JOB AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_PRIMARY_JOB
 WHERE STD_PRIMARY_JOB_ID > 0
UNION ALL
SELECT 'STD_SECONDARY_JOB' AS LOOKUP_TYPE  -- PNV
	     ,STD_SECONDARY_JOB_ID AS ID
       ,SECONDARY_JOB AS CODE
       ,SECONDARY_JOB AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_SECONDARY_JOB
 WHERE STD_SECONDARY_JOB_ID > 0
UNION ALL
SELECT 'STD_WORK_LOCATION' AS LOOKUP_TYPE  -- PNV
	     ,STD_WORK_LOCATION_ID AS ID
       ,WORK_LOCATION AS CODE
       ,WORK_LOCATION AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_WORK_LOCATION
 WHERE STD_WORK_LOCATION_ID > 0
 UNION ALL
 SELECT 'STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,1 AS ID
       ,'Active' AS CODE
       ,'Active' AS NAME
       ,0 AS PARENT_ID
       ,2 AS SORT_ORDER
UNION ALL
SELECT 'STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,2 AS ID
       ,'Inactive' AS CODE
       ,'Inactive' AS NAME
       ,0 AS PARENT_ID
       ,3 AS SORT_ORDER
UNION ALL
SELECT 'STATUS' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,3 AS ID
       ,'Pending' AS CODE
       ,'Pending' AS NAME
       ,0 AS PARENT_ID
       ,4 AS SORT_ORDER
UNION ALL
SELECT 'DEPLOYMENT_STAGE' AS LOOKUP_TYPE   -- Build 3.0.10 
       ,0 AS ID
       ,'All' AS CODE
       ,'All' AS NAME
       ,0 AS PARENT_ID
       ,0 AS SORT_ORDER
UNION ALL
SELECT 'DEPLOYMENT_STAGE' AS LOOKUP_TYPE  -- PNV
	     ,STD_DEPLOYMENT_STAGE_ID AS ID
       ,DEPLOYMENT_STAGE AS CODE
       ,DEPLOYMENT_STAGE AS NAME
       ,0 AS PARENT_ID
       ,1 AS SORT_ORDER
  FROM AHOBPR.STD_DEPLOYMENT_STAGE
 WHERE STD_DEPLOYMENT_STAGE_ID > 0
-- select * from  [AHOBPR].[VIEW_LOOKUP]
GO

---------------------------------------------------------------------------------------------------------
PRINT 'ALTER PROCEDURE [AHOBPR].[SP_ClinicalUserAdHocReport]';
GO
---------------------------------------------------------------------------------------------------------
-- ALTER PROCEDURE [AHOBPR].[SP_ClinicalUserAdHocReport]
IF OBJECT_ID('[AHOBPR].[SP_ClinicalUserAdHocReport]') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE [AHOBPR].[SP_ClinicalUserAdHocReport] AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO

SET ANSI_NULLS OFF
GO

SET QUOTED_IDENTIFIER OFF
GO

-- =============================================
-- Author:		Padmashri N. Valaparla
-- Create date: November 27, 2017
-- Description:	Used for the AHOBPR Clinical User Ad-Hoc Report
-- =============================================

ALTER PROCEDURE [AHOBPR].[SP_ClinicalUserAdHocReport]
  @actionTypeId varchar(30) = NULL, -- Action Type ID
  @fromDateText varchar(100) = NULL,
  @toDateText varchar(100) = NULL,
  @userRoleId varchar(30) = NULL, -- User role ID
  @StatusId varchar(30) = NULL, -- User Status ID
  @PrimaryJob varchar(8000) = NULL, -- Multiple Primary Job, comma-separated values when not NULL
  @WorkLocation varchar(8000) = NULL, -- Multiple Work Location, comma-separated values when not NULL  
  @SecondaryJob varchar(8000) = NULL, -- Multiple Secondary Job, comma-separated values when not NULL
  @ChangeStatusState  varchar(100) = NULL, -- Multiple states, comma-separated values when not NULL 
  @JobTitle varchar(80) = NULL -- Job Title 
AS

BEGIN
 DECLARE @fromDate DATETIME2(0) = NULL,
          @toDate DATETIME2(0) = NULL,
		  @Query VARCHAR(8000),
		  @State varchar(30) = NULL;

--Temp table for holding the AUDIT_LOG 
  CREATE TABLE #AUDIT_LOG
  ( 	
	  [TYPE_ID]               [tinyint]       NOT NULL,
	  [USER_ID]               [int]           NULL,
	  [REGISTRANT_ID]         [int]           NULL,
	  [NUMBER_OF_REGISTRANTS] [int]           NULL,
	  [MESSAGE]               [varchar](1000) NULL,
	  [CREATED]               [datetime]      NOT NULL
	 );

  INSERT INTO #AUDIT_LOG
    SELECT [TYPE_ID], [USER_ID],[REGISTRANT_ID],[NUMBER_OF_REGISTRANTS],[MESSAGE],[CREATED] 
	  FROM AHOBPR.AUDIT_LOG
	  WHERE USER_ID IS NOT NULL;

  -- Convert date parameters      
  SET @fromDate = dbo.CleanDate(@fromDateText);
  SET @toDate = dbo.AddMaxTime(dbo.CleanDate(@toDateText));

 IF @fromDate IS NOT NULL 
	  DELETE FROM #AUDIT_LOG WHERE CREATED < @fromDate

 IF @toDate IS NOT NULL 
	  DELETE FROM #AUDIT_LOG WHERE CREATED > @toDate
  
 IF @actionTypeId IS NOT NULL AND @actionTypeId != ''
	  DELETE FROM #AUDIT_LOG WHERE TYPE_ID <> @actionTypeId

IF @userRoleId IS NOT NULL AND @userRoleId != ''
	  DELETE FROM #AUDIT_LOG 
	    WHERE USER_ID NOT IN (SELECT A.USER_ID FROM DBO.USER_ROLES A,  #AUDIT_LOG B 
													  WHERE A.STD_ROLE_ID = @userRoleId AND A.USER_ID = B.USER_ID);

  
SET @Query = 'SELECT U.LAST_NAME, U.FIRST_NAME, AHOBPR.GetUserRolesByID(U.USER_ID) AS ROLES,P.PRIMARY_JOB, U.JOB_TITLE,
				CASE WHEN (D.ACTIVE_FLAG = 1 AND D.PENDING_FLAG = 0) THEN ''Active'' 
					WHEN (D.ACTIVE_FLAG = 0 AND D.PENDING_FLAG = 0) THEN ''Inactive''
					WHEN D.PENDING_FLAG = 1 THEN ''Pending'' 
					END AS Status,  W.WORK_LOCATION,F.STATES	 
			   FROM [AHOBPR].[AHOBPR_USER] D
					LEFT OUTER JOIN DBO.USERS U ON D.USER_ID = U.USER_ID
					LEFT OUTER JOIN [AHOBPR].[STD_PRIMARY_JOB] P ON D.PRIMARY_JOB_ID = P.STD_PRIMARY_JOB_ID
					LEFT OUTER JOIN [AHOBPR].[STD_WORK_LOCATION] W ON D.WORK_LOCATION_ID = W.STD_WORK_LOCATION_ID ';

IF @ChangeStatusState <> NULL
	BEGIN
		Select @State = AHOBPR.GetStateCodeByID (@ChangeStatusState);
		SET @Query = @Query + ' JOIN [AHOBPR].[USER_STATES_FILTER] F ON F.USER_ID = U.USER_ID';
		SET @Query = @Query + ' AND STATES LIKE (''%' + @State + '%'') ';
	END
ELSE
	SET @Query = @Query + ' LEFT JOIN [AHOBPR].[USER_STATES_FILTER] F ON F.USER_ID = U.USER_ID';


IF @actionTypeId <> NULL OR (@fromDateText <> NULL and @toDateText <> NULL)
	BEGIN
		SET @Query = @Query + ' JOIN (select distinct USER_ID from #AUDIT_LOG ';
		SET @Query = @Query + ' ) L on L.USER_ID = U.USER_ID ';
	END

SET @Query = @Query + ' WHERE 1 = 1 ';

				
IF @userRoleId <> NULL
	IF @userRoleId = 100  
		SET @Query = @Query + 'AND AHOBPR.GetUserRolesByID(U.USER_ID) like (''%Registry%'') ';
	IF @userRoleId = 101
		SET @Query = @Query + 'AND AHOBPR.GetUserRolesByID(U.USER_ID) like (''%Advanced%'') ';
	IF @userRoleId = 102
		SET @Query = @Query + 'AND AHOBPR.GetUserRolesByID(U.USER_ID) like (''%Care Team%'') ';
	IF @userRoleId = 417
		SET @Query = @Query + 'AND AHOBPR.GetUserRolesByID(U.USER_ID) like (''%Help Desk%'') ';


IF @StatusId = 1
     SET @Query = @Query + 'AND D.ACTIVE_FLAG = 1 AND D.PENDING_FLAG = 0';

IF @StatusId = 2
     SET @Query = @Query + 'AND D.ACTIVE_FLAG = 0 AND D.PENDING_FLAG = 0';

IF @StatusId = 3
     SET @Query = @Query + 'AND D.PENDING_FLAG = 1 ';


IF ISNULL(@PrimaryJob,'') > ''
    BEGIN
      SET @PrimaryJob = REPLACE(@PrimaryJob,',',''',''');
      SET @Query = @Query + ' AND PRIMARY_JOB_ID IN ( ''' + @PrimaryJob + ''') ';
		      		
	END

IF ISNULL(@SecondaryJob,'') > ''
    BEGIN
      SET @SecondaryJob = REPLACE(@SecondaryJob,',',''',''');
      SET @Query = @Query + ' AND SECONDARY_JOB_ID IN ( ''' + @SecondaryJob + ''') ';
		      		
	END

IF ISNULL(@WorkLocation,'') > ''
    BEGIN
      SET @WorkLocation = REPLACE(@WorkLocation,',',''',''');
      SET @Query = @Query + ' AND WORK_LOCATION_ID IN ( ''' + @WorkLocation + ''') ';
		      		
	END 		

IF @JobTitle <> NULL
	SET @Query = @Query + 'AND JOB_TITLE like (''%' + @JobTitle + '%'') ';


PRINT  @Query;
  
EXECUTE (@Query);  
	
END

GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

---------------------------------------------------------------------------------------------------------
PRINT 'ALTER PROCEDURE [AHOBPR].[SP_UpdateRegistrant]';
GO
---------------------------------------------------------------------------------------------------------
-- ALTER PROCEDURE [AHOBPR].[SP_UpdateRegistrant]
IF OBJECT_ID('[AHOBPR].[SP_UpdateRegistrant]') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE [AHOBPR].[SP_UpdateRegistrant] AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
ALTER PROCEDURE [AHOBPR].[SP_UpdateRegistrant] 
    @REGISTRANT_ID int,
    @RACE varchar(50),
    @ETHNICITY varchar(50),
    @DECEASED_FLAG bit,
    @DEATH_DATE date,
    @MARITAL_STATUS varchar(50),
    @EDUCATION_LEVEL varchar(50),
    @UPDATED datetime2(0),
	@UPDATEDBY varchar(30)
AS
BEGIN
    SET NOCOUNT ON;
	SET @UPDATEDBY = ISNULL(@UPDATEDBY, 'SP_UpdateRegistrant');
UPDATE [AHOBPR].[REGISTRANT]
   SET 
     [RACE] = @RACE
    ,[ETHNICITY] = @ETHNICITY
    ,[DECEASED_FLAG] = @DECEASED_FLAG
    ,[DEATH_DATE] = @DEATH_DATE
    ,[MARITAL_STATUS] = @MARITAL_STATUS
    ,[EDUCATION_LEVEL] = @EDUCATION_LEVEL
    ,[UPDATEDBY] = @UPDATEDBY
    ,[UPDATED] = @UPDATED

 WHERE [AHOBPR].[REGISTRANT].[REGISTRANT_ID] =  @REGISTRANT_ID;
END

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF OBJECT_ID('AHOBPR.SP_InsertIntoUpdatesProcessed') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE AHOBPR.SP_InsertIntoUpdatesProcessed AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO

ALTER PROCEDURE [AHOBPR].[SP_InsertIntoUpdatesProcessed]
	@notificationId			bigint,
	@registrantId			bigint,
	@edipi					VARCHAR(50),
  @processName			VARCHAR(100),
	@processStatus			VARCHAR(100),
	@processError			VARCHAR(4000) = NULL,
	@createdBy				VARCHAR(30)
AS
BEGIN

	SET NOCOUNT ON;

	INSERT INTO AHOBPR.UPDATES_PROCESSED_NOTIFICATION_STATUS (					  
		[UPDATES_BENS_REGISTRANT_NOTIFICATION_ID], 
		[REGISTRANT_ID],
		[EDIPI],
    [PROCESS_NAME],
		[PROCESS_STATUS],
		[PROCESS_ERROR],
		[CREATEDBY],
		[CREATED],
		[UPDATEDBY],
		[UPDATED])
	VALUES (			
		  @notificationId
		, @registrantId
		, @edipi
    , @processName
		, @processStatus
		, @processError
		, @createdBy
		, GETDATE()
		, @createdBy
		, GETDATE());

	SELECT SCOPE_IDENTITY();

END

---------------------------------------------------------------------------------------------------------
PRINT 'ALTER PROCEDURE [AHOBPR].[SP_GetPendingRegistrantUpdates]';
GO
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		Leon Mansfield
-- Create date: 2017-11-01
-- Description:	
-- =============================================
IF OBJECT_ID('AHOBPR.SP_GetPendingRegistrantUpdates') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE AHOBPR.SP_GetPendingRegistrantUpdates AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO
ALTER PROCEDURE [AHOBPR].[SP_GetPendingRegistrantUpdates] 
	-- Add the parameters for the stored procedure here
AS
BEGIN
	DECLARE @MaxQueueId int;
	DECLARE @MaxProcessDate datetime2(0);
	DECLARE @CREATEDBY varchar(30);
	SET @CREATEDBY = ISNULL(@CREATEDBY, 'SP_GetPendingRegistrantUpdates');
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	SET @MaxProcessDate = (SELECT MAX(CREATED) 
						   FROM [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] WITH (READPAST));
	SET @MaxProcessDate = ISNULL(@MaxProcessDate, '1900-01-01');
	PRINT @MaxProcessDate;
	INSERT
	 INTO	[AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] 
			(EDIPI, REGISTRANT_ID, CREATED, CREATEDBY)
	 SELECT UQ.EDIPI, REG.REGISTRANT_ID, UQ.CREATED, @CREATEDBY 
	 FROM   [AHOBPR].[UPDATES_BENS_NOTIFICATION] as UQ
	 JOIN   [AHOBPR].[REGISTRANT] REG ON UQ.EDIPI = REG.EDIPI
	 WHERE  UQ.CREATED > @MaxProcessDate;

--Step 5

	SELECT 
	[UPDATES_BENS_REGISTRANT_NOTIFICATION_ID],[EDIPI],[REGISTRANT_ID],[CREATEDBY],[CREATED]
	FROM [AHOBPR].[UPDATES_BENS_REGISTRANT_NOTIFICATION] q WITH (READPAST)
	WHERE NOT EXISTS (select * from [AHOBPR].[UPDATES_PROCESSED_NOTIFICATION_STATUS] s where s.[UPDATES_BENS_REGISTRANT_NOTIFICATION_ID] = q.[UPDATES_BENS_REGISTRANT_NOTIFICATION_ID]) ;
		
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'ALTER PROCEDURE [AHOBPR].[SP_InsertIntoBensUpdates]';
GO
---------------------------------------------------------------------------------------------------------
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF OBJECT_ID('AHOBPR.SP_InsertIntoBensUpdates') IS NULL -- Check if SP Exists
 EXEC('CREATE PROCEDURE AHOBPR.SP_InsertIntoBensUpdates AS SET NOCOUNT ON;') -- Create dummy/empty SP
GO
ALTER PROCEDURE [AHOBPR].[SP_InsertIntoBensUpdates] 
	-- Add the parameters for the stored procedure here
    @edipi VARCHAR(50)
AS
BEGIN
    SET NOCOUNT ON;
	DECLARE @createdby varchar(30);
	SET @createdby = ISNULL(@CREATEDBY, 'SP_InsertIntoBensUpdates');
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
    INSERT INTO  [AHOBPR].[UPDATES_BENS_NOTIFICATION]  ([EDIPI], [CREATEDBY], [CREATED])
    VALUES(
        @edipi, @CREATEDBY, GETDATE()
    );
--Step 5	
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Adding STD_PAYPLAN_ID to [REGISTRANT_DEPLOYMENT]';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') 
         AND name = 'STD_PAYPLAN_ID')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] 
	ADD STD_PAYPLAN_ID int	
END
GO
-- Add the FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE foreign key constraint if it does not exist
IF (OBJECT_ID('ahobpr.[FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN]', 'F') IS NULL)
BEGIN
	Print N'Trying to add foreign key FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN'
	ALTER 
		TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]  
		ADD  CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_STD_PAYPLAN] 
		FOREIGN KEY([STD_PAYPLAN_ID])
		REFERENCES [AHOBPR].[STD_PAYPLAN] ([STD_PAYPLAN_ID]);
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
PRINT 'Adding FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE to REGISTRANT_DEPLOYMENT';
---------------------------------------------------------------------------------------------------------

ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]  WITH CHECK ADD  CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_STD_DEPLOYMENT_STAGE] FOREIGN KEY([STD_DEPLOYMENT_STAGE_ID])
REFERENCES [AHOBPR].[STD_DEPLOYMENT_STAGE] ([STD_DEPLOYMENT_STAGE_ID])
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
PRINT 'Dropping  column MILITARY_RANK from REGISTRANT_DEPLOYMENT';
---------------------------------------------------------------------------------------------------------
IF  EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') 
         AND name = 'MILITARY_RANK')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]
		DROP COLUMN	[MILITARY_RANK]
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
PRINT 'Dropping  column STD_SERVICE_OCCUPATION_ID and constraints from REGISTRANT_DEPLOYMENT';
---------------------------------------------------------------------------------------------------------
-- Remove FK from REGISTRANT_DEPLOYMENT Table
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_OCCUPATION]', 'F') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_OCCUPATION';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_OCCUPATION;
END
GO
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_OCCUPATION]', 'D') IS NOT NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_OCCUPATION';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_OCCUPATION;
END
GO
IF (OBJECT_ID('[FK_REGISTRANT_DEPLOYMENT_OCCUPATION]', 'C') IS NOT  NULL)
BEGIN
	Print N'Trying to drop FK_REGISTRANT_DEPLOYMENT_OCCUPATION';
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] DROP CONSTRAINT FK_REGISTRANT_DEPLOYMENT_OCCUPATION;
END
GO
IF EXISTS (SELECT *  FROM  [sys].[default_constraints] 
		   WHERE  object_id = OBJECT_ID(N'ahobpr.FK_REGISTRANT_DEPLOYMENT_OCCUPATION') )
BEGIN
	ALTER 
		TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT] 
		DROP CONSTRAINT [FK_REGISTRANT_DEPLOYMENT_OCCUPATION];
END
GO
IF  EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_DEPLOYMENT]') 
         AND name = 'STD_SERVICE_OCCUPATION_ID')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_DEPLOYMENT]
		DROP COLUMN	[STD_SERVICE_OCCUPATION_ID]
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Add Columns PERSONNEL_CATEGORY_TYPE_CODE to [AHOBPR].[REGISTRANT_SERVICE_EPISODE] if it does not exist';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_SERVICE_EPISODE]') 
         AND name = 'PERSONNEL_CATEGORY_TYPE_CODE')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE]
		ADD	[PERSONNEL_CATEGORY_TYPE_CODE] [varchar](3) NULL
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Add constraint PERSONNEL_CATEGORY_TYPE_CODE to [AHOBPR].[REGISTRANT_SERVICE_EPISODE] if it does not exist';
---------------------------------------------------------------------------------------------------------
ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE]  WITH CHECK ADD  CONSTRAINT [FK_REGISTRANT_SERVICE_EPISODE_STD_COMPONENT] FOREIGN KEY([PERSONNEL_CATEGORY_TYPE_CODE])
REFERENCES [AHOBPR].[STD_COMPONENT] ([STD_COMPONENT_ID])
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Add constraint NARRATIVE_REASON_FOR_SEPARATION_TEXT to [AHOBPR].[REGISTRANT_SERVICE_EPISODE] if it does not exist';
---------------------------------------------------------------------------------------------------------
IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[AHOBPR].[REGISTRANT_SERVICE_EPISODE]') 
         AND name = 'NARRATIVE_REASON_FOR_SEPARATION_TEXT')
BEGIN
	ALTER TABLE [AHOBPR].[REGISTRANT_SERVICE_EPISODE]
		ADD	[NARRATIVE_REASON_FOR_SEPARATION_TEXT] [varchar](500) NULL
END
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
PRINT 'Create table [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION]';
---------------------------------------------------------------------------------------------------------
CREATE TABLE [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION]
(
	[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_ID] INT NOT NULL IDENTITY, 
    [STD_SERVICE_OCCUPATION_ID] INT NOT NULL, 
	[REGISTRANT_DEPLOYMENT_ID] INT NOT NULL,
	[OCCUPATION_TYPE] CHAR(1) NOT NULL,
	[START_DATE] [datetime2](0) NOT NULL,
	[CREATEDBY] [varchar](30) NOT NULL,
	[UPDATEDBY] [varchar](30) NOT NULL,
	[CREATED] [datetime2](0) NOT NULL,
	[UPDATED] [datetime2](0) NOT NULL,
	[ROW_VERSION] [timestamp] NOT NULL,
	 CONSTRAINT [PK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] PRIMARY KEY CLUSTERED 
(
	[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [AHOBPR]
) ON [AHOBPR]

 ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] WITH CHECK 
	ADD  CONSTRAINT [FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_STD_SERVICE_OCCUPATION] FOREIGN KEY ([STD_SERVICE_OCCUPATION_ID]) 
	REFERENCES [AHOBPR].[STD_SERVICE_OCCUPATION] ([STD_SERVICE_OCCUPATION_ID])
GO

ALTER TABLE  [AHOBPR].[REGISTRANT_SERVICE_SPECIFIC_OCCUPATION] WITH CHECK 
    ADD CONSTRAINT [FK_REGISTRANT_SERVICE_SPECIFIC_OCCUPATION_REGISTRANT_DEPLOYMENT] FOREIGN KEY([REGISTRANT_DEPLOYMENT_ID]) REFERENCES [AHOBPR].[REGISTRANT_DEPLOYMENT] ([REGISTRANT_DEPLOYMENT_ID])
GO
---------------------------------------------------------------------------------------------------------
PRINT 'Done';
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
print N'Update complete.';
print 'Completed ' + CAST(GETDATE() as varchar(20)) + '.';
---------------------------------------------------------------------------------------------------------
go

update  [dbo].[DatabaseChangeLog]
  set   ScriptDescription = 'Script Completed Successfully.'
  where [MajorReleaseNumber]  = '$(MajorReleaseNumber)'
    and [MinorReleaseNumber]  = '$(MinorReleaseNumber)'
    and [PointReleaseNumber]  = '$(PointReleaseNumber)'
    and [ScriptName]          = '$(ScriptName)'
    and TargetRegistry        = 'AHOBPR';
   
go
select * from [dbo].[DatabaseChangeLog]
where TargetRegistry        = 'AHOBPR'
  and [MajorReleaseNumber] = '$(MajorReleaseNumber)'
  and [MinorReleaseNumber] = '$(MinorReleaseNumber)'
  and [PointReleaseNumber] = '$(PointReleaseNumber)'
  and [ScriptName] = '$(ScriptName)';  
go

