﻿using NLog;
using System;
using System.IO;
using System.Net;

namespace BENSClientService
{
    /// <summary>
    /// This class is used to call the RESTful service endpoints used by AHOBPR
    /// </summary>
    public class RestfulClient
    {
        string url;
        string secretKey;
        private static Logger logger = LogManager.GetCurrentClassLogger();
        public RestfulClient(string url, string secretKey)
        {
            ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls |
                                       SecurityProtocolType.Tls11 |
                                       SecurityProtocolType.Tls12;
            this.url = url;
            this.secretKey = secretKey;
        }
        /// <summary>
        /// Call the RESTful URL to add this entry to AHOBPR.UPDATES_BENS_NOTIFICATION table
        /// </summary>
        /// <param name="edipi"></param>
        /// <returns></returns>
        public bool AddEdipiToDatabase(string edipi)
        {
            var addedToDb = false;
            try
            {
                var fullUrl = url + "/bens/queue/add/" + edipi;
                var request = WebRequest.Create(fullUrl);
                logger.Debug("REST service url: " + fullUrl);
                request.Method = "GET";
                request.ContentType = @"application/json; charset=utf-8";
                request.Headers.Add("Authorization", "Basic " + secretKey);
                logger.Debug($"Url: {request.RequestUri}");
                logger.Debug($"Auth: {request.Headers["Authorization"]}");
                using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
                {
                    var result = string.Empty;
                    using (StreamReader sr = new StreamReader(response.GetResponseStream()))
                    {
                        result = sr.ReadToEnd();
                        if (logger.IsDebugEnabled) {
                            var entry = LogEntryCleaner.Clean(result);
                            logger.Debug($"Response from REST service:  {entry}");
                        }
                        addedToDb |= result == @"{""AddEdipiForUpdateResult"":true}";
                    }
                }

            }
            catch(WebException ex)
            {
                logger.Error("WebException in AddEdipiToDatabase().");
                logger.Debug($"WebException in AddEdipiToDatabase(): {ex.Message}");
            }
            catch (Exception ex)
            {
                logger.Error("Exception in web request -- ");
                logger.Debug($"{nameof(ex)}: {ex.Message}");
            }
            return addedToDb;
        }
        /// <summary>
        /// Call the RESTful URL to process all new entries in AHOBPR.UPDATES_BENS_NOTIFICATION
        /// </summary>
        /// <returns></returns>
        public string ProcessBensQueue()
        {
            var result = string.Empty;
            try
            {
                
                var fullUrl = url + "/bens/update/all";
                logger.Debug($"Calling ProcessBensQueue(). REST service url: '{fullUrl}'");
                var request = WebRequest.Create(fullUrl);
                request.Method = "GET";
                request.ContentType = @"application/json; charset=utf-8";
                request.Headers.Add("Authorization", "Basic " + secretKey);

                using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
                {                 
                    using (StreamReader sr = new StreamReader(response.GetResponseStream()))
                    {
                        result = sr.ReadToEnd();
                        if (logger.IsDebugEnabled)
                        {
                            var entry = LogEntryCleaner.Clean(result);
                            logger.Debug($"Response from REST service: {entry}");
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                logger.Error($"Exception in ProcessBensQueue()");
                logger.Debug($"Exception: {ex.Message}");
                result = "{}";
            }
            return result;
        }
        
    }
}

