﻿using System;
using System.Threading.Tasks;
using Quartz;
using NLog;

namespace BENSClientService
{
    public class ResolveQueueJob : IJob
    {
        static Logger logger = LogManager.GetCurrentClassLogger();
        public async Task Execute(IJobExecutionContext context)
        {
            var result = string.Empty;
            try
            {
                var client = (RestfulClient)context.JobDetail.JobDataMap["client"];
                await Task.Run(() => client.ProcessBensQueue());
            }
            catch(Exception ex)
            {
                logger.Debug($"Error: {ex.Message}");
            }
            logger.Debug($"Result: '{result}'");
        }
    }
}
