﻿using System;
using System.Configuration;

namespace BENSClientService
{
    public class NightlyJobSettings : ConfigurationSection
    {
        static NightlyJobSettings settings = ConfigurationManager.GetSection("nightlyJob") as NightlyJobSettings;
        public static NightlyJobSettings Settings
        {
            get { return settings; }
        }
        [ConfigurationProperty("hour"
    , DefaultValue = 3
    , IsRequired = false)]
        [IntegerValidator(MinValue = 0
    , MaxValue = 23)]
        public int Hour
        {
            get { return (int)this["hour"]; }
            set { this["hour"] = value; }
        }
        [ConfigurationProperty("minute"
   , DefaultValue = 1
   , IsRequired = false)]
        [IntegerValidator(MinValue = 0
   , MaxValue = 59)]
        public int Minute
        {
            get { return (int)this["minute"]; }
            set { this["minute"] = value; }
        }
    }
}
