﻿
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using NLog;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using Quartz;

namespace BENSClientService
{
    public class RestfulClient 
    {
        RestfulClient client;
        private static Logger logger = LogManager.GetCurrentClassLogger();
        public RestfulClient(RestfulClient restClient)
        {
            client = restClient;
        }
        public bool AddEdipiToDatabase(string edipi)
        {
            var addedToDb = false;
            try
            {
                var fullUrl = client.URL + "/bensupdate/" + edipi;
                var request = WebRequest.Create(fullUrl);
                logger.Debug("REST service url: " + fullUrl);
                request.Method = "GET";
                request.ContentType = @"application/json; charset=utf-8";

                request.Headers.Add("Authorization", "Basic " + client.Key);

                using (HttpWebResponse response = (HttpWebResponse)request.GetResponse())
                {
                    var jsonResponse = string.Empty;
                    using (StreamReader sr = new StreamReader(response.GetResponseStream()))
                    {
                        jsonResponse = sr.ReadToEnd();
                        logger.Debug("Response from REST service: " + jsonResponse);
                        addedToDb |= jsonResponse == @"{""AddEdipiForUpdateResult"":true}";
                    }
                }

            }
            catch (Exception ex)
            {
                logger.Error("Exception in web request -- ");
                logger.Error(nameof(ex) + ": " + ex.Message);
            }
            return addedToDb;
        }
    }
}
