﻿using IBM.WMQ;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Collections.Specialized;
using System.Collections;
using IBM.XMS;
using NLog;

namespace BENSClientService
{
    public class BensMQProperties
    {
        static Logger logger = LogManager.GetCurrentClassLogger();
        private NameValueCollection appSettings;
        string _selector;
        public BensMQProperties(NameValueCollection applicationSettings)
        {
            if (applicationSettings != null)
            {
                this.appSettings = applicationSettings;

                //ConnectionInterval = int.Parse(appSettings["connectionIntervalInMS"]);
                Durability = appSettings["durability"];
                MQCHLLIB = appSettings["MQCHLLIB"];
                MQCHLTAB = appSettings["MQCHLTAB"];
                QueueManagerName = appSettings["queueManagerName"];
                SubscriptionName = appSettings["subscriptionName"];
                TopicName = appSettings["topicName"];
                Timeout = int.Parse(appSettings["timeout"]);
                Selector = appSettings["selectors"];
                if (appSettings.AllKeys.Contains("enableTracing"))
                {
                    if (bool.Parse(appSettings["enableTracing"]))
                    {
                        Environment.SetEnvironmentVariable("XMS_TRACE_ON", "1");
                        Environment.SetEnvironmentVariable("XMS_TRACE_FILE_PATH", appSettings["traceLogDir"]);
                        Environment.SetEnvironmentVariable("XMS_TRACE_FORMAT", "BASIC");
                        Environment.SetEnvironmentVariable("XMS_TRACE_SPECIFICATION", "*=all=enabled");
                    }
                }
                // logger.Debug($"Set ConnectionInterval: {ConnectionInterval}");
                if (logger.IsDebugEnabled)
                {
                    logger.Debug($"Set Durability: {LogEntryCleaner.Clean(Durability)}");
                    logger.Debug($"Set MQCHLLIB: {LogEntryCleaner.Clean(MQCHLLIB)}");
                    logger.Debug($"Set MQCHLTAB: {LogEntryCleaner.Clean(MQCHLTAB)}");
                    logger.Debug($"Set QueueManagerName: {LogEntryCleaner.Clean(QueueManagerName)}");
                    logger.Debug($"Set SubscriptionNme: {LogEntryCleaner.Clean(SubscriptionName)}");
                    logger.Debug($"Set TopicName: {LogEntryCleaner.Clean(TopicName)}");
                }
            }
            else
            {
                throw new ArgumentNullException(nameof(applicationSettings), "Null parameter passed to BensMQProperties constructor");
            }
        }

       // public int ConnectionInterval { get; set; }
        public string Durability { get; set; } = "durable";
        public string MQCHLLIB { get; set; }
        public string MQCHLTAB { get; set; }
        public string QueueManagerName { get; set; }
        public string Selector
        {
            get { return _selector; }
            set
            {
                if (value != null) { _selector = value; }
                else
                {
                    _selector = string.Empty;
                }
            }
        }
        public string SubscriptionName { get; set; }
        public int Timeout { get; set; }
        public MQTopic Topic { get; set; }
        public string TopicName { get; set; }

        public IConnectionFactory GetFactory(XMSFactoryFactory factory)
        {
            var cf = factory.CreateConnectionFactory();
            logger.Debug("Connection Factory created.");
            cf.SetStringProperty(XMSC.WMQ_HOST_NAME, appSettings["hostName"]);
            cf.SetIntProperty(XMSC.WMQ_PORT, int.Parse(appSettings["port"]));
            cf.SetStringProperty(XMSC.WMQ_CHANNEL, appSettings["channel"]);
            cf.SetIntProperty(XMSC.WMQ_CONNECTION_MODE, XMSC.WMQ_CM_CLIENT_UNMANAGED);
            cf.SetStringProperty(XMSC.WMQ_QUEUE_MANAGER, QueueManagerName);
            cf.SetStringProperty(XMSC.WMQ_SSL_KEY_REPOSITORY, appSettings["sslKeyRepository"]);
            cf.SetStringProperty(XMSC.WMQ_SSL_CIPHER_SPEC, appSettings["cipherSpec"]);
            cf.SetStringProperty(XMSC.WMQ_SSL_CIPHER_SUITE, appSettings["cipherSuite"]);
            cf.SetStringProperty(XMSC.CLIENT_ID, "BENSSecureClient");

            return cf;

        }
    }
}
