﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Remoting.Messaging;
using System.Web;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class EmailLogManager : AHOBPRBaseBO
    {
        static AHOBPRShared _sharedManager;

        public static AHOBPRShared sharedManager
        {
            get
            {
                if (_sharedManager == null)
                    _sharedManager = new AHOBPRShared();

                return _sharedManager;
            }
        }

        public static int LogMail(int registrantId, string eTo, string eCC, string eBCC, string subject, string body, string faliledrecipients, int templateId)
        {
            try
            {
                using (_dbAhopbr = GetDataContext())
                {
                    _dbAhopbr.SP_RecordEmailLog(templateId,
                                 registrantId,
                                 UserId,
                                 eTo,
                                 eCC,
                                 eBCC,
                                 subject,
                                 body,
                                 faliledrecipients,
                                 "DBA",
                                 "DBA");
                }
                return 0;
            }
            catch (Exception ex)
            {
                sharedManager.LogErrorMessage("Database Update", "AHOBPREmailLogManager.LogMail", ex.Message);
                return 0;
            }
        }

        private static int UserId
        {
            get
            {                
                int userId = 0;
                
                UserAccountManager user = (UserAccountManager)HttpContext.Current.User;
                userId = user.UserId;

                return userId;
            }
        }

    }
}
