﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.Specialized;
using System.Configuration;
using System.Net.Mail;


namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    [Serializable]
    public class EMailMessage
    {
        public AHOBPRShared _sharedManager = new AHOBPRShared();
        public MailMessage mail { get; set; }
        public StringCollection toList { get; set; }
        public string from { get; set; }


        public EMailMessage(string subject, string body, string from, StringCollection toAddressList)
        {
            mail = new MailMessage { Body = body, Subject = subject };
            foreach (string toAddress in toAddressList)
            {
                AddBccAddress(toAddress);
            }
            AddFromAddress(from);


        }
        public EMailMessage(string subject, string body, string fromAddress, string toAddress)
        {
            mail = new MailMessage { Subject = subject, Body = body };
            AddBccAddress(toAddress);
            AddFromAddress(fromAddress);
        }

        public void AddRecipient(StringCollection toAddressList)
        {
            foreach (string toAddress in toAddressList)
            {
                AddBccAddress(toAddress);
            }

        }

        public void AddRecipient(string toAddress)
        {
            AddBccAddress(toAddress);
        }

        public void AddBccAddress(string toAddress)
        {
            try
            {
                if (toAddress.Trim() != String.Empty)
                {
                    if (!mail.Bcc.Contains(new MailAddress(toAddress)))
                    {
                        mail.Bcc.Add(toAddress);
                    }
                }
            }
            catch (Exception exception)
            {
                _sharedManager.LogErrorMessage("Invalid email address - " + toAddress, "AHOBPREmailMessage.AddBccAddress", exception.ToString());
            }


        }
        public void AddFromAddress(string fromAddress)
        {
            try
            {
                if (fromAddress.Trim() != String.Empty)
                {
                    mail.From = new MailAddress(from);
                }
            }
            catch (Exception exception)
            {
                _sharedManager.LogErrorMessage("Invalid email address - " + fromAddress, "AHOBPREmailMessage.fromAddress", exception.ToString());
            }
        }


        public void SetField(String key, String value)
        {
            mail.Body = mail.Body.Replace("{" + key.ToUpper() + "}", value);
        }
                
        public bool Send(int registrantId, int templateId, int sendMessageType)
        {
            string emailSetting = "Y";
            bool toAddressExists = false;
            bool bccAddressExists = false;
            bool ccAddressExists = false;
            bool failure = false;
            if ((mail.Subject.Length == 0) || (mail.Body.Length == 0))
            {
                return false;
            }

            if ((mail.To != null) && (mail.To.Count > 0))
            {
                toAddressExists = true;
            }

            if ((mail.CC != null) && (mail.CC.Count > 0))
            {
                ccAddressExists = true;
            }

            if ((mail.Bcc != null) && (mail.Bcc.Count > 0))
            {
                bccAddressExists = true;
            }

            if (!(toAddressExists || bccAddressExists || ccAddressExists))
            {
                return false;
            }

            if (mail.From == null)
            {
                if (ConfigurationSettings.AppSettings["EmailFrom"] != null)
                {
                    mail.From = new MailAddress(ConfigurationSettings.AppSettings["EmailFrom"]);
                }
            }

            if (
                
                
                ConfigurationSettings.AppSettings["EmailEnabled"] != null)
            {
                emailSetting = ConfigurationSettings.AppSettings["EmailEnabled"];
            }

            if (emailSetting != "Y")
            {
                return true; //don't send anything, emailing is turned off
            }


            string bccAddresses = string.Join(";", (from MailAddress m in mail.Bcc select m.Address).ToArray());
            string ccAddresses = string.Join(";", (from MailAddress m in mail.CC select m.Address).ToArray());
            string toAddresses = string.Join(";", (from MailAddress m in mail.To select m.Address).ToArray());

            SmtpClient server = new SmtpClient();

            try
            {
                

                switch (sendMessageType)
                {
                    //email must be written to email log in order for notification to be sent to the registrant portal
                    //Send Notification only.  Only write to email log, don't send email.
                    case (int)Enums.messageType.sendNotification:
                        EmailLogManager.LogMail(registrantId, toAddresses, ccAddresses, bccAddresses, mail.Subject, mail.Body, "", templateId);
                        break;

                    default:
                        //server.EnableSsl = true;
                        server.Send(mail);
                        EmailLogManager.LogMail(registrantId, toAddresses, ccAddresses, bccAddresses, mail.Subject, mail.Body, "", templateId);
                        break;
                   
                }



               
            }

            catch (SmtpFailedRecipientsException ex)
            {
                failure = true;
                StringBuilder failedrcpts = new StringBuilder();

                for (int i = 0; i < ex.InnerExceptions.Length; i++)
                {
                    failedrcpts.Append(ex.InnerExceptions[i].FailedRecipient + "(Reason:" + ex.InnerExceptions[i].StatusCode.ToString() + ")");
                    failedrcpts.Append(",");
                }
                failedrcpts.Remove(failedrcpts.Length - 1, 1);
                EmailLogManager.LogMail(registrantId, toAddresses, ccAddresses, bccAddresses, mail.Subject, mail.Body, failedrcpts.ToString(), templateId);
                _sharedManager.LogErrorMessage("SmtpFailedRecipientsException", "AHOBPREmailMessage.Send", ex.ToString());

            }

            catch (SmtpFailedRecipientException ex)
            {
                failure = true;
                EmailLogManager.LogMail(registrantId, toAddresses, ccAddresses, bccAddresses, mail.Subject, mail.Body, ex.FailedRecipient + "(Reason:" + ex.StatusCode.ToString() + ")", templateId);
                _sharedManager.LogErrorMessage("SmtpFailedRecipientsException", "AHOBPREmailMessage.Send", ex.ToString());

            }
            catch (SmtpException ex)
            {
                failure = true;
                EmailLogManager.LogMail(registrantId, toAddresses, ccAddresses, bccAddresses, mail.Subject, mail.Body, "SmtpException", templateId);
                _sharedManager.LogErrorMessage("SmtpException", "AHOBPREmailMessage.Send", getLowestException(ex).ToString());

            }
            catch (Exception ex)
            {
                failure = true;
                EmailLogManager.LogMail(registrantId, toAddresses, ccAddresses, bccAddresses, mail.Subject, mail.Body, "GenericException", templateId);
                _sharedManager.LogErrorMessage("UnknownException", "AHOBPREmailMessage.Send", getLowestException(ex).ToString());

            }

            //Retry Logic - Will only retry if address count > 1
            if (failure == true && (mail.Bcc.Count > 1 || mail.To.Count > 1))
            {
                List<MailAddress> addresses = new List<MailAddress>();
                if (bccAddressExists)
                {
                    foreach (MailAddress addr in mail.Bcc)
                    {
                        addresses.Add(addr);
                    }
                }
                if (toAddressExists)
                {
                    foreach (MailAddress addr in mail.To)
                    {
                        addresses.Add(addr);
                    }
                }
                mail.To.Clear();
                mail.Bcc.Clear();
                mail.CC.Clear();
                foreach (MailAddress addr in addresses)
                {
                    mail.To.Clear();
                    mail.To.Add(addr);
                    try
                    {
                        //server.EnableSsl = true;
                        server.Send(mail);
                    }
                    catch (Exception ex)
                    {
                        EmailLogManager.LogMail(registrantId, addr.Address, "", "", mail.Subject, mail.Body, "Second Try", templateId);
                        _sharedManager.LogErrorMessage("Second Email Failure", "AHOBPREmailMessage.Send", getLowestException(ex).ToString());
                    }
                }
            }

            return true;
        }

        /// <summary>
        /// Returns the lowest Innerexception (which often has the most detailed information)
        /// </summary>
        /// <param name="e">Exception</param>
        /// <returns>Lowest inner exception</returns>
        public Exception getLowestException(Exception e)
        {
            int i = 0;
            //Just in case there is somehow an infinite loop of innerExceptions...
            while (e.InnerException != null && i < 10)
            {
                e = e.InnerException;
                i++;
            }
            return e;
        }
    }







}

