﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Data.SqlClient;
using System.Reflection;
using System.Data.Linq;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRQueueManager : AHOBPRBaseBO
    {
        private AHOBPRShared _sharedManager = new AHOBPRShared();

        #region Save Queue Batch
        public int AddQueueBatch(string registrantIds, int queueTypeId, int itemId, string itemDescription, int batchSize, string userIds)
        {
            int returnStatus = 0;

            if ((string.IsNullOrEmpty(registrantIds) && string.IsNullOrEmpty(userIds)) 
                || queueTypeId == 0 || (itemId == 0 && string.IsNullOrEmpty(itemDescription)))
            {
                return returnStatus;
            }

            using (_dbAhopbr = GetDataContext())
            {
                _dbAhopbr.DeferredLoadingEnabled = false;

                QUEUE_BATCH queueBatch = new QUEUE_BATCH();

                queueBatch.REGISTRANT_ID_BATCH = registrantIds;
                queueBatch.USER_ID_BATCH = userIds;
                queueBatch.STD_QUEUE_TYPE_ID = queueTypeId;
                queueBatch.ITEM_ID = itemId;
                queueBatch.ITEM_DESCRIPTION = itemDescription;
                queueBatch.STATUS = "new";
                queueBatch.BATCH_SIZE = batchSize;

                _dbAhopbr.QUEUE_BATCHes.InsertOnSubmit(queueBatch);

                try
                {
                    _dbAhopbr.SubmitChanges(ConflictMode.ContinueOnConflict);

                    returnStatus = 1;
                }
                catch (System.Data.SqlClient.SqlException ex)
                {
                    _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                    returnStatus = -1;
                }
                catch (ChangeConflictException e)
                {
                    _dbAhopbr.ChangeConflicts.ResolveAll(RefreshMode.KeepCurrentValues);

                    try
                    {
                        _dbAhopbr.SubmitChanges(ConflictMode.FailOnFirstConflict);
                        returnStatus = 1;
                    }
                    catch (Exception ex)
                    {
                        _sharedManager.LogErrorMessage("Database Update", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message);
                        returnStatus = -1;
                    }
                }
                catch
                {
                    returnStatus = 0;
                }

          }
            return returnStatus;
        }

        public IList<SP_GetQueueMonitorResult> GetQueueMonitorData()
        {
            try
            {
                using (AHOBPRLinqDataContext db = GetDataContext())
                {
                    //call stored procedure
                    IList<SP_GetQueueMonitorResult> results = db.SP_GetQueueMonitor().ToList();
                    return results;
                }
            }
            catch (Exception ex)
            {
                _sharedManager.LogErrorMessage("Sql Exception", this.GetType().Name + "." + MethodBase.GetCurrentMethod().Name, ex.Message + "\r\n" + ex.StackTrace);
                return null;
            }

        }

        #endregion
    }
}
