﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.ValueTypes;
using System.Reflection;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public class AHOBPRLookUpManager : AHOBPRBaseBO
    {
        Dictionary<string, string> unkCodeBySubject = new Dictionary<string, string>
        {
            {"race", "Z" },
            {"marital", "UNK" },
            {"ethnicity", "Z" }
        };
        const string UNKNOWNTEXT = "Unknown";
        const int UNKOWNEDUCATION = 99;
        public string GetRaceByCode(string code)
        {
            var result = string.Empty;
            code = string.IsNullOrEmpty(code) ? unkCodeBySubject["race"] : code;
            try
            {
                using (_dbAhopbr = GetDataContext())
                {
                    result = _dbAhopbr.STD_RACEs.FirstOrDefault(e => e.CODE == code).DESCRIPTION_TEXT;
                }
            }
            catch (Exception ex)
            {
                new AHOBPRShared().LogErrorMessage("LookupManager", "GetRaceByCode", ex.Message);
            }
            return (result != string.Empty) ? result : UNKNOWNTEXT;
        }
        public string GetMaritalStatusByCode(string code)
        {
            var result = string.Empty;
            code = string.IsNullOrEmpty(code) ? unkCodeBySubject["marital"] : code;
            //Using dbo.STD_MARITALSTATUS, so switching out EMIS outlier NeverMarried code with dbo code.
            try
            {
                using (_dbAhopbr = GetDataContext())
                {
                    result = _dbAhopbr.STD_MARITALSTATUS.FirstOrDefault(e => e.CODE == code).DESCRIPTION_TEXT;
                }
            }
            catch (Exception ex)
            {
                new AHOBPRShared().LogErrorMessage("LookupManager", "GetMaritalStatusByCode", ex.Message);
            }
            return (result != string.Empty) ? result : UNKNOWNTEXT;
        }
        #region Methods for Lookup Branch of Service
        public string GetBranchOfServiceById(int branchId)
        {
            using (_dbAhopbr = GetDataContext())
            {
                string branch = _dbAhopbr.STD_BRANCH_OF_SERVICEs
                                .FirstOrDefault(r => r.STD_BRANCH_OF_SERVICE_ID == branchId)
                                .BRANCH_OF_SERVICE;
                return branch;
            }
        }
        #endregion
        public string GetEthnicityByCode(string code)
        {
            code = string.IsNullOrEmpty(code) ? unkCodeBySubject["ethnicity"] : code;
            string result = string.Empty;
            if (!code.IsNullOrEmpty())
            {
                using (_dbAhopbr = GetDataContext())
                {
                    result = _dbAhopbr.STD_ETHNICITies.FirstOrDefault(e => e.CODE == code).TEXT;
                }
            }
            return (result == string.Empty) ? code : result;
        }

        public string GetEducationLevelByCode(int code)
        {
            code = code == 0 ? UNKOWNEDUCATION : code;
            string result = string.Empty;

            using (_dbAhopbr = GetDataContext())
            {
                result = _dbAhopbr.STD_EDUCATION_LEVELs.FirstOrDefault(e => e.CODE == code).DESCRIPTION_TEXT;
            }
            return (result == string.Empty) ? code.ToString() : result;
        }
    }
}
