﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Dynamic;
using System.Text;
using System.Data;
using System.Data.Linq;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessAHOBPR;

namespace VeteransAffairs.Registries.BusinessManagerAHOBPR
{
    public enum AhobprBaseControlType
    {
        None = 0,
        Label = 1,
        TextBox = 2,
        RadioButtonList = 3,
        DropDownList = 4,
        ListBox = 5,
        CheckBox = 6,
        RadioButtonListTextValue = 7
    }

    /// <summary>
    /// 
    /// </summary>
    [Serializable()]
    [System.ComponentModel.DataObject]
    public class AHOBPRBaseControlManager : AHOBPRBaseBO
    {
        /// <summary>
        /// Select GUI Controls from STD_GUI_CONTROLS table by category
        /// </summary>
        /// <param name="category"></param>
        /// <returns></returns>
        public List<STD_GUI_CONTROL_AHOBPR> SelectGuiControlList(string category)
        {
            using (_dbAhopbr = GetDataContext())
            {
                //SetLoadWithGuiControl(_dbAhopbr);

                if (AHOBPRGlobal.GuiControlAll == null)
                {
                    AHOBPRGlobal.GuiControlAll = SelectGuiControlAll().ToList();
                }

                List<STD_GUI_CONTROL_AHOBPR> entities = (from e in AHOBPRGlobal.GuiControlAll
                                                  where e.CATEGORY == category
                                                  orderby e.SORT_ORDER
                                                  orderby e.NAME
                                                  select e).ToList();

                return entities;

            }
        }


        /// <summary>
        /// Select all values from STD_GUI_CONTROLS_OBPR table
        /// </summary>
        /// <returns></returns>
        private IQueryable<STD_GUI_CONTROL_AHOBPR> SelectGuiControlAll()
        {
            int registryId = AHOBPRShared.GetRegistryID();
            IQueryable<STD_GUI_CONTROL_AHOBPR> linqFilter = (from e in _dbAhopbr.STD_GUI_CONTROL_AHOBPRs
                                                             where e.STD_REGISTRY_ID == registryId
                                                             select e);
            return linqFilter;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="lookupCategory"></param>
        /// <returns></returns>
        public List<AHOBPR_VIEW_LOOKUP> SelectLookupList(string lookupCategory)
        {
            using (_dbAhopbr = GetDataContext())
            {
                if (AHOBPRGlobal.ViewLookupAll == null)
                {
                    AHOBPRGlobal.ViewLookupAll = SelectViewLookupAll().ToList();
                }

                List<AHOBPR_VIEW_LOOKUP> entities = (from e in AHOBPRGlobal.ViewLookupAll
                                                     where e.LOOKUP_TYPE == lookupCategory
                                                     select e).ToList();

                return entities;

            }
        }
        public List<VIEW_FACILITY_LOOKUP> SelectFacilityLookupList(string lookupCategory)
        {
            using (_dbAhopbr = GetDataContext())
            {
                if (AHOBPRGlobal.ViewFacilityLookupAll == null)
                {
                    AHOBPRGlobal.ViewFacilityLookupAll = (from e in _dbAhopbr.VIEW_FACILITY_LOOKUPs
                                                          select e).ToList();
                }

                List<VIEW_FACILITY_LOOKUP> entities = (from e in AHOBPRGlobal.ViewFacilityLookupAll
                                                     where e.LOOKUP_TYPE == lookupCategory
                                                     orderby e.SORT_ORDER, e.NAME
                                                     select e).ToList();

                return entities;

            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="category"></param>
        /// <param name="parentId"></param>
        /// <returns></returns>
        public List<VIEW_FACILITY_LOOKUP> GetFacilityListByParentId(string category, int parentId)
        {
            List<VIEW_FACILITY_LOOKUP> results = new List<VIEW_FACILITY_LOOKUP>();
            if (parentId > 0)
            {
                results = SelectFacilityLookupList(category);
                results = results.Where(l => l.PARENT_ID == parentId).OrderBy(l => l.SORT_ORDER).ToList();
            }

            return results;
        }


        /// <summary>
        /// Select all values from VIEW_LOOKUP view
        /// </summary>
        /// <returns></returns>
        private IQueryable<AHOBPR_VIEW_LOOKUP> SelectViewLookupAll()
        {
            IQueryable<AHOBPR_VIEW_LOOKUP> linqFilter = (from e in _dbAhopbr.AHOBPR_VIEW_LOOKUPs
                                                      orderby e.LOOKUP_TYPE, e.SORT_ORDER, e.NAME
                                                      select e);
            return linqFilter;
        }

    }
}
