﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using AntiXssEnc = Microsoft.Security.Application;

public partial class controls_ToolQuestionPreview : System.Web.UI.UserControl
{
    //private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    //private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
    AHOBPRToolManager _toolManager = new AHOBPRToolManager();
    //private AHOBPRLookUpManager _lookupManager = new AHOBPRLookUpManager();

    protected void Page_Load(object sender, EventArgs e)
    {
       LoadControlsFromObject(Helpers.getIntFromString(HiddenFieldQuestionId.Value));                
    }

    public void LoadControlsFromObject(int questionId)
    {
        TOOL_QUESTION question = _toolManager.GetQuestionById(questionId);
        if (question != null)
        {
            LabelQuestion.Text = AntiXssEnc.Encoder.HtmlEncode(string.IsNullOrEmpty(HiddenFieldSequence.Value) ? "1. " + question.TEXT : HiddenFieldSequence.Value + ". " + question.TEXT);
            List<TOOL_ANSWER> answers = (from e in question.TOOL_ANSWERs
                                         orderby e.STANDARD_FLAG, e.ORDER
                                         select e).ToList();
            if (question.TYPE == "multipleChoice")
            {
                DropDownListAnswers.Visible = true;
                LabelForDropDownListAnswers.Visible = true;
                RepeaterRadioButtons.Visible = false;
                RepeaterCheckBoxes.Visible = false;
 
                DropDownListAnswers.DataSource = answers;
                DropDownListAnswers.DataTextField = "TEXT";
                DropDownListAnswers.DataValueField = "ORDER";
                DropDownListAnswers.DataBind();
            }
            else if (question.TYPE == "multiSelect")
            {
                DropDownListAnswers.Visible = false;
                LabelForDropDownListAnswers.Visible = false;
                RepeaterRadioButtons.Visible = false;
                RepeaterCheckBoxes.Visible = true;

                RepeaterCheckBoxes.DataSource = answers;
                RepeaterCheckBoxes.DataBind();
            }
            else
            {
                DropDownListAnswers.Visible = false;
                LabelForDropDownListAnswers.Visible = false;
                RepeaterCheckBoxes.Visible = false;
                RepeaterRadioButtons.Visible = true;

                RepeaterRadioButtons.DataSource = answers;
                RepeaterRadioButtons.DataBind();
            }
        }
        
    }

    public void LoadUserControl(int questionId)
    {
        HiddenFieldQuestionId.Value = questionId.ToString();
    }

    public string QuestionId
    {
        set
        {
            HiddenFieldQuestionId.Value = value;
        }
    }

    public string Sequence
    {
        set
        {
            HiddenFieldSequence.Value = value;
        }
    }
  
}
