﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class controls_UserControlQuestionnaire : System.Web.UI.UserControl
{
    private AHOBPRQuestionnaireManager _manager = new AHOBPRQuestionnaireManager();


    protected void Page_Load(object sender, EventArgs e)
    {

    }

    public string QuestionnaireVersion { get; set; }

    public void LoadControlsFromObject(int registrantId, QuestionnaireDisplayType displayType, int sectionId, int subSectionId)
    {
        HiddenFieldRegistrantId.Value = registrantId.ToString();
        HiddenFieldDisplayType.Value = displayType.ToString(); ;
        HiddenFieldSectionId.Value = sectionId.ToString();
        HiddenFieldSubSection.Value = subSectionId.ToString();
        SetPanelText(displayType, sectionId, subSectionId, registrantId);
        QuestionnaireVersion = _manager.GetQuestionnaireVersion(registrantId);

        if (IsSectionOneOne(registrantId, sectionId, subSectionId))
        {
            UserControlDeploymentHistory.LoadUserControl(registrantId);
            ShowDeploymentHistory();
        }
        else if (IsSectionOneTwo(registrantId, sectionId, subSectionId))
        {
            ShowDeploymentExposure();
        }
        else
        {
            ShowQuestionnaireResponse();
        }
    }

    private void ShowDeploymentHistory()
    {
        UserControlDeploymentHistory.Visible = true;
        GridViewQuestionnaire.Visible = false;
        RepeaterDeploymentExposure.Visible = false;
    }

    private void ShowDeploymentExposure()
    {
        RepeaterDeploymentExposure.Visible = true;
        UserControlDeploymentHistory.Visible = false;
        GridViewQuestionnaire.Visible = false;
    }

    private void ShowQuestionnaireResponse()
    {
        GridViewQuestionnaire.Visible = true;
        RepeaterDeploymentExposure.Visible = false;
        UserControlDeploymentHistory.Visible = false;
    }

    private bool IsSectionOneOne(int registrantId, int sectionId, int subSectionId)
    {
        bool result = false;
        if (_manager.GetSectionAndSubSectionBprId(registrantId, sectionId, subSectionId) == AHOBPRGlobal.FormSectionOneOneBprId)
        {
            result = true;
        }

        return result;
    }

    private bool IsSectionOneTwo(int registrantId, int sectionId, int subSectionId)
    {
        bool result = false;
        if (_manager.GetSectionAndSubSectionBprId(registrantId, sectionId, subSectionId) == AHOBPRGlobal.FormSectionOneTwoBprId)
        {
            result = true;
        }

        return result;
    }

    private void SetPanelText(QuestionnaireDisplayType displayType, int sectionId, int subSectionId, int registrantId)
    {
        if (displayType == QuestionnaireDisplayType.Summary)
        {
            PanelQuestionnaire.GroupingText = " Clinically Relevant Summary ";
            DisablePaging();
        }
        else if (displayType == QuestionnaireDisplayType.Full)
        {
            PanelQuestionnaire.GroupingText = " Full Questionnaire ";
            GridViewQuestionnaire.Columns[2].Visible = false;
        }
        else
        {
            var sectionDescription = _manager.GetSectionAndSubSectionDescription(registrantId, sectionId, subSectionId);
            PanelQuestionnaire.GroupingText = " Questionnaire Responses by Section > " + sectionDescription;
            GridViewQuestionnaire.Columns[1].Visible = false;
            DisablePaging();
        }
    }

    private void DisablePaging()
    {
        GridViewQuestionnaire.AllowPaging = false;
        GridViewQuestionnaire.DataSourceID = "ObjectDataSourceQuestionnaireNoPaging";
        GridViewQuestionnaire.DataBind();
    }


    public int RegistrantId { get; set; }
    public QuestionnaireDisplayType DisplayType { get; set; }
    public int SectionId { get; set; }
    public int SubSectionId { get; set; }

}
