﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserControlFollowupQuestions.ascx.cs" Inherits="controls_UserControlFollowupQuestions" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<script type = "text/javascript">
    $(document).ready(function() {

    if ($('#<%= CheckBoxFollowupQuestionGroup.ClientID %>').is(':checked')) {
        $('#<%= GridViewQuestionnaire.ClientID %>').show();
    }
    else {
        $('#<%= GridViewQuestionnaire.ClientID %>').hide();
    }

    $('#<%= CheckBoxFollowupQuestionGroup.ClientID %>').change(function() {
        if (this.checked) {
            $('#<%= GridViewQuestionnaire.ClientID %>').show();
        }
        else {
            $('#<%= GridViewQuestionnaire.ClientID %>').hide();
        }
    });
});
</script>

<asp:Panel ID="PanelFollowupQuestions" runat="server" role="heading" aria-level="3">
    <asp:ObjectDataSource 
        ID="ObjectDataSourceFollowupFormResponses" runat="server" 
            SelectMethod="GetFormResponsesFollowup" 
            SortParameterName="sort"
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRQuestionnaireManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="string" />
            <asp:ControlParameter ControlID="HiddenFieldFollowupFormId" Name="formId" PropertyName="Value" Type="String" />
            <asp:Parameter Name="sort" Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    <asp:CheckBox ID="CheckBoxFollowupQuestionGroup" runat="server" Text="" Font-Bold="true"  />
    <asp:GridView 
        ID="GridViewQuestionnaire" 
        runat="server" 
        DataSourceID="ObjectDataSourceFollowupFormResponses"
        AutoGenerateColumns="False" Width="100%"
        EnableModelValidation="True"
        Caption="Follow-up Questions" 
        DataKeyNames="FOLLOWUP_FORM_RESPONSE_QUESTION_ID">
    <EmptyDataTemplate>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No questionnaire responses found.&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</EmptyDataTemplate>
    <Columns>
        <asp:BoundField DataField="FOLLOWUP_FORM_RESPONSE_QUESTION_ID" HeaderText="Form Response Detail ID" Visible="false" />
       
       <asp:TemplateField HeaderText="Question ID" SortExpression="STD_FORM_QUESTION_ID">
          <HeaderStyle HorizontalAlign="Center"  />
          <ItemStyle HorizontalAlign="Left" />
          <ItemTemplate>
                <asp:Label ID="LabelQuestionId" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("STD_FORM_QUESTION.FORM_QUESTION_UNIQUE_ID")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        <asp:TemplateField HeaderText="Question" >
          <HeaderStyle HorizontalAlign="Center" />
          <ItemStyle HorizontalAlign="Left" />
          <ItemTemplate>
                <asp:Label ID="LabelQuestion" SkinID="DataLabel" runat="server" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("STD_FORM_QUESTION.TEXT"))) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

      <asp:TemplateField HeaderText="Answer(s)" >
            <ItemStyle HorizontalAlign="Left" />
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelAnswers" runat="server" SkinID="DataLabel" Text='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("Answers"))) %>'></asp:Label>
            </ItemTemplate>
      </asp:TemplateField>      
     </Columns>
</asp:GridView>
</asp:Panel>
<asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
<asp:HiddenField ID="HiddenFieldFollowupFormId" runat="server" />
