﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserControlFacilityDropdownLists.ascx.cs" Inherits="controls_UserControlFacilityDropdownLists" %>
<script type = "text/javascript">
    $(function() {

        if ($('#<%= DropDownListVisn.ClientID %>').val() == "" || $('#<%= DropDownListVisn.ClientID %>').val() == "0") {

            $('#<%= DropDownListMainFacility.ClientID %>').empty().append('<option selected="selected" value="0"></option>');
            $('#<%= DropDownListSubFacility.ClientID %>').empty().append('<option selected="selected" value="0"></option>');
            $('#<%= DropDownListMainFacility.ClientID %>').attr('disabled', 'disabled');
            $('#<%= DropDownListSubFacility.ClientID %>').attr('disabled', 'disabled');
            $('#<%= HiddenFieldMainFacility.ClientID %>').val('');
            $('#<%= HiddenFieldSubFacility.ClientID %>').val('');
        }
        else if ($('#<%= DropDownListMainFacility.ClientID %>').val() == "" || $('#<%= DropDownListMainFacility.ClientID %>').val() == "0") {

            $('#<%= DropDownListSubFacility.ClientID %>').empty().append('<option selected="selected" value="0"></option>');
            $('#<%= DropDownListSubFacility.ClientID %>').attr('disabled', 'disabled');
            $('#<%= HiddenFieldMainFacility.ClientID %>').val('');
            $('#<%= HiddenFieldSubFacility.ClientID %>').val('');
        }

        if ($('#<%= DropDownListVisn.ClientID %>').val() != "" && $('#<%= DropDownListVisn.ClientID %>').val() != "0") {
            var params = new Object();
            params.parentId = $('#<%= DropDownListVisn.ClientID %>').val();
            params.category = $('#<%= HiddenFieldCategoryMainFacility.ClientID %>').val();
            $.ajax(
           {
               type: "POST",
               data: $.toJSON(params),
               dataType: "json",
               contentType: "application/json; charset=utf-8",
               url: "controls/FillDropDownList.asmx/GetLookupListByParentId",
               success: function(response) {
                   if (response.d == "") {
                       $('#<%= DropDownListMainFacility.ClientID %>').attr('disabled', 'disabled');
                   }
                   else {
                       $('#<%= DropDownListMainFacility.ClientID %>').removeAttr('disabled');
                   }
                   $('#<%= DropDownListSubFacility.ClientID %>').empty().append('<option selected="selected" value="0"></option>');
                   $('#<%= DropDownListSubFacility.ClientID %>').attr('disabled', 'disabled');
                   $('#<%= DropDownListMainFacility.ClientID %>').populateSelect(response.d);

                   if ($('#<%= HiddenFieldMainFacility.ClientID %>').val() !== "") {
                       $('#<%= DropDownListMainFacility.ClientID %>').val($('#<%= HiddenFieldMainFacility.ClientID %>').val());
                   }

                   if ($('#<%= HiddenFieldClosestFacility.ClientID %>').val() == "True")
                   {
                       EnableDisableRequiredValidator("<%= DropDownListVisn.ClientID %>", "<%= RequiredFieldValidatorMainFacility.ClientID %>");
                   }
               },
               failure: function(response) {
                   alert(response.d);
               }
           });
        }

        //  select a value from the first dropdown list
        $('#<%= DropDownListVisn.ClientID %>').change(function() {
            $('#<%= DropDownListMainFacility.ClientID %>').val('');
            $('#<%= HiddenFieldMainFacility.ClientID %>').val('');
            $('#<%= HiddenFieldSubFacility.ClientID %>').val('');
            if ($(this).val() == "" || $(this).val() == "0") {

                $('#<%= DropDownListMainFacility.ClientID %>').empty().append('<option selected="selected" value="0"></option>');
                $('#<%= DropDownListSubFacility.ClientID %>').empty().append('<option selected="selected" value="0"></option>');
                $('#<%= DropDownListMainFacility.ClientID %>').attr('disabled', 'disabled');
                $('#<%= DropDownListSubFacility.ClientID %>').attr('disabled', 'disabled');
                if ($('#<%= HiddenFieldClosestFacility.ClientID %>').val() == "True")
                {
                    EnableValidator("<%= RequiredFieldValidatorMainFacility.ClientID %>", false);
                }
            }
            else {
                var params = new Object();
                params.parentId = $(this).val();
                params.category = $('#<%= HiddenFieldCategoryMainFacility.ClientID %>').val();
                $.ajax(
               {
                   type: "POST",
                   data: $.toJSON(params),
                   dataType: "json",
                   contentType: "application/json; charset=utf-8",
                   url: "controls/FillDropDownList.asmx/GetLookupListByParentId",
                   success: function(response) {
                       if (response.d == "") {
                           $('#<%= DropDownListMainFacility.ClientID %>').attr('disabled', 'disabled');
                       }
                       else {
                           $('#<%= DropDownListMainFacility.ClientID %>').removeAttr('disabled');
                       }
                       $('#<%= DropDownListSubFacility.ClientID %>').empty().append('<option selected="selected" value="0"></option>');
                       $('#<%= DropDownListSubFacility.ClientID %>').attr('disabled', 'disabled');
                       $('#<%= DropDownListMainFacility.ClientID %>').populateSelect(response.d);
                       if ($('#<%= HiddenFieldClosestFacility.ClientID %>').val() == "True")
                       {
                           EnableValidator("<%= RequiredFieldValidatorMainFacility.ClientID %>", true);
                       }
                   },
                   failure: function(response) {
                       alert(response.d);
                   }
               });
            }
        });

        if ($('#<%= HiddenFieldMainFacility.ClientID %>').val() != "" && $('#<%= HiddenFieldMainFacility.ClientID %>').val() != "0") {
            //alert($('#<%= HiddenFieldMainFacility.ClientID %>').val())
            var params = new Object();
            params.parentId = $('#<%= HiddenFieldMainFacility.ClientID %>').val();
            params.category = $('#<%= HiddenFieldCategorySubFacility.ClientID %>').val();
            $.ajax(
            {
                type: "POST",
                data: $.toJSON(params),
                dataType: "json",
                contentType: "application/json; charset=utf-8",
                url: "controls/FillDropDownList.asmx/GetLookupListByParentId",
                success: function(response) {
                    if (response.d == "") {
                        $('#<%= DropDownListSubFacility.ClientID %>').attr('disabled', 'disabled');
                    }
                    else {
                        $('#<%= DropDownListSubFacility.ClientID %>').removeAttr('disabled');
                    }
                    $('#<%= DropDownListSubFacility.ClientID %>').populateSelect(response.d);

                    if ($('#<%= HiddenFieldSubFacility.ClientID %>').val() !== "") {
                        $('#<%= DropDownListSubFacility.ClientID %>').val($('#<%= HiddenFieldSubFacility.ClientID %>').val());
                    }
                },
                failure: function(response) {
                    alert(response.d);
                }
            });
        }

        //  select a value from the second dropdown list
        $('#<%= DropDownListMainFacility.ClientID %>').change(function() {
            $('#<%= HiddenFieldMainFacility.ClientID %>').val($(this).val());
            //$('#<%= HiddenFieldSubFacility.ClientID %>').val($(this).val());
            if ($(this).val() == "" || $(this).val() == "0") {

                $('#<%= DropDownListSubFacility.ClientID %>').empty().append('<option selected="selected" value="0"></option>');
                $('#<%= DropDownListSubFacility.ClientID %>').attr('disabled', 'disabled');
            }
            else {
                var params = new Object();
                params.parentId = $(this).val();
                params.category = $('#<%= HiddenFieldCategorySubFacility.ClientID %>').val();
                $.ajax(
            {
                type: "POST",
                data: $.toJSON(params),
                dataType: "json",
                contentType: "application/json; charset=utf-8",
                url: "controls/FillDropDownList.asmx/GetLookupListByParentId",
                success: function(response) {
                    if (response.d == "") {
                        $('#<%= DropDownListSubFacility.ClientID %>').attr('disabled', 'disabled');
                    }
                    else {
                        $('#<%= DropDownListSubFacility.ClientID %>').removeAttr('disabled');
                    }
                    $('#<%= DropDownListSubFacility.ClientID %>').populateSelect(response.d);
                },
                failure: function(response) {
                    alert(response.d);
                }
            });
            }
        });

    });
    
    
 </script>
    <table>
        <tr>
            <td role="combobox" aria-label="Closest Facility is a Facility where is closest to registrants. The Selection Criteria allows the user to filter with one Main Facility or one Sub Facility.">
            <asp:Panel runat="server" ID="PanelFacility" BorderWidth="0" GroupingText="Facility&nbsp&nbsp" role="heading" aria-level="3"
                ToolTip="Location is a VISN or Facility that a registrant is assigned to as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who are not assigned.">
                <table>
                    <tr>
                        <td>
                            <asp:Label SkinID="DataLabel" ID="LabelforDropDownListVisn" runat="server" AssociatedControlID="DropDownListVisn">VISN:</asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListVisn" AppendDataBoundItems="true" runat="server">
                                <asp:ListItem Value="0" Text="-- Select a VISN --"></asp:ListItem>
                            </asp:DropDownList>
                        </td>
                        <td>
                            <asp:Label SkinID="DataLabel" ID="LabelforDropDownListMainFacility" runat="server" AssociatedControlID="DropDownListMainFacility">Main Facility:</asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListMainFacility" AppendDataBoundItems="true" runat="server" Width="350">
                                <asp:ListItem Value="0" Text=" "></asp:ListItem>
                            </asp:DropDownList>
                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorMainFacility" runat="server" ForeColor="DarkRed" Visible="false" Enabled="false"
                                ControlToValidate="DropDownListMainFacility" Display="Dynamic" EnableClientScript="true" ValidationGroup="OnRunReport"
                                SetFocusOnError="true" InitialValue="0" ErrorMessage="Please select a Main Facility">
                            </asp:RequiredFieldValidator>
                        </td>
                        <td>
                            <asp:Label SkinID="DataLabel" ID="LabelForDropDownListSubFacility" runat="server" AssociatedControlID="DropDownListSubFacility">Sub-facility:</asp:Label>
                            <br />
                            <asp:DropDownList ID="DropDownListSubFacility" AppendDataBoundItems="true" runat="server" Width="350">
                                <asp:ListItem Value="0" Text=""></asp:ListItem>
                            </asp:DropDownList>
                        </td>
                    </tr>
                </table>
            </asp:Panel>
        </td>
    </tr>
</table>

<asp:HiddenField ID = "HiddenFieldVisn" runat = "server" /> 
<asp:HiddenField ID = "HiddenFieldMainFacility" runat = "server" /> 
<asp:HiddenField ID = "HiddenFieldSubFacility" runat = "server" /> 
<asp:HiddenField ID = "HiddenFieldCategoryMainFacility" runat = "server" Value="MainFacility" /> 
<asp:HiddenField ID = "HiddenFieldCategorySubFacility" runat = "server" Value="Facility"  />
<asp:HiddenField ID = "HiddenFieldMainFacilityDescription" runat = "server" /> 
<asp:HiddenField ID = "HiddenFieldLocationType" runat = "server" /> 
<asp:HiddenField ID = "HiddenFieldClosestFacility" runat = "server" /> 
