﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.ValueTypes;
using AntiXssEnc = Microsoft.Security.Application;

public partial class controls_UserControlEncounterInformation : System.Web.UI.UserControl
{
    private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();
    private AHOBPRShared _sharedManager = new AHOBPRShared();
    //private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private static SessionFacade userSession;
        
    protected void Page_Load(object sender, EventArgs e)
    {
        if (HttpContext.Current.Session != null && HttpContext.Current.Session["UserSession"] != null)
            userSession = HttpContext.Current.Session["UserSession"] as SessionFacade;
        else
            userSession = new SessionFacade();

        int registrantId = userSession.RegistrantId;
        LoadUserControl(registrantId);
        LoadEncounterData(registrantId);
        LoadCurrentHealthCareData(registrantId);
        CheckShowEvaluation();
    }

    public void LoadUserControl(int registrantId)
    {
        HiddenFieldRegistrantId.Value = registrantId.ToString();
    }

    public void LoadEncounterData(int registrantId)
    {       
       
            REGISTRANT_VISIT registrant = _registrantManager.GetMostRecentEncounter(registrantId);
           
            if (registrant != null)
            {
                PanelEncounterInfoDetails.Visible = true;
                PanelNoEncounterInformationFound.Visible = false;
                //LabelTextEncounterUpdated.Text = "(Updated " + (registrant.UPDATED.ToShortDateString() ?? string.Empty) + ")";
                LabelTextEncounterUpdated.Text = "(Updated " + (Convert.ToDateTime(registrant.UPDATED).ToString("MM/dd/yyyy") ?? string.Empty) + ")";
                //LabelTextEncounterDate.Text = registrant.VISIT_DATE_TIME.HasValue ? registrant.VISIT_DATE_TIME.Value.Month + "/" + registrant.VISIT_DATE_TIME.Value.Day + "/" + registrant.VISIT_DATE_TIME.Value.Year : string.Empty;
                LabelTextEncounterDate.Text = registrant.VISIT_DATE_TIME.HasValue ? Convert.ToDateTime(registrant.VISIT_DATE_TIME).ToString("MM/dd/yyyy") : string.Empty;
                LabelTextEncounterApptType.Text = registrant.APPOINTMENT_TYPE;
                if (registrant.STD_INSTITUTION_ID != 0 && registrant.STD_INSTITUTION_ID != null)
                {
                    int institutionId = (int?)registrant.STD_INSTITUTION_ID ?? 0;
                    LabelTextEncounterLocation.Text = _sharedManager.GetFacilityDescription(institutionId);
                }
                else
                {
                    LabelTextEncounterLocation.Text = null;
                }
                
            }
            else
            {
                PanelEncounterInfoDetails.Visible = false;
                PanelNoEncounterInformationFound.Visible = true;
            }
        
    }

    public void LoadCurrentHealthCareData(int registrantId)
    {       
            REGISTRANT registrant = _registrantManager.GetRegistrantById(registrantId);
            PanelCurrentHealthCareInformation.Visible = true;
            PanelNoCurrentHealthCareFound.Visible = false;

            //if registrant has health benifits display data
            string closestFacility = _sharedManager.GetClosestFacilityDescription(registrant.REGISTRANT_ID);
            if (registrant.ELIGIBILITY_STATUS != null || registrant.ENROLLMENT_STATUS != null)
            {
                //LabelTextEnrollmentUpdated.Text = "(Updated " + (registrant.UPDATED.ToShortDateString()) + ")";
                LabelTextEnrollmentUpdated.Text = "(Updated " + (Convert.ToDateTime(registrant.UPDATED).ToString("MM/dd/yyyy")) + ")";
                LabelTextStatus.Text = registrant.ENROLLMENT_STATUS;
                if (registrant.STD_INSTITUTION_ID != 0 && registrant.STD_INSTITUTION_ID != null && registrant.ENROLLMENT_STATUS == "ENROLLED")
                {
                    int institutionId = (int?)registrant.STD_INSTITUTION_ID ?? 0;
                    LabelTextAssignedLocation.Text = _sharedManager.GetFacilityDescription(institutionId);
                }
                else
                {
                    LabelAssignedLocation.Text = "Closest Facility: ";
                    LabelTextAssignedLocation.Text =  closestFacility;
                }

                //LabelTextEligibilityUpdated.Text = "(Updated " + (registrant.UPDATED.ToShortDateString()) + ")";
                LabelTextEligibilityUpdated.Text = "(Updated " + (Convert.ToDateTime(registrant.UPDATED).ToString("MM/dd/yyyy")) + ")";
                LabelTextEligibilityStatus.Text = registrant.ELIGIBILITY_STATUS;
                LabelTextEligibility.Text = registrant.ELIGIBILITY;

            }
            else
            {
                if (string.IsNullOrEmpty(closestFacility))
                {
                    PanelCurrentHealthCareInformation.Visible = false;
                    PanelNoCurrentHealthCareFound.Visible = true;
                }
                else
                {
                    LabelAssignedLocation.Text = "Closest Facility: ";
                    LabelTextAssignedLocation.Text = closestFacility;
                }
            }
        
    }

    public void CheckShowEvaluation()
    {
               
    
        if (GridViewAhobprEvaluation.Rows.Count == 0)
        {
            PanelEvaluation.Visible = false;
            PanelNoEvaluationFound.Visible = true;
                        
        }
        else
        {
            PanelEvaluation.Visible = true;
            PanelNoEvaluationFound.Visible = false;
           
        }

    }

     protected void GridViewAhobprEvaluation_RowDataBound(Object sender, GridViewRowEventArgs e)
    {
        if ((e.Row.RowType == DataControlRowType.DataRow))
        {
            EvaluationGridview evalUpdated = (EvaluationGridview)e.Row.DataItem;
            GridViewAhobprEvaluation.Caption =  AntiXssEnc.Encoder.HtmlEncode(evalUpdated.EvaluationUpdated);
            
        }
    }


}