﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="UserControlEncounterInformation.ascx.cs"
    Inherits="controls_UserControlEncounterInformation" %>
<%@ Register Src="BaseControlLabel.ascx" TagName="BaseControlLabel" TagPrefix="UserControl" %>

<script type="text/javascript">
    $(document).ready(function() {

    if ($('#<%= CheckBoxEncounterInformation.ClientID %>').is(':checked')) {
            $('#<%= PanelEncounterInformation.ClientID %>').show();
            $('#<%= PanelEncounterInfoDetails.ClientID %>').show();
            $('#<%= PanelEvaluation.ClientID %>').show();
            $('#<%= PanelNoEncounterInformationFound.ClientID %>').show();
            $('#<%= PanelNoEvaluationFound.ClientID %>').show();
        }
        else {
            $('#<%= PanelEncounterInformation.ClientID %>').hide();
            $('#<%= PanelEncounterInfoDetails.ClientID %>').hide();
            $('#<%= PanelEvaluation.ClientID %>').hide();
            $('#<%= PanelNoEncounterInformationFound.ClientID %>').hide();
            $('#<%= PanelNoEvaluationFound.ClientID %>').hide();
        }

        $('#<%= CheckBoxEncounterInformation.ClientID %>').change(function() {
            if (this.checked) {
                $('#<%= PanelEncounterInformation.ClientID %>').show();
                $('#<%= PanelEncounterInfoDetails.ClientID %>').show();
                $('#<%= PanelEvaluation.ClientID %>').show();
                $('#<%= PanelNoEncounterInformationFound.ClientID %>').show();
                $('#<%= PanelNoEvaluationFound.ClientID %>').show();
            }
            else {
                $('#<%= PanelEncounterInformation.ClientID %>').hide();
                $('#<%= PanelEncounterInfoDetails.ClientID %>').hide();
                $('#<%= PanelEvaluation.ClientID %>').hide();
                $('#<%= PanelNoEncounterInformationFound.ClientID %>').hide();
                $('#<%= PanelNoEvaluationFound.ClientID %>').hide();
            }
        });

        if ($('#<%= CheckBoxCurrentHealthCare.ClientID %>').is(':checked')) {
            $('#<%= PanelCurrentHealthCareInformation.ClientID %>').show();
            $('#<%= PanelNoCurrentHealthCareFound.ClientID %>').show();
        }
        else {
            $('#<%= PanelCurrentHealthCareInformation.ClientID %>').hide();
            $('#<%= PanelNoCurrentHealthCareFound.ClientID %>').hide();
        }

        $('#<%= CheckBoxCurrentHealthCare.ClientID %>').change(function() {
            if (this.checked) {
                $('#<%= PanelCurrentHealthCareInformation.ClientID %>').show();
                $('#<%= PanelNoCurrentHealthCareFound.ClientID %>').show();
            }
            else {
                $('#<%= PanelCurrentHealthCareInformation.ClientID %>').hide();
                $('#<%= PanelNoCurrentHealthCareFound.ClientID %>').hide();
            }
        });


    });
</script>
<hr />
<br />
<asp:CheckBox ID="CheckBoxEncounterInformation" runat="server" Text="View Encounter Information"
    Font-Bold="true" Checked="false" ToolTip="Select this checkbox to show Most Recent Encounter and AHOBPR Evaluation information." />

<asp:Panel ID="PanelEncounterInformation" runat="server" GroupingText=" Encounter Information " >
    <h3>Encounter Information</h3>
<asp:Panel ID="PanelNoEncounterInformationFound" runat="server"  BorderStyle="None" >
    <asp:Label SkinID="DataLabel" ID="LabelNoEncounterInformationFound" runat="server"
        Text="No most recent encounter found."></asp:Label>
</asp:Panel>
<asp:Panel ID="PanelEncounterInfoDetails" runat="server"  BorderStyle="None">
    <table>
        <tr>
            <td>
                <asp:Label SkinID="DataLabel" ID="LabelEncounterUpdated" runat="server" AssociatedControlID="LabelTextEncounterUpdated">Most Recent Encounter </asp:Label>
                <asp:Label ID="LabelTextEncounterUpdated" runat="server" Text="" />
            </td>
        </tr>
        <tr>
            <td>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Label SkinID="DataLabel" ID="LabelEncounterDate" runat="server" AssociatedControlID="LabelTextEncounterDate">Date:  </asp:Label>
                <asp:Label ID="LabelTextEncounterDate" runat="server" Text="" />
            </td>
        </tr>
        <tr>
            <td>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Label SkinID="DataLabel" ID="LabelEncounterLocation" runat="server" AssociatedControlID="LabelTextEncounterLocation">Location:  </asp:Label>
                <asp:Label ID="LabelTextEncounterLocation" runat="server" Text="" />
            </td>
        </tr>
        <tr>
            <td>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Label SkinID="DataLabel" ID="LabelEncounterApptType" runat="server" AssociatedControlID="LabelTextEncounterApptType">Appointment Type:  </asp:Label>
                <asp:Label ID="LabelTextEncounterApptType" runat="server" Text="" />
            </td>
        </tr>
    </table>
    </asp:Panel>
    <br />
    <asp:Panel ID="PanelNoEvaluationFound" runat="server"  BorderStyle="None" role="heading" aria-level="3">
    <asp:Label SkinID="DataLabel" ID="LabelNoEvaluationInformationFound" runat="server"
        Text="No AHOBPR Evaluation found."></asp:Label>
</asp:Panel>
<asp:Panel ID="PanelEvaluation" runat="server"  BorderStyle="None" role="heading" aria-level="3">
    <asp:GridView ID="GridViewAhobprEvaluation" runat="server" Caption="AHOBPR Evaluation"
        AutoGenerateColumns="False" DataSourceID="DataSourceAHOBPREvaluation" EnableModelValidation="True"
        DataKeyNames="RegistrantId"  OnRowDataBound="GridViewAhobprEvaluation_RowDataBound">
        <EmptyDataTemplate>
            &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp No AHOBPR Evaluation found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
        <Columns>
            <asp:TemplateField HeaderText="ID" AccessibleHeaderText="ID" Visible="false">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelRegistrantId" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("RegistrantId")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Updated"  Visible="false">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelEvauluationUpdated" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("EvaluationUpdated")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Date">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelDate" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("EvaluationDate")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Location">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelLocation" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("Location"))  %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Clinic Code">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelClinicCode" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("ClinicCode")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
            <asp:TemplateField HeaderText="Stop Code">
                <HeaderStyle HorizontalAlign="Center" />
                <ItemTemplate>
                    <asp:Label ID="LabelStopCode" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("StopCode")) %>'></asp:Label>
                </ItemTemplate>
            </asp:TemplateField>
        </Columns>
    </asp:GridView>
    <asp:ObjectDataSource ID="DataSourceAHOBPREvaluation" runat="server" SelectMethod="GetAHOBPRExamination"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value"
                Type="String" />
        </SelectParameters>
    </asp:ObjectDataSource>
    </asp:Panel>
</asp:Panel>
<br />
<br />
<hr />
<br />
<asp:CheckBox ID="CheckBoxCurrentHealthCare" runat="server" Text="View Current Health Care Information"
    Font-Bold="true" Checked="false" ToolTip="Select this checkbox to show Current Health Care Enrollment information." />

<asp:Panel ID="PanelNoCurrentHealthCareFound" runat="server" GroupingText=" Current Health Care Information " role="heading" aria-level="3" >
    <br />
    <div>Current Health Care Information</div>
    <asp:Label SkinID="DataLabel" ID="LabelNoCurrentHealthCareFound" runat="server" Text="No health care enrollment information found."></asp:Label>
</asp:Panel>

<asp:Panel ID="PanelCurrentHealthCareInformation" runat="server" GroupingText=" Current Health Care Information " role="heading" aria-level="3">
    <br />
    <div class="FiveOhEightHeading" >Current Health Care Information</div>
    <table>
        <tr>
            <td>
                <asp:Label SkinID="DataLabel" ID="LabelEnrollmentUpdated" runat="server" AssociatedControlID="LabelTextEnrollmentUpdated">Current Health Care Enrollment </asp:Label>
                <asp:Label ID="LabelTextEnrollmentUpdated" runat="server" Text="" />
            </td>
        </tr>
        <tr>
            <td>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Label SkinID="DataLabel" ID="LabelStatus" runat="server" AssociatedControlID="LabelTextStatus">Status:  </asp:Label>
                <asp:Label ID="LabelTextStatus" runat="server" Text="" />
            </td>
        </tr>
        <tr>
            <td>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Label SkinID="DataLabel" ID="LabelAssignedLocation" runat="server" AssociatedControlID="LabelTextAssignedLocation">Location:  </asp:Label>
                <asp:Label ID="LabelTextAssignedLocation" runat="server" Text="" />
            </td>
        </tr>
        <tr>
            <td>
            <br />
                <asp:Label SkinID="DataLabel" ID="LabelEligibilityUpdate" runat="server" AssociatedControlID="LabelTextEligibilityUpdated">Current Eligibility </asp:Label>
                <asp:Label ID="LabelTextEligibilityUpdated" runat="server" Text="" />
            </td>
        </tr>
        <tr>
            <td>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Label SkinID="DataLabel" ID="LabelEligibility" runat="server" AssociatedControlID="LabelTextEligibility">Eligibility:  </asp:Label>
                <asp:Label ID="LabelTextEligibility" runat="server" Text="" />
            </td>
        </tr>
        <tr>
            <td>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Label SkinID="DataLabel" ID="LabelEligibilityStatus" runat="server" AssociatedControlID="LabelTextEligibilityStatus">Status:  </asp:Label>
                <asp:Label ID="LabelTextEligibilityStatus" runat="server" Text="" />
            </td>
        </tr>
    </table>
    </asp:Panel>
    <asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
