﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;

public partial class controls_UserControlAsOfDate : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            CompareValidatorTextBoxAsOfDate.ValueToCompare = DateTime.Now.ToShortDateString();
            TextBoxAsOfDate.Text = DateTime.Now.ToShortDateString();
        }
    }
 
    public string AsOfDateValue
    {
        get
        {
            return TextBoxAsOfDate.Text;
        }
        set
        {
            TextBoxAsOfDate.Text = value;
        }
    }


    public void LoadControlsFromObject(string dateDescription, bool required)
    {
        RequiredFieldValidatorTextBoxAsOfDate.Enabled = required;
        RequiredFieldValidatorTextBoxAsOfDate.Visible = required;
    }

    public bool ValidateCustomValidator()
    {
        CustomValidatorAsOfDate.IsValid = true;

        //Verify a 4-digit year has been entered and valid date
        if (!string.IsNullOrEmpty(TextBoxAsOfDate.Text))
        {
            string dateYear = TextBoxAsOfDate.Text.Split('/').Last();
            //count slashes
            var slashCount = TextBoxAsOfDate.Text.Count(x => x == '/');

            //Verify a 4-digit year has been entered and valid date
            if (TextBoxAsOfDate.Text.Length < 6)
            {
                CustomValidatorAsOfDate.IsValid = false;
                CustomValidatorAsOfDate.ErrorMessage = "Please enter a valid As of Date (mm/dd/yyyy).";
            }
            else if (slashCount != 2)
            {
                CustomValidatorAsOfDate.IsValid = false;
                CustomValidatorAsOfDate.ErrorMessage = "Please enter a valid As of Date (mm/dd/yyyy).";
            }
            else if (dateYear.Length < 4)
            {
                CustomValidatorAsOfDate.IsValid = false;
                CustomValidatorAsOfDate.ErrorMessage = "Please enter a 4-digit year for As of Date.";
            }
            if (CustomValidatorAsOfDate.IsValid == false)
            {
                TextBoxAsOfDate.Focus();
            }
        }

        return CustomValidatorAsOfDate.IsValid;
    }

}
