﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class controls_UserControlAllDeployments : System.Web.UI.UserControl
{
    private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

    protected void Page_Load(object sender, EventArgs e)
    {
    }


    public void LoadUserControl(int registrantId)
    {
        HiddenFieldRegistrantId.Value = registrantId.ToString();
        List<REGISTRANT_DEPLOYMENT> deployments = _registrantManager.SelectRegistrantDeploymentHistory(registrantId.ToString(), string.Empty, 0, 1000).ToList();
        GridViewDeploymentHistory.DataSource = deployments;
        GridViewDeploymentHistory.DataBind();

        REGISTRANT registrant = _registrantManager.GetRegistrantByIdLight(registrantId);
        LabelPre911.Text = registrant.PRE_911_DEPLOYMENT;
        LabelPost911.Text = registrant.POST_911_DEPLOYMENT;

        if (DropDownListLocation.Items.Count == 1 && deployments.Count() > 0)
        {
            //Load location dropdown list
            List<KeyValuePair<string, string>> locations = (from d in deployments
                                                            orderby d.DEPLOYMENT_COUNTRY
                                                            select new KeyValuePair<string, string>(d.DEPLOYMENT_COUNTRY, d.DEPLOYMENT_COUNTRY)).Distinct().ToList();
            DropDownListLocation.DataSource = locations;
            DropDownListLocation.DataValueField = "Key";
            DropDownListLocation.DataTextField = "Value";
            DropDownListLocation.DataBind();

            //Load data source dropdown list
            List<KeyValuePair<string, string>> sources = (from d in deployments
                                                          orderby d.DataSource
                                                          select new KeyValuePair<string, string>(d.DataSource, d.DataSource)).Distinct().ToList();
            DropDownListSource.DataSource = sources;
            DropDownListSource.DataValueField = "Key";
            DropDownListSource.DataTextField = "Value";
            DropDownListSource.DataBind();

            //Load deployment stage dropdown list
            List<KeyValuePair<string, string>> stages = (from d in deployments
                                                         orderby d.DeploymentStage
                                                         select new KeyValuePair<string, string>(d.DeploymentStage, d.DeploymentStage)).Distinct().ToList();
            DropDownListStage.DataSource = stages;
            DropDownListStage.DataValueField = "Key";
            DropDownListStage.DataTextField = "Value";
            DropDownListStage.DataBind();
        }

    }

    public string NavigationSource {get; set;}

    protected void ButtonFilter_Click(object sender, EventArgs e)
    {
        List<REGISTRANT_DEPLOYMENT> deployments = _registrantManager.SelectRegistrantDeploymentHistory(HiddenFieldRegistrantId.Value, string.Empty, 0, 1000).ToList();
        if (!string.IsNullOrEmpty(DropDownListLocation.Text) && DropDownListLocation.Text != "All")
        {
            deployments = (from d in deployments where d.DEPLOYMENT_COUNTRY == DropDownListLocation.Text select d).ToList();
        }
        if (!string.IsNullOrEmpty(DropDownListSource.Text) && DropDownListSource.Text != "All")
        {
            deployments = (from d in deployments where d.DataSource == DropDownListSource.Text select d).ToList();
        }
        if (!string.IsNullOrEmpty(DropDownListStage.Text) && DropDownListStage.Text != "All")
        {
            deployments = (from d in deployments where d.DeploymentStage == DropDownListStage.Text select d).ToList();
        }
        GridViewDeploymentHistory.DataSource = deployments;
        GridViewDeploymentHistory.DataBind();

    }
    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        this.DropDownListLocation.SelectedIndex = -1;
        this.DropDownListSource.SelectedIndex = -1;
        this.DropDownListStage.SelectedIndex = -1;
    }
}
