﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true"
    CodeFile="ToolQuestionList.aspx.cs" Inherits="ToolQuestionList" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">

    <script type="text/javascript">

        $(function() {
            if ($('#<%# HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%# TextBoxKeyWords.ClientID %>').focus();

        });
    </script>

    <div class="breadcrumb">
        <asp:Label ID="BreadCrumbLabel" runat="server" Text="<H1>Follow-up Question Tool > Question List</H1>" />
    </div>
    <div class="excludeSaveWarnings">
        <asp:LinkButton ID="LinkButtonAddQuestion" runat="server" Text="Add New Question" PostBackUrl="~/ToolQuestionEdit.aspx?id=0" />
        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
        <asp:LinkButton ID="LinkButtonQuestionGroup" runat="server" Text="Go to Question Group List" PostBackUrl="~/ToolQuestionGroupList.aspx" />
        <br />    <br />
        <asp:Panel ID="PanelListQuestions" runat="server" GroupingText="Manage Questions&nbsp;&nbsp;"
            Width="100%">
            <table>
                <tr>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForTextBoxKeyWords" runat="server" Text="Filter By Key Words:"
                            AssociatedControlID="TextBoxKeyWords" ToolTip="Filter By Key Words" />
                        <br />
                        <asp:TextBox ID="TextBoxKeyWords" runat="server" Width="250" ToolTip="Filter By Key Words"></asp:TextBox>
                         &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                         
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForDropDownListQuestionType" runat="server" Text="Filter By Type:"
                            AssociatedControlID="DropDownListQuestionType" ToolTip="Filter by Question Type" />
                        <br />
                        <asp:DropDownList runat='server' ID='DropDownListQuestionType' ToolTip='Filter by Question Type'>
                            <asp:ListItem Value='' Text='All' />
                            <asp:ListItem Value='multipleChoice' Text='Dropdown List - Mutiple Choice' />
                            <asp:ListItem Value='multiSelect' Text='Checkboxes - Mutliple Select' />
                            <asp:ListItem Value='text' Text='Radio Buttons with Free Text' />
                            <asp:ListItem Value='number' Text='Radio Buttons with Numeric Value' />
                        </asp:DropDownList>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                    </td>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelForDropDownListStatus" runat="server" Text="Filter By Status:"
                            AssociatedControlID="DropDownListStatus" ToolTip="Filter by Status" />
                        <br />
                        <asp:DropDownList runat='server' ID='DropDownListStatus' ToolTip='Filter by Status'>
                            <asp:ListItem Value='' Text='All' />
                            <asp:ListItem Value='1' Text='In Progress' />
                            <asp:ListItem Value='2' Text='Completed' />
                            <asp:ListItem Value='3' Text='Deactivated' />
                        </asp:DropDownList>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                     </td>
                    <td>
                        <br />
                        <asp:Button ID="ButtonSearch" runat="server" Text=" Filter " OnClick="ButtonSearch_Click" />
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick="ButtonClear_Click" />
                        
                    </td>
                 </tr>
            </table>
            <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
            <asp:Panel runat='server' ID='PanelSearResults'  >
                <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="true" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="true" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
        </div>
                <asp:GridView 
                    ID="GridViewQuestions" 
                    runat="server" 
                    OnRowCommand = "GridViewQuestions_RowCommand"
                    AutoGenerateColumns="False" Width="100%"
                    DataSourceID="DataSourceFilterQuestions"
                    AllowPaging="True" 
                    AllowSorting="True" 
                    Visible="true" 
                    Caption="To sort please click table headings" 
                    EnableModelValidation="True"
                    DataKeyNames="TOOL_QUESTION_ID" 
                    onrowdatabound="GridViewQuestions_RowDataBound">
                     <EmptyDataTemplate>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        No Questions Found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
                      <Columns>
                         <asp:TemplateField HeaderText="Edit" SortExpression="" AccessibleHeaderText='Edit'>
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton runat='server' ID='LinkButtonEdit' CommandName='Edit' 
                                CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TOOL_QUESTION_ID"))) %>' Text="Edit" 
                                 Enabled='<%# Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>'
                                 Visible='<%# Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Preview" SortExpression="" AccessibleHeaderText='Preview'>
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton runat='server' ID='LinkButtonPreview' CommandName='Preview' CommandArgument='<%# Helpers.AhobprEval(Eval("TOOL_QUESTION_ID")) %>' Text="Preview Question" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Question ID" SortExpression="TOOL_QUESTION_ID">
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelQuestionID" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TOOL_QUESTION_ID")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Question Text" SortExpression="TEXT">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle ></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelQuestionText" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TEXT")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Key Words" SortExpression="KEY_WORDS">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle ></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelKeyWords" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("KEY_WORDS")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Type" SortExpression="TYPE">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle ></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelType" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("TYPE")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Min Value" SortExpression="MIN">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle ></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelMin" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MIN")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Max Value" SortExpression="MAX">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelMax" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MAX")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Status" SortExpression="" AccessibleHeaderText="Status">
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:Label ID="LabelStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("status")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Action" SortExpression="" AccessibleHeaderText='Delete'>
                            <ItemStyle HorizontalAlign="Center" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                               <asp:Button ID="ButtonDelete" runat="server"
                                    Text="  Delete  "
                                    Enabled = '<%# Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>' Visible='<%# Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>'
                                    OnClientClick="return confirm('Are you sure you want to delete this question? Click cancel if you do not want to delete.');"
                                    ToolTip='<%# string.Format("Delete {0} from question list", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"TEXT"))))  %>' 
                                    CommandName="DELETE_FLAG" 
                                    CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(("TOOL_QUESTION_ID"))) %>' 
                                    CausesValidation="false"/>
                               <asp:Button ID="ButtonDeactivate" runat="server"
                                    Text='<%# Convert.ToBoolean(Eval("ACTIVE_FLAG")) ? " Deactivate " : "  Activate  " %>' 
                                    Enabled = '<%# !Convert.ToBoolean(Eval("EDITABLE_FLAG")) %>' Visible='<%# !Convert.ToBoolean(Eval("EDITABLE_FLAG"))  %>'
                                    ToolTip='<%# string.Format("{0} {1} from question list", Convert.ToBoolean(Eval("ACTIVE_FLAG")) ? " Deactivate " : "  Activate ", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"TEXT"))))   %>' 
                                    CommandName="UPDATE_FLAG" 
                                    CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(("TOOL_QUESTION_ID"))) %>' 
                                    CausesValidation="false"/>
                          </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <FooterStyle HorizontalAlign='Right' BackColor='White' />
                </asp:GridView>
           </asp:Panel>
            <br />
        </asp:Panel>
          <asp:ObjectDataSource 
            ID="DataSourceFilterQuestions" runat="server" 
                SelectMethod="SearchQuestions" 
                SelectCountMethod="SearchQuestionsCount"
                StartRowIndexParameterName="startRow" 
                MaximumRowsParameterName="maxRows" 
                SortParameterName="sort"
                EnablePaging="True"  
                TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRToolManager">
            <SelectParameters>
                <asp:ControlParameter ControlID="TextBoxKeyWords" Name="keyWords" PropertyName="Text" Type="String" />
                <asp:ControlParameter ControlID="DropDownListQuestionType" Name="type" PropertyName="SelectedValue" Type="String" />
                <asp:ControlParameter ControlID="DropDownListStatus" Name="status" PropertyName="SelectedValue" Type="String" />
                <asp:Parameter Name="sort" Type="String" />
                <asp:Parameter Name="startRow" Type="Int32" />
                <asp:Parameter Name="maxRows" Type="Int32" />
           </SelectParameters>
        </asp:ObjectDataSource>    
         <br />    <br />
         <asp:LinkButton ID="LinkButtonNewQuestionBottom" runat="server" Text="Add New Question" PostBackUrl="~/ToolQuestionEdit.aspx?id=0" />
        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
        <asp:LinkButton ID="LinkButtonQuestionGroupListBottom" runat="server" Text="Go to Question Group List" PostBackUrl="~/ToolQuestionGroupList.aspx" />
   </div>
</asp:Content>
