﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;

public partial class ReportStatusByLocation : BasePage
{
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private List<STD_GUI_CONTROL_AHOBPR> _dbControls = null;
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private AHOBPRReportManager _reportManager = new AHOBPRReportManager();
    private string _serverReportName = "ReportStatusByLocation";

    public string ServerReportParameters { get; set; }

    protected void Page_Load(object sender, EventArgs e)
    {
        UserSession.RegistrantId = 0;

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        if (!IsPostBack)
        {
            ShowStatusByLocationReport(false);
            ShowReportViewer(false);
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }

        TextBoxAsOfDate.Text = DateTime.Now.ToShortDateString();
        //ShowStatusByLocationReport(false);
        LoadBaseControls();
        if (IsPostBack)
        {
            ReloadBaseControlValue();
        }
        //set Location panel names & ToolTips
        UserControlReportLocationAssigned.LocationPanelName = "  Assigned Location  ";
        UserControlReportLocationEvaluation.LocationPanelName = "  AHOBPR Evaluation Location (Most Recent)  ";
        UserControlReportLocationAssigned.LocationPanelToolTip = "Assigned Location is a VISN or Facility that a registrant is assigned to as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who are not assigned.";
        UserControlReportLocationEvaluation.LocationPanelToolTip = "AHOBPR Evaluation Location is a VISN or Facility where a registrant had their most recent AHOBPR Evaluation as reported in CDW. The Selection Criteria allows the user to filter with all locations, one VISN, Main Facility, or one Sub-Facility, or Registrants who have not had a AHOBPR Evaluation.";
        UserControlFacilityDropdownLists.FacilityPanelName = "  Closest Facility  ";
        UserControlFacilityDropdownLists.FacilityPanelToolTip = "Closest Facility is a Facility where is closest to registrants. The Selection Criteria allows the user to filter with one Main Facility or one Sub Facility.";
    }

    private void ReloadBaseControlValue()
    {
        BaseControlListBoxState.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxState.Text);
        BaseControlListBoxStatus.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxStatus.Text);
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        Response.Redirect("ReportStatusByLocation.aspx");
    }

    protected void ButtonPrintReport_Click(object sender, EventArgs e)
    {
        ReportViewerReport.Reset();
        SetReportPath();
        SetReportParameters();

        ReportViewerReport.ProcessingMode = ProcessingMode.Remote;
        ReportViewerReport.Visible = true;
        ReportViewerReport.ServerReport.Refresh();
        ShowReportViewer(true);
    }

    private void SetReportPath()
    {
        ReportViewerReport.ServerReport.ReportPath = _serverReportName;

        var config = RegistriesConfigurations.GetConfig();

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

        if (ReportViewerReport.ServerReport.ReportPath.IndexOf(
                Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
        {
            ReportViewerReport.ServerReport.ReportPath =
                Helpers.GetConfigEntry("BaseReportPath") + ReportViewerReport.ServerReport.ReportPath;
        }
    }
    private void SetReportParameters()
    {
        _reportParameters.Clear();

        SetStateParameter();
        SetStatusParameter();
        SetLocationParameter();
        SetClosestFacilityParameter();

        ReportViewerReport.ServerReport.SetParameters(_reportParameters);
    }

    private void SetStateParameter()
    {
        string states = string.Empty;
        if (!string.IsNullOrEmpty(BaseControlListBoxState.Text))
        {
            states = BaseControlListBoxState.Text;
            ReportParameter reportParameterState =
                new ReportParameter("state", states);
            _reportParameters.Add(reportParameterState);

            ServerReportParameters += Environment.NewLine + " State: " + states;
        }
    }

    private void SetStatusParameter()
    {
        string status = string.Empty;
        if (string.IsNullOrEmpty(BaseControlListBoxStatus.Text))
        {
            status = _reportManager.GetStatusParameterList();
        }
        else
        {
            status = BaseControlListBoxStatus.Text;
        }

        ReportParameter reportParameterStatus =
            new ReportParameter("status", status);
        _reportParameters.Add(reportParameterStatus);

        ServerReportParameters += Environment.NewLine + " Status: " + status;
    }

    private void SetClosestFacilityParameter()
    {
        ReportParameter reportParameterClosestFacility = new ReportParameter("closestFacilityId", UserControlFacilityDropdownLists.FacilityId);
        _reportParameters.Add(reportParameterClosestFacility);
    }

    private void SetLocationParameter()
    {
        string assignedLocationType = string.Empty;
        string assignedLocationKey = string.Empty;
        string evaluationLocationType = string.Empty;
        string evaluationLocationKey = string.Empty;

        if (!string.IsNullOrEmpty(UserControlReportLocationAssigned.LocationType))
        {
            assignedLocationType = UserControlReportLocationAssigned.LocationType;
            ReportParameter reportParameter = new ReportParameter("AssignedLocationType", assignedLocationType);
            _reportParameters.Add(reportParameter);

        }

        if (!string.IsNullOrEmpty(UserControlReportLocationAssigned.LocationKey))
        {
            assignedLocationKey = UserControlReportLocationAssigned.LocationKey;
            ReportParameter reportParameter = new ReportParameter("AssignedLocationKey", assignedLocationKey);
            _reportParameters.Add(reportParameter);

        }

        if (!string.IsNullOrEmpty(UserControlReportLocationEvaluation.LocationType))
        {
            evaluationLocationType = UserControlReportLocationEvaluation.LocationType;
            ReportParameter reportParameter = new ReportParameter("EvaluatedLocationType", evaluationLocationType);
            _reportParameters.Add(reportParameter);

        }

        if (!string.IsNullOrEmpty(UserControlReportLocationEvaluation.LocationKey))
        {
            evaluationLocationKey = UserControlReportLocationEvaluation.LocationKey;
            ReportParameter reportParameter = new ReportParameter("EvaluatedLocationKey", evaluationLocationKey);
            _reportParameters.Add(reportParameter);

        }
    }

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_REPORT_STATUSBYLOCATION"))
        {
            Control userControl = PanelReportParm.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                switch (dbItem.BASE_CONTROL_TYPE)
                {
                    case (int)AhobprBaseControlType.ListBox:
                        controls_BaseControlListBox baseControl = (controls_BaseControlListBox)userControl;
                        baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                            dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                        break;
                    case (int)AhobprBaseControlType.DropDownList:
                        controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                        baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                                   dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                        break;
                    case (int)AhobprBaseControlType.RadioButtonList:
                        controls_BaseControlRadioButtonList baseControlRadioButtonList = (controls_BaseControlRadioButtonList)userControl;

                        baseControlRadioButtonList.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY);
                        break;

                }
            }
        }

        if (PanelClosestFacility.Visible)
        {
            UserControlFacilityDropdownLists.LoadControlsFromObject();
        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsReportStatusByLocation == null)
        {
            _dbControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsReportStatusByLocation = _dbControls;
        }
        else
        {
            _dbControls = UserSession.GuiControlsReportStatusByLocation;
        }

        return _dbControls;
    }


    protected void GridViewStatusByLocation_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewStatusByLocation.SelectedIndex = index;
            UserSession.RegistrantId = GridViewStatusByLocation.SelectedIndex;
            Response.Redirect("QuestionnaireSummary.aspx?id=" + GridViewStatusByLocation.SelectedIndex);
        }
    }

    protected void ButtonRunReport_Click(object sender, EventArgs e)
    {
        ShowReportViewer(false);
        ShowStatusByLocationReport(true);
        gridViewPageSizeDdl.Visible = true;
        LabelItemsPerPage.Visible = true;
    }


    private void ShowStatusByLocationReport(bool show)
    {
        PanelStatusByLocation.Visible = show;
        if (show)
        {
            GridViewStatusByLocation.DataBind();
            
        }
    }

 
    private void ShowReportViewer(bool show)
    {
        PanelReportViewer.Visible = show;

        if (show)
        {
            ShowStatusByLocationReport(false);
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }
    }


    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR REPORT Status By Location";
    }

    public override string MenuItemName()
    {
        return "AHOBPR REPORT Status By Location";
    }

    protected void DataSourceStatusByLocation_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        var totalRecordsFound = e.ReturnValue;
        LabelNumberOfResultsFound.Text = "Total Number of Results Found: " + totalRecordsFound.ToString();

    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {

        GridViewStatusByLocation.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);

    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewStatusByLocation.PageIndex = e.NewPageIndex;

    }

}
