﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class ReportRegistrantsInStatus : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            ShowRegistrantStatusReport(false);
        }

    }

    private void ShowRegistrantStatusReport(bool show)
    {
        PanelRegistrantStatusReport.Visible = show;
        if (show)
        {
            GridViewRegistrantStatus.DataBind();
            GridViewRegistrantStatus.Visible = true;
        }
    }

    #region

    public override string MenuItemName()
    {
        return "Registrants in Status Report";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR REGISTRANT IN STATUS REPORT";
    }
    public override string TopMenuName()
    {
        return "Reporting";
    }

    #endregion

       protected void ButtonRunReport_Click(object sender, EventArgs e)
    {
        ShowRegistrantStatusReport(true);
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        Response.Redirect("ReportRegistrantsInStatus.aspx");
    }
}