﻿<%@ Page Language="C#" EnableEventValidation="false" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="ReportRegistrantsInStatus.aspx.cs" Inherits="ReportRegistrantsInStatus" %>
<%@ Register Src="controls/UserControlFromToDate.ascx" TagName="UserControlFromToDate" TagPrefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Reports > Registrants in Status Report</H1>"/>
    </div><br /> 
     <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
    <asp:Panel ID="PanelSelectParameters" runat="server" GroupingText=" Selection Criteria (Please select at least one)">
        <asp:Panel ID="PanelStatus" runat="server" GroupingText ="Date Range">
            <table cellspacing="6">
                <tr>
                     <td><UserControl:UserControlFromToDate ID="UserControlDateRangeActionDate" runat="server" /></td>
                </tr>
            </table>
        </asp:Panel>

        <asp:Panel ID="Panel1" runat="server" Width="100%" Visible="true">
            <table>
                <tr>
                    <td>
                        <asp:Button runat="server" ID="Button1" Text="Run Report"
                            Width="120px" ValidationGroup="OnRunReport" OnClick="ButtonRunReport_Click" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:Button runat="server" ID="Button3" Text="Clear"
                         Width="120px" OnClick="ButtonClear_Click" />
                    </td>
                </tr>
            </table>
        </asp:Panel>

    <asp:Panel ID="PanelRegistrantStatusReport" runat="server" GroupingText=" Report Results ">
        <center>
            <asp:Label ID="LabelReportCriteria" runat="server" Text="" Font-Bold="true" Font-Size="Large"></asp:Label></center>
        <br />
        <asp:GridView ID="GridViewRegistrantStatus" runat="server" DataSourceID="DataSourceRegistrantStatusReport"
            AutoGenerateColumns="False" Width="100%" AllowPaging="false" AllowSorting="false" ShowFooter="false"
             Caption="Registrants In Status Report">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.
            </EmptyDataTemplate>
            <Columns>
                <asp:TemplateField HeaderText="Registrant Status" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRegistrantStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Row_Name")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Change in Date Range"
                    ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelDateRange" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("duringRangeCount")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Total Registrants" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" BackColor="#3554A4" ForeColor="White" />
                    <ItemTemplate>
                        <asp:Label ID="LabelTotalRegistrants" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("atEndOfRangeCount")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <br />
        <asp:Panel runat="server">
            <p>
                <strong>
                    Report Numbers reflect counts of registrants in the status they were in at the To-Date.<br />
                </strong>
                <strong>Changed in date range = </strong> is the number of registrants who entered this status during the date range.<br />
                <strong>Total Registrants = </strong> is the number of registrants in the status at the To-Date.
            </p>
        </asp:Panel>
    </asp:Panel>
     <asp:ObjectDataSource ID="DataSourceRegistrantStatusReport" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetRegistrantStatusReport" EnablePaging="false" SelectCountMethod="GetRegistrantStatusReportReportCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="UserControlDateRangeActionDate" Name="reportStartDate" PropertyName="FromDateValue"
                Type="DateTime" />
            <asp:ControlParameter ControlID="UserControlDateRangeActionDate" Name="reportEndDate" PropertyName="ToDateValue"
                Type="DateTime" />
        </SelectParameters>
    </asp:ObjectDataSource>
    </asp:Panel>
</asp:Content>