﻿<%@ Page Title="" EnableEventValidation="false" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="ReportEligibilityReview.aspx.cs" Inherits="ReportEligibilityReview" %>
<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
<%@ Register Src="controls/BaseControlListBox.ascx" TagName="BaseControlListBox" TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlAdminFlagFilter.ascx" TagName="UserControlAdminFlagFilter"
    TagPrefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <script type = "text/javascript">
        $(document).ready(function() {
            $('.textInput').change(function() {
                $('#<%= PanelReportViewer.ClientID %>').hide();
                $('#<%= PanelRegistrantEligibilityReview.ClientID %>').hide();
            });
        });
    </script>
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Reporting > Eligibility Review Report</H1>"/>
    </div>    
    <br />
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>   
    <asp:Panel ID="PanelReportParm" runat="server" GroupingText=" Selection Criteria (Please select at least one)" Width="100%">
        <UserControl:BaseControlListBox ID="BaseControlListBoxStatus" runat="server" />
        <br />
        <UserControl:UserControlAdminFlagFilter ID="UserControlAdminFlagFilter" runat="server" />
        <asp:CustomValidator ID="CustomValidator" runat="server" SetFocusOnError="true"
            ErrorMessage="Please select at least one search criteria.<br />" ValidationGroup="OnRunReport" ForeColor="DarkRed"></asp:CustomValidator>

        <asp:Panel ID="PanelButtons" runat="server" Width="100%" Visible="true">
            <table>
                <tr>
                    <td>
                        <asp:Button runat="server" ID="ButtonRunReport" Text="Run Report" OnClick="ButtonRunReport_Click"
                            Width="120px" ValidationGroup="OnRunReport" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:Button ID="ButtonPrintReport" runat="server" Text="Print/Export Report" Width="150px"
                            ValidationGroup="OnRunReport" OnClick="ButtonPrintReport_Click" Style="margin-left: 0px;
                            margin-top: 8px" />
                          &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                         <asp:Button runat="server" ID="ButtonClear" Text="Clear" 
                            Width="120px" OnClick="ButtonClear_Click"/>
                     </td>
                </tr>
            </table>
        </asp:Panel>
    </asp:Panel>
    <asp:Panel ID="PanelReportViewer" runat="server">
        <rsweb:ReportViewer ID="ReportViewerReport" runat="server" Width="100%" ProcessingMode="Remote"
            Height="700px">
        </rsweb:ReportViewer>
    </asp:Panel>
    <asp:Panel ID="PanelRegistrantEligibilityReview" runat="server" Visible="false" GroupingText=" Report Results ">
        <asp:Label runat="server" ID="LabelNumberOfResultsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
            </div>
        <asp:GridView ID="GridViewRegistrantEligibilityReview" runat="server" DataSourceID="DataSourceRegistrantEligibilityReview"
            Caption="To sort please click table headings"
            AutoGenerateColumns="False" PageSize="20" Width="100%" AllowPaging="True" AllowSorting="True" DataKeyNames="REGISTRANT_ID"
            PagerSettings-Mode="Numeric"
            OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:TemplateField Visible="false" HeaderText="ID" SortExpression="REGISTRANT_ID" >
                      <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantID" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))  %>'
                            CommandName="Details" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID")) %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Last Name" SortExpression="LAST_NAME" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                         <asp:Label ID="LabelLastName" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("LAST_NAME")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="First Name" SortExpression="FIRST_NAME">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelFirstName" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("FIRST_NAME")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Middle Name" SortExpression="MIDDLE_NAME">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelMiddleName" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("MIDDLE_NAME")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="SSN" SortExpression="SSN">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Snum")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
          </Columns>
            <HeaderStyle HorizontalAlign="Left" />
        </asp:GridView>
    </asp:Panel>
    <asp:ObjectDataSource ID="DataSourceRegistrantEligibilityReview" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetEligibilityReviewReport" EnablePaging="true" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="SortExpression" SelectCountMethod="GetEligibilityReviewReportCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
           <asp:ControlParameter ControlID="BaseControlListBoxStatus" Name="registrantStatus" PropertyName="Text"
                Type="String" />
           <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagId" PropertyName="AdminFlagId"
                Type="String" />
           <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFromDateText" PropertyName="AdminFlagEnteredDateFrom" Type="String" />
           <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminToDateText" PropertyName="AdminFlagEnteredDateTo" Type="String" />      
        </SelectParameters>
    </asp:ObjectDataSource>
    </asp:Content>

