<%@ Page Title="Registrants" EnableEventValidation="false" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="RegistrantStatusHistory.aspx.cs" Inherits="RegistrantStatusHistory" %>
<%@ Register src="controls/UserControlRegistrant.ascx" tagname="UserControlRegistrant" tagprefix="UserControl" %>
<%@ Register src="controls/UserControlQuestionnaire.ascx" tagname="UserControlQuestionnaire" tagprefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
     <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Registrants > Registrant > Status History</H1>"/>
    </div>   
    <UserControl:UserControlRegistrant ID="UserControlRegistrant" runat="server" /> 
     <br />
<asp:Panel ID="PanelStatusHistory" runat="server" GroupingText=" Status History " >
    <asp:GridView 
        ID="GridViewStatusHistory" 
        runat="server" 
        Caption="Status History"   
        AutoGenerateColumns="False"
        DataSourceID="DataSourceStatusHistory"
        EnableModelValidation="True" 
        DataKeyNames="PROCESS_METRICS_ID" 
        onrowdatabound="GridViewStatusHistory_RowDataBound">
    <EmptyDataTemplate>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp No status history found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
    <Columns>
        <asp:TemplateField HeaderText="ID" AccessibleHeaderText="ID" Visible="false" >
           <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelStatusId" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("PROCESS_METRICS_ID")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>
        
        <asp:TemplateField HeaderText="Status">
           <HeaderStyle HorizontalAlign="Center" />
           <ItemTemplate>
                <asp:Label ID="LabelStatus" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("PROCESS_METRICS_VALUE"))  %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        <asp:TemplateField HeaderText="Updated Date Time" >
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelUpdatedDateTime" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("UPDATED")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

        
        <asp:TemplateField HeaderText="Updated By">
            <HeaderStyle HorizontalAlign="Center" />
            <ItemTemplate>
                <asp:Label ID="LabelUpdatedBy" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("UPDATEDBY")) %>'></asp:Label>
            </ItemTemplate>
        </asp:TemplateField>

    </Columns>
</asp:GridView>
    <asp:ObjectDataSource 
        ID="DataSourceStatusHistory" runat="server" 
            SelectMethod="SelectProcessMetrics" 
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="String" />
            <asp:ControlParameter ControlID="HiddenFieldProcessMeticType" Name="metricType" PropertyName="Value" Type="String" />
      </SelectParameters>
    </asp:ObjectDataSource>
</asp:Panel>
<asp:HiddenField ID="HiddenFieldProcessMeticType" runat="server" />
<asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
</asp:Content>


