﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Web.UI.WebControls.WebParts;
using System.Text;
using System.IO;
using System.Reflection;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

public partial class NameUpdateSearchRegistrant : BasePage
{
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
   // private AHOBPRRegistrantManager _registrantManager = new AHOBPRRegistrantManager();

    #region Protected Members

    protected void Page_Load(object sender, EventArgs e)
    {
        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }
        LoadBaseControls();
        UserSession.RegistrantId = 0;
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        GridViewRegistrant.DataBind();
        GridViewRegistrant.Visible = true;
        gridViewPageSizeDdl.Visible = true;
        LabelItemsPerPage.Visible = true;

        if (!IsPostBack)
        {
            UserControlBirthDate.LoadControlsFromObject(string.Empty, "Date of Birth (mm/dd/yyyy):<br />", "Date of Birth", "SearchRegistrant");
        }
    }


    protected void Search_Click(object sender, EventArgs e)
    {
        SearchRegistrants();
    }

    private void HideSelectButtonColumn()
    {
        UserAccountManager currentUser = (UserAccountManager)HttpContext.Current.User;
        if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleHelpDeskCode))
            && !currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode))
            && GridViewRegistrant.Rows.Count > 0)
        {
            GridViewRegistrant.HeaderRow.Cells[5].Visible = false;
            for (int index = 0; index < GridViewRegistrant.Rows.Count; index ++)
            {
                GridViewRegistrant.Rows[index].Cells[5].Visible = false;
            }
        }

    }
 
    private void SearchRegistrants()
    {

        // Validate that at least one value was entered    
        if (String.IsNullOrEmpty(BaseControlTextBoxLastName.Text) 
            && String.IsNullOrEmpty(BaseControlTextBoxLast4SSN.Text)
            && string.IsNullOrEmpty(UserControlBirthDate.Text))
        {
            CustomValidatorSearchCriteria.ErrorMessage = "Please select at least one search criteria.";
            CustomValidatorSearchCriteria.IsValid = false;
        }
        else if (UserControlBirthDate.ValidateCustomValidator() == true)
        {
            GridViewRegistrant.DataBind();
            GridViewRegistrant.Visible = true;
            gridViewPageSizeDdl.Visible = true;
            LabelItemsPerPage.Visible = true;
        }
        else
        {
            GridViewRegistrant.Visible = false;
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
            LabelNumberOfRegistrantsFound.Visible = false;
        }
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        BaseControlTextBoxLastName.Text = string.Empty;
        BaseControlTextBoxLast4SSN.Text = string.Empty;
        UserControlBirthDate.Text = string.Empty;
        GridViewRegistrant.DataBind();
        GridViewRegistrant.Visible = true;
        gridViewPageSizeDdl.Visible = true;
        LabelItemsPerPage.Visible = true;
        LabelBreadCrumb.Text = "<H1>Non-Verified Names > Registrant Search </H1>";
    }
            
    #endregion

    #region Abstract Member Implementations
    public override string TopMenuName()
    {
        return "Registrants";
    }

    public override string MenuItemName()
    {
        return "Non-Verified Names";
    }

    public override string AppObjectCode()
    {
        return "AHOBPR NAME UPDATE";
    }
    #endregion

    #region Private Members

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_NAME_UPDATE_SEARCH"))
        {
            Control userControl = PanelSearchCriteria.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.TextBox)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                        dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                        dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION,
                        dbItem.REQUIRED);
                }
          }
        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsNameUpdateSearch == null)
        {
            _dbAhopbrControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsNameUpdateSearch = _dbAhopbrControls;
        }
        else
        {
            _dbAhopbrControls = UserSession.GuiControlsNameUpdateSearch;
        }

        return _dbAhopbrControls;
    }

    #endregion
    protected void GridViewRegistrant_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewRegistrant.SelectedIndex = index;
            UserSession.RegistrantId = (int)GridViewRegistrant.SelectedValue;
            Response.Redirect("NameUpdate.aspx?id=" + GridViewRegistrant.SelectedValue);
        }
    }

    protected void RegistrantSearchDS_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        var totalRecordsFound = e.ReturnValue;
        LabelNumberOfRegistrantsFound.Visible = true;
        LabelNumberOfRegistrantsFound.Text = "Total Registrants Found: " + totalRecordsFound;
        LabelBreadCrumb.Text = "<H1>Non-Verified Names > Registrant Search </H1>";


    }

    protected void GridViewRegistrant_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        HideSelectButtonColumn();        
    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {
        if (UserControlBirthDate.ValidateCustomValidator() == true)
        {
            GridViewRegistrant.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);
        }
        else
        {
            GridViewRegistrant.Visible = false;
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
            LabelNumberOfRegistrantsFound.Visible = false;
        }
    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewRegistrant.PageIndex = e.NewPageIndex;

    }

}