﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true"
    CodeFile="MyEmailTemplates.aspx.cs" Inherits="MyEmailTemplates" %>

<%@ Register Assembly="Microsoft.ReportViewer.WebForms, Version=11.0.0.0, Culture=neutral, PublicKeyToken=89845dcd8080cc91"
    Namespace="Microsoft.Reporting.WebForms" TagPrefix="rsweb" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID="LabelBreadCrumb" runat="server" Text="<H1>Registrants > My Message Templates</H1>" />
    </div>
    <div>
         <asp:Panel ID="PanelRegistryMessages" runat="server" GroupingText="My Message Templates&nbsp;&nbsp;"
            Width="100%">
             <div style="text-align: right;" runat="server" id="pageSizeDiv1">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage1" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl1"   ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl1" AutoPostBack="true"  CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewMyTempPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
            </div>
            <asp:GridView ID="GridViewMyTemplates" runat="server" AutoGenerateColumns="False" Width="100%"
                OnRowDataBound="GridViewMyTemplates_RowDataBound"  DataSourceID="MyTemplates" AllowPaging="true"
                AllowSorting="True" DataKeyNames="TEMPLATE_ID" Caption="My Message Templates"
                PagerSettings-Mode="Numeric"
                OnPageIndexChanging="gridViewMyTemp_PageIndexChanging">
                <EmptyDataTemplate>No Message Templates Found</EmptyDataTemplate>
                <Columns>
                    <asp:BoundField DataField="TEMPLATE_ID" HeaderText="ID" SortExpression="TEMPLATE_ID" />
                    <asp:TemplateField HeaderText="Title">
                        <ItemTemplate>
                            <asp:LinkButton ID="LinkButtonTitle" runat="server" CausesValidation="False" CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TEMPLATE_ID"))) %>'
                                CommandName="Preview" OnCommand="PreviewCommand" ></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Subject">
                        <ItemTemplate>
                            <asp:Label ID="lblsubject" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Status" SortExpression="Active">
                        <HeaderStyle HorizontalAlign="Center" />
                       <ItemStyle HorizontalAlign="Center" />
                       <ItemTemplate>
                            <asp:Label ID="LabelActive" runat="server" SkinID="DataLabel" Text='<%# Convert.ToBoolean(Eval("ACTIVE")) ? "Active" : "Inactive" %>'
                                />
                        </ItemTemplate>
                </asp:TemplateField> 
                   <asp:TemplateField HeaderText="Action">
                       <HeaderStyle HorizontalAlign="Center" />
                       <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:LinkButton ID="LinkButtonEdit" runat="server" CausesValidation="False" CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TEMPLATE_ID"))) %>'
                                CommandName="Edit" OnCommand="EditCommand" Text="Edit"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
             </asp:Panel> 
            <br />
            <asp:Panel ID="PanelAvailableMessageTemplates" runat="server" GroupingText="Available Message Templates&nbsp;&nbsp;"
            Width="100%">              
                    <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"   ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true"  CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
            </div>
             <asp:GridView ID="GridViewAvailableTemplates" runat="server" AutoGenerateColumns="False" Width="100%"
                OnRowDataBound="GridViewAvailableTemplates_RowDataBound"  DataSourceID="dataTemplates" 
                AllowSorting="True" DataKeyNames="TEMPLATE_ID" AllowPaging="True" Caption="Available Message Templates"
                PagerSettings-Mode="Numeric"
                OnPageIndexChanging="gridView_PageIndexChanging">
                <Columns>
                    <asp:BoundField DataField="TEMPLATE_ID" HeaderText="ID" SortExpression="TEMPLATE_ID" />
                    <asp:TemplateField HeaderText="Title">
                        <ItemTemplate>
                            <asp:LinkButton ID="LinkButtonTitle" runat="server" CausesValidation="False" CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TEMPLATE_ID"))) %>'
                                CommandName="Preview" OnCommand="PreviewCommand" ></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Subject">
                        <ItemTemplate>
                            <asp:Label ID="lblsubject" runat="server"></asp:Label>
                        </ItemTemplate>
                    </asp:TemplateField>
                   <asp:TemplateField HeaderText="Action">
                       <HeaderStyle HorizontalAlign="Center" />
                       <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:LinkButton ID="LinkButtonCopy" runat="server" CausesValidation="False" CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("TEMPLATE_ID"))) %>'
                                CommandName="Copy" OnCommand="CopyCommand" Text="Copy"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
        </asp:Panel>
    </div>
    <asp:HiddenField runat="server" ID="HiddenFieldUserName" />
    <asp:ObjectDataSource ID="dataTemplates" runat="server" TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPREmailTemplateManager"
        SelectMethod="GetTemplatesForAdvancedUsers" EnablePaging="True"  SelectCountMethod="GetTemplatesForAdvancedUsersCount"
        SortParameterName="SortExpression" StartRowIndexParameterName="startRowIndex" MaximumRowsParameterName="maximumRows" >
   </asp:ObjectDataSource>
    <asp:ObjectDataSource ID="MyTemplates" runat="server" TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPREmailTemplateManager"
        SelectMethod="GetTemplatesByUser" EnablePaging="True"  SelectCountMethod="GetTemplatesByUserCount"
        SortParameterName="SortExpression" StartRowIndexParameterName="startRowIndex" MaximumRowsParameterName="maximumRows" >
    <SelectParameters>
        <asp:ControlParameter ControlID="HiddenFieldUserName" Name="userName" PropertyName="Value" Type="string" />
    </SelectParameters>
    </asp:ObjectDataSource>
</asp:Content>
