﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using AntiXssEnc = Microsoft.Security.Application;
using System.Configuration;

public partial class MyAccountEditUser : BasePage
{
    private string _currentRegistry = Helpers.GetConfigEntry("Registry");
    private List<STD_GUI_CONTROL_AHOBPR> _dbControls = null;
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();

    USER userEntry;
    AHOBPR_USER _ahobprUserEntry;
    UsersManager usersManager = new UsersManager();
    AHOBPRUserManager _ahobprUserManager = new AHOBPRUserManager();
    USER_STATES_FILTER _stateFilter = new USER_STATES_FILTER();
    private bool _isOnlyAdvancedUser = false;

    #region Protected Methods
    protected void Page_Load(object sender, EventArgs e)
    {
        UserAccountManager currentUser = (UserAccountManager)HttpContext.Current.User;
        UserAccountManager manager = new UserAccountManager(currentUser.UserName, "AHOBPR");
        AlterPageForAdvancedUsers(currentUser, ConfigurationManager.AppSettings["ChangeStatusStateFilterLimit"].ToString());
        if (!IsPostBack)
        {
            HiddenFieldUserID.Value = manager.UserId.ToString();
            ReloadControls();
        }
        LoadBaseControls();
        if (_isOnlyAdvancedUser)
        {
            LoadUserControlListBox();
        }
    }

    private void AlterPageForAdvancedUsers(UserAccountManager user, string filterLimit)
    {
        //set class field as it will be referenced when saving the user
        _isOnlyAdvancedUser = CheckIfUserHasAdvancedUserRole(user);
        SetVisibilityOfStateFilterDiv(_isOnlyAdvancedUser, filterLimit);

    }

    private bool CheckIfUserHasAdvancedUserRole(UserAccountManager user)
    {
        if (user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode)) && 
            !user.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode))) {
            _isOnlyAdvancedUser = true;
        }
        return _isOnlyAdvancedUser;
    }

    private void SetVisibilityOfStateFilterDiv(bool isAdvancedUser, string filterLimit)
    {
        if (_isOnlyAdvancedUser)
        {
            ListBoxState.Visible = true;
            StateFilterLimit.Text = filterLimit;
            UserControlListBoxState.IsRequired = true;
        }
        else
        {
            //DEBUGGING: Remove and find a better way to TEST
            ListBoxState.Visible = false;
            //todo put code in javascript that will pass by validation if limit set to 0
            //todo add button save functionality that will not submit state filter info if user isn't an advanced user
            StateFilterLimit.Text = "0";
            UserControlListBoxState.IsRequired = false;
        }
    }

    private void ReloadControls()
    {
        //Create User Entity object and Set properties to state of form
        getEntry(Convert.ToInt32(HiddenFieldUserID.Value));

        if (IsPostBack && userEntry != null)
        {
            LoadControlsFromObject();
        }
    }
    protected void getEntry(int id)
    {
        userEntry = usersManager.SelectByID(_currentRegistry, id);
        _ahobprUserEntry = _ahobprUserManager.GetUser(id);
    }
    #endregion Protected Methods

    public override string TopMenuName()
    {
        return "My Account";
    }
    public override string MenuItemName()
    {
        return "Account Information";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR MY ACCOUNT";
    }
    void Page_PreRender(object sender, EventArgs e)
    {
        if (userEntry != null)
        {
           
            //This is the last event in the page life cycle where changes can be made to the page object
            //so enforce business rules on the object (which could possibly change the propertie of the object
            //then load the form controls from the object

            //Enforce business rules on the referral object
            //need to call EnforceBusinessRules method in the ReferralManager because some rules require a database call
            //pass in the local instance of referral to the method.  The method will return the object with modifications due to business rules.
            if (IsPostBack)
            {
                int ret;
                ret = usersManager.EnforceBusinessRules(ref userEntry);
            }

            //Load Controls from the Object
            LoadControlsFromObject();

        }

    }
    #region Object/Form Mapping
    private void LoadUserControlListBox()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_MYACCOUNT_ACCOUNTINFORMATION"))
        {
            //PanelUserInformation is the Panel ID found in MyAccountEditUser.aspx
            Control userControl = PanelUserInformation.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.ListBox)
                {
                    controls_UserControlListBoxState baseControl = (controls_UserControlListBoxState)userControl;
                    baseControl.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                            dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                }
            }
        }

    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsMyAccountEditUser == null)
        {
            _dbControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            //Session["GuiControlsMyAccountEditUser"] = _dbControls;
            UserSession.GuiControlsMyAccountEditUser = _dbControls;
        }
        else
        {
            //_dbControls = (List<STD_GUI_CONTROL_AHOBPR>)Session["GuiControlsMyAccountEditUser"];
            _dbControls = UserSession.GuiControlsMyAccountEditUser;
        }

        return _dbControls;
    }

    private void LoadControlsFromObject()
    {
        if (userEntry != null &&
            userEntry.USER_ID != 0)
        {
            AHOBPRUserManager ahobprUserManager = new AHOBPRUserManager();
            AHOBPR_USER ahobprUser = ahobprUserManager.GetUser(userEntry.USER_ID);

            //Username:
            TextBoxUsername.Text = userEntry.USERNAME;
            //Full Name:
            TextBoxFullName.Text = userEntry.FULL_NAME;

            //First Name:
            TextBoxFirstName.Text = userEntry.FIRST_NAME;

            //Middle Name:
            TextBoxMiddleName.Text = userEntry.MIDDLE_NAME;

            //Last Name:
            TextBoxLastName.Text = userEntry.LAST_NAME;

            //Maiden Name:
            TextBoxMaidenName.Text = userEntry.MAIDEN_NAME;

            //Employee Number:
            TextBoxEmployeeNumber.Text = userEntry.EMPLOYEE_NUMBER;

            //Job Title:
            TextBoxJobTitle.Text = userEntry.JOB_TITLE;

            //Email Address:
            TextBoxEmailAddress.Text = userEntry.EMAIL_ADDRESS;

            //Telephone:
            TextBoxTelephone.Text = userEntry.TELEPHONE_NUMBER;

            //Fax:
            TextBoxFax.Text = userEntry.FAX_NUMBER;

            //Created By:
            string createdBy = string.IsNullOrEmpty(userEntry.CREATEDBY) ? userEntry.USERNAME : userEntry.CREATEDBY;
            LabelCreatedBy.Text = AntiXssEnc.Encoder.HtmlEncode(createdBy);

            //Created On:
            LabelCreatedOn.Text = Helpers.getShortDateStringFromNullableDate(userEntry.CREATED);

            //Updated By:
            string updatedBy = string.IsNullOrEmpty(userEntry.UPDATEDBY) ? userEntry.USERNAME : userEntry.UPDATEDBY;
            LabelUpdatedBy.Text = AntiXssEnc.Encoder.HtmlEncode(updatedBy);

            //Updated On:
            LabelUpdatedOn.Text = Helpers.getShortDateStringFromNullableDate(userEntry.UPDATED);

            //Last Login
            LabelLastLogin.Text = ahobprUser.LAST_LOGIN == null ? "[None]" : ahobprUser.LAST_LOGIN.Value.ToString();

            //Last VistA Login:
            LabelLastVistaLogin.Text = ahobprUser.LAST_VISTA_LOGIN == null ? "[None]" : ahobprUser.LAST_VISTA_LOGIN.Value.ToString();

            //Status label, Activate & Approve buttons:
            if (ahobprUser.ACTIVE_FLAG)
            {
                if (ahobprUser.PENDING_FLAG)
                {
                    LabelStatus.Text = "Pending";
                }
                else
                {
                    LabelStatus.Text = "Active";
                }
            }
            else
            {
                LabelStatus.Text = "Inactive";
            }

            //Primary Job, Secondary Job and Work Location
            BaseControlDropdownListPrimaryJob.Text = ahobprUser.PRIMARY_JOB_ID.ToString();
            BaseControlDropdownListSecondaryJob.Text = ahobprUser.SECONDARY_JOB_ID.ToString();
            BaseControlDropdownListWorkLocation.Text = ahobprUser.WORK_LOCATION_ID.ToString();

            // user state filter
            //Only advanced users have the opportunity to select the states to filter on
            //The UserConotrolListBoxState won't be loaded for a non-advanced user, so
            // don't try to set that control
            if (_isOnlyAdvancedUser)
            {
                _stateFilter = _ahobprUserManager.GetStatesFilter(userEntry.USER_ID);
                if (_stateFilter == null)
                {
                    //USER isn't set up in this table, better create an entry to be saved later
                    _stateFilter = new USER_STATES_FILTER
                    {
                        USER_ID = userEntry.USER_ID,
                        STATES = ""
                    };
                }
                this.UserControlListBoxState.DataElementValue = Helpers.ConvertToKeyValuePair(_stateFilter.STATES);
            }
        }
    }

    private void LoadObjectFromControls()
    {
        getEntry(Convert.ToInt32(HiddenFieldUserID.Value));

        //Username:
        userEntry.USERNAME = TextBoxUsername.Text;

        //Full Name:
        userEntry.FULL_NAME = TextBoxFullName.Text;

        //First Name:
        userEntry.FIRST_NAME = TextBoxFirstName.Text;

        //Middle Name:
        userEntry.MIDDLE_NAME = TextBoxMiddleName.Text;

        //Last Name:
        userEntry.LAST_NAME = TextBoxLastName.Text;

        //Maiden Name:
        userEntry.MAIDEN_NAME = TextBoxMaidenName.Text;

        //Employee Number:
        userEntry.EMPLOYEE_NUMBER = TextBoxEmployeeNumber.Text;

        //Job Title:
        userEntry.JOB_TITLE = TextBoxJobTitle.Text;

        //Email Address:
        userEntry.EMAIL_ADDRESS = TextBoxEmailAddress.Text;

        //Telephone:
        userEntry.TELEPHONE_NUMBER = TextBoxTelephone.Text;

        //Fax:
        userEntry.FAX_NUMBER = TextBoxFax.Text;


      
        //Primary job, secondary job and work location
        if (_ahobprUserEntry == null || _ahobprUserEntry.USER_ID == 0)
        {
            _ahobprUserEntry = new AHOBPR_USER();
            _ahobprUserEntry.USER_ID = userEntry.USER_ID;
        }
        var primaryId = string.IsNullOrEmpty(BaseControlDropdownListPrimaryJob.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListPrimaryJob.Text);
        var secondaryId = string.IsNullOrEmpty(BaseControlDropdownListSecondaryJob.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListSecondaryJob.Text);
        var workLocation = string.IsNullOrEmpty(BaseControlDropdownListWorkLocation.Text) ? null : (int?)Helpers.getIntFromString(BaseControlDropdownListWorkLocation.Text);
        _ahobprUserManager.UpdatePrimaryJob(_ahobprUserEntry, primaryId);
        _ahobprUserManager.UpdateSecondaryJob(_ahobprUserEntry, secondaryId);
        _ahobprUserManager.UpdateWorkLocation(_ahobprUserEntry, workLocation);


        //Only advanced users have the opportunity to select the states to filter on

        if (_isOnlyAdvancedUser)
        {
            //TODO Add STATE_FILTER settings here
            _stateFilter.USER_ID = Convert.ToInt32(HiddenFieldUserID.Value);
            _stateFilter.STATES = UserControlListBoxState.Text;
        }
    }



    #endregion
    #region Postback Events

    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        int returnSaveValue;

        LoadObjectFromControls();
        returnSaveValue = usersManager.Update(userEntry);
        _ahobprUserManager.UpdateUser(_ahobprUserEntry);
        //Only advanced users have the opportunity to select the states to filter on
        //If the user doesn't have the advanced users role, don't make a call to the DB
        if (_isOnlyAdvancedUser)
        {
            _ahobprUserManager.UpdateUserStateFilter(_stateFilter);
        }
       
        //Set Broken Rule Error Display
        if (userEntry.BrokenRules.Count == 0)
        {
            var master = (this.Master as RegistryMaster);
            if (master != null)
            {
                master.SetDirtyFlag(false);
            }
            Alert.ShowSaveSuccess();
        }

    }

    protected void ButtonCancel_Click(object sender, EventArgs e)
    {
        ReloadControls();
    }


    #endregion

    protected void ShowMessage(string message)
    {
        string script = "<script language=\"javascript\"  type=\"text/javascript\">alert('" + message.Replace("'", "\\'") + "');</script>";
        ScriptManager.RegisterStartupScript(Page, this.GetType(), "AlertMessage", script, false);
    }



    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_MYACCOUNT_ACCOUNTINFORMATION"))
        {
            Control userControl = PanelUserInformation.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                switch (dbItem.BASE_CONTROL_TYPE)
                {
                    case (int)AhobprBaseControlType.DropDownList:
                        controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                        baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                                   dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                        break;

                }
            }
        }
    }
}
