﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using AntiXssEnc = Microsoft.Security.Application;

public partial class Login : BasePage
{
    #region Messages

    private const String CreateAccountError = "There was an error creating your account.  " +
        "Please contact the AHOBPR Clinical Portal Registry Manager/Help Desk.  " +
        "Email & Phone # go here.";
    private const String WaitingForAuthorization = "If you have a VistA account, click below to validate you credentials. Once your VistA credentials are validated your account will be approved.<br /> ";
    private const String VistaLoginFailureNewAccount = "Your VistA Credentials cannot be validated.  " +
        "Try again or select 'I don't have a VistA account'";
    private const String VistaLoginFailureExistingAccount = "If you have a VistA account, click below to validate you credentials. Once your VistA credentials are validated your account will be approved.";
    private const String AccountDisabled = "Your account has been disabled.  <br />If you have a VistA account, click below to validate you credentials. Once your VistA credentials are validated your account will be approved.  <br /> ";
    private const String VistaLoginMessage = "Vista credentials are validated annually.  " +
        "In order to continue accessing the AHOBPR Clinical Portal, please verify your VistA credentials.";
    private const String ContactInfo = "If you don’t have a VistA account contact the AHOBPR Help Desk (877) 470-5947 -Weekdays 7a.m. – 7p.m (CT).";
    private const String ContactInfoPending = "If you don’t have a VistA account,  your account is pending approval.  Contact the AHOBPR Help Desk (877) 470-5947 -Weekdays 7a.m. – 7p.m (CT).";

    #endregion

    #region Events

    protected void Page_Load(object sender, EventArgs e)
    {
        UserSession.GuiControls = null;
        if (!IsPostBack)
        {
            if (!string.IsNullOrEmpty(UserSession.LoginMessage))
            {
                DisplayMessage(UserSession.LoginMessage);
                UserSession.LoginMessage = string.Empty;
                return;
            }

            DisplayMessage(null);
            CheckLogin();

            string rString = GetVistaLoginAddress();
            vistaLoginBtn.PostBackUrl = rString;
        }
    }

    protected void createAcctBtn_Click(Object sender, EventArgs e)
    {
        Response.Redirect("CreateAccount.aspx");
    }

    protected void devLoginBtn_Click(Object sender, EventArgs e)
    {
        String username = ((LinkButton)sender).CommandArgument;
        HttpContext.Current.User = new System.Security.Principal.GenericPrincipal(
            new System.Security.Principal.GenericIdentity(username), new String[] { });
        System.Threading.Thread.CurrentPrincipal = HttpContext.Current.User;
        Response.Cookies.Add(new HttpCookie("Debug-UserName", username));
        CheckLogin();
    }

    protected void newUserBtn_Click(Object sender, EventArgs e)
    {
        string username = HttpContext.Current.User.GetCurrentUserNameWithoutDomain() + DateTime.Now.Millisecond.ToString();
        HttpContext.Current.User = new System.Security.Principal.GenericPrincipal(
            new System.Security.Principal.GenericIdentity(username), new String[] { });
        System.Threading.Thread.CurrentPrincipal = HttpContext.Current.User;
        Response.Cookies.Add(new HttpCookie("Debug-UserName", username));
        CheckLogin();
    }

    #endregion 

    #region Page Setup

    private void DisplayMessage(String message)
    {
        if (!string.IsNullOrEmpty(UserSession.LoginMessage))
        {
            message = UserSession.LoginMessage;
        }
        if (message != null)
        {
            newUserLoginPnl.Visible = false;
            switch (message)
            {
                case "CreateAccountError":
                    loginMessageLbl.Text = CreateAccountError;
                    break;
                case "WaitingForAuthorization":
                    loginMessageLbl.Text = WaitingForAuthorization;
                    loginMessage2Lbl.Text = ContactInfoPending;
                    newUserLoginPnl.Visible = true;
                    break;                    
                case "VistaLoginFailureExistingAccount":
                    loginMessageLbl.Text = VistaLoginFailureExistingAccount;
                    break;
                case "VistaLoginFailureNewAccount":
                    loginMessageLbl.Text = VistaLoginFailureNewAccount;
                    break;
                case "AccountDisabled":
                    loginMessageLbl.Text = AccountDisabled;
                    loginMessage2Lbl.Text = ContactInfo;
                    newUserLoginPnl.Visible = true;
                    break;
                case "VistaLoginMessage":
                    loginMessageLbl.Text = VistaLoginMessage;
                    loginMessage2Lbl.Text = ContactInfo;
                    newUserLoginPnl.Visible = true;
                    break;
            }
            UserSession.LoginMessage = string.Empty;
        }
    }

    public override string TopMenuName()
    {
        return string.Empty;
    }

    public override string MenuItemName()
    {
        return string.Empty;
    }

    public override string AppObjectCode()
    {
        return string.Empty;
    }

    #endregion

    private void CheckLogin()
    {
        //Determine whether the user exists:
        //Try pulling the user from the main user table:
        string userId = HttpContext.Current.User.GetCurrentUserNameWithoutDomain();
        string Registry = Helpers.GetConfigEntry("Registry");
        UserAccountManager mainUser = new UserAccountManager(userId, Registry);

        //now determine if they're an AHOBPR user:
        AHOBPRUserManager userManager = new AHOBPRUserManager();
        AHOBPR_USER ahobprUser = userManager.GetUser(mainUser.UserId);
        if (mainUser.UserId == 0 || ahobprUser == null)
        {
            //Then this user does not have an account in the system.
            //Redirect them to the create account page:
            Response.Redirect("CreateAccount.aspx");
        }

        //The user does have a standard login, set the current user & principal:
        HttpContext.Current.User = mainUser;
        System.Threading.Thread.CurrentPrincipal = mainUser;

        switch (ahobprUser.IsValid())
        {
            case AhobprExtensions.LoginResults.New:
                DeleteUserCookie();
                Response.Redirect("CreateAccount.aspx");
                break;
            case AhobprExtensions.LoginResults.Disabled:
                DisplayMessage("AccountDisabled");
                DeleteUserCookie();
                break;
            case AhobprExtensions.LoginResults.Disabled90Days:
                //Disable the account:
                userManager.EnableAccount(ahobprUser, false);
                //Redirect to the VISTA login page
                DisplayMessage("AccountDisabled");
                DeleteUserCookie();
                break;
            case AhobprExtensions.LoginResults.DisabledVista:
                DisplayMessage("VistaLoginMessage");
                DeleteUserCookie();
                break;
            case AhobprExtensions.LoginResults.Pending:
                DisplayMessage("WaitingForAuthorization");
                DeleteUserCookie();
                break;
            case AhobprExtensions.LoginResults.Valid:
                SuccessfulLogin();
                break;
        }
    }

    private void SuccessfulLogin()
    {
        //Update Last Login value for this user:
        AHOBPRUserManager userManager = new AHOBPRUserManager();
        AHOBPR_USER ahobprUser = userManager.GetUser(((VeteransAffairs.Registries.BusinessManager.UserAccountManager)HttpContext.Current.User).UserId);
        userManager.UpdateLogin(ahobprUser);
        UserSession.CurrentUser = ahobprUser;

        if (Request.Cookies["CurrentUser"] == null)
        {
            HttpCookie newCookie = new HttpCookie("CurrentUser", HttpContext.Current.User.GetCurrentUserNameWithoutDomain());
            newCookie.Expires = DateTime.Now.AddMinutes(30);
            Response.Cookies.Add(newCookie);
            
            Response.Redirect("login.aspx");
        }
        else
        {
            HttpCookie newCookie = new HttpCookie("CurrentUser", HttpContext.Current.User.GetCurrentUserNameWithoutDomain());
            newCookie.Expires = DateTime.Now.AddMinutes(30);
            Response.Cookies.Add(newCookie);

            Response.Redirect("RegistrantSearch.aspx");
        }
    }

    private void DeleteUserCookie()
    {
        HttpCookie newCookie = new HttpCookie("CurrentUser", "x");
        newCookie.Expires = DateTime.Now.AddMinutes(30);
        Response.Cookies.Add(newCookie);
    }

    private string GetVistaLoginAddress()
    {
        String strFinalURL = string.Empty;
        String strUserKey = Convert.ToBase64String(System.Text.ASCIIEncoding.ASCII.GetBytes(HttpContext.Current.User.GetCurrentUserNameWithoutDomain()));
        String[] strURLArray = new String[] 
        {   "DevVistaLogin.aspx" + "/" + strUserKey
            , "https://IP           /ahobpr-provider/registry" + "/" + strUserKey
            , "https://IP           /ahobpr-provider/registry" + "/" + strUserKey
            , "https://IP           /ahobpr-provider/registry" + "/" + strUserKey
            , "https://IP           /ahobpr-provider/registry" + "/" + strUserKey
            , "https://IP           /ahobpr-provider/registry" + "/" + strUserKey
        };
        
        String redirect = Helpers.GetConfigEntry("VistaLoginAddress") + "/" + strUserKey;

        if (strURLArray.Contains(redirect))
            strFinalURL = redirect;

        return strFinalURL;
    }
}
