﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Configuration;
using System.IO;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using System.Web.Configuration;

public partial class EnvironmentCheck : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        AHOBPRAdminManager manager = new AHOBPRAdminManager();

        LabelBuildVersion.Text = "Build Version: " + manager.GetBuildVersion()
            + "<br />Build Date Time: " + GetBuildDateTime();

        LabelErrorPageInfo.Text = GetFileInfo("ErrorPage.aspx");

        LabelDatabaseName.Text = manager.GetDatabaseName();

    }

    private string GetBuildDateTime()
    {
        string buildDate = string.Empty;
        FileInfo file = new FileInfo(Request.PhysicalApplicationPath + "\\bin\\VeteransAffairs.Registries.BusinessManager.dll");

        if (file.Exists)
        {
            buildDate = file.LastWriteTime.ToString(); ;
        }

        return buildDate;
    }

    private string GetFileInfo(string fileName)
    {
        string fileInfo = string.Empty;

        // create an instance of the FileInfo object
        FileInfo file = new FileInfo(Request.PhysicalApplicationPath + "\\" + fileName);

        if (file.Exists)
        {
            fileInfo += "File Name: " + file.Name + "<br />";
            fileInfo += "Location: " + file.FullName + "<br />";
            fileInfo += "Created on: " + file.CreationTime + "<br />";
            fileInfo += "Last modified on: " + file.LastWriteTime + "<br />";
            fileInfo += "File size (in bytes): " + file.Length.ToString() + "<br />";
        }
        else
        {
            fileInfo = "<font color=\"red\">Sorry, the  file <b>" + fileName + "</b> was not found.</font>";
        }
        return fileInfo;
    }
    protected void ButtonGetFileInfo_Click(object sender, EventArgs e)
    {
        //LabelFileInfo.Text = GetFileInfo(TextBoxFileName.Text);
    }

    protected String BprEval(Object o)
    {
        if (o == null)
        {
            return "";
        }
        return HttpUtility.HtmlEncode(o.ToString());
    }

    public override string TopMenuName()
    {
        return string.Empty;
    }

    public override string MenuItemName()
    {
        return string.Empty;
    }

    public override string AppObjectCode()
    {
        return string.Empty;
    }
}
