﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using Microsoft.Reporting.WebForms;

public partial class ClinicalUserAdHocReport : BasePage
{
   // List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private AHOBPRBaseControlManager _baseControlManager = new AHOBPRBaseControlManager();
    private List<STD_GUI_CONTROL_AHOBPR> _dbAhopbrControls = null;
   // private AHOBPRReportManager _reportManager = new AHOBPRReportManager();
   // private string _serverReportName = "ClinicalUserAdHocReport";

    public string ServerReportParameters { get; set; }

    protected void Page_Load(object sender, EventArgs e)
    {
        UserSession.ClinicalUserAdHocReportFilterActionType = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterRole = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterFromDate = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterToDate = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterStatus = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterPrimaryJob = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterSecondaryJob = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterChangeStatusState = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterJobTitle = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterWorkLocation = string.Empty;
        UserSession.ClinicalUserAdHocReportFilterRole = string.Empty;

        LoadBaseControls();

        var master = (this.Master as RegistryMaster);
        if (master != null)
        {
            master.SetDirtyFlag(false);
        }

        if(!IsPostBack)
        {
            ShowClinicalUserAdHocReport(false);
            //ShowReportViewer(false);
            gridViewPageSizeDdl.Visible = false;
            LabelItemsPerPage.Visible = false;
        }

        UserSession.RegistrantId = 0;

        UserControlDateRangeActionDate.FromDateLabel = "From Date (mm/dd/yyyy):<br />";
        UserControlDateRangeActionDate.ToDateLabel = "To Date (mm/dd/yyyy):<br />";
        UserControlDateRangeActionDate.LoadControlsFromObject(string.Empty, false, string.Empty, "OnRunReport");

        if (IsPostBack)
        {
            ReloadBaseControlValue();
        }

        if (!string.IsNullOrEmpty(UserSession.UserListSortDirection)
            || !string.IsNullOrEmpty(UserSession.UserListSortColumn))
        {
            HiddenFieldSort.Value = UserSession.UserListSortColumn + " " + UserSession.UserListSortDirection;
        }
    }

    private void ReloadBaseControlValue()
    {
        BaseControlListBoxPrimaryJob.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxPrimaryJob.Text);
        BaseControlListBoxSecondaryJob.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxSecondaryJob.Text);
        BaseControlListBoxWorkLocation.DataElementValue = Helpers.ConvertToKeyValuePair(BaseControlListBoxWorkLocation.Text);
    }
    
    #region Abstract Member Implementations

    public override string MenuItemName()
    {
        return "Clinical User Ad Hoc Report";
    }
    public override string AppObjectCode()
    {
        return "AHOBPR CLINICAL USER AD-HOC REPORT";
    }
    public override string TopMenuName()
    {
        return "Administration";
    }

    #endregion

    private void LoadBaseControls()
    {
        foreach (STD_GUI_CONTROL_AHOBPR dbItem in GetGuiControls("AHOBPR_CLINICAL_USER_ADHOC_REPORT"))
        {
            Control userControl = PanelSearchCriteriaAction.FindControl(dbItem.USER_CONTROL_ID);
            if (userControl != null)
            {
                if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.TextBox)
                {
                    controls_BaseControlTextBox baseControl = (controls_BaseControlTextBox)userControl;
                    baseControl.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                        dbItem.INCLUDE_LABEL, dbItem.DATA_TYPE_MAX_LENGTH, dbItem.DATA_ELEMENT_WIDTH,
                        dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.VALIDATION_REGULAR_EXPRESSION,
                        dbItem.REQUIRED);
                }
                else if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.DropDownList)
                {
                    controls_BaseControlDropDownList baseControlDropdown = (controls_BaseControlDropDownList)userControl;

                    baseControlDropdown.LoadControlsFromObject(string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP, dbItem.INCLUDE_LABEL, dbItem.LOOKUP_LIST_CATEGORY,
                                                               dbItem.VALIDATION_GROUP, dbItem.VALIDATION_ERROR_MESSAGE, dbItem.REQUIRED);
                }
                else if (dbItem.BASE_CONTROL_TYPE == (int)AhobprBaseControlType.ListBox)
                {
                    controls_BaseControlListBox baseControlListBox = (controls_BaseControlListBox)userControl;

                    baseControlListBox.LoadControlsFromObject(dbItem.LOOKUP_LIST_CATEGORY, string.Empty, dbItem.LABEL_TEXT, dbItem.TOOL_TIP,
                            dbItem.INCLUDE_LABEL, dbItem.DATA_ELEMENT_WIDTH, dbItem.VALIDATION_GROUP, dbItem.REQUIRED);
                }
            }

        }
    }

    private List<STD_GUI_CONTROL_AHOBPR> GetGuiControls(string controlCategory)
    {
        if (UserSession.GuiControlsClinicalUserAdHocReport == null)
        {
            _dbAhopbrControls = _baseControlManager.SelectGuiControlList(controlCategory).ToList<STD_GUI_CONTROL_AHOBPR>();
            UserSession.GuiControlsClinicalUserAdHocReport = _dbAhopbrControls;
        }
        else
        {
            _dbAhopbrControls = UserSession.GuiControlsClinicalUserAdHocReport;
        }

        return _dbAhopbrControls;
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        //UserSession.ClinicalUserAdHocReportFilterActionType = BaseControlDropDownListActionType.Text = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterRole = BaseControlDropDownListRole.Text = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterFromDate = UserControlDateRangeActionDate.FromDateValue = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterToDate = UserControlDateRangeActionDate.ToDateValue = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterStatus = BaseControlDropDownListStatus.Text = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterPrimaryJob = BaseControlListBoxPrimaryJob.Text = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterSecondaryJob = BaseControlListBoxSecondaryJob.Text = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterWorkLocation = BaseControlListBoxWorkLocation.Text = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterChangeStatusState = BaseControlDropDownListChangeStatusState.Text = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterJobTitle = BaseControlTextBoxJobTitle.Text = string.Empty;
        //UserSession.ClinicalUserAdHocReportFilterRole = BaseControlDropDownListRole.Text = string.Empty;
        //UserSession.UserListSortDirection = string.Empty;
        //UserSession.UserListSortColumn = string.Empty;
        //HiddenFieldSort.Value = string.Empty;
        //HideGridView();
        Response.Redirect("ClinicalUserAdHocReport.aspx");
    }

    protected void ButtonPrintReport_Click(object sender, EventArgs e)
    {
        
    }

    protected void ButtonRunReport_Click(object sender, EventArgs e)
    {
        //ShowReportViewer(false);
        SearchUsers();
        gridViewPageSizeDdl.Visible = true;
        LabelItemsPerPage.Visible = true;
    }

    protected void DataSourceClinicalUserAdHocReport_Selected(object sender, ObjectDataSourceStatusEventArgs e)
    {
        var totalRecordsFound = e.ReturnValue;
        LabelNumberOfResultsFound.Text = "Total Number of Results Found: " + totalRecordsFound.ToString();
    }

    protected void gridViewPageSizeDdlChanged(Object sender, EventArgs e)
    {
        GridViewClinicalUserAdHocReport.PageSize = int.Parse(gridViewPageSizeDdl.SelectedValue);
    }

    protected void gridView_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewClinicalUserAdHocReport.PageIndex = e.NewPageIndex;
    }

    private void ShowClinicalUserAdHocReport(bool show)
    {
        PanelClinicalUserAdHocReport.Visible = show;
        if (show)
        {
            GridViewClinicalUserAdHocReport.DataBind();
        }
    }
   
    protected void GridViewClinicalUserAdHocReport_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        
    }

    private void SearchUsers()
    {
        // Validate that at least one value was entered    
        if (string.IsNullOrEmpty(BaseControlDropDownListRole.Text)
            && string.IsNullOrEmpty(BaseControlDropDownListActionType.Text)
            && string.IsNullOrEmpty(UserControlDateRangeActionDate.FromDateValue)
            && string.IsNullOrEmpty(UserControlDateRangeActionDate.ToDateValue)
            && string.IsNullOrEmpty(BaseControlListBoxSecondaryJob.Text)
            && string.IsNullOrEmpty(BaseControlListBoxPrimaryJob.Text)
            && string.IsNullOrEmpty(BaseControlDropDownListChangeStatusState.Text)
            && string.IsNullOrEmpty(BaseControlListBoxWorkLocation.Text)
            && string.IsNullOrEmpty(BaseControlTextBoxJobTitle.Text)
             && string.IsNullOrEmpty(BaseControlDropDownListStatus.Text)
            )
        {
            CustomValidatorSearchCriteria.ErrorMessage = "Please enter at least one of the following fields for Search Criteria: Action Type, Date Range, Role, Status, Primary Job, Secondary Job, Work Location, Change Status State, and Job Title.";
            CustomValidatorSearchCriteria.IsValid = false;
            PanelClinicalUserAdHocReport.Visible = false;
        }
        else
        {
            UserSession.ClinicalUserAdHocReportFilterActionType = BaseControlDropDownListActionType.Text;
            UserSession.ClinicalUserAdHocReportFilterRole = BaseControlDropDownListRole.Text;
            UserSession.ClinicalUserAdHocReportFilterFromDate = UserControlDateRangeActionDate.FromDateValue;
            UserSession.ClinicalUserAdHocReportFilterToDate = UserControlDateRangeActionDate.ToDateValue;
            UserSession.ClinicalUserAdHocReportFilterStatus = BaseControlDropDownListStatus.Text;
            UserSession.ClinicalUserAdHocReportFilterPrimaryJob = BaseControlListBoxPrimaryJob.Text;
            UserSession.ClinicalUserAdHocReportFilterSecondaryJob = BaseControlListBoxSecondaryJob.Text;
            UserSession.ClinicalUserAdHocReportFilterWorkLocation = BaseControlListBoxWorkLocation.Text;
            UserSession.ClinicalUserAdHocReportFilterChangeStatusState = BaseControlDropDownListChangeStatusState.Text;
            UserSession.ClinicalUserAdHocReportFilterJobTitle = BaseControlTextBoxJobTitle.Text;
            UserSession.ClinicalUserAdHocReportFilterRole = BaseControlDropDownListRole.Text;
            ShowClinicalUserAdHocReport(true);
        }
    }

    //private void HideGridView()
    //{
    //    gridViewPageSizeDdl.Visible = false;
    //    LabelItemsPerPage.Visible = false;
    //    LabelNumberOfResultsFound.Visible = false;
    //    PanelClinicalUserAdHocReport.Visible = false;
    //}
}