<%@ Page Title="Registrants" EnableEventValidation="false" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="ChangeStatusSearchRegistrant.aspx.cs" Inherits="ChangeStatusSearchRegistrant" %>
<%@ Register Src="controls/BaseControlListBox.ascx" TagName="BaseControlListBox" TagPrefix="UC" %>
<%@ Register src="controls/BaseControlTextBox.ascx" tagname="BaseControlTextBox" tagprefix="UserControl" %>
<%@ Register Src="controls/UserControlAdminFlagFilter.ascx" TagName="UserControlAdminFlagFilter" TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlFromToDate.ascx" TagName="UserControlFromToDate" TagPrefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">

    <script type = "text/javascript">
        $(document).ready(function() {
            $('.textInput').change(function() {
                $('#<%= PanelRegistrantsList.ClientID %>').hide();
            });
        });
    </script>
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Change Status > Registrant Search</H1>"/>
    </div>    
    <asp:Panel ID="PanelSearchCriteria" runat="server" GroupingText="Registrant Search Criteria">
    <table>
    <tr>
    <td>
        <UC:BaseControlListBox ID="BaseControlListBoxStatus" runat="server" />
    </td>
    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
    <td>
    <UserControl:UserControlFromToDate ID="UserControlDateRangeStatusChangeDate" runat="server" />
    <br />
    <table>
    <tr>
    <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxLastName" runat="server" /></td>
    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
    <td><UserControl:BaseControlTextBox ID="BaseControlTextBoxLast4SSN" runat="server" /></td>
    </tr>
    </table>
       
    </td>
    </tr>
    <tr>
    <td colspan="3">
        <UserControl:UserControlAdminFlagFilter ID="UserControlAdminFlagFilter" runat="server" />
    </td>
    </tr>
    <tr>
    <td colspan="3">
        <asp:CheckBox runat="server" ID="CheckBoxExcludeReviewHECAdminFlag" Text="Exclude All Registrants with Review-HEC Admin Flag" />
        <br />
        <asp:CustomValidator ID="CustomValidatorSearchCriteria" runat="server" ErrorMessage="Please select at least one search criteria."
        ValidationGroup="onSearch"></asp:CustomValidator>
    </td>
    </tr>
    <tr>
    <td colspan="3">
        <br />
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <asp:Button ID="Search" runat="server" onclick="Search_Click" Text="&nbsp;Search&nbsp;" ValidationGroup="onSearch" />
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <asp:Button runat="server" ID="ButtonClear" Text="&nbsp;&nbsp;Clear&nbsp;&nbsp;" OnClick="ButtonClear_Click"/>
    </td>
    </tr>
    </table>
    <br />
 
    </asp:Panel>
    <asp:Panel ID="PanelRegistrantsList" runat="server"  Width="1000px">
        <asp:Label runat="server" ID="LabelNumberOfRegistrantsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right; width: 1000px;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
            </div>
            <asp:GridView 
                ID="GridViewRegistrant" 
                runat="server" 
                OnRowCommand = "GridViewRegistrant_RowCommand"
                AutoGenerateColumns="False" 
                DataSourceID="RegistrantSearchDS"
                AllowPaging="True" 
                AllowSorting="True" 
                Visible="False" 
                Caption="To sort please click table headings" 
                EnableModelValidation="True"
                DataKeyNames="REGISTRANT_ID"
                PagerSettings-Mode="Numeric"
                OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:TemplateField HeaderText="ID" SortExpression="REGISTRANT_ID" AccessibleHeaderText="ID" >
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRegistrantId" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Registrant Name" SortExpression="LAST_NAME, FIRST_NAME">
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelRegistrantLastName" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("Name"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                 <asp:TemplateField HeaderText="Last 4 of SSN">
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelLast4Ssn" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("Last4Ssn"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                <asp:TemplateField HeaderText="Date of Birth" SortExpression="BIRTH_DATE">
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID="LabelDateOfBirth" SkinID="DataLabel" runat="server" Text='<%# Helpers.AhobprEval(Eval("Dob"))  %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

               <asp:TemplateField HeaderText="Duty Status" SortExpression="STD_SERVICE_STATUS.SERVICE_STATUS" ItemStyle-HorizontalAlign="Center">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelServiceStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("STD_SERVICE_STATUS.SERVICE_STATUS")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>

                
                <asp:TemplateField HeaderText="Registrant Current Status" SortExpression="STD_REGISTRANT_STATUS.ORDINAL_VALUE">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelRegistryStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("STD_REGISTRANT_STATUS.REGISTRANT_STATUS")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:TemplateField HeaderText="Last Admin Flag Set">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelLastAdminFlag" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("LastAdminFlag")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                
                <asp:ButtonField ButtonType = "Button" Text = "Select" CommandName = "Details" 
                   ItemStyle-VerticalAlign="Middle" ItemStyle-HorizontalAlign="Center" AccessibleHeaderText = "Select" HeaderText ="Action" />
            </Columns>
        </asp:GridView>
        <asp:ObjectDataSource 
        ID="RegistrantSearchDS" runat="server" 
            SelectMethod="SearchRegistrantsForChangeStatus" 
            SelectCountMethod="SearchRegistrantsForChangeStatusCount"
            StartRowIndexParameterName="startRow" 
            MaximumRowsParameterName="maxRows" 
            SortParameterName="sort"
            EnablePaging="True"  
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager"
            OnSelecting="RegistrantSearchDS_Selecting"
            onselected="RegistrantSearchDS_Selected">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlTextBoxLastName" Name="lastName" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlTextBoxLast4SSN" Name="last4SSN" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxStatus" Name="registryStatusIds" PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlag" PropertyName="AdminFlagId" Type="String" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagFromDate" PropertyName="AdminFlagEnteredDateFrom" Type="String" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagToDate" PropertyName="AdminFlagEnteredDateTo" Type="String" />
            <asp:ControlParameter ControlID="CheckBoxExcludeReviewHECAdminFlag" Name="exludeReviewHecAdminFlag" PropertyName="Checked" Type="Boolean" />
            <asp:ControlParameter ControlID="UserControlDateRangeStatusChangeDate" Name="statusFromDate" PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeStatusChangeDate" Name="statusToDate" PropertyName="ToDateValue" Type="String" />
            <asp:Parameter Name="hasStateFilter"  DefaultValue="false" Type="Boolean" />
            <asp:Parameter Name="stateFilter"  DefaultValue="" Type="String"/>
            <asp:Parameter Name="sort" Type="String" />
            <asp:Parameter Name="startRow" Type="Int32" />
            <asp:Parameter Name="maxRows" Type="Int32" />
            <asp:Parameter Name="totalRecords" Type="Int32" Direction="Output" />
       </SelectParameters>
    </asp:ObjectDataSource>
     </asp:Panel>


</asp:Content>

