﻿using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.ComponentModel;
using System.Web.SessionState;
using System.Collections.Generic;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.ViaEmrServiceReference;
using System.Web.UI.WebControls;

[Serializable]
public class SessionFacade
{
    [field: NonSerialized]
    public event PropertyChangedEventHandler PropertyChangedHandler;

    public SessionFacade()
    {
        this.PropertyChangedHandler = new PropertyChangedEventHandler(PropertyChanged);
    }

    protected virtual void SendPropertyChanged(String propertyName)
    {
        if ((this.PropertyChangedHandler != null))
        {
            this.PropertyChangedHandler(this, new PropertyChangedEventArgs(propertyName));
        }
    }

    /// <summary>
    /// Handles the property changed event.
    /// </summary>
    /// <param name="sender">object</param>
    /// <param name="e">Property Changed arguements</param>
    private void PropertyChanged(object sender, PropertyChangedEventArgs e)
    {
        HttpContext.Current.Session["UserSession"] = this;
    }
   
    # region Private Declarations
    //---------------------------------------------------------------------

    private int referenceStatus; 
    private string menuItemSelected;
    private string selectedMenuUrl;
    private string sortColumn;
    private string sortDirection;
    private string userListSortColumn;
    private string userListSortDirection;
    private string loginMessage;
    private string successfulLogin;
    private string vistaResponse;
    private string sessionTimedOut;
    private string formId;
    private string noteContent;
    private string noteSentToCprs;
    private AHOBPR_USER currentUser;

    private string siteCode;
    private string dUZ;
    private string dFN;
    private string serverIP;
    private string serverPort;
    private string ccowSiteCode;
    private personsTO personsTo;
    private string ahobprNoteTitleIen;
    private int registrantId;

    private string actionTrackingUserId;
    private string actionTrackingUserFullName;
    private string actionTrackingUserRoles;
    private string actionTrackingFilterLastName;
    private string actionTrackingFilterFirstName;
    private string actionTrackingFilterActionType;
    private string actionTrackingFilterUserRole;
    private string actionTrackingFilterFromDate;
    private string actionTrackingFilterToDate;
    private string actionTrackingFilterItemPerpage;

    private string changeStatusSearchParameterStatus;
    private string changeStatusSearchParameterName;
    private string changeStatusSearchParameterSnum;
    private string changeStatusSearchParameterAdminFlag;
    private string changeStatusSearchParameterAdminFlagFromDate;
    private string changeStatusSearchParameterAdminFlagToDate;
    private bool excludeReviewHecAdminFlag;
    private string statusFromDate;
    private string statusToDate;

    private string fromDate;
    private string toDate;
    private string assignedLocationType;
    private string assignedLocationKey;
    private string evaluationLocationType;
    private string evaluationLocationKey;
    private string visnId;
    private string mainFacility;
    private string subFacility;
    private string reportLocationRadioButton;
    private string evalVisnId;
    private string evalMainFacility;
    private string evalSubFacility;
    private string evalReportLocationRadioButton;
    private string closestVisnId;
    private string closestMainFacility;
    private string closestSubFacility;

    private string lastServerReportName;
    private string lastServerReportNameAdhoc;

    private string clinicalUserAdHocReportFilterActionType;
    private string clinicalUserAdHocReportFilterRole;
    private string clinicalUserAdHocReportFilterFromDate;
    private string clinicalUserAdHocReportFilterToDate;
    private string clinicalUserAdHocReportFilterStatus;
    private string clinicalUserAdHocReportFilterPrimaryJob;
    private string clinicalUserAdHocReportFilterSecondaryJob;
    private string clinicalUserAdHocReportFilterWorkLocation;
    private string clinicalUserAdHocReportFilterChangeStatusState;
    private string clinicalUserAdHocReportFilterJobTitle;

    private List<STD_GUI_CONTROL_AHOBPR> guiControlsActionTracking;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsAddFlags;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsUserEmailTemplate;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsSendQuestions;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsMessageTemplate;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsChangeStatus;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsChangeStatusSearch;
    private List<STD_GUI_CONTROL_AHOBPR> guiControls;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsMySendMessage;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsMyAccountEditUser;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsCreateUserAccount;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsNameUpdate;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsNameUpdateSearch;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsReportAdhoc;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsReportContactInformation;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsReportEligibilityReview;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsReportFollowupQuestions;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsReportParticipation;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsReportStatusByLocation;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsToolEditQuestion;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsToolEditQuestionGroup;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsHealthFactor;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsRegistrantUserControl;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsRegistrantInformationUserControl;
    private List<STD_GUI_CONTROL_AHOBPR> guiControlsClinicalUserAdHocReport;

    private SessionListBox userControlSubpopulationFlag;
    private SessionListBox userControlStatus;
    private SessionListBox userControlState;
    private SessionListBox userControlHealthFactor;

    //---------------------------------------------------------------------
    # endregion

    # region Public Properties
    //---------------------------------------------------------------------

    public int ReferenceStatus
    {
        get
        {
            return referenceStatus;
        }

        set
        {
            referenceStatus = value;
            this.SendPropertyChanged("ReferenceStatus");
        }
    }

    public string MenuItemSelected
    {
        get
        {
            return menuItemSelected;
        }

        set
        {
            menuItemSelected = value;
            this.SendPropertyChanged("MenuItemSelected");
        }
    }

    public string SelectedMenuUrl
    {
        get
        {
            return selectedMenuUrl;
        }

        set
        {
            selectedMenuUrl = value;
            this.SendPropertyChanged("SelectedMenuUrl");
        }
    }

    public string SortColumn
    {
        get
        {
            return sortColumn;
        }

        set
        {
            sortColumn = value;
            this.SendPropertyChanged("SortColumn");
        }
    }

    public string SortDirection
    {
        get
        {
            return sortDirection;
        }

        set
        {
            sortDirection = value;
            this.SendPropertyChanged("SortDirection");
        }
    }

    public string UserListSortColumn
    {
        get
        {
            return userListSortColumn;
        }

        set
        {
            userListSortColumn = value;
            this.SendPropertyChanged("UserListSortColumn");
        }
    }

    public string UserListSortDirection
    {
        get
        {
            return userListSortDirection;
        }

        set
        {
            userListSortDirection = value;
            this.SendPropertyChanged("UserListSortDirection");
        }
    }

    public string LoginMessage
    {
        get
        {
            return loginMessage;
        }

        set
        {
            loginMessage = value;
            this.SendPropertyChanged("LoginMessage");
        }
    }

    public string SuccessfulLogin
    {
        get
        {
            return successfulLogin;
        }

        set
        {
            successfulLogin = value;
            this.SendPropertyChanged("SuccessfulLogin");
        }
    }

    public string VistaResponse
    {
        get
        {
            return vistaResponse;
        }

        set
        {
            vistaResponse = value;
            this.SendPropertyChanged("VistaResponse");
        }
    }

    public string SessionTimedOut
    {
        get
        {
            return sessionTimedOut;
        }

        set
        {
            sessionTimedOut = value;
            this.SendPropertyChanged("SessionTimedOut");
        }
    }

    public string FormId
    {
        get
        {
            return formId;
        }

        set
        {
            formId = value;
            this.SendPropertyChanged("FormId");
        }
    }

    public string NoteContent
    {
        get
        {
            return noteContent;
        }

        set
        {
            noteContent = value;
            this.SendPropertyChanged("NoteContent");
        }
    }

    public string NoteSentToCprs
    {
        get
        {
            return noteSentToCprs;
        }

        set
        {
            noteSentToCprs = value;
            this.SendPropertyChanged("NoteSentToCprs");
        }
    }

    public AHOBPR_USER CurrentUser
    {
        get
        {
            return currentUser;
        }

        set
        {
            currentUser = value;
            this.SendPropertyChanged("CurrentUser");
        }
    }

    public string SiteCode
    {
        get
        {
            return siteCode;
        }

        set
        {
            siteCode = value;
            this.SendPropertyChanged("SiteCode");
        }
    }

    public string DUZ
    {
        get
        {
            return dUZ;
        }

        set
        {
            dUZ = value;
            this.SendPropertyChanged("DUZ");
        }
    }

    public string DFN
    {
        get
        {
            return dFN;
        }

        set
        {
            dFN = value;
            this.SendPropertyChanged("DFN");
        }
    }

    public string ServerIP
    {
        get
        {
            return serverIP;
        }

        set
        {
            serverIP = value;
            this.SendPropertyChanged("ServerIP");
        }
    }

    public string ServerPort
    {
        get
        {
            return serverPort;
        }

        set
        {
            serverPort = value;
            this.SendPropertyChanged("ServerPort");
        }
    }

    public string CcowSiteCode
    {
        get
        {
            return ccowSiteCode;
        }

        set
        {
            ccowSiteCode = value;
            this.SendPropertyChanged("CcowSiteCode");
        }
    }

    public personsTO PersonsTo
    {
        get
        {
            return personsTo;
        }

        set
        {
            personsTo = value;
            this.SendPropertyChanged("PersonsTo");
        }
    }

    public string AhobprNoteTitleIen
    {
        get
        {
            return ahobprNoteTitleIen;
        }

        set
        {
            ahobprNoteTitleIen = value;
            this.SendPropertyChanged("AhobprNoteTitleIen");
        }
    }

    public int RegistrantId
    {
        get
        {
            return registrantId;
        }

        set
        {
            registrantId = value;
            this.SendPropertyChanged("RegistrantId");
        }
    }

    public string ActionTrackingUserId
    {
        get
        {
            return actionTrackingUserId;
        }

        set
        {
            actionTrackingUserId = value;
            this.SendPropertyChanged("ActionTrackingUserId");
        }
    }

    public string ActionTrackingUserFullName
    {
        get
        {
            return actionTrackingUserFullName;
        }

        set
        {
            actionTrackingUserFullName = value;
            this.SendPropertyChanged("ActionTrackingUserFullName");
        }
    }

    public string ActionTrackingUserRoles
    {
        get
        {
            return actionTrackingUserRoles;
        }

        set
        {
            actionTrackingUserRoles = value;
            this.SendPropertyChanged("ActionTrackingUserRoles");
        }
    }

    public string ActionTrackingFilterLastName
    {
        get
        {
            return actionTrackingFilterLastName;
        }

        set
        {
            actionTrackingFilterLastName = value;
            this.SendPropertyChanged("ActionTrackingFilterLastName");
        }
    }

    public string ActionTrackingFilterFirstName
    {
        get
        {
            return actionTrackingFilterFirstName;
        }

        set
        {
            actionTrackingFilterFirstName = value;
            this.SendPropertyChanged("ActionTrackingFilterFirstName");
        }
    }

    public string ActionTrackingFilterActionType
    {
        get
        {
            return actionTrackingFilterActionType;
        }

        set
        {
            actionTrackingFilterActionType = value;
            this.SendPropertyChanged("ActionTrackingFilterActionType");
        }
    }

    public string ActionTrackingFilterUserRole
    {
        get
        {
            return actionTrackingFilterUserRole;
        }

        set
        {
            actionTrackingFilterUserRole = value;
            this.SendPropertyChanged("ActionTrackingFilterUserRole");
        }
    }

    public string ActionTrackingFilterFromDate
    {
        get
        {
            return actionTrackingFilterFromDate;
        }

        set
        {
            actionTrackingFilterFromDate = value;
            this.SendPropertyChanged("ActionTrackingFilterFromDate");
        }
    }

    public string ActionTrackingFilterToDate
    {
        get
        {
            return actionTrackingFilterToDate;
        }

        set
        {
            actionTrackingFilterToDate = value;
            this.SendPropertyChanged("ActionTrackingFilterToDate");
        }
    }

    public string ActionTrackingFilterItemPerpage
    {
        get
        {
            return actionTrackingFilterItemPerpage;
        }

        set
        {
            actionTrackingFilterItemPerpage = value;
            this.SendPropertyChanged("ActionTrackingFilterItemPerpage");
        }
    }

    public string ChangeStatusSearchParameterStatus
    {
        get
        {
            return changeStatusSearchParameterStatus;
        }

        set
        {
            changeStatusSearchParameterStatus = value;
            this.SendPropertyChanged("ChangeStatusSearchParameterStatus");
        }
    }

    public string ChangeStatusSearchParameterName
    {
        get
        {
            return changeStatusSearchParameterName;
        }

        set
        {
            changeStatusSearchParameterName = value;
            this.SendPropertyChanged("ChangeStatusSearchParameterName");
        }
    }

    public string ChangeStatusSearchParameterSnum
    {
        get
        {
            return changeStatusSearchParameterSnum;
        }

        set
        {
            changeStatusSearchParameterSnum = value;
            this.SendPropertyChanged("ChangeStatusSearchParameterSnum");
        }
    }

    public string ChangeStatusSearchParameterAdminFlag
    {
        get
        {
            return changeStatusSearchParameterAdminFlag;
        }

        set
        {
            changeStatusSearchParameterAdminFlag = value;
            this.SendPropertyChanged("ChangeStatusSearchParameterAdminFlag");
        }
    }

    public string ChangeStatusSearchParameterAdminFlagFromDate
    {
        get
        {
            return changeStatusSearchParameterAdminFlagFromDate;
        }

        set
        {
            changeStatusSearchParameterAdminFlagFromDate = value;
            this.SendPropertyChanged("ChangeStatusSearchParameterAdminFlagFromDate");
        }
    }

    public string ChangeStatusSearchParameterAdminFlagToDate
    {
        get
        {
            return changeStatusSearchParameterAdminFlagToDate;
        }

        set
        {
            changeStatusSearchParameterAdminFlagToDate = value;
            this.SendPropertyChanged("ChangeStatusSearchParameterAdminFlagToDate");
        }
    }

    public bool ExcludeReviewHecAdminFlag
    {
        get
        {
            return excludeReviewHecAdminFlag;
        }

        set
        {
            excludeReviewHecAdminFlag = value;
            this.SendPropertyChanged("ExcludeReviewHecAdminFlag");
        }
    }

    public string StatusFromDate
    {
        get
        {
            return statusFromDate;
        }

        set
        {
            statusFromDate = value;
            this.SendPropertyChanged("StatusFromDate");
        }
    }

    public string StatusToDate
    {
        get
        {
            return statusToDate;
        }

        set
        {
            statusToDate = value;
            this.SendPropertyChanged("StatusToDate");
        }
    }

    public string FromDate
    {
        get
        {
            return fromDate;
        }

        set
        {
            fromDate = value;
            this.SendPropertyChanged("FromDate");
        }
    }

    public string ToDate
    {
        get
        {
            return toDate;
        }

        set
        {
            toDate = value;
            this.SendPropertyChanged("ToDate");
        }
    }

    public string AssignedLocationType
    {
        get
        {
            return assignedLocationType;
        }

        set
        {
            assignedLocationType = value;
            this.SendPropertyChanged("AssignedLocationType");
        }
    }

    public string AssignedLocationKey
    {
        get
        {
            return assignedLocationKey;
        }

        set
        {
            assignedLocationKey = value;
            this.SendPropertyChanged("AssignedLocationKey");
        }
    }

    public string EvaluationLocationType
    {
        get
        {
            return evaluationLocationType;
        }

        set
        {
            evaluationLocationType = value;
            this.SendPropertyChanged("EvaluationLocationType");
        }
    }

    public string EvaluationLocationKey
    {
        get
        {
            return evaluationLocationKey;
        }

        set
        {
            evaluationLocationKey = value;
            this.SendPropertyChanged("EvaluationLocationKey");
        }
    }

    public string VisnId
    {
        get
        {
            return visnId;
        }

        set
        {
            visnId = value;
            this.SendPropertyChanged("VisnId");
        }
    }

    public string MainFacility
    {
        get
        {
            return mainFacility;
        }

        set
        {
            mainFacility = value;
            this.SendPropertyChanged("MainFacility");
        }
    }

    public string SubFacility
    {
        get
        {
            return subFacility;
        }

        set
        {
            subFacility = value;
            this.SendPropertyChanged("SubFacility");
        }
    }

    public string ReportLocationRadioButton
    {
        get
        {
            return reportLocationRadioButton;
        }

        set
        {
            reportLocationRadioButton = value;
            this.SendPropertyChanged("ReportLocationRadioButton");
        }
    }

    public string EvalVisnId
    {
        get
        {
            return evalVisnId;
        }

        set
        {
            evalVisnId = value;
            this.SendPropertyChanged("EvalVisnId");
        }
    }

    public string EvalMainFacility
    {
        get
        {
            return evalMainFacility;
        }

        set
        {
            evalMainFacility = value;
            this.SendPropertyChanged("EvalMainFacility");
        }
    }

    public string EvalSubFacility
    {
        get
        {
            return evalSubFacility;
        }

        set
        {
            evalSubFacility = value;
            this.SendPropertyChanged("EvalSubFacility");
        }
    }

    public string EvalReportLocationRadioButton
    {
        get
        {
            return evalReportLocationRadioButton;
        }

        set
        {
            evalReportLocationRadioButton = value;
            this.SendPropertyChanged("EvalReportLocationRadioButton");
        }
    }

    public string ClosestVisnId
    {
        get
        {
            return closestVisnId;
        }

        set
        {
            closestVisnId = value;
            this.SendPropertyChanged("ClosestVisnId");
        }
    }

    public string ClosestMainFacility
    {
        get
        {
            return closestMainFacility;
        }

        set
        {
            closestMainFacility = value;
            this.SendPropertyChanged("ClosestMainFacility");
        }
    }

    public string ClosestSubFacility
    {
        get
        {
            return closestSubFacility;
        }

        set
        {
            closestSubFacility = value;
            this.SendPropertyChanged("ClosestSubFacility");
        }
    }

    public string LastServerReportName
    {
        get
        {
            return lastServerReportName;
        }

        set
        {
            lastServerReportName = value;
            this.SendPropertyChanged("LastServerReportName");
        }
    }

    public string LastServerReportNameAdhoc
    {
        get
        {
            return lastServerReportNameAdhoc;
        }

        set
        {
            lastServerReportNameAdhoc = value;
            this.SendPropertyChanged("LastServerReportNameAdhoc");
        }
    }

    public string ClinicalUserAdHocReportFilterActionType
    {
        get
        {
            return clinicalUserAdHocReportFilterActionType;
        }

        set
        {
            clinicalUserAdHocReportFilterActionType = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterActionType");
        }
    }

    public string ClinicalUserAdHocReportFilterRole
    {
        get
        {
            return clinicalUserAdHocReportFilterRole;
        }

        set
        {
            clinicalUserAdHocReportFilterRole = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterRole");
        }
    }

    public string ClinicalUserAdHocReportFilterFromDate
    {
        get
        {
            return clinicalUserAdHocReportFilterFromDate;
        }

        set
        {
            clinicalUserAdHocReportFilterFromDate = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterFromDate");
        }
    }

    public string ClinicalUserAdHocReportFilterToDate
    {
        get
        {
            return clinicalUserAdHocReportFilterToDate;
        }

        set
        {
            clinicalUserAdHocReportFilterToDate = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterToDate");
        }
    }

    public string ClinicalUserAdHocReportFilterStatus
    {
        get
        {
            return clinicalUserAdHocReportFilterStatus;
        }

        set
        {
            clinicalUserAdHocReportFilterStatus = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterStatus");
        }
    }

    public string ClinicalUserAdHocReportFilterPrimaryJob
    {
        get
        {
            return clinicalUserAdHocReportFilterPrimaryJob;
        }

        set
        {
            clinicalUserAdHocReportFilterPrimaryJob = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterPrimaryJob");
        }
    }
    public string ClinicalUserAdHocReportFilterSecondaryJob
    {
        get
        {
            return clinicalUserAdHocReportFilterSecondaryJob;
        }

        set
        {
            clinicalUserAdHocReportFilterSecondaryJob = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterSecondaryJob");
        }
    }

    public string ClinicalUserAdHocReportFilterWorkLocation
    {
        get
        {
            return clinicalUserAdHocReportFilterWorkLocation;
        }

        set
        {
            clinicalUserAdHocReportFilterWorkLocation = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterWorkLocation");
        }
    }

    public string ClinicalUserAdHocReportFilterChangeStatusState
    {
        get
        {
            return clinicalUserAdHocReportFilterChangeStatusState;
        }

        set
        {
            clinicalUserAdHocReportFilterChangeStatusState = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterChangeStatusState");
        }
    }
    public string ClinicalUserAdHocReportFilterJobTitle
    {
        get
        {
            return clinicalUserAdHocReportFilterJobTitle;
        }

        set
        {
            clinicalUserAdHocReportFilterJobTitle = value;
            this.SendPropertyChanged("ClinicalUserAdHocReportFilterJobTitle");
        }
    }


    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsActionTracking
    {
        get 
        {
            return guiControlsActionTracking;
        }
        set 
        {
            guiControlsActionTracking = value;
            this.SendPropertyChanged("GuiControlsActionTracking");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsAddFlags
    {
        get
        {
            return guiControlsAddFlags;
        }
        set
        {
            guiControlsAddFlags = value;
            this.SendPropertyChanged("GuiControlsAddFlags");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsUserEmailTemplate
    {
        get
        {
            return guiControlsUserEmailTemplate;
        }
        set
        {
            guiControlsUserEmailTemplate = value;
            this.SendPropertyChanged("GuiControlsUserEmailTemplate");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsSendQuestions
    {
        get
        {
            return guiControlsSendQuestions;
        }
        set
        {
            guiControlsSendQuestions = value;
            this.SendPropertyChanged("GuiControlsSendQuestions");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsMessageTemplate
    {
        get
        {
            return guiControlsMessageTemplate;
        }
        set
        {
            guiControlsMessageTemplate = value;
            this.SendPropertyChanged("GuiControlsMessageTemplate");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsChangeStatus
    {
        get
        {
            return guiControlsChangeStatus;
        }
        set
        {
            guiControlsChangeStatus = value;
            this.SendPropertyChanged("GuiControlsChangeStatus");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsChangeStatusSearch
    {
        get
        {
            return guiControlsChangeStatusSearch;
        }
        set
        {
            guiControlsChangeStatusSearch = value;
            this.SendPropertyChanged("GuiControlsChangeStatusSearch");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControls
    {
        get
        {
            return guiControls;
        }
        set
        {
            guiControls = value;
            this.SendPropertyChanged("GuiControls");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsMySendMessage
    {
        get
        {
            return guiControlsMySendMessage;
        }
        set
        {
            guiControlsMySendMessage = value;
            this.SendPropertyChanged("GuiControlsMySendMessage");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsNameUpdate
    {
        get
        {
            return guiControlsNameUpdate;
        }
        set
        {
            guiControlsNameUpdate = value;
            this.SendPropertyChanged("GuiControlsNameUpdate");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsNameUpdateSearch
    {
        get
        {
            return guiControlsNameUpdateSearch;
        }
        set
        {
            guiControlsNameUpdateSearch = value;
            this.SendPropertyChanged("GuiControlsNameUpdateSearch");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsReportAdhoc
    {
        get
        {
            return guiControlsReportAdhoc;
        }
        set
        {
            guiControlsReportAdhoc = value;
            this.SendPropertyChanged("GuiControlsReportAdhoc");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsReportContactInformation
    {
        get
        {
            return guiControlsReportContactInformation;
        }
        set
        {
            guiControlsReportContactInformation = value;
            this.SendPropertyChanged("GuiControlsReportContactInformation");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsReportEligibilityReview
    {
        get
        {
            return guiControlsReportEligibilityReview;
        }
        set
        {
            guiControlsReportEligibilityReview = value;
            this.SendPropertyChanged("GuiControlsReportEligibilityReview");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsReportFollowupQuestions
    {
        get
        {
            return guiControlsReportFollowupQuestions;
        }
        set
        {
            guiControlsReportFollowupQuestions = value;
            this.SendPropertyChanged("GuiControlsReportFollowupQuestions");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsReportParticipation
    {
        get
        {
            return guiControlsReportParticipation;
        }
        set
        {
            guiControlsReportParticipation = value;
            this.SendPropertyChanged("GuiControlsReportParticipation");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsReportStatusByLocation
    {
        get
        {
            return guiControlsReportStatusByLocation;
        }
        set
        {
            guiControlsReportStatusByLocation = value;
            this.SendPropertyChanged("GuiControlsReportStatusByLocation");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsToolEditQuestion
    {
        get
        {
            return guiControlsToolEditQuestion;
        }
        set
        {
            guiControlsToolEditQuestion = value;
            this.SendPropertyChanged("GuiControlsToolEditQuestion");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsToolEditQuestionGroup
    {
        get
        {
            return guiControlsToolEditQuestionGroup;
        }
        set
        {
            guiControlsToolEditQuestionGroup = value;
            this.SendPropertyChanged("GuiControlsToolEditQuestionGroup");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsHealthFactor
    {
        get
        {
            return guiControlsHealthFactor;
        }
        set
        {
            guiControlsHealthFactor = value;
            this.SendPropertyChanged("GuiControlsHealthFactor");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsRegistrantUserControl
    {
        get
        {
            return guiControlsRegistrantUserControl;
        }
        set
        {
            guiControlsRegistrantUserControl = value;
            this.SendPropertyChanged("GuiControlsRegistrantUserControl");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsRegistrantInformationUserControl
    {
        get
        {
            return guiControlsRegistrantInformationUserControl;
        }
        set
        {
            guiControlsRegistrantInformationUserControl = value;
            this.SendPropertyChanged("GuiControlsRegistrantInformationUserControl");
        }
    }

    public SessionListBox UserControlSubpopulationFlag
    {
        get
        {
            if (userControlSubpopulationFlag == null)
            {
                userControlSubpopulationFlag = new SessionListBox();
                this.SendPropertyChanged("UserControlSubpopulationFlag");
            }

            return userControlSubpopulationFlag;
        }
        set
        {
            userControlSubpopulationFlag = value;
            this.SendPropertyChanged("UserControlSubpopulationFlag");
        }
    }

    public SessionListBox UserControlStatus
    {
        get
        {
            if (userControlStatus == null)
            {
                userControlStatus = new SessionListBox();
                this.SendPropertyChanged("UserControlStatus");
            }

            return userControlStatus;
        }
        set
        {
            userControlStatus = value;
            this.SendPropertyChanged("UserControlStatus");
        }
    }

    public SessionListBox UserControlState
    {
        get
        {
            if (userControlState == null)
            {
                userControlState = new SessionListBox();
                this.SendPropertyChanged("UserControlState");
            }

            return userControlState;
        }
        set
        {
            userControlState = value;
            this.SendPropertyChanged("UserControlState");
        }
    }

    public SessionListBox UserControlHealthFactor
    {
        get
        {
            if (userControlHealthFactor == null)
            {
                userControlHealthFactor = new SessionListBox();
                this.SendPropertyChanged("UserControlHealthFactor");
            }

            return userControlHealthFactor;
        }
        set
        {
            userControlHealthFactor = value;
            this.SendPropertyChanged("UserControlHealthFactor");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsMyAccountEditUser
    {
        get
        {
            return guiControlsMyAccountEditUser;
        }

        set
        {
            guiControlsMyAccountEditUser = value;
            this.SendPropertyChanged("GuiControlsMyAccountEditUser");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsCreateUserAccount
    {
        get
        {
            return guiControlsCreateUserAccount;
        }

        set
        {
            guiControlsCreateUserAccount = value;
            this.SendPropertyChanged("GuiControlsCreateUserAccount");
        }
    }

    public List<STD_GUI_CONTROL_AHOBPR> GuiControlsClinicalUserAdHocReport
    {
        get
        {
            return guiControlsClinicalUserAdHocReport;
        }
        set
        {
            guiControlsClinicalUserAdHocReport = value;
            this.SendPropertyChanged("GuiControlsClinicalUserAdHocReport");
        }
    }
    //---------------------------------------------------------------------
    # endregion
}
