﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Web;
using VeteransAffairs.Registries.BusinessManager;

public class ServiceCaller
{
    private static UserAccountManager _currentUser = (UserAccountManager)HttpContext.Current.User;

    /// <summary>
    /// TLB - RTC 470224 AHOBPR Clinical Portal Change Status Exception
    /// Force socket connection to use TLS1.1 or TLS1.2 protocol
    /// </summary>
    private static void UpdateSecurityProtocol()
    {
        ServicePointManager.Expect100Continue = true;
        ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls11 | SecurityProtocolType.Tls12;
    }

    public static String UpdateJsonInfoStatus(String userId, String newStatus)
    {
        //TLB - RTC 470224
        UpdateSecurityProtocol();

        String uri = Helpers.GetConfigEntry("JsonServiceUri") + "UpdateRegistrantStatus/" + userId + "/" + newStatus + "/" + _currentUser.UserName;
        WebRequest request = WebRequest.Create(uri);
        request.Method = "GET";
        request.ContentType = @"application/json; charset=utf-8";
        String secretKey = Helpers.GetConfigEntry("secretKey");
        request.Headers.Add("Authorization", "Basic " + secretKey);

        HttpWebResponse response = (HttpWebResponse)request.GetResponse();
        string jsonResponse = string.Empty;
        using (StreamReader sr = new StreamReader(response.GetResponseStream()))
        {
            jsonResponse = sr.ReadToEnd();
        }
        return jsonResponse;
    }

    /// <summary>
    /// Update registrant name
    /// </summary>
    /// <param name="userId"></param>
    /// <param name="lastName"></param>
    /// <param name="firstName"></param>
    /// <param name="middleName"></param>
    /// <returns></returns>
    public static String UpdateJsonRegistrantName(string userId, string lastName, string firstName, string middleName)
    {
        //TLB - RTC 470224
        UpdateSecurityProtocol();

        //TLB: RTC 487861 - Previously name values were not required.  If a blank/null value was passed for one of the names,
        // the service call would fail.  Added requirement for last and first name, and made middle name optional.

        String uri = Helpers.GetConfigEntry("JsonServiceUri");
        if (!string.IsNullOrEmpty(middleName))
            uri += "updatename/" + userId + "/" + lastName + "/" + firstName + "/" + middleName + "/" + _currentUser.UserName;
        else
            uri += "updatename2/" + userId + "/" + lastName + "/" + firstName + "/" + _currentUser.UserName;

        WebRequest request = WebRequest.Create(uri);
        request.Method = "GET";
        request.ContentType = @"application/json; charset=utf-8";
        String secretKey = Helpers.GetConfigEntry("secretKey");
        request.Headers.Add("Authorization", "Basic " + secretKey);

        HttpWebResponse response = (HttpWebResponse)request.GetResponse();
        string jsonResponse = string.Empty;
        using (StreamReader sr = new StreamReader(response.GetResponseStream()))
        {
            jsonResponse = sr.ReadToEnd();
        }
        return jsonResponse;
    }

    public static bool CreateFollowupFormJson(string toolFormId, string isSystemWide)
    {
        //TLB - RTC 470224
        UpdateSecurityProtocol();

        String uri = Helpers.GetConfigEntry("JsonServiceUri") + "createfollowupformjson/" + toolFormId + "/" + isSystemWide + "/" + _currentUser.UserName;
        WebRequest request = WebRequest.Create(uri);
        request.Method = "GET";
        request.ContentType = @"application/json; charset=utf-8";
        String secretKey = Helpers.GetConfigEntry("secretKey");
        request.Headers.Add("Authorization", "Basic " + secretKey);

        HttpWebResponse response = (HttpWebResponse)request.GetResponse();
        string jsonResponse = string.Empty;
        using (StreamReader sr = new StreamReader(response.GetResponseStream()))
        {
            jsonResponse = sr.ReadToEnd();
        }
        return jsonResponse.Contains("true");
    }

    public static bool UpdateFollowupFormJsonSystemWide(string toolformId)
    {
        //TLB - RTC 470224
        UpdateSecurityProtocol();

        String uri = Helpers.GetConfigEntry("JsonServiceUri") + "UpdateFollowupFormJsonSystemWide/" + toolformId;
        WebRequest request = WebRequest.Create(uri);
        request.Method = "GET";
        request.ContentType = @"application/json; charset=utf-8";
        String secretKey = Helpers.GetConfigEntry("secretKey");
        request.Headers.Add("Authorization", "Basic " + secretKey);

        HttpWebResponse response = (HttpWebResponse)request.GetResponse();
        string jsonResponse = string.Empty;
        using (StreamReader sr = new StreamReader(response.GetResponseStream()))
        {
            jsonResponse = sr.ReadToEnd();
        }
        return jsonResponse.Contains("true");
    }

    public static bool CreateUserFormJson(string registrantId, string formId)
    {
        //TLB - RTC 470224
        UpdateSecurityProtocol();

        String uri = Helpers.GetConfigEntry("JsonServiceUri") + "CreateUserFormJson/" + registrantId + "/" + formId + "/" + _currentUser.UserName; ;
        WebRequest request = WebRequest.Create(uri);
        request.Method = "GET";
        request.ContentType = @"application/json; charset=utf-8";
        String secretKey = Helpers.GetConfigEntry("secretKey");
        request.Headers.Add("Authorization", "Basic " + secretKey);

        HttpWebResponse response = (HttpWebResponse)request.GetResponse();
        string jsonResponse = string.Empty;
        using (StreamReader sr = new StreamReader(response.GetResponseStream()))
        {
            jsonResponse = sr.ReadToEnd();
        }
        return jsonResponse.Contains("true");
    }


    public static bool CreateMessageJson(string registrantId, string emailTemplateId)
    {
        //TLB - RTC 470224
        UpdateSecurityProtocol();

        String uri = Helpers.GetConfigEntry("JsonServiceUri") + "createmessagejson/" + registrantId + "/" + emailTemplateId + "/" + _currentUser.UserName; ;
        WebRequest request = WebRequest.Create(uri);
        request.Method = "GET";
        request.ContentType = @"application/json; charset=utf-8";
        String secretKey = Helpers.GetConfigEntry("secretKey");
        request.Headers.Add("Authorization", "Basic " + secretKey);

        HttpWebResponse response = (HttpWebResponse)request.GetResponse();
        string jsonResponse = string.Empty;
        using (StreamReader sr = new StreamReader(response.GetResponseStream()))
        {
            jsonResponse = sr.ReadToEnd();
        }
        return jsonResponse.Contains("true");
    }

    public static bool ReopenQuestionnaire(string userId)
    {
        //TLB - RTC 470224
        UpdateSecurityProtocol();

        String uri = Helpers.GetConfigEntry("JsonServiceUri") + "reopenquestionnaire/" + userId;
        WebRequest request = WebRequest.Create(uri);
        request.Method = "GET";
        request.ContentType = @"application/json; charset=utf-8";
        String secretKey = Helpers.GetConfigEntry("secretKey");
        request.Headers.Add("Authorization", "Basic " + secretKey);

        HttpWebResponse response = (HttpWebResponse)request.GetResponse();
        string jsonResponse = string.Empty;
        using (StreamReader sr = new StreamReader(response.GetResponseStream()))
        {
            jsonResponse = sr.ReadToEnd();
        }
        return jsonResponse.Contains("true");
    }
}
