using System;
using System.Collections.Generic;
using System.Linq;
using System.Data.Linq;
using System.Web;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;

/// <summary>
/// Summary description for MenuBuilder
/// </summary>
public static class MenuBuilder
{
    //private static string[] PageList;
    private static string fontColorNavyBlue = "#1E2D54";
    private static string fontColorLightBlue = "#2e498f";
    private static SessionFacade userSession;

    //Look at using sitemap (Database entries available)
    /// <summary>
    /// Builds a menu and takes child excluion into consideration
    /// </summary>
    /// <param name="currentUrl"></param>
    /// <param name="horizontalMenu"></param>
    /// <param name="pageTopMenuItem"></param>
    /// <param name="leftMenu"></param>
    /// <param name="pageLeftMenuItem"></param>
    /// <param name="breadCrumb"></param>
    /// <param name="accessiblePageList"></param>
    public static void BuildDynamicNavigationItems(string currentUrl, Menu horizontalMenu, string pageTopMenuItem,
        Menu leftMenu, string pageLeftMenuItem, Label breadCrumb, string[] accessiblePageList, int registrantId)
    {
        BuildDynamicNavigationItems(currentUrl, horizontalMenu, pageTopMenuItem, leftMenu, pageLeftMenuItem, breadCrumb, accessiblePageList, true, registrantId);
    }
    /// <summary>
    /// Builds left menu based on top menu location and pages accessible by user
    /// </summary>
    /// <param name="currentUrl"></param>
    /// <param name="horizontalMenu"></param>
    /// <param name="pageTopMenuItem"></param>
    /// <param name="leftMenu"></param>
    /// <param name="pageLeftMenuItem"></param>
    /// <param name="breadCrumb"></param>
    /// <param name="accessiblePageList"></param>
    private static void BuildDynamicNavigationItems(string currentURL, Menu horizontalMenu, string pageTopMenuItem, Menu leftMenu, string pageLeftMenuItem,
        Label breadCrumb, string[] accessiblePageList, bool showChildren, int registrantId)
    {
        MenuItem menuItemNew = null;
        MenuItem sectionMenuItem = null;
        MenuItem subSectionMenuItem = null;
        try
        {
            UserAccountManager currentUser = (UserAccountManager)HttpContext.Current.User;
       
        leftMenu.Width = new Unit(167);
        switch (pageTopMenuItem)
        {
            case "My Account":
                leftMenu.Width = new Unit(150);
                menuItemNew = new MenuItem("Account Information", "AHOBPR MY ACCOUNT", "", "MyAccountEditUser.aspx");
                menuItemNew.ToolTip = "Select to edit account information";
                leftMenu.Items.Add(menuItemNew);

                leftMenu.Width = new Unit(150);
                menuItemNew = new MenuItem("My Actions Tracking", "AHOBPR MY ACCOUNT", "", "AdminActionTrackingByUser.aspx?from=myaccount");
                menuItemNew.ToolTip = "Select to view my actions";
                leftMenu.Items.Add(menuItemNew);
                break;
            case "Tool":
                leftMenu.Width = new Unit(150);
                menuItemNew = new MenuItem("Question Group List", "AHOBPR TOOL", "", "ToolQuestionGroupList.aspx");
                menuItemNew.ToolTip = "Select to manage question group list for tool";
                leftMenu.Items.Add(menuItemNew);

                leftMenu.Width = new Unit(150);
                menuItemNew = new MenuItem("Question List", "AHOBPR TOOL", "", "ToolQuestionList.aspx");
                menuItemNew.ToolTip = "Select to manage question list for tool";
                leftMenu.Items.Add(menuItemNew);

                break;
            case "Administration":
                leftMenu.Width = new Unit(200);
                menuItemNew = new MenuItem("Users", "AHOBPR ADMIN LIST USERS", "", "AdminListUsers.aspx");
                menuItemNew.ToolTip = "Select to manage registry users";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Role Matrix", "AHOBPR ADMIN USER ROLE", "", "AdminEditUsersRoles.aspx");
                menuItemNew.ToolTip = "Select to manage registry user roles";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Registry Flags", "AHOBPR REGISTRY FLAG", "", "AdminRegistryFlags.aspx");
                menuItemNew.ToolTip = "Select to manage registry flags";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Registry Messages", "AHOBPR REGISTRY MESSAGES", "", "ManageEmailTemplate.aspx");
                menuItemNew.ToolTip = "Select to manage emails and notifications";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Clinical Portal User Email", "AHOBPR REGISTRY MESSAGES", "", "AdminUserEmailTemplateList.aspx");
                menuItemNew.ToolTip = "Select to manage clinical portal user email templates";
                leftMenu.Items.Add(menuItemNew);
               

                menuItemNew = new MenuItem("Send Message", "AHOBPR SEND MESSAGE", "", "AdminSendMessage.aspx");
                menuItemNew.ToolTip = "Select to send emails and notifications to registrants";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Send Email to Users", "AHOBPR SEND MESSAGE", "", "AdminSendEmailToUser.aspx");
                menuItemNew.ToolTip = "Select to send emails to users";
                leftMenu.Items.Add(menuItemNew);

               
                menuItemNew = new MenuItem("Send Follow-up Questions", "AHOBPR TOOL", "", "AdminSendFollowupQuestions.aspx");
                menuItemNew.ToolTip = "Select to send follow-up questions";
                leftMenu.Items.Add(menuItemNew);

                
                menuItemNew = new MenuItem("Queue Monitor", "AHOBPR TOOL", "", "AdminQueueMonitor.aspx");
                menuItemNew.ToolTip = "Select to see and monitor the queue for emails, notifications, follow-up questions and flags";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Action Tracking", "AHOBPR ADMIN LIST USERS", "", "AdminActionTracking.aspx");
                menuItemNew.ToolTip = "Select to see user activities";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Clinical User Ad Hoc Report", "AHOBPR CLINICAL USER AD-HOC REPORT", "", "ClinicalUserAdHocReport.aspx");
                menuItemNew.ToolTip = "Select to see clinical user Ad Hoc report";
                leftMenu.Items.Add(menuItemNew);

                break;

            case "Registrants":
                menuItemNew = new MenuItem("Registrant Search", "AHOBPR REGISTRANT SEARCH", "", "RegistrantSearch.aspx");
                menuItemNew.ToolTip = "Select to search registrant";
                leftMenu.Items.Add(menuItemNew);

                if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode)) ||
                    currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleHelpDeskCode)))
                {
                    //menuItemNew = new MenuItem("Change Status", "AHOBPR CHANGE STATUS", "", "ChangeStatusSearchRegistrant.aspx");
                    //menuItemNew.ToolTip = "Select to search registrants and change their eligibility status";
                    //leftMenu.Items.Add(menuItemNew);

                    menuItemNew = new MenuItem("Non-Verified Names", "AHOBPR NAME UPDATE", "", "NameUpdateSearchRegistrant.aspx");
                    if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleHelpDeskCode)))
                    {
                        menuItemNew.ToolTip = "Select to search registrants who have non-verified names";
                    }
                    else
                    {
                        menuItemNew.ToolTip = "Select to search registrants and change their names";
                    }
                    leftMenu.Items.Add(menuItemNew);
                }


                if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode))
                    || currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode)))
                {
                    menuItemNew = new MenuItem("Change Status", "AHOBPR CHANGE STATUS", "", "ChangeStatusSearchRegistrant.aspx");
                    menuItemNew.ToolTip = "Select to search registrants and change their eligibility status";
                    leftMenu.Items.Add(menuItemNew);

                    menuItemNew = new MenuItem("Add Flags", "AHOBPR ADMIN ADD FLAGS", "", "AdminAddFlags.aspx");
                    menuItemNew.ToolTip = "Select to add mass Flags";
                    leftMenu.Items.Add(menuItemNew);
                }

                if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode)))
                {
                    menuItemNew = new MenuItem("My Message Templates", "AHOBPR MY TEMPLATES", "", "MyEmailTemplates.aspx");
                    menuItemNew.ToolTip = "Select to set up email templates";
                    leftMenu.Items.Add(menuItemNew);

                    menuItemNew = new MenuItem("Send Message", "AHOBPR MY TEMPLATES", "", "MySendMessage.aspx");
                    menuItemNew.ToolTip = "Select to set up email templates";
                    leftMenu.Items.Add(menuItemNew);
                }            

                if (currentURL.Contains("Questionnaire") || currentURL.Contains("SubpopulationFlag")
                    || currentURL.Contains("AdminTracking") || currentURL.Contains("RegistrantStatusHistory")
                    || currentURL.Contains("PreviousHealthFactors") || currentURL.Contains("RegistrantDeploymentHistory")
                    || currentURL.Contains("RegistrantHelpDesk") || currentURL.Contains("RegistrantInformation"))
                {
                    menuItemNew = new MenuItem("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", " ", "", "");
                    menuItemNew.ToolTip = "Selected Registrant Menu";
                    menuItemNew.Selectable = false;
                    leftMenu.Items.Add(menuItemNew);

                    leftMenu.Width = new Unit(305);

                    if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode))
                        || currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode))
                        || currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleCareTeamCode)))
                    {
                        menuItemNew = new MenuItem("Clinically Relevant Summary", "AHOBPR QUESTIONNAIRE SUMMARY", "", "QuestionnaireSummary.aspx?id=" + registrantId);
                        menuItemNew.ToolTip = "Select to view registrant Health Factors, Encounter Information, Health Care Information, and Clinically Relevant questions";
                        leftMenu.Items.Add(menuItemNew);

                        AHOBPRQuestionnaireManager questionnaireManager = new AHOBPRQuestionnaireManager();
                        STD_FORM form = questionnaireManager.GetFormByRegistrantId(registrantId);
                        if (form != null)
                        {
                            menuItemNew = new MenuItem("Full Questionnaire", "AHOBPR QUESTIONNAIRE FULL", "", "QuestionnaireFull.aspx?id=" + registrantId);
                            menuItemNew.ToolTip = "Select to view a list of all the questions and responses from the questionnaire.";
                            leftMenu.Items.Add(menuItemNew);

                            foreach (STD_FORM_SECTION section in form.STD_FORM_SECTIONs)
                            {
                                sectionMenuItem = new MenuItem(section.MENU_ITEM_NAME, "AHOBPR QUESTIONNAIRE SECTION", "", "QuestionnaireSection.aspx?sectionId=" + section.STD_FORM_SECTION_ID);
                                //sectionMenuItem.ToolTip = "Select to see questionnaire Section - " + section.TITLE;
                                sectionMenuItem.ToolTip = section.TOOL_TIP;
                                menuItemNew.ChildItems.Add(sectionMenuItem);
                                foreach (STD_FORM_SUB_SECTION subsection in section.STD_FORM_SUB_SECTIONs)
                                {
                                    if (!string.IsNullOrEmpty(subsection.MENU_ITEM_NAME))
                                    {
                                        subSectionMenuItem = new MenuItem(subsection.MENU_ITEM_NAME, "AHOBPR QUESTIONNAIRE SECTION", "", "QuestionnaireSection.aspx?sectionId=" + section.STD_FORM_SECTION_ID + "&subSectionId=" + subsection.STD_FORM_SUB_SECTION_ID);
                                        //subSectionMenuItem.ToolTip = "Select to see questionnaire sub section - " + subsection.TITLE;
                                        subSectionMenuItem.ToolTip = subsection.TOOL_TIP;
                                        sectionMenuItem.ChildItems.Add(subSectionMenuItem);
                                        sectionMenuItem.Selectable = false;
                                    }
                                }

                                if (sectionMenuItem.Selectable)
                                {
                                    sectionMenuItem.NavigateUrl = "QuestionnaireSection.aspx?sectionId=" + section.STD_FORM_SECTION_ID + "&subSectionId=" + section.STD_FORM_SUB_SECTIONs.First().STD_FORM_SUB_SECTION_ID;
                                }
                            }

                            if (questionnaireManager.HasFollowUpQuestions(registrantId))
                            {
                                menuItemNew = new MenuItem("Follow-up Questions", "AHOBPR QUESTIONNAIRE SECTION", "", "QuestionnaireFollowup.aspx?id=" + registrantId);
                                menuItemNew.ToolTip = "Select to view registrants follow-up questions";
                                leftMenu.Items.Add(menuItemNew);
                            }
                        }
                    }
                    else if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleHelpDeskCode)))
                    {
                        menuItemNew = new MenuItem("Summary", "AHOBPR NAME UPDATE", "", "RegistrantHelpDesk.aspx?id=" + registrantId);
                        menuItemNew.ToolTip = "Select to view registrant information, encounter information, health care information, and deployment history";
                        leftMenu.Items.Add(menuItemNew);
                    }


                    menuItemNew = new MenuItem("Deployment History", "AHOBPR DEPLOYMENT HISTORY", "", "RegistrantDeploymentHistory.aspx?id=" + registrantId);
                    menuItemNew.ToolTip = "Select to view registrants deployment history";
                    leftMenu.Items.Add(menuItemNew);

                    menuItemNew = new MenuItem("Status History", "AHOBPR STATUS HISTORY", "", "RegistrantStatusHistory.aspx?id=" + registrantId);
                    menuItemNew.ToolTip = "Select to view registrants status history";
                    leftMenu.Items.Add(menuItemNew);

                    menuItemNew = new MenuItem("Subpopulation Flags", "AHOBPR SUBPOPULATION FLAG", "", "SubpopulationFlag.aspx?id=" + registrantId);
                    menuItemNew.ToolTip = "Select to view and add Subpopulation Flags to the registrants record.";
                    leftMenu.Items.Add(menuItemNew);

                    menuItemNew = new MenuItem("Admin Tracking", "AHOBPR ADMIN TRACKING", "", "AdminTracking.aspx?id=" + registrantId);
                    menuItemNew.ToolTip = "Select to view and add Administrative Flags to the registrants record.";
                    leftMenu.Items.Add(menuItemNew);
                }

                break;
            case "Reporting":
                leftMenu.Width = new Unit(260);
                menuItemNew = new MenuItem("Status by Location Report", "AHOBPR REPORT Status by Location", "", "ReportStatusByLocation.aspx");
                menuItemNew.ToolTip = "Select to generate the Status by Location Report";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Aging Report", "AHOBPR REPORT AGING", "", "ReportAging.aspx");
                menuItemNew.ToolTip = "Select to generate the aging report";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Duty Status Report", "AHOBPR MILITARY STATUS REPORT", "", "ReportMilitaryStatus.aspx");
                menuItemNew.ToolTip = "Select to generate the Military Status report";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Ad Hoc Report by Individual", "AHOBPR REPORT Ad Hoc", "", "ReportAdHoc.aspx?reportType=Individual");
                menuItemNew.ToolTip = "Select to generate the Ad Hoc Report by Individaul";
                leftMenu.Items.Add(menuItemNew);

                menuItemNew = new MenuItem("Ad Hoc Report by Location", "AHOBPR REPORT AD HOC BY LOCATION", "", "ReportAdHoc.aspx?reportType=Aggregate");
                menuItemNew.ToolTip = "Select to generate the Ad Hoc Report by Location";
                leftMenu.Items.Add(menuItemNew);

                if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode))
                || currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode)))
                {
                    menuItemNew = new MenuItem("Participation Report", "AHOBPR REPORT PARTICIPATION", "", "ReportParticipation.aspx");
                    menuItemNew.ToolTip = "Select to generate the Participation Report";
                    leftMenu.Items.Add(menuItemNew);
                }

                menuItemNew = new MenuItem("Registrant Contact Information Report", "AHOBPR REPORT CONTACT INFORMATION", "", "ReportContactInformation.aspx");
                menuItemNew.ToolTip = "Select to generate the Registrant Contact Information Report";
                leftMenu.Items.Add(menuItemNew);


                if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode)))
                {
                    menuItemNew = new MenuItem("Eligibility Review Report", "AHOBPR REPORT ELIGIBILITY REVIEW", "", "ReportEligibilityReview.aspx");
                    menuItemNew.ToolTip = "Select to generate the Eligibility Review Report";
                    leftMenu.Items.Add(menuItemNew);
                }

                if (currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleRegistryManagerCode))
                || currentUser.IsInRole(AHOBPRShared.GetUserRoleId(AHOBPRGlobal.AhobprUserRoleAdvancedUserCode)))
                {
                    menuItemNew = new MenuItem("Follow-up Questions Report", "AHOBPR REPORT FOLLOW-UP QUESTIONS", "", "ReportFollowupQuestions.aspx");
                    menuItemNew.ToolTip = "Select to generate the Follow-up Questions Report";
                    leftMenu.Items.Add(menuItemNew);
                }

                menuItemNew = new MenuItem("Registrants In Status Report", "AHOBPR REGISTRANT IN STATUS REPORT", "", "ReportRegistrantsInStatus.aspx");
                menuItemNew.ToolTip = "Select to generate the Registrants In Status Report";
                leftMenu.Items.Add(menuItemNew);
                break;

            default:
                leftMenu.Items.Add(new MenuItem("Top Menu Not Registered"));
                break;
        }

        SetMenuItemHighlightWithCurrentUrl(leftMenu.Items, currentURL);
        }
        catch (NullReferenceException ex)
        {
            Logging.LogErrorMessage("", "", ex.Message);
        }
        catch (Exception ex)
        {
            Logging.LogErrorMessage("", "", ex.Message);
        }
    }

    /// <summary>

    /// <summary>
    /// 
    /// </summary>
    /// <param name="menu"></param>
    /// <param name="currentURL"></param>
    private static void SetMenuItemHighlightWithCurrentUrl(MenuItemCollection menu, string currentURL)
    {
        if (HttpContext.Current.Session != null && HttpContext.Current.Session["UserSession"] != null)
            userSession = HttpContext.Current.Session["UserSession"] as SessionFacade;
        else
            userSession = new SessionFacade();

        bool elemSelected;
        string[] pathElems = currentURL.Split(new char[] { '/' });

        SelectAndHighLightElement(menu, pathElems[pathElems.Length - 1], out elemSelected);

        if (!elemSelected)
        {
            string origUrl = userSession.SelectedMenuUrl;
            if (!string.IsNullOrEmpty(origUrl))
            {
                SelectAndHighLightElement(menu, origUrl, out elemSelected);
            }
        }
    }


    public static void SelectAndHighLightElement(MenuItemCollection menu, string url, out bool selected)
    {
        if (HttpContext.Current.Session != null && HttpContext.Current.Session["UserSession"] != null)
            userSession = HttpContext.Current.Session["UserSession"] as SessionFacade;
        else
            userSession = new SessionFacade();

        if (url.Contains("AdminTracking.aspx") && url.Contains("from=changeStatus"))
        {
            url = url.Replace("&from=changeStatus", string.Empty);
        }
        else if (url.Contains("ChangeStatus.aspx"))
        {
            url = "ChangeStatusSearchRegistrant.aspx";
        }
        else if (url.Contains("Tool") && url.Contains("?id"))
        {
            if (url.Contains("ToolQuestionEdit.aspx") || url.Contains("ToolQuestionPreview.aspx"))
            {
                url = "ToolQuestionList.aspx";
            }
            else if (url.Contains("ToolQuestionGroupEdit.aspx") || url.Contains("ToolQuestionGroupPreview.aspx"))
            {
                url = "ToolQuestionGroupList.aspx";
            }
        }
        foreach (MenuItem elem in menu)
        {
            if (elem.NavigateUrl.Equals(url, StringComparison.CurrentCultureIgnoreCase))
            {
                userSession.SelectedMenuUrl = url;
                selected = true;

                if (elem.Selectable)
                {
                    elem.Selected = true;
                    elem.Text = elem.Text.Replace(fontColorNavyBlue, fontColorLightBlue);
                }
                return;

            }
            else
            {
                if (elem.ChildItems.Count > 0)

                    SelectAndHighLightElement(elem.ChildItems, url, out selected);

            }
        }

        selected = false;

    }

    public static string getReferralCount(int statusToCount)
    {
        string _returnText = "";

        //RegistryEntitiesDataContext db = new RegistryEntitiesDataContext();

        //using (db)
        //{

        //    var referrals = (from c in db.REFERRALs where c.STD_REFERRAL_STATUS_ID == statusToCount select c);

        //    int referralCount;
        //    referralCount = referrals.Count();

        //    if (referralCount > 0)
        //    {
        //        _returnText = " (" + referralCount.ToString() + ")";
        //    }
        //    else 
        //    {
        //        _returnText = "";
        //    }

        //};

        return _returnText;
    }
}
