﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Configuration;
using System.ComponentModel;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using AntiXssEnc = Microsoft.Security.Application;

/// <summary>
/// Summary description for Helpers
/// </summary>
public static class Helpers
{
    #region Actions, Error Codes, Descriptions for CCOW

    public static readonly string SentillionReasonDesc = "The sentillion components are not functioning. They are either missing or should be reinstalled.";
    public static readonly string SentillionReasonCode = "sentillion";
    public static readonly string ContextReasonDesc = "It is possible that user context sharing has been disabled by CPRS";
    public static readonly string ContextReasonCode = "context";
    public static readonly string RequestStationAction = "requestStation";
    public static readonly string ConfirmAction = "confirm";
    public static readonly string ActionQueryField = "action";
    public static readonly string ReasonQueryField = "reason";
    public static readonly string VistaQueryField = "vista";
    public static readonly string InvalidDivisionErrorSnippet = "Division specified is invalid for user.";
    public static readonly string InvalidDivisionPleasantErrorPrefix = "The VIA service reports that you are not authorized for division ";
    public static readonly string DivisionNotSupportedFormat = "Division [{0}] not supported";
    public static readonly string SuccessMessage = "SUCCESS";
    public static readonly string VIASiteLookupSuccessPrefix = "The VIA service reports that your primary station is ";

    #endregion Error Codes and Descriptions Shared for CCOW

    private static string[] _countries = new string[] { 
         "Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", 
         "Angola", "Anguilla", "Antarctica", "Antigua And Barbuda", "Argentina", 
         "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan",
		   "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus",
		   "Belgium", "Belize", "Benin", "Bermuda", "Bhutan",
		   "Bolivia", "Bosnia Hercegovina", "Botswana", "Bouvet Island", "Brazil",
		   "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Byelorussian SSR",
		   "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands",
		   "Central African Republic", "Chad", "Chile", "China", "Christmas Island",
		    "Colombia", "Comoros", "Congo", "Cook Islands",
		   "Costa Rica", "Cote D'Ivoire", "Croatia", "Cuba", "Cyprus",
		   "Czech Republic", "Czechoslovakia", "Denmark", "Djibouti", "Dominica",
		   "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador",
		   "England", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia",
		   "Falkland Islands", "Faroe Islands", "Fiji", "Finland", "France",
		   "Gabon", "Gambia", "Georgia", "Germany", "Ghana",
		   "Gibraltar", "Great Britain", "Greece", "Greenland", "Grenada",
		   "Guadeloupe", "Guam", "Guatemela", "Guernsey", "Guiana",
		   "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Heard Islands",
		   "Honduras", "Hong Kong", "Hungary", "Iceland", "India",
		   "Indonesia", "Iran", "Iraq", "Ireland", "Isle Of Man",
		   "Israel", "Italy", "Jamaica", "Japan", "Jersey",
		   "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Korea, South",
		   "Korea, North", "Kuwait", "Kyrgyzstan", "Lao People's Dem. Rep.", "Latvia",
		   "Lebanon", "Lesotho", "Liberia", "Libya", "Liechtenstein",
		   "Lithuania", "Luxembourg", "Macau", "Macedonia", "Madagascar",
		   "Malawi", "Malaysia", "Maldives", "Mali", "Malta",
		   "Mariana Islands", "Marshall Islands", "Martinique", "Mauritania", "Mauritius",
		   "Mayotte", "Mexico", "Micronesia", "Moldova", "Monaco",
		   "Mongolia", "Montserrat", "Morocco", "Mozambique", "Myanmar",
		   "Namibia", "Nauru", "Nepal", "Netherlands", "Netherlands Antilles",
		   "Neutral Zone", "New Caledonia", "New Zealand", "Nicaragua", "Niger",
		   "Nigeria", "Niue", "Norfolk Island", "Northern Ireland", "Norway",
		   "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea",
		   "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland",
		   "Polynesia", "Portugal", "Puerto Rico", "Qatar", "Reunion",
		   "Romania", "Russian Federation", "Rwanda", "Saint Helena", "Saint Kitts",
		   "Saint Lucia", "Saint Pierre", "Saint Vincent", "Samoa", "San Marino",
		   "Sao Tome and Principe", "Saudi Arabia", "Scotland", "Senegal", "Seychelles",
		   "Sierra Leone", "Singapore", "Slovakia", "Slovenia", "Solomon Islands",
		   "Somalia", "South Africa", "South Georgia", "Spain", "Sri Lanka",
		   "Sudan", "Suriname", "Svalbard", "Swaziland", "Sweden",
		   "Switzerland", "Syrian Arab Republic", "Taiwan", "Tajikista", "Tanzania",
		   "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago",
		   "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu",
		   "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States",
		   "Uruguay", "Uzbekistan", "Vanuatu", "Vatican City State", "Venezuela",
		   "Vietnam", "Virgin Islands", "Wales", "Western Sahara", "Yemen",
		   "Yugoslavia", "Zaire", "Zambia", "Zimbabwe"};

    /// <summary>
    /// Get a string from an object
    /// </summary>
    /// <param name="sessionVariable"></param>
    /// <returns></returns>
    public static string GetStringFromObject(object sessionVariable)
    {
        string result = string.Empty;

        if (sessionVariable != null)
        {
            result = sessionVariable.ToString();
        }

        return result;
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="searchcriteriaName"></param>
    /// <param name="searchcriteriaValue"></param>
    /// <returns></returns>
    public static string GetReportSearchCriteria(string searchcriteriaName, string searchcriteriaValue)
    {
        string result = string.Empty;

        if (!string.IsNullOrEmpty(searchcriteriaValue) && !string.IsNullOrEmpty(searchcriteriaName))
        {
            result = searchcriteriaName + ": " + searchcriteriaValue;
        }

        return result;
    }

     /// <summary>
    /// Returns an array with all countries
    /// </summary>     
    public static StringCollection GetCountries()
    {
        StringCollection countries = new StringCollection();
        countries.AddRange(_countries);
        return countries;
    }
    /// <summary>
    /// Returns sorted list of all countries
    /// </summary>
    /// <param name="insertEmpty"></param>
    /// <returns></returns>
    public static SortedList GetCountries(bool insertEmpty)
    {
        SortedList countries = new SortedList();
        if (insertEmpty)
            countries.Add("", "Please select one...");
        foreach (String country in _countries)
            countries.Add(country, country);
        return countries;
    }
    /// <summary>
    /// highlights controls on selection 
    /// </summary>
    /// <param name="container"></param>
    /// <param name="className"></param>
    public static void SetInputControlsHighlight(Control container, string className)
    {
        foreach (Control ctl in container.Controls)
        {
            if ( ctl is TextBox || ctl is DropDownList ||
                ctl is ListBox || ctl is CheckBox || ctl is RadioButton ||
                ctl is RadioButtonList || ctl is CheckBoxList )
            {
                WebControl wctl = ctl as WebControl;
                if (wctl != null)
                {
                    wctl.Attributes.Add("onfocus", string.Format("this.className = '{0}';", className));
                    wctl.Attributes.Add("onblur", "this.className = '';");
                }
            }
            else
            {
                if (ctl.Controls.Count > 0)
                    SetInputControlsHighlight(ctl, className);
            }
        }
    }

    /// <summary>
    /// Utility to build a control list of pre-defined control type within a container(usually panel)
    /// </summary>
    /// <param name="container"></param>
    /// <param name="type"></param>
    /// <returns></returns>
    public static List<Control> BuildControlList(Control container, Type type) 
    {
        List<Control> controlList = new List<Control>();

        AddControlsToList(container.Controls, type, controlList);

        return controlList; 
    }
    private static void AddControlsToList(ControlCollection collection, Type type, List<Control> listToFill)
    {
         foreach (Control control in collection)
         {
            if (control.GetType().Equals(type))
            {

                listToFill.Add(control);
            }
            else
            {
                if (control.Controls.Count > 0 )
                    AddControlsToList(control.Controls, type, listToFill);

            }
        }   
    }
    public static Boolean isInteger(string valueToCheck)
    {
        int _tempInt; 
		
		try
			{
				_tempInt = Convert.ToInt32( valueToCheck );
                return true;
			}
			catch
			{
				return false;
			}

    }
    public static Boolean isString(string valueToCheck)
    {
        string _tempString; 
		
		try
			{
                _tempString = valueToCheck.ToString();
                return true;
			}
			catch
			{
				return false;
			}

    }
    public static string GetConfigEntry(string key)
    {
        string Val = string.Empty ;   
        if (WebConfigurationManager.AppSettings.Count > 0)
                Val = WebConfigurationManager.AppSettings.Get(key);

        return Val;
    }

    /// <summary>
    /// Default size for queue batch is 500 unless there is a configurable value in web.config
    /// </summary>
    /// <returns></returns>
    public static int GetQueueBatchSize()
    {
        int size = 500;

        string configuredSize = GetConfigEntry("QueueBatchSize");
        if (!string.IsNullOrEmpty(configuredSize))
        {
            size = getIntFromString(configuredSize);
        }
        return size;
    }

    public static string GetIdBatch(List<int> idList, int startBatchNumber, int batchSize, int totalBatches)
    {
        string ids = string.Empty;
        int batchNumber = 0;
        int count = 0;
        foreach (int id in idList)
        {
            count++;
            batchNumber = count % batchSize == 0 ? count / batchSize : Convert.ToInt32(count / batchSize) + 1;
            if (batchNumber == startBatchNumber)
            {
                ids = string.IsNullOrEmpty(ids) ? id.ToString() : ids + "," + id.ToString();
            }
            else if (batchNumber > startBatchNumber)
            {
                break;
            }
        }

        return ids;
    }

    /// <summary>
    /// useful function to convert to various nullable types from string
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <param name="input"></param>
    /// <returns></returns>
    public static T? ConvertStringToNullable<T>(string input) where T:struct
    {
        T? result = null;
        
        TypeConverter converter = TypeDescriptor.GetConverter(typeof(T));

        if (string.IsNullOrEmpty(input))
        {
            result = null;
        }
        else
        {
            try
            {
                result = (T)converter.ConvertFromString(input);
            }
            catch
            {
                result = null;
            }
           
        }

        return result;
    }
    public static Nullable<T> ToNullable<T>(this string s) where T : struct
    {
        Nullable<T> result = new Nullable<T>();
        try
        {
            if (!string.IsNullOrEmpty(s) && s.Trim().Length > 0)
            {
                TypeConverter conv = TypeDescriptor.GetConverter(typeof(T));
                result = (T)conv.ConvertFrom(s);
            }
        }
        catch { }
        return result;
    }
    public static int getIntFromString(string inString)
    {
        int returnInt = 0;
        int tempInt;
        bool result = int.TryParse(inString, out tempInt);
        if (result)
        {
            returnInt = tempInt;
        }
        return returnInt;
    }

    public static DateTime GetDateFromString(string inString)
    {
        DateTime returnDate = DateTime.MinValue;
        DateTime tempDate;
        bool result = DateTime.TryParse(inString, out tempDate);
        if (result)
        {
            returnDate = tempDate;
        }
        return returnDate;
    }

    public static string getShortDateStringFromNullableDate(DateTime? inDate)
    {
        string returnString = "";
        if (inDate.HasValue)
        {
            returnString = Convert.ToDateTime(inDate).ToShortDateString();
        }
        return returnString;
    }

    public static int GetDefaultTimeout()
    {
        return 600;
    }

    /// <summary>
    /// 
    /// </summary>
    /// <param name="value"></param>
    /// <returns></returns>
    public static List<KeyValuePair<string, string>> ConvertToKeyValuePair(string value)
    {
        List<KeyValuePair<string, string>> result = new List<KeyValuePair<string, string>>();

        if (!string.IsNullOrEmpty(value))
        {
            List<string> valueList = value.Split(',').ToList();
            foreach (string item in valueList)
            {
                if (!string.IsNullOrEmpty(item))
                {
                    KeyValuePair<string, string> pair = new KeyValuePair<string, string>(item, string.Empty);
                    result.Add(pair);
                }
            }
        }

        return result;
    }


    public static string AhobprEval(Object o)
    {
        if (o == null)
        {
            return string.Empty;
        }
        return AntiXssEnc.Encoder.HtmlEncode(o.ToString(), false);
    }

    public static bool IsSessionVariableNullOrEmpty(object sessionVariable)
    {
        return string.IsNullOrEmpty(GetStringFromSessionVariable(sessionVariable));
    }

    public static string GetStringFromSessionVariable(object sessionVariable)
    {
        string result = string.Empty;

        if (sessionVariable != null)
        {
            result = sessionVariable.ToString();
        }

        return result;
    }

    public static void AddActivityToAuditLog(string userId, string message, string registrantId, AuditLogType type, int? numberOfRegistrants)
    {
        AHOBPRAuditManager auditManager = new AHOBPRAuditManager();
        auditManager.AddToLog(userId, message, registrantId, type, numberOfRegistrants);
    }

}
