<%@ Page Title="Registrants" EnableEventValidation="false" Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" CodeFile="AdminTracking.aspx.cs" Inherits="AdminTracking" %>
<%@ Register src="controls/UserControlRegistrant.ascx" tagname="UserControlRegistrant" tagprefix="UserControl" %>
<%@ Register src="controls/UserControlQuestionnaire.ascx" tagname="UserControlQuestionnaire" tagprefix="UserControl" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
     <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="<H1>Registrants > Registrant > Admin Tracking</H1>"/>
    </div>   
    <UserControl:UserControlRegistrant ID="UserControlRegistrant" runat="server" /> 
    <br />
   <asp:Panel ID="PanelAdminTrackingFlags" runat="server" GroupingText=" Admin Tracking " >
        <asp:GridView ID = "GridViewAdminTrackingFlags" 
            DataSourceID="ObjectDataSourceAdminTrackingFlags" 
            ShowFooter = "True" 
            AutoGenerateColumns = "False" 
            runat ="server" 
            Caption="Admin Flags"   
            OnPreRender="GridViewAdminTrackingFlags_PreRender"
            DataKeyNames = "REGISTRANT_REGISTRY_FLAG_ID" 
            OnRowCommand="GridViewAdminTrackingFlags_RowCommand" 
            EmptyDataText="No Admin Flags Available">
            <EmptyDataTemplate>
                <asp:Label ID="LabelforDropdownListAdminTrackingFlagsEmpty" 
                            AssociatedControlID="DropdownListAdminTrackingFlagsEmpty" SkinID="DataLabel"
                            runat="server" Text="Admin Flag: &nbsp&nbsp&nbsp&nbsp"></asp:Label>  
                 <asp:DropdownList ID="DropdownListAdminTrackingFlagsEmpty" runat="server" 
                            ToolTip="Select Admin Flag" DataSourceID="ObjectDataSourceAdminTrackingFlagsLookupList"
                            DataTextField="NAME" DataValueField="ID">
                 </asp:DropdownList> &nbsp&nbsp&nbsp&nbsp
                <asp:Button ID="ButtonEmptyAddCommand" runat="server" 
                    Text="  Add  " 
                    ToolTip="Add Admin Flag" 
                    CommandName="EMPTYADD" 
                    CausesValidation="true" ValidationGroup = "RegistryFlagGroup" />
                 
            </EmptyDataTemplate>
            <Columns>
              <asp:TemplateField HeaderText = "Admin Flag" >
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID = "LabelSubpopulationFlag" runat = "server" SkinID="DataLabel" Text = '<%# Helpers.AhobprEval(Eval("STD_REGISTRY_FLAG.REGISTRY_FLAG_NAME")) %>'/>
                    </ItemTemplate>
                    <FooterTemplate>                                                                      
                        <asp:Label ID = "LabelforDropdownListAdminTrackingFlags" Text = "Admin Flag:<br />" SkinID="DataLabel"
                        runat = "server" AssociatedControlID="DropdownListAdminTrackingFlags"  Font-Size="X-Small"></asp:Label> 
                        <asp:DropdownList ID="DropdownListAdminTrackingFlags" runat="server" 
                            ToolTip="Select Admin Flag" DataSourceID="ObjectDataSourceAdminTrackingFlagsLookupList"
                            DataTextField="NAME" DataValueField="ID">
                        </asp:DropdownList>                
                    </FooterTemplate> 
               </asp:TemplateField>
               <asp:TemplateField HeaderText = "Created Date Time">
                   <HeaderStyle HorizontalAlign="Center" />
                   <ItemTemplate>
                        <asp:Label ID = "LabelFlagCreationDate" runat = "server" SkinID="DataLabel" Text = '<%# Helpers.AhobprEval(Eval("CREATED")) %>'/>
                    </ItemTemplate>
                 </asp:TemplateField>
                 <asp:TemplateField HeaderText = "Created By User" >
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID = "LabelFlagCreatedBy" runat = "server" SkinID="DataLabel" Text = '<%# Helpers.AhobprEval(Eval("CREATEDBY")) %>'/>
                    </ItemTemplate>
                 </asp:TemplateField>
                 <asp:TemplateField >
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <FooterStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                       <asp:Button ID="ButtonDelete" runat="server"
                            Text="  Remove  "
                            Enabled='<%# Convert.ToBoolean(Eval("CanFlagBeRemoved")) || 
                                     ((VeteransAffairs.Registries.BusinessManager.UserAccountManager)HttpContext.Current.User).RoleName.Contains("AHOBPR Registry Manager") && Convert.ToBoolean(Eval("NotPredefined")) %>' 
                            Visible='<%# Convert.ToBoolean(Eval("CanFlagBeRemoved")) ||
                                     ((VeteransAffairs.Registries.BusinessManager.UserAccountManager)HttpContext.Current.User).RoleName.Contains("AHOBPR Registry Manager") && Convert.ToBoolean(Eval("NotPredefined")) %>'
                            OnClientClick="return confirm('Are you sure you want to remove this admin flag? Click cancel if you do not want to remove.');"
                            ToolTip='<%# string.Format("Remove {0} from registrant admin flag list", AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(DataBinder.Eval(Container.DataItem,"STD_REGISTRY_FLAG.REGISTRY_FLAG_NAME")))) %>' 
                            CommandName="DELETE_FLAG" 
                            CommandArgument='<%# AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("REGISTRANT_REGISTRY_FLAG_ID"))) %>' 
                            CausesValidation="false"/>
                    </ItemTemplate>
                    <FooterTemplate>
                       <br />
                       <asp:Button Text="  Add  " ToolTip="Add Admin Flag" CommandName="ADD" CausesValidation="true" runat="server" ID="ButtonAddCommand" 
                       ValidationGroup = "RegistryFlagGroup"  />&nbsp;
                    </FooterTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <asp:ObjectDataSource ID="ObjectDataSourceAdminTrackingFlags" runat="server" 
            SelectMethod="SelectRegistrantAdminTrackingFlags" 
            TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRRegistrantManager">
            <SelectParameters>
                <asp:ControlParameter ControlID="HiddenFieldRegistrantId" Name="registrantId" PropertyName="Value" Type="String" />
        </SelectParameters>
        </asp:ObjectDataSource>

         <asp:ObjectDataSource ID="ObjectDataSourceAdminTrackingFlagsLookupList" runat="server" 
                SelectMethod="SelectLookupList" TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRBaseControlManager" >
            <SelectParameters>
                <asp:Parameter Name="lookupCategory" Type="String" DefaultValue="ADMINTRACKING_FLAG_ACTIVE" />
            </SelectParameters>
        </asp:ObjectDataSource>
    </asp:Panel>
    <br /><br />
    &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
    <asp:Button ID="ButtonBackToChangeStatus" runat="server" onclick="ButtonBackToChangeStatus_Click" Text="  Return to Change Status Page  " />

    <asp:HiddenField ID="HiddenFieldRegistrantId" runat="server" />
</asp:Content>

