﻿<%@ Page Title="" Language="C#" EnableEventValidation="false" MasterPageFile="~/Registry.master"
    AutoEventWireup="true" CodeFile="AdminSendFollowupQuestions.aspx.cs" Inherits="AdminSendFollowupQuestions" %>

<%@ Register Src="controls/BaseControlListBox.ascx" TagName="BaseControlListBox" TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlDropDownList.ascx" TagName="BaseControlDropDownList" TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlRadioButtonList.ascx" TagName="BaseControlRadioButtonList" TagPrefix="UserControl" %>
<%@ Register Src="controls/BaseControlTextBox.ascx" TagName="BaseControlTextBox" TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlReportLocation.ascx" TagName="UserControlReportLocation" TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlAdminFlagFilter.ascx" TagName="UserControlAdminFlagFilter" TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlFromToDate.ascx" TagName="UserControlFromToDate" TagPrefix="UserControl" %>
<%@ Register Src="controls/UserControlFacilityDropdownLists.ascx" TagName="UserControlFacilityDropdownLists" TagPrefix="UserControl" %>
<%@ Register src="controls/UserControlDate.ascx" tagname="UserControlBirthDate" tagprefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">

    <script type="text/javascript">
        $(document).ready(function() {
            $("#<%= DropDownListQuestion.ClientID %>").change(function() {
                $('#<%= PanelSendQuestions.ClientID %>').hide();
                $('#<%= PanelSend.ClientID %>').hide();          
            });

            $('#<%= BaseControlListBoxSubpopulationFlag.ClientID %>').change(function() {
                $('#<%= PanelSendQuestions.ClientID %>').hide();
                $('#<%= PanelSend.ClientID %>').hide();
            });

            $('#<%= UserControlAdminFlagFilter.ClientID + "_DropDownListAdminFlag" %>').change(function() {
                $('#<%= PanelSendQuestions.ClientID %>').hide();
                $('#<%= PanelSend.ClientID %>').hide();
            });

            $('#<%= RadioButtonListHealthConcerns.ClientID %>').click(function() {
                $('#<%= PanelSendQuestions.ClientID %>').hide();
                $('#<%= PanelSend.ClientID %>').hide();
            });
            $('#<%= RadioButtonListHealthConcerns.ClientID %>').click(function() {
                $('#<%= PanelSendQuestions.ClientID %>').hide();
                $('#<%= PanelSend.ClientID %>').hide();
            });
            $('#<%= RadioButtonListHealthConcerns.ClientID %>').click(function() {
                $('#<%= PanelSendQuestions.ClientID %>').hide();
                $('#<%= PanelSend.ClientID %>').hide();
            });


            $('.textInput').change(function() {
                $('#<%= PanelSendQuestions.ClientID %>').hide();
                $('#<%= PanelSend.ClientID %>').hide();
            });
        });
    </script>

    <script type="text/javascript">

        function checkAll(objRef) {

            var GridView = objRef.parentNode.parentNode.parentNode;

            var inputList = GridView.getElementsByTagName("input");

            for (var i = 0; i < inputList.length; i++) {

                //Get the Cell To find out ColumnIndex

                var row = inputList[i].parentNode.parentNode;

                if (inputList[i].type == "checkbox" && objRef != inputList[i]) {

                    if (objRef.checked) {

                        //If the header checkbox is checked

                        //check all checkboxes

                        //and highlight all rows

                        //row.style.backgroundColor = "aqua";

                        inputList[i].checked = true;

                    }

                    else {

                        //If the header checkbox is checked

                        //uncheck all checkboxes

                        //and change rowcolor back to original 

                        if (row.rowIndex % 2 == 0) {

                            //Alternating Row Color

                            //row.style.backgroundColor = "#C2D69B";

                        }

                        else {

                            //row.style.backgroundColor = "white";

                        }

                        inputList[i].checked = false;

                    }

                }

            }

        }

    </script>

    <script type="text/javascript">

        function Check_Click(objRef) {

            //Get the Row based on checkbox

            var row = objRef.parentNode.parentNode;

            if (objRef.checked) {

                //If checked change color to Aqua

                //row.style.backgroundColor = "aqua";

            }

            else {

                //If not checked change back to original color

                if (row.rowIndex % 2 == 0) {

                    //Alternating Row Color

                    //row.style.backgroundColor = "#C2D69B";

                }

                else {

                    //row.style.backgroundColor = "white";

                }

            }



            //Get the reference of GridView

            var GridView = row.parentNode;



            //Get all input elements in Gridview

            var inputList = GridView.getElementsByTagName("input");



            for (var i = 0; i < inputList.length; i++) {

                //The First element is the Header Checkbox

                var headerCheckBox = inputList[0];



                //Based on all or none checkboxes

                //are checked check/uncheck Header Checkbox

                var checked = true;

                if (inputList[i].type == "checkbox" && inputList[i] != headerCheckBox) {

                    if (!inputList[i].checked) {

                        checked = false;

                        break;

                    }

                }

            }

            headerCheckBox.checked = checked;



        }

    </script>

    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID="LabelBreadCrumb" runat="server" Text="<H1>Administration > Send Follow-up Questions</H1>" />
    </div>
    <br />
    <asp:Panel ID="PanelSelectParameters" runat="server" GroupingText=" Selection Criteria - Step 1 of 2 (Please select at least one)">
        <table cellspacing="8">
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxDOB" runat="server" Text="Date of Birth" ToolTip="Registrant’s date of birth." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxLastName" runat="server" Text="Last Name" ToolTip="Registrant last name." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxLast4SSN" runat="server" Text=" Last 4 of SSN" ToolTip=" Last for digits of Registrants SSN." />
                </td>
                <td>
                    <asp:CheckBox ID="CheckBoxHealthConcerns" runat="server" Text="Health Concerns? Yes/No (Yes=any positive response to Q3.A-3.K)"
                        ToolTip="Health Concerns is any positive response to Q3.A–3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers." />
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxSubpopulationFlag" runat="server" Text="Subpopulation Flag"
                        ToolTip="Subpopulation Flag is a flag on the registrant record set by a Clinical Portal user.  The Selection Criteria allows the user to filter with one subpopulation flag." />
                    <br />
                    <br />
                    <asp:CheckBox ID="CheckBoxAdminFlag" runat="server" Text="Admin Flag" ToolTip="Admin Flag is a flag on the registrant record set by a Clinical Portal user.  A registrant record could have more than one of the same Admin Flag.  The Selection Criteria allows the user to filter with one Admin Flag and a date range the flag was set." />
                </td>
                <td>
                    <asp:Panel ID="PanelDeploymentCountry" runat="server" GroupingText="Deployment Country"
                        ToolTip="Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments or deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.">
                        <asp:RadioButtonList ID="RadioButtonListDeploymentCountry" runat="server" RepeatDirection="Horizontal"
                            ToolTip="Deployment Country received from deployment data interfaces.  The Selection Criteria allows the user to filter with one country and by all deployments or deployments that have exposure responses.  The data for deployments that have exposure responses will only be available for registrants in Participant status.">
                            <asp:ListItem Selected="True">None</asp:ListItem>
                            <asp:ListItem>All Deployments</asp:ListItem>
                            <asp:ListItem>Deployments With Exposure Responses</asp:ListItem>
                        </asp:RadioButtonList>
                    </asp:Panel>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxQuestion" runat="server" Text="Response to specific question"
                        ToolTip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses." />
                    <br />
                    <br />
                    <asp:CustomValidator ID="CustomValidatorSelectDataElements" runat="server" SetFocusOnError="true"
                        ErrorMessage="Please select at least one data element." ValidationGroup="SelectDataElements"
                        ForeColor="DarkRed"></asp:CustomValidator>
                </td>
                <td>
                    <asp:Panel ID="PanelFormStartEndDate" runat="server" GroupingText="Date Range for Questionnaire"
                        ToolTip="Date Range for Questionnaire is the Start Date or Completed Date for a registrants questionnaire. The Selection Criteria allows the user to filter by a date range for Start Date, Completed Date, or no date range. ">
                        <asp:RadioButtonList ID="RadioButtonListStartEndDate" runat="server" RepeatDirection="Horizontal"
                            ToolTip="Date Range for Questionnaire is the Start Date or Completed Date for a registrants questionnaire. The Selection Criteria allows the user to filter by a date range for Start Date, Completed Date, or no date range. ">
                            <asp:ListItem Selected="True">None</asp:ListItem>
                            <asp:ListItem>Questionnaire Start Date</asp:ListItem>
                            <asp:ListItem>Questionnaire Completed Date</asp:ListItem>
                        </asp:RadioButtonList>
                    </asp:Panel>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxClosestFacility" runat="server" Text="Closest Facility" ToolTip=" Closest Facility is the registrant’s closest VA medical facility. The Selection Criteria allows the user to filter by registrants' closest facility." />
                </td>
                
            </tr>
            <tr>
                <td>
                    <asp:CheckBox ID="CheckBoxRegistrantStatus" Visible="false" runat="server" Text="Registrant Status"
                        ToolTip="Registrant Status is the status of the registrant’s questionnaire: No Consent, Consent, Not Eligible, Review, Review Not-Eligible, Eligible, and Participant.  The Selection Criteria allows a user to filter with one or more statuses." />
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <asp:Button runat="server" ID="ButtonNext" Text=" Go to Step 2 " OnClick="ButtonNext_Click"
                        ValidationGroup="SelectDataElements" />
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp
                    <asp:Button runat="server" ID="ButtonClearSelection" Text="Clear" Width="120px" OnClick="ButtonClearSelection_Click" />
                </td>
            </tr>
        </table>
    </asp:Panel>
    <asp:Panel ID="PanelParameterSendQuestions" runat="server" GroupingText=" Selection Criteria - Step 2 of 2 (Please select at least one)">
        <br />
        <asp:Panel ID="PanelQuestion" runat="server" ToolTip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses.">
            <asp:Label SkinID="DataLabel" ID="LabelForDropDownListQuestion" runat="server" Text="Questions:"
                AssociatedControlID="DropDownListQuestion" ToolTip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses." />
            <asp:DropDownList runat="server" ID="DropDownListQuestion" Width="900" AutoPostBack="true"
                EnableClientScript="true" ToolTip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses."
                OnSelectedIndexChanged="QuestionDropDownList_SelectedIndexChanged" />
            <br />
            <UserControl:BaseControlListBox ID="BaseControlListBoxAnswer" runat="server" Visible="false"
                Tooltip="Specific Question is a question and response from a completed questionnaire. This data will only be available for registrants in Participant status.  The Selection Criteria allows the user to filter with one question and one or more responses." />
        </asp:Panel>
        <asp:Panel ID="PanelQuestionnaireDate" runat="server">
            <UserControl:UserControlFromToDate ID="UserControlDateRangeFormStartDate" runat="server" />
            <UserControl:UserControlFromToDate ID="UserControlDateRangeFormToDate" runat="server" />
        </asp:Panel>
        <UserControl:BaseControlListBox ID="BaseControlListBoxSubpopulationFlag" runat="server" />
        <UserControl:UserControlAdminFlagFilter ID="UserControlAdminFlagFilter" runat="server" />
        <asp:Panel ID="PanelExcludeAdminFlag" runat="server" GroupingText=" Exclude Admin Flag "
            ToolTip="Exclude selected Admin Flag.">
            <asp:RadioButtonList ID="RadioButtonListExcludeAdminFlag" runat="server" RepeatDirection="Horizontal"
                RepeatLayout="Table" ToolTip="Radio button for if the Registrant has a email address.">
                <asp:ListItem Text="All" Value="N" Selected="True" />
                <asp:ListItem Text="Exclude selected Admin Flag." Value="Y" />
            </asp:RadioButtonList>
        </asp:Panel>
        <asp:Panel ID="PanelHealthConcerns" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <asp:Panel ID="PanelRadioButtonHealthConcerns" runat="server" GroupingText="Health Concerns? Yes/No (Yes=any positive response to Q3.A-3.K)"
                            ToolTip="Health Concerns is any positive response to Q3.A–3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.">
                            <asp:RadioButtonList ID="RadioButtonListHealthConcerns" runat="server" RepeatDirection="Horizontal"
                                RepeatLayout="Table" ToolTip="Health Concerns is any positive response to Q3.A–3.K by the registrant. This data will only be available for registrants in Participant status. The Selection Criteria allows the user to filter with all answers, any yes answers, or only no answers.">
                                <asp:ListItem Text="All" Selected="True" />
                                <asp:ListItem Text="Yes" />
                                <asp:ListItem Text="No" />
                            </asp:RadioButtonList>
                        </asp:Panel>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="PanelStatus" runat="server">
            <UserControl:BaseControlListBox ID="BaseControlListBoxStatus" runat="server" />
        </asp:Panel>
        <asp:Panel ID="PanelHealthFactorDeployment" runat="server">
            <UserControl:BaseControlDropDownList ID="BaseControlDropDownListDeploymentCountryAll"
                runat="server" />
            <UserControl:BaseControlDropDownList ID="BaseControlDropDownListDeploymentCountryExposure"
                runat="server" />
            <UserControl:BaseControlListBox ID="BaseControlListBoxHealthFactor"  Visible="false" runat="server" />
        </asp:Panel>
        <asp:Panel ID="PanelClosestFacility" runat="server" Visible="false">
            <UserControl:UserControlFacilityDropdownLists ID="UserControlFacilityDropdownLists" runat="server" ClosestFacility="true" />
        </asp:Panel>
        <asp:Panel ID="PanelRegistrantInfo" runat="server">
            <table cellspacing="6">
                <tr>
                    <td>
                        <UserControl:BaseControlTextBox ID="BaseControlTextBoxLastName" runat="server" />
                    </td>
                    <td>
                        <UserControl:BaseControlTextBox ID="BaseControlTextBoxLast4SSN" runat="server" />
                    </td>
                </tr>
                <tr>
                    <td>
                        <UserControl:UserControlBirthDate ID="UserControlBirthDate" runat="server" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:CustomValidator ID="CustomValidatorStep2" runat="server" SetFocusOnError="true"
            ErrorMessage="Please select at least one search criteria.<br />" ValidationGroup="OnSearch"
            ForeColor="DarkRed"></asp:CustomValidator>
        <asp:Panel ID="PanelButtons" runat="server" Width="100%" Visible="true">
            <table>
                <tr>
                    <td>
                        <asp:Button runat="server" ID="ButtonSearch" Text="Find" OnClick="ButtonSearch_Click"
                            Width="120px" ValidationGroup="OnSearch" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:Button runat="server" ID="ButtonClear" Text="Clear" Width="120px" OnClick="ButtonClear_Click" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp
                        <asp:Button runat="server" ID="ButtonBack" Text="Back to Step 1" OnClick="ButtonBack_Click" />
                    </td>
                </tr>
            </table>
        </asp:Panel>
    </asp:Panel>
    
    <asp:Panel ID="PanelSendQuestions" runat="server" GroupingText=" Search Results ">
        <center>
            <asp:Label ID="LabelReportCriteria" runat="server" Text="" Font-Bold="true" Font-Size="Large"></asp:Label></center>
        <asp:Label runat="server" ID="LabelNumberOfResultsFound" Font-Bold="true"></asp:Label>
        <div style="text-align: right;" runat="server" id="pageSizeDiv">
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl"  Visible="false" ToolTip ="Items per page" />
                    
                    <asp:DropDownList runat="server" ID="gridViewPageSizeDdl" AutoPostBack="true" Visible="false" CausesValidation="false" ToolTip="Items per page"
                        OnSelectedIndexChanged="gridViewPageSizeDdlChanged">
                        <asp:ListItem Text="10" Value="10"></asp:ListItem>
                        <asp:ListItem Text="25" Value="25"></asp:ListItem>
                        <asp:ListItem Text="50" Value="50"></asp:ListItem>
                        <asp:ListItem Text="100" Value="100"></asp:ListItem>
                    </asp:DropDownList>
       </div>
        <asp:GridView ID="GridViewSendQuestions"
             runat="server"
             DataSourceID="DataSourceSendQuestions"
             AutoGenerateColumns="False"
             PageSize="20"
             Width="100%"
             AllowSorting="True"
             AllowPaging="True"
             OnRowCommand="GridViewSendQuestions_RowCommand"
             DataKeyNames="REGISTRANT_ID"
             Caption="To sort please click table headings"
             OnPageIndexChanged="GridViewSendQuestions_PageIndexChanged"
             OnSorting="GridViewSendQuestions_Sorting"
             OnDataBound="GridViewSendQuestions_DataBound"
             PagerSettings-Mode="Numeric"
             OnPageIndexChanging="gridView_PageIndexChanging">
            <EmptyDataTemplate>
                No match found. Please verify the information you entered in the search criteria.</EmptyDataTemplate>
            <Columns>
                <asp:TemplateField HeaderText="Action">
                   <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:CheckBox ID="checkBoxSend" runat="server" Text="Select" />
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ID" SortExpression="REGISTRANT_ID">
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantID" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))   %>'
                            CommandName="Details" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))  %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Registrant Name" SortExpression="Name">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:LinkButton ID="LinkButtonRegistrantName" runat="server" CommandArgument='<%# Helpers.AhobprEval(Eval("REGISTRANT_ID"))   %>'
                            CommandName="Details" SkinID="DataLabel" ToolTip="Registrant Name" Text='<%# Helpers.AhobprEval(Eval("Name"))  %>'>
                        </asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Date of Birth" SortExpression="BirthDate">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelDOB" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("BirthDateDisplay")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="SSN" SortExpression="SSN">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Last4SSN")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Registrant Status" SortExpression="Status">
                    <ItemStyle HorizontalAlign="Left" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelStatus" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("Status")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="Questionnaire<br />Completed Date" SortExpression="QuestionCompleteDate">
                    <ItemStyle HorizontalAlign="Center" />
                    <HeaderStyle HorizontalAlign="Center" />
                    <ItemTemplate>
                        <asp:Label ID="LabelQuestionCompleteDate" runat="server" SkinID="DataLabel" Text='<%# Helpers.AhobprEval(Eval("QuestionCompleteDateDisplay")) %>'></asp:Label>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <br />
    </asp:Panel>
    <asp:ObjectDataSource ID="DataSourceSendQuestions" runat="server" OldValuesParameterFormatString="original_{0}"
        SelectMethod="GetRegistrantsSendQuestions" EnablePaging="True" StartRowIndexParameterName="startRowIndex"
        MaximumRowsParameterName="maximumRows" SortParameterName="sortExpression" SelectCountMethod="GetSendQuestionsCount"
        TypeName="VeteransAffairs.Registries.BusinessManagerAHOBPR.AHOBPRReportManager">
        <SelectParameters>
            <asp:ControlParameter ControlID="BaseControlListBoxStatus" Name="status" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormStartDate" Name="formStartFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormStartDate" Name="formStartToDateText"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormToDate" Name="formCompletionFromDateText"
                PropertyName="FromDateValue" Type="String" />
            <asp:ControlParameter ControlID="UserControlDateRangeFormToDate" Name="formCompletionToDateText"
                PropertyName="ToDateValue" Type="String" />
            <asp:ControlParameter ControlID="HiddenFieldQuestion" Name="questionNumber" PropertyName="Value"
                Type="String" />
            <asp:ControlParameter ControlID="BaseControlListBoxAnswer" Name="answer" PropertyName="Text"
                Type="String" />
            <asp:ControlParameter ControlID="RadioButtonListHealthConcerns" Name="healthConcerns"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlListBoxSubpopulationFlag" Name="subpopulationFlag"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlag" PropertyName="AdminFlagId"
                Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentCountryAll" Name="deploymentAll"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlDropDownListDeploymentCountryExposure"
                Name="deploymentExposure" PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagFromDateText"
                PropertyName="AdminFlagEnteredDateFrom" Type="string" />
            <asp:ControlParameter ControlID="UserControlAdminFlagFilter" Name="adminFlagToDateText"
                PropertyName="AdminFlagEnteredDateTo" Type="string" />
            <asp:ControlParameter ControlID="RadioButtonListExcludeAdminFlag" Name="excludeAdminFlag"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlTextBoxLastName" Name="lastName"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="BaseControlTextBoxLast4SSN" Name="last4SSN"
                PropertyName="Text" Type="string" />
            <asp:ControlParameter ControlID="UserControlBirthDate" Name="dob" 
                PropertyName="Text" Type="String" />
            <asp:ControlParameter ControlID="UserControlFacilityDropdownLists" Name="closestFacilityId"
                PropertyName="FacilityId" Type="String" />     
        </SelectParameters>
    </asp:ObjectDataSource>
    <div>
        <br />
        <br />
        <asp:Panel ID="PanelSend" runat="server" Width="75%" Visible="false">
            <table>
                <tr>
                    <td>
                        <UserControl:BaseControlDropDownList ID="BaseControlDropDownListFollowupQuestionGroup"
                            runat="server" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    </td>
                    <td>
                        <asp:Button runat="server" ID="ButtonSendQuestionsAll" Text="Send to All"
                            ValidationGroup="SendQuestions" OnClick="ButtonSendQuestionsAll_Click" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:Button runat="server" ID="ButtonSendQuestionsSelected" Text="Send to Selected"
                            ValidationGroup="SendQuestions" OnClick="ButtonSendQuestionsSelected_Click" />
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <asp:CustomValidator ID="CustomValidatorSendQuestions" runat="server" ErrorMessage="Please select at least one registrant."
                            ValidationGroup="SendQuestions" ForeColor="DarkRed"></asp:CustomValidator>
                    </td>
                </tr>
            </table>
        </asp:Panel>
    </div>
    <asp:HiddenField ID="HiddenFieldQuestion" runat="server" />
    <asp:HiddenField ID="HiddenFieldFacility" runat="server" Value="0" />
    <asp:HiddenField ID="HiddenFieldVisn" runat="server" />
    <asp:HiddenField ID="HiddenFieldLocation" runat="server" />
    <asp:HiddenField ID="HiddenAssignedLocationType" runat="server" />
    <asp:HiddenField ID="HiddenAssignedLocationKey" runat="server" />
    <asp:HiddenField ID="HiddenFieldTotalRegistrants" runat="server" />
</asp:Content>
